

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archBackupRestoreParam.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archBackupRestoreParam.sp,v $ $Id: archBackupRestoreParam.sp,v 1.98.2.31 2020/03/31 19:26:24 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archBackupRestoreParam')
BEGIN
	print '>>> Drop Stored Procedure: archBackupRestoreParam <<<'
	drop procedure archBackupRestoreParam
END
IF EXISTS (select * from GxQscripts where name='archBackupRestoreParam')
	delete from GxQscripts where name = 'archBackupRestoreParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupRestoreParam')
	delete from GXDBVersions where aliasname = 'archBackupRestoreParam'
GO
print '... Creating Procedure: archBackupRestoreParam'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archBackupRestoreParam
  @i_jobId integer,
  @i_appId integer,
  @i_archGrpId integer,
  @i_archGrpCopyId integer,
  @i_backupLevel integer,
  @i_dataType integer,
  @i_opType integer,
  @i_archFileId integer,
  @i_commCellId integer,
  @i_srcClientID bigint,
  @i_SIDBStoreId integer,
  @i_getCopyIdOnly integer,
  @i_addDDBMapIfMissing integer
AS
  DECLARE @o_errorCode integer;
  DECLARE @o_clientId integer;
  DECLARE @o_appTypeId integer;
  DECLARE @o_instance integer;
  DECLARE @o_backupSet integer;
  DECLARE @o_appId integer;
  DECLARE @o_archGrpId integer;
  DECLARE @o_archGrpName varchar(144);
  DECLARE @o_archGrpFlags integer;
  DECLARE @o_archGrpCopyId integer;
  DECLARE @o_archGrpCopyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_compressWhere integer;
  DECLARE @o_numNWAgents integer;
  DECLARE @o_NWWriteSpeed integer;
  DECLARE @o_SIBlockSizeKB integer;
  DECLARE @o_SIMinObjSizeKB integer;
  DECLARE @o_SignatureType integer;
  DECLARE @o_SignatureModuleWhere integer;
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_SIDBStoreFlags integer;
  DECLARE @o_SigCacheEnabled integer;
  DECLARE @o_SigCacheDBSizeMB integer;
  DECLARE @o_SigCacheBufferSizeKB integer;
  DECLARE @o_VSAEnabled integer;
  DECLARE @o_encryption integer;
  DECLARE @o_restoreAccess integer;
  DECLARE @o_subclientEnc integer;
  DECLARE @o_encType integer;
  DECLARE @o_encKeyLen integer;
  DECLARE @o_RSAPubKey varchar(1024);
  DECLARE @o_RSAPriKey varchar(1024);
  DECLARE @o_MMHostAttribute integer;
  DECLARE @o_extraFlags bigint;
  DECLARE @o_DedupFactor integer;
  DECLARE @o_companyId integer;
  DECLARE @o_companyGUID uniqueidentifier;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblClientProp TABLE (DedupEnabled int, SigCacheEnabled int, SigCacheDBSizeMB int, SigCacheBufferSizeKB int, VSAEnabled int, HighLatencyOpt int)
CREATE	TABLE #tblAppEnc (clientId int, appTypeId int, encryption int, restoreAccess int, drToolAccess int, subclientEnc int,
		encType int, encKeyLen int, SIDBStoreId int, RSAPubKey varchar(1024), RSAPriKeyBPF varchar(1024), RSAPriKeyUPF varchar(1024),
		companyId int, companyGUID uniqueidentifier)
-- local variables
DECLARE @l_errorCode		INT = 0
DECLARE @l_clientId			INT = 0
DECLARE @l_appTypeId		INT = 0
DECLARE @l_instance			INT = 0
DECLARE @l_backupSet		INT = 0
DECLARE @l_appId			INT = 0
DECLARE @l_appStatus		INT = 0
DECLARE @l_realAppId		INT = 0
DECLARE @l_dataArchGrpId	INT = 0
DECLARE @l_logArchGrpId		INT = 0
DECLARE @l_opType			INT = 0
DECLARE @l_archGrpId		INT = 0
DECLARE @l_archGrpFlags		INT = 0
DECLARE @l_archGrpCopyId	INT = 0
DECLARE @l_archGrpCopyFlags	INT = 0
DECLARE @l_dedupeFlags		INT = 0
DECLARE @l_compressWhere	INT = 0
DECLARE @l_numNWAgents		INT = 0
DECLARE @l_NWWriteSpeed		INT = 0
DECLARE @l_SIDBStoreId		INT =  @i_SIDBStoreId
DECLARE @l_SIDBFlags		INT = 0
DECLARE @l_SIBlockSizeKB	INT = 0
DECLARE @l_SIMinObjSizeKB	INT = 0
DECLARE @l_SignatureType	INT = 0
DECLARE @l_SignatureModuleWhere INT = 0
DECLARE @l_DedupEnabledOnClient	INT = 0
DECLARE @l_SigCacheEnabled	INT = 0
DECLARE @l_SigCacheDBSizeMB	INT = 0
DECLARE @l_SigCacheBufferSizeKB	INT = 0
DECLARE @l_VSAEnabled		INT = 0
DECLARE @l_HighLatencyOpt	INT = 0
DECLARE @l_MMHostAttribute	INT = 0
DECLARE @l_copyExtendedFlags	INT = 0
DECLARE @l_StoreStatus			INT = 0
DECLARE @l_CopySigCacheDBSizeMB INT = 0
DECLARE	@tblMAClientIds TABLE (MAClientId int)
DECLARE @jmCachedStoragePolicy INT = 0
DECLARE @l_extraFlags		INT = 0
DECLARE @l_storeCreateTime	INT = 0
DECLARE @l_clientUpgradeTime	INT = 0
DECLARE @l_storePartitionCount	INT = 0
DECLARE @tblDDBOnlineStatus TABLE (SIDBStoreId INT, dedupeFlags INT)
DECLARE @l_associatedAppId 	INT = 0
DECLARE @l_DedupFactor		INT = 0
DECLARE @ddbCopy			INT = 0
SET @l_appId			= @i_appId
SET @l_realAppId		= @i_appId
SET @l_archGrpId		= @i_archGrpId
SET @l_archGrpCopyId	= @i_archGrpCopyId
SET	@l_opType			= @i_opType
IF @l_archGrpId <= 1
BEGIN
	SET @jmCachedStoragePolicy = dbo.JMGetStoragePolicyForJob(@i_jobId, @i_commCellId, @i_opType, @i_backupLevel, @i_dataType)
	IF @jmCachedStoragePolicy > 0
		SET @l_archGrpId = @jmCachedStoragePolicy
END
IF	@i_opType NOT IN (4, 14, 59, 60, 65) AND @i_archFileId > 0 AND @i_commCellId > 0
BEGIN
	-- Restore: get archGroupId from archFile table
	SELECT @l_archGrpId = archGroupId, @l_appId = appId
	FROM	archFile WITH (NOLOCK)
	WHERE	id = @i_archFileId AND commCellId = @i_commCellId
	IF @@ROWCOUNT = 0
	BEGIN
SET @l_errorCode = 48
		GOTO FINISH
	END
END
ELSE
BEGIN
	IF	@l_opType = 4
		SELECT	@l_opType = opType FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId
	-- SnapToMedia: get archGroupId and the real appId
	IF	@l_opType = 60
		SELECT	@l_realAppId = applicationId FROM JMJobWF WITH (NOLOCK) WHERE childJobId = @i_jobId
END
SELECT	@l_clientId = clientId, @l_appTypeId = appTypeId, @l_instance = instance, @l_backupSet = backupSet,
		@l_dataArchGrpId = dataArchGrpID, @l_logArchGrpId = logArchGrpID, @l_appStatus = subclientStatus
FROM	APP_application WITH (NOLOCK)
WHERE	id = @l_appId
IF @l_archGrpCopyId <= 0
BEGIN
	IF @l_archGrpId <= 1 AND @i_opType IN (4, 14, 59, 60, 65)
	BEGIN
		-- Backup:
IF @l_appTypeId IN (22, 3, 37, 62, 61,
79, 135, 80, 103, 104, 125)
			SELECT @l_archGrpId = currentPolicy FROM JMBkpJobInfo WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND currentPolicy > 0
 		-- BACKUP COPY should use the same SP as the snap job did. After Beta2.
		IF @l_archGrpId <= 1 AND @l_opType = 60
SELECT	@l_archGrpId = (CASE WHEN (bkpAttributes & 0x2000) <> 0 AND logArchGrpId > 0 THEN logArchGrpId ELSE dataArchGrpId END)
			FROM	JMBkpStats WITH (NOLOCK)
			WHERE	commCellId = 2 AND jobId = (SELECT TOP 1 processedJobId FROM JMJobWF B WITH (NOLOCK) WHERE childJobId = @i_jobId)
		IF @l_archGrpId <= 1
			SET @l_archGrpId = (CASE WHEN @i_dataType = 4 THEN @l_logArchGrpId ELSE @l_dataArchGrpId END)
		-- using incrSP or not
		DECLARE @l_incrSP INT = 0
		DECLARE @l_exchDBSnapincrSPSupport INT = 0
IF @l_appTypeId = 53 AND @l_opType IN(59, 60)
			SET @l_exchDBSnapincrSPSupport = ISNULL((SELECT TOP 1 CONVERT(INT,value) FROM GXGlobalParam WITH (NOLOCK) where modified = 0 AND name = N'ExchDBSnapBkpIncrSPSupport'),0)
		IF @i_backupLevel IN (2, 4, 256)
            --For lotus notes DB transaction log subclient ignore incremental SP. This is to fix the issue when log backup goes to full SP but during archive index we end up picking incremental SP
			--Ignore incremental SP for command line and log command line subclient
AND NOT (@l_appStatus & 0x0080 > 0 AND @l_appTypeId IN (59, 77))
AND NOT (@l_appStatus & 0x0040 > 0 OR @l_appStatus & 0x1000 > 0)
AND NOT ((@i_dataType = 1 OR @i_dataType = 2) AND @l_appTypeId = 104)
AND (@i_dataType <> 4 OR @l_appTypeId NOT IN (
2,
22,
23,
3,
37,
81,
4,
16,
70,
71,
6,
59,
51,
77,
62,
61,
79,
135,
80,
103,
104))
			AND (@l_opType NOT IN (59,60) OR @l_exchDBSnapincrSPSupport > 0 )
		BEGIN
			-- Get the incr storage policy step only for non-refcopy subclient.
IF ((@l_appStatus & 0x10000) = 0)
			BEGIN
				SET @l_incrSP = (SELECT incrSP FROM archGroup WITH (NOLOCK) WHERE id = @l_archGrpId)
			END
			IF	@l_incrSP > 1 AND EXISTS (SELECT * FROM archGroup WITH (NOLOCK) WHERE id = @l_incrSP)
				SET @l_archGrpId = @l_incrSP
		END
	END
	IF @i_opType IN (59, 65)
	BEGIN
		DECLARE @l_subOpType int = 0
		SELECT @l_subOpType = subOpType FROM JMJobInfo WITH (NOLOCK)
		WHERE jobId = @i_jobId AND commCellId = @i_commCellId
		--If it is delayed catalog job we have to use the source copy for catalog instead of default snap copy. Optype is same for both snap backup and delayed catalog but subOptype differs
		SELECT	@l_archGrpCopyId = AGC.id, @l_archGrpId = AGC.archGroupId,
				@l_archGrpCopyFlags = AGC.flags, @l_dedupeFlags = AGC.dedupeFlags, @l_copyExtendedFlags = AGC.extendedFlags, @l_CopySigCacheDBSizeMB = AGC.maxCacheDBSizeMB
		FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	AG.id = @l_archGrpId AND
		(
		--enum CvOptype{ DELAYEDCATALOG = 96,
		(@l_subOpType <> 96 AND AGC.id = AG.defaultSnapCopy)
		OR
		(@l_subOpType = 96 AND AGC.id = (SELECT CASE WHEN DCProp.sourceCopyId > 0 THEN DCProp.sourceCopyId ELSE AG.defaultSnapCopy END FROM archDeferredCatalogProp DCProp WITH (NOLOCK) WHERE DCProp.archGroupId = AG.id))
		)
		AND AGC.isSnapCopy = 1
		IF	@@ROWCOUNT = 0
		BEGIN
SET @l_errorCode = 80
			GOTO FINISH
		END	END
	ELSE
	BEGIN
		SELECT	@l_archGrpId = archGroupId, @l_archGrpCopyId = id,
				@l_archGrpCopyFlags = flags, @l_dedupeFlags = dedupeFlags, @l_copyExtendedFlags = extendedFlags, @l_CopySigCacheDBSizeMB = maxCacheDBSizeMB
		FROM	archGroupCopy WITH (NOLOCK)
WHERE	archGroupId = @l_archGrpId AND siloAppId = @l_appId AND (flags & 524288) > 0
		IF	@@ROWCOUNT = 0
		BEGIN
			SELECT	@l_archGrpId = id, @l_archGrpCopyId = defaultCopy
			FROM	archGroup WITH (NOLOCK) WHERE id = @l_archGrpId
			SELECT	@l_archGrpCopyFlags = flags, @l_dedupeFlags = dedupeFlags, @l_copyExtendedFlags = extendedFlags, @l_CopySigCacheDBSizeMB = maxCacheDBSizeMB
			FROM	archGroupCopy WITH (NOLOCK)
			WHERE	id = @l_archGrpCopyId
		END
	END
END
ELSE
BEGIN
	SELECT	@l_archGrpId = archGroupId, @l_archGrpCopyFlags = flags, @l_dedupeFlags = dedupeFlags, @l_copyExtendedFlags = extendedFlags, @l_CopySigCacheDBSizeMB = maxCacheDBSizeMB
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	id = @l_archGrpCopyId
END
IF @l_archGrpId <= 1
BEGIN
SET @l_errorCode = 3
	GOTO FINISH
END
SET @ddbCopy = ISNULL((SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @l_appId AND attrName = 'DDB Backup CopyId' AND Modified = 0), 0)
IF @ddbCopy > 0
BEGIN
	SET @l_archGrpCopyId = @ddbCopy
	-- Override the copy properties for this copy.
	SELECT	@l_archGrpId = archGroupId, @l_archGrpCopyFlags = flags, @l_dedupeFlags = dedupeFlags, @l_copyExtendedFlags = extendedFlags, @l_CopySigCacheDBSizeMB = maxCacheDBSizeMB
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	id = @l_archGrpCopyId
END
--
-- At this point we figured out which copyId to use
-- If this is called to find only copyId then return
--
IF @i_getCopyIdOnly = 1
BEGIN
	SELECT	@l_errorCode, 0, 0, 0, 0, 0,
			@l_archGrpId, '', 0, @l_archGrpCopyId,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, NULL
	RETURN
END
-- Get the mediaAgent from the resource manager tables. CRC was not honoured. PP Item.
INSERT INTO @tblMAClientIds
SELECT Distinct MMR.ClientId
FROM MMResource MMR WITH (NOLOCK), MMResourceToJob MMRJ WITH (NOLOCK)
WHERE MMRJ.JobId_l = @i_jobId
AND MMRJ.ReservationId = MMR.ReservationId
SELECT	@l_MMHostAttribute = MAX(Attribute & 256) | MAX(Attribute & 512) | MAX(Attribute & 32)
FROM	@tblMAClientIds T, MMHost H WITH (NOLOCK)
WHERE	H.ClientId = T.MAClientId
DECLARE	@l_clientReleaseId	INT
SELECT	@l_clientReleaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = @l_clientId
SET	@l_SIMinObjSizeKB = 0
SET	@l_SignatureType = 0
IF	(@l_dedupeFlags & 262144) > 0
BEGIN
	DECLARE @l_jobType INT = dbo.GetJobTypeForJobID(@i_jobId)
	IF @l_SIDBStoreId = 0
	BEGIN
		SELECT	@l_SIDBStoreId = SIDBStoreId
		FROM	archSubclientCopyDDBMap WITH(READUNCOMMITTED)
		WHERE	appId = @l_appId
				AND copyId = @l_archGrpCopyId
		IF @l_SIDBStoreId = 0
		BEGIN
			--
			-- Cloud laptop backups we don't do reservation so DDB mapping won't get added
			-- If pipeline lookup is for cloud laptop then add mapping if it's missing
			--
			IF @i_addDDBMapIfMissing = 1
			BEGIN
				IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
				CREATE TABLE #lt_archCreateCopySubClientDDBMApOutput (xmlOutput XML)
				IF object_id('tempdb.dbo.#inputApps') is not null DROP TABLE #inputApps
				CREATE TABLE #inputApps -- only populate appID and copyID if this table is being created in the caller
				(
					appId    INT,
					copyId   INT,
					appTypeId   INT,
					instanceId  INT,
					clientId  INT,
					clientstatus INT,
					releaseId INT,
					servicePack INT
				)
				INSERT INTO #inputApps(appId, copyId)
				SELECT @l_appId, @l_archGrpCopyId
				exec archCreateCopySubClientDDBMAp ''
				IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
				SELECT  @l_SIDBStoreId = SIDBStoreId
				FROM    archSubclientCopyDDBMap WITH(READUNCOMMITTED)
				WHERE   appId = @l_appId AND copyId = @l_archGrpCopyId
			END
			IF @l_SIDBStoreId = 0
			BEGIN
				--
				--Synthfull reads may happens from deconfigured subclients having no DDB mapping
				--Use default DDB in such cases
				--
				IF 	@l_jobType = 4 /*BACKUP*/ AND @i_archFileId <= 0
				BEGIN
SET @l_errorCode = 360
					GOTO FINISH
				END
				ELSE
				BEGIN
					SELECT 	@l_SIDBStoreId = SIDBStoreId
					FROM	archCopySIDBStore WITH(READUNCOMMITTED)
					WHERE	copyId = @l_archGrpCopyId
AND flags & 2 > 0
				END
			END
		END
	END
	IF @l_jobType = 4 /*BACKUP*/ AND @i_archFileId <= 0
	BEGIN
IF	EXISTS(SELECT 1 FROM archCopySIDBStore WITH(READUNCOMMITTED) WHERE SIDBStoreId = @l_SIDBStoreId AND flags & 2 = 0)
		BEGIN
			IF object_id('tempdb.dbo.#InputDataAccessNodeConfigs') is not null DROP TABLE #InputDataAccessNodeConfigs
			CREATE TABLE #InputDataAccessNodeConfigs -- only populate appID and copyID if this table is being created in the caller
			(
				ProxyCLientId	 INT,
				ProxyEntityType		INT,
				ProxyClientGroupID	INT,
				ClientId	 INT,
				appTypeId	INT,
				instanceId	INT,
				bkpsetid  INT,
				subclientID INT,
				isAllowed	INT
			)
			INSERT INTO #InputDataAccessNodeConfigs
			SELECT @i_srcClientID, 3/*EntityType_CLIENT_ENTITY*/, 0, 0, 0, 0, 0, @i_appId,1
			exec archCheckDataAcessNodeConfigurationAllowed ''
			IF EXISTS (SELECT 1 FROM #InputDataAccessNodeConfigs WHERE isAllowed = 0)
			BEGIN
SET @l_errorCode = 359
				GOTO FINISH
			END
			IF object_id('tempdb.dbo.#InputDataAccessNodeConfigs') is not null DROP TABLE #InputDataAccessNodeConfigs
		END
	END
	SELECT	@l_SIMinObjSizeKB = MinObjSizeKB, @l_SignatureType = SignatureType, @l_SIDBFlags = Flags, @l_storeCreateTime = CreatedTime,
	@l_DedupFactor = DedupFactor
	FROM	idxSIDBStore WITH (NOLOCK)
	WHERE	SIDBStoreId = @l_SIDBStoreId
	SELECT @l_storePartitionCount = COUNT(SubStoreId)
	FROM IdxSIDBSubStore WITH (NOLOCK)
	WHERE SIDBStoreId = @l_SIDBStoreId
	-- When reach this point, if option for "allow backup" is off, reservation logic should already take care everything.
	-- Job should always run in dedupe mode in this case. StoreStatus will remain as it is.
	-- When the "allow backup" if on, we do the following check in addtion to reseiliency setting.
	-- Do all the logic only if the dedup is not already inactive on the copy.
IF (@l_dedupeFlags & 1048576) = 0
	BEGIN
		-- Always allow transaction log backup run in non-Dedup mode
		DECLARE @isTransactionLogBackupPhase INT = 0
		EXEC MMIsTransactionLogBackupPhase @i_jobId, @i_commCellId, @isTransactionLogBackupPhase output
		IF @isTransactionLogBackupPhase = 1
		BEGIN
SET @l_dedupeFlags = @l_dedupeFlags | 1048576
		END
		ELSE
		BEGIN
			INSERT INTO @tblDDBOnlineStatus
			EXEC MMCheckDDBOnlineStatus @l_SIDBStoreId, @l_archGrpCopyId, @i_commCellId
			SELECT @l_dedupeFlags = dedupeFlags
			FROM @tblDDBOnlineStatus WHERE SIDBStoreId = @l_SIDBStoreId
		END
	END
END
-- The default value for 'Single Instancing Option' is 1 -- signature generation will happen On Client
IF	(@l_dedupeFlags & 262144) <> 0
AND (@l_dedupeFlags & 1048576) = 0
BEGIN
	SET @l_SignatureModuleWhere = 1
	--If subclient is configured with subclient policy the get the setting for subclient Policy.
 	SET @l_associatedAppId =  ISNULL((SELECT CONVERT(int, attrVal)
    						FROM    APP_SubClientProp WITH (NOLOCK)
    						WHERE   ComponentNameId = @l_realAppId AND attrName = N'Associated subclient Policy' AND modified = 0), 0)
	SELECT	@l_SignatureModuleWhere = CONVERT(INT, attrVal)
	FROM	APP_SubclientProp WITH (NOLOCK)
	WHERE	((componentNameId = @l_realAppId AND @l_associatedAppId = 0) OR (componentNameId = @l_associatedAppId AND @l_associatedAppId > 0)) AND attrName = N'Single Instancing Option' AND modified = 0
    -- Deduplication is ON only when it is enabled at both copy level and subclient level
	IF	@l_SignatureModuleWhere > 0 AND @l_clientReleaseId > 13
	BEGIN
		INSERT	INTO @tblClientProp
		SELECT	(case when attrName = N'Enable DeDuplication' then CONVERT(int, attrVal) else 0 end),
				(case when attrName = N'Enable Client Signature Cache' then CONVERT(int, attrVal) else 0 end),
				(case when attrName = N'Client Max DB Cache Size' then CONVERT(int, attrVal) else 0 end),
				(case when attrName = N'Maximum Cache Buffer Size' then CONVERT(int, attrVal) else 4096 end),
				(case when attrName = N'Enable Intelligent Block Alignment'	then CONVERT(int, attrVal) else 0 end),
				(case when attrName = N'Optimize for High Latency Networks'	then CONVERT(int, attrVal) else 0 end)
		FROM	APP_ClientProp WITH (NOLOCK)
		WHERE	ComponentNameId = @l_clientId AND modified = 0
			AND attrName IN (N'Enable DeDuplication', N'Enable Client Signature Cache', N'Client Max DB Cache Size',
				N'Maximum Cache Buffer Size', N'Enable Intelligent Block Alignment', N'Optimize for High Latency Networks')
		IF	@@ERROR = 0 AND @@ROWCOUNT > 0
		BEGIN
			SELECT	@l_DedupEnabledOnClient = MAX(DedupEnabled),
					@l_SigCacheEnabled = MAX(SigCacheEnabled),
					@l_SigCacheDBSizeMB = MAX(SigCacheDBSizeMB),
					@l_SigCacheBufferSizeKB = MAX(SigCacheBufferSizeKB),
					@l_VSAEnabled = MAX(VSAEnabled),
					@l_HighLatencyOpt = MAX(HighLatencyOpt)
			FROM	@tblClientProp
		END
		IF	@l_DedupEnabledOnClient = 1
			SET @l_SignatureModuleWhere = 3
		--ELSE IF @l_DedupEnabledOnClient = 2 -- commenting out since when dedup is disabled on client then lookup at subclient option to determine if
		--	SET @l_SignatureModuleWhere = 2 -- signature generation is on client or MA. So do not override sigModWhere here. only the above condition is fine.
		ELSE
		BEGIN
			SET	@l_SigCacheEnabled = 0
			SET	@l_VSAEnabled = 0
		END
		IF	@l_SigCacheEnabled > 0
		BEGIN
			IF	@l_SigCacheDBSizeMB = 0
				SET @l_SigCacheDBSizeMB = 4096
			IF	@l_SigCacheBufferSizeKB = 0
				SET @l_SigCacheBufferSizeKB = 4096
		END
		ELSE
		BEGIN
			SET @l_SigCacheDBSizeMB = 0
			SET @l_SigCacheBufferSizeKB = 0
		END
	END
IF @l_clientReleaseId = 16
	BEGIN
		SELECT @l_clientUpgradeTime = attrVal FROM APP_ClientProp WHERE attrName = 'Client Upgrade Time' AND componentNameId = @l_clientId
		--if clientUpgradeTime is set, then it's an upgrade. else it's a new install
		IF ((@l_clientUpgradeTime > 0) AND (@l_clientUpgradeTime < @l_storeCreateTime))
		BEGIN
SET @l_extraFlags = @l_extraFlags | 1
		END
		-- new install condition
		ELSE IF (@l_clientUpgradeTime = 0)
		BEGIN
SET @l_extraFlags = @l_extraFlags | 1
		END
	END
ELSE IF @l_clientReleaseId > 16
	BEGIN
SET @l_extraFlags = @l_extraFlags | 1
	END
END
ELSE
BEGIN
	SET @l_SignatureModuleWhere = 0
	--If non-dedup primary then check if any of the secondary copy store has creation time older than clientUpgrade time.
	DECLARE @l_allCopyStoreCreateTimeMin INT = 0
	SELECT @l_allCopyStoreCreateTimeMin = MIN(ISNULL(I.CreatedTime, 0))
	FROM archGroupCopy C WITH (NOLOCK), archCopySIDBStore C2S WITH(READUNCOMMITTED), IdxSIDBStore I WITH (NOLOCK)
	WHERE C.archGroupId = @l_archGrpId
	AND C.id = C2S.copyId
	AND C2S.SIDBStoreId = I.SIDBStoreId
AND (C2S.flags & 4) > 0
IF @l_clientReleaseId = 16
	BEGIN
		SELECT @l_clientUpgradeTime = attrVal FROM APP_ClientProp WHERE attrName = 'Client Upgrade Time' AND componentNameId = @l_clientId
		--if clientUpgradeTime is set, then it's an upgrade. else it's a new install
		IF ((@l_clientUpgradeTime > 0) AND (@l_allCopyStoreCreateTimeMin > 0) AND (@l_clientUpgradeTime < @l_allCopyStoreCreateTimeMin))
		BEGIN
SET @l_extraFlags = @l_extraFlags | 1
		END
		-- new install condition
		ELSE IF ((@l_clientUpgradeTime = 0) OR (@l_allCopyStoreCreateTimeMin = 0))
		BEGIN
SET @l_extraFlags = @l_extraFlags | 1
		END
	END
ELSE IF @l_clientReleaseId > 16
	BEGIN
SET @l_extraFlags = @l_extraFlags | 1
	END
END
-- Cleint-Side-Deduplication can be enabled by either or both Client-Property and Copy-Property
IF	@l_SignatureModuleWhere <> 0 AND @l_clientReleaseId > 13 AND (@l_dedupeFlags & 524288) <> 0 AND @l_DedupEnabledOnClient = 0
BEGIN
	SET @l_SignatureModuleWhere = 3 /*CV_CLIENTSIDE_DEDUP*/
	SET @l_SigCacheEnabled = 1
END
-- If Dedup enabled and multipartition store and client is pre-v10. Then perform MA Side dedup.
IF (@l_SignatureModuleWhere > 0) AND (@l_storePartitionCount > 1) AND (@l_clientReleaseId < 15)
BEGIN
	SET @l_SignatureModuleWhere = 2 /*CV_SIGNATURE_DEST*/
END
-- MR : 169082 - Source-side deduplication should not be loaded For readless Synthfull. This is unnecessary overhead.
IF (@l_opType = 14 /*SYNTHFULL*/) AND ((@l_dedupeFlags & 8388608) > 0)
BEGIN
	SET @l_SignatureModuleWhere = 1 /*CV_SIGNATURE_SOURCE*/
END
IF	@l_SigCacheEnabled > 0 AND @l_DedupEnabledOnClient = 0
BEGIN
--	SET @l_SigCacheDBSizeMB = 4096
	--When @l_SigCacheEnabled > 0 and @l_DedupEnabledOnClient = 0 (use storage policy settings), then use cacheDBSize from copy property instead of client.
IF (@l_dedupeFlags & 1073741824) > 0
		SET @l_SigCacheDBSizeMB = @l_CopySigCacheDBSizeMB
	SET @l_SigCacheBufferSizeKB = 4096
END
IF @l_SigCacheEnabled > 0 AND @l_DedupEnabledOnClient <> 0
BEGIN
	--When clientside dedup is enabled and high latency Opt is disabled on client then disable it in copyflags so that cpp can send it back disabled.
	IF @l_HighLatencyOpt = 0
SET @l_dedupeFlags = @l_dedupeFlags & ~(4)
	ELSE
SET @l_dedupeFlags = @l_dedupeFlags | 4
END
-- get SIBlockSizeKB
SELECT	@l_archGrpFlags = flags, @l_SIBlockSizeKB = SIBlockSizeKB
FROM	archGroup WITH (NOLOCK)
WHERE	id = @l_archGrpId
IF (@l_dedupeFlags & 134217728) <> 0 AND @l_SIDBStoreId > 0
	SELECT	@l_SIBlockSizeKB = AG.SIBlockSizeKB
	FROM	archGroup AG WITH (NOLOCK), archCopyToGlobalPolicy C2G WITH(READUNCOMMITTED)
	WHERE	AG.id = C2G.globalPolicyId
			AND C2G.copyId = @l_archGrpCopyId
ELSE
IF	@l_clientReleaseId <= 13 AND (@l_archGrpFlags & 32) = 0
	SET @l_SIBlockSizeKB = 0
ELSE
IF	@l_SIBlockSizeKB = 0
SET @l_SIBlockSizeKB = 128
--encr settings are not available for subclient policy. Let this be for original appId only.
INSERT	INTO #tblAppEnc
EXEC archBackupEncryptionInfo @l_realAppId, @l_archGrpCopyId
-- get subclient's compression properties
SELECT	@l_compressWhere = compressWhere, @l_numNWAgents = numNWAgents, @l_NWWriteSpeed = NWWriteSpeed
FROM	archPipeConfig WITH (NOLOCK)
WHERE	((appNumber = @l_realAppId AND @l_associatedAppId = 0) OR (appNumber = @l_associatedAppId AND @l_associatedAppId > 0))
IF @@ROWCOUNT = 0
BEGIN
	SET	@l_compressWhere = 4
	SET	@l_NWWriteSpeed = -1
	IF @l_appTypeId IN (
17,
19,
64,
63,
21,
36,
29)
		SET	@l_numNWAgents = 1
	ELSE
SET	@l_numNWAgents = 2
END
-- No throttling for Synthetic Full
IF	@l_opType = 14
	SET	@l_NWWriteSpeed = -1
-- If client-side dedup, set the cache-buffer size to 4096 by default if not set.
IF @l_SignatureModuleWhere = 3
BEGIN
	IF	@l_SigCacheBufferSizeKB = 0
		SET @l_SigCacheBufferSizeKB = 4096
END
-- If signature generation is on client side, compression should be also on client side.
IF	@l_compressWhere = 1 AND @l_SignatureModuleWhere IN (1, 3)
	SET	@l_compressWhere = 0
-- If the copy is non-dedup and compressWhere is 2 (i.e. use SP settings) then check for extendedFlags to determine if compression has to be
-- done at the client.
IF @l_compressWhere = 2 AND ((@l_dedupeFlags & 262144) = 0)
BEGIN
IF ((@l_copyExtendedFlags & 16) > 0)
        BEGIN
                -- For these Oracle appTypes this option behaves as if compression has to be done on MA instead.
IF (@l_appTypeId IN (22, 80))
                        AND EXISTS (SELECT * FROM MMConfigs  WITH (NOLOCK) WHERE name = 'MMCONFIG_COMPRESS_ON_MEDIA_AGENT_FOR_ORACLE_BKP' and Value > 0)
                        SET @l_compressWhere = 1 -- CV_COMPRESS_DEST
                ELSE
                        SET @l_compressWhere = 0 -- CV_COMPRESS_SOURCE
        END
ELSE IF ((@l_copyExtendedFlags & 16384) > 0)
        BEGIN
               SET @l_compressWhere = 1 -- CV_COMPRESS_DEST
        END
END
-- Compression and encryption are not supported on HP StoreOnce library.
DECLARE @deviceType int = 0
SET @deviceType = (SELECT TOP 1 DEV.DeviceTypeId FROM MMDataPath D WITH (READUNCOMMITTED)
			INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
			INNER JOIN MMMountPath M WITH (READUNCOMMITTED) ON DP.MasterPoolId = M.MasterPoolId
			INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON M.MountPathId = MPSD.MountPathId
			INNER JOIN MMDevice DEV WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEV.DeviceId
			WHERE D.copyId = @l_archGrpCopyId
		)
IF (@deviceType >= 2) AND (@deviceType <= 1000)
BEGIN
SET @l_extraFlags = @l_extraFlags | 2
IF (@deviceType = 59)
    BEGIN
	    SET @l_compressWhere = 4 -- Force Off
    END
END
-- Check if the new compression scheme is applicable for this backup
DECLARE @lzoConfig INT = 0
SELECT @lzoConfig = value
FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_LZO_COMPRESSION_SCHEME_CONFIG'
IF @lzoConfig = 1
BEGIN
SET @l_extraFlags |= 4
END
ELSE IF @lzoConfig IN ( 2, 3)
BEGIN
	DECLARE @clientLZOSetting INT = 0
SELECT @clientLZOSetting = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'EnableLZOCompression' AND componentNameId = @l_clientId AND modified = 0
	IF (@clientLZOSetting > 0)
	BEGIN
SET @l_extraFlags |= 4
	END
END
FINISH:
IF @l_errorCode = 0
	SELECT	@l_errorCode, @l_clientId, @l_appTypeId, @l_instance, @l_backupSet, @l_appId,
			@l_archGrpId, (SELECT name FROM archGroup WHERE id = @l_archGrpId), @l_archGrpFlags, @l_archGrpCopyId,
			@l_archGrpCopyFlags, @l_dedupeFlags, @l_compressWhere, @l_numNWAgents, @l_NWWriteSpeed,
			@l_SIBlockSizeKB, @l_SIMinObjSizeKB, @l_SignatureType, @l_SignatureModuleWhere, @l_SIDBStoreId, @l_SIDBFlags,
			@l_SigCacheEnabled, @l_SigCacheDBSizeMB, @l_SigCacheBufferSizeKB, @l_VSAEnabled,
			encryption, restoreAccess, subclientEnc, encType, encKeyLen,
			RSAPubKey, (case restoreAccess when 0 then RSAPriKeyBPF when 1 then RSAPriKeyUPF else '' end), @l_MMHostAttribute, @l_extraFlags, @l_DedupFactor,
			companyId, companyGUID
	FROM	#tblAppEnc
ELSE
	SELECT	@l_errorCode, @l_clientId, @l_appTypeId, @l_instance, @l_backupSet, @l_appId,
			@l_archGrpId, (SELECT name FROM archGroup WHERE id = @l_archGrpId), @l_archGrpFlags, @l_archGrpCopyId,
			@l_archGrpCopyFlags, @l_dedupeFlags, @l_compressWhere, @l_numNWAgents, @l_NWWriteSpeed,
			@l_SIBlockSizeKB, @l_SIMinObjSizeKB, @l_SignatureType, @l_SignatureModuleWhere, @l_SIDBStoreId, @l_SIDBFlags,
			@l_SigCacheEnabled, @l_SigCacheDBSizeMB, @l_SigCacheBufferSizeKB, @l_VSAEnabled,
			0, 0, 0, 0, 0, '', '', @l_MMHostAttribute, @l_extraFlags, @l_DedupFactor, 0, NULL
DROP TABLE #tblAppEnc
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archBackupRestoreParam')
	delete from GxQscripts where name = 'archBackupRestoreParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupRestoreParam')
	delete from GXDBVersions where aliasname = 'archBackupRestoreParam'
GO

insert into GXDBVersions values(2, 'archBackupRestoreParam',  '00010098000200310000', 'archBackupRestoreParam', '00010098000200310000')
GO

