

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archBackupEncryptionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archBackupEncryptionInfo.sp,v $ $Id: archBackupEncryptionInfo.sp,v 1.17.286.11 2020/12/23 23:43:05 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archBackupEncryptionInfo')
BEGIN
	print '>>> Drop Stored Procedure: archBackupEncryptionInfo <<<'
	drop procedure archBackupEncryptionInfo
END
IF EXISTS (select * from GxQscripts where name='archBackupEncryptionInfo')
	delete from GxQscripts where name = 'archBackupEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archBackupEncryptionInfo'
GO
print '... Creating Procedure: archBackupEncryptionInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archBackupEncryptionInfo
  @i_appId int,
  @i_archCopyId int
AS
  DECLARE @o_clientId int;
  DECLARE @o_appTypeId int;
  DECLARE @o_encryption int;
  DECLARE @o_restoreAccess int;
  DECLARE @o_drToolAccess int;
  DECLARE @o_subclientEnc int;
  DECLARE @o_encType int;
  DECLARE @o_encKeyLen int;
  DECLARE @o_SIDBStoreId int;
  DECLARE @o_RSAPubKey varchar(1024);
  DECLARE @o_RSAPriKeyBPF varchar(1024);
  DECLARE @o_RSAPriKeyUPF varchar(1024);
  DECLARE @o_companyId int;
  DECLARE @o_companyGUID uniqueidentifier;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@o_encryption	= 0
SET	@o_drToolAccess	= 0
SET	@o_subclientEnc	= 2 /*ENC_NETWORK_AND_MEDIA*/
SET	@o_encType		= 0
SET	@o_encKeyLen	= 0
SET	@o_SIDBStoreId	= 0
SET	@o_RSAPubKey	= ''
SET	@o_RSAPriKeyBPF	= ''
SET	@o_RSAPriKeyUPF	= ''
SET	@o_companyId	= 0
DECLARE @l_subclientEnc		int
DECLARE @l_associatedAppId	int
SET	@l_subclientEnc		= -1
SET	@l_associatedAppId	= 0
DECLARE @l_copyEncType	INT = 0
DECLARE @l_copyEncKeyLen INT = 0
DECLARE @l_copyDrToolAccess INT = 0
DECLARE	@l_encryptionSettings INT = 0
DECLARE	@l_overrideClientSettings BIT = 0
DECLARE @l_archGroupId INT =  0
SELECT	@o_clientId = clientId, @o_appTypeId = appTypeId
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @i_appId
SELECT	@l_copyEncType = encType, @l_copyEncKeyLen = encKeyLen,
@l_copyDrToolAccess = (CASE WHEN (flags & 131072) = 0 THEN 2 ELSE 0 END), --0 for Via Media Password, 1 for Via Pass Phrase, 2 for No Access
		@l_archGroupId = archGroupId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_archCopyId
SELECT	 @o_SIDBStoreId = SIDBStoreId
FROM	archSubClientCopyDDBMap WITH (READUNCOMMITTED)
WHERE	appId = @i_appId
		AND CopyId = @i_archCopyId
-- Disable encryption for DDB backups
DECLARE @l_DDBBackupPropChkSum INT = CHECKSUM(N'DDB Backup')
IF EXISTS(SELECT 1 FROM APP_SubClientProp WITH(READUNCOMMITTED) WHERE componentNameId = @i_appId AND attrName = N'DDB Backup' AND modified = 0 AND cs_attrName = @l_DDBBackupPropChkSum)
BEGIN
	SET @o_subclientEnc = 0 -- Subclient enc Off
	GOTO FINISH
END
-- Compression and encryption are not supported on HP StoreOnce library.
IF EXISTS (SELECT 1 FROM MMDataPath D WITH (READUNCOMMITTED)
		INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
		INNER JOIN MMMountPath M WITH (READUNCOMMITTED) ON DP.MasterPoolId = M.MasterPoolId
		INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON M.MountPathId = MPSD.MountPathId
		INNER JOIN MMDevice DEV WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEV.DeviceId
	WHERE D.copyId = @i_archCopyId
AND DEV.DeviceTypeId = 59)
BEGIN
	SET @o_subclientEnc = 0 -- Subclient enc Off
	GOTO FINISH
END
--
-- Override client settings if encryption is set at dedupe copy level
-- Dedupe blocks may across clients so mixing of encrypted and unencrypted data is not supported
--
IF 	@l_copyEncType > 0
	AND @o_SIDBStoreId > 0
BEGIN
	SET @l_overrideClientSettings = 1
END
SELECT	@l_subclientEnc = CONVERT(int, attrVal)
FROM	APP_SubClientProp WITH (NOLOCK)
WHERE	ComponentNameId = @i_appId
	AND attrName = N'Encrypt: encryption' AND modified = 0
IF	@l_subclientEnc = -1
BEGIN
	SELECT	@l_associatedAppId = CONVERT(int, attrVal)
	FROM	APP_SubClientProp WITH (NOLOCK)
	WHERE	ComponentNameId = @i_appId AND attrName = N'Associated subclient Policy' AND modified = 0
	IF	@l_associatedAppId > 0
		SELECT	@l_subclientEnc = CONVERT(int, attrVal)
		FROM	APP_SubClientProp WITH (NOLOCK)
		WHERE	ComponentNameId = @l_associatedAppId
			AND attrName = N'Encrypt: encryption' AND modified = 0
END
IF	@l_subclientEnc > -1
	SET @o_subclientEnc = @l_subclientEnc
--We should not allow disabling encryption at subclient level if override is set on copy
IF	@l_overrideClientSettings = 1 AND @o_subclientEnc NOT IN (1 /*ENC_MEDIA_ONLY*/, 2 /*ENC_NETWORK_AND_MEDIA*/)
	SET @o_subclientEnc = 2 /*ENC_NETWORK_AND_MEDIA*/
IF @o_subclientEnc > 0
BEGIN
	--Get Client Encryption Settings
	IF OBJECT_ID('tempdb..#lt_ClientEncSettings') IS NOT NULL DROP TABLE #lt_ClientEncSettings
	CREATE TABLE #lt_ClientEncSettings (encryptionSetting int, restoreAccess int, drToolAccess int, encType int, encKeyLen int,
			rsaPubKey varchar(1024), rsaPriKeyUPF varchar(1024), rsaPriKeyBPF varchar(1024), companyId int, companyGUID uniqueidentifier)
	EXEC archGetClientEncryptionSettings @o_clientId
	SELECT 	@l_encryptionSettings = encryptionSetting,
			@o_restoreAccess = restoreAccess,
			@o_drToolAccess = drToolAccess,
			@o_encType = encType,
			@o_encKeyLen = encKeyLen,
			@o_RSAPubKey = rsaPubKey,
			@o_RSAPriKeyUPF = rsaPriKeyUPF,
			@o_RSAPriKeyBPF = rsaPriKeyBPF,
			@o_companyId = companyId,
			@o_companyGUID = companyGUID
	FROM	#lt_ClientEncSettings
	DROP TABLE #lt_ClientEncSettings
	--
	-- Always use storage policy settings if override is set
	-- 1. Disable at client level -> Use SP
	-- 2. Enabled at client level
	--	  a. If KMS is set at company level then we should stick to client settings since we dedupe within company only
	--    b. If NO KMS then Use SP
	--
	IF	@l_overrideClientSettings = 1
		AND
		(
			@l_encryptionSettings = 2 /*App::EncryptionSettings_OFF*/
			OR (@l_encryptionSettings = 1 /*App::EncryptionSettings_ON_CLIENT*/ AND @o_companyId = 0)
		)
	BEGIN
		SET @l_encryptionSettings =  0 /*App::EncryptionSettings_USE_SPSETTINGS*/
	END
	IF	@l_encryptionSettings = 2 -- new client level force encryption off
	BEGIN
		SET @o_encryption = 0
		SET @o_subclientEnc = 0
	END
	ELSE
	IF @l_encryptionSettings = 1 -- use client encryption settings
	BEGIN
		SET @o_encryption = 1
	END
	ELSE -- use storage policy setting option
	BEGIN
		IF (@l_copyEncType > 0)
		BEGIN
			SET @o_encryption = 1
			SET @o_encType = @l_copyEncType
			SET @o_encKeyLen = @l_copyEncKeyLen
			SET @o_drToolAccess = @l_copyDrToolAccess
		END
		ELSE
		BEGIN
			SET @o_encryption = 0
			SET @o_subclientEnc = 0
		END
	END
END
IF	@o_subclientEnc > 0
BEGIN
	-- Default encryption: Cvc::BLOWFISH with 128 bit key
	IF @o_encType = 0
		SET @o_encType = 2
	IF @o_encKeyLen = 0
		SET @o_encKeyLen = 128
END
--
-- Always use "Via Media Password" for DR copies
-- "No Access" is not supported for DR copies since we can't restore CS DB in case of Disaster
--
IF @o_drToolAccess <> 0
BEGIN
IF @o_appTypeId = 1000 OR EXISTS(SELECT 1 FROM archGroup WITH(READUNCOMMITTED) WHERE id = @l_archGroupId AND type = 2)
		SET @o_drToolAccess = 0 --APP::CipherDirectMediaAccess_Regular (Via Media Password)
END
FINISH:
SELECT	@o_clientId, @o_appTypeId, @o_encryption, @o_restoreAccess, @o_drToolAccess, @o_subclientEnc,
		@o_encType, @o_encKeyLen, @o_SIDBStoreId, @o_RSAPubKey, @o_RSAPriKeyBPF, @o_RSAPriKeyUPF, @o_companyId, @o_companyGUID
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archBackupEncryptionInfo')
	delete from GxQscripts where name = 'archBackupEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archBackupEncryptionInfo'
GO

insert into GXDBVersions values(2, 'archBackupEncryptionInfo',  '00010017028600110000', 'archBackupEncryptionInfo', '00010017028600110000')
GO

