

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAuxCopyJobAppSizeCalc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAuxCopyJobAppSizeCalc.sp,v $ $Id: archAuxCopyJobAppSizeCalc.sp,v 1.2.2.4 2019/09/26 06:56:05 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archAuxCopyJobAppSizeCalc')
BEGIN
	print '>>> Drop Stored Procedure: archAuxCopyJobAppSizeCalc <<<'
	drop procedure archAuxCopyJobAppSizeCalc
END
IF EXISTS (select * from GxQscripts where name='archAuxCopyJobAppSizeCalc')
	delete from GxQscripts where name = 'archAuxCopyJobAppSizeCalc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAuxCopyJobAppSizeCalc')
	delete from GXDBVersions where aliasname = 'archAuxCopyJobAppSizeCalc'
GO
print '... Creating Procedure: archAuxCopyJobAppSizeCalc'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAuxCopyJobAppSizeCalc
  @i_jobId INT,
  @i_commCellId INT,
  @i_attempStart INT,
  @i_attemptUnCompSize BIGINT
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal integer
  DECLARE @o_jobUnCompSize BIGINT
  DECLARE @o_attemptUnCompSize BIGINT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_now INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @l_archGroupId INT = 0
DECLARE @l_archGroupCopyId INT = 0
DECLARE	@l_opType INT = 0
DECLARE	@l_jobStartTime INT = 0
DECLARE	@l_jobUnCompSize	BIGINT
DECLARE @l_attemptUnCompSize BIGINT
DECLARE	@l_retVal INT = 0
DECLARE @l_retCode INT = 0
DECLARE @retVal TABLE( val int)
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
CREATE TABLE #destArchFileCopy (DestCopyId INT, archFileId INT, CommCellId INT PRIMARY KEY(destCopyId, archFileId, CommCellId))
SELECT	@l_opType = opType, @l_archGroupId = archGrpId
FROM	JMAdminJobInfoTable WITH (NOLOCK)
WHERE	jobId =  @i_jobId
		AND CommCellId = @i_commCellId
SET	@l_retVal	=	@@ERROR
IF	@l_retVal != 0 GOTO CX_EXIT
SELECT  @l_jobStartTime = ISNULL(MIN(startTime), @i_attempStart)
FROM	JMAdminJobAttemptInfoTable
WHERE	JobId = @i_jobId
		AND commCellId = @i_commCellId
SET	@l_retVal	=	@@ERROR
IF	@l_retVal != 0 GOTO CX_EXIT
IF (@l_jobStartTime = 0 OR @l_jobStartTime >  @i_attempStart)
	SET	@l_jobStartTime = @i_attempStart
DECLARE @CopyTable TABLE (copyId INTEGER)
INSERT INTO @CopyTable
SELECT	archGrpCopyID
FROM	JMDataCopiedStatsTable WITH (NOLOCK)
WHERE	JobId = @i_jobId
		AND CommCellId = @i_commCellId
SET	@l_retVal	=	@@ERROR
IF	@l_retVal != 0 GOTO CX_EXIT
IF (@l_opType = 13 /*AUXCOPY*/)
BEGIN
	INSERT INTO #destArchFileCopy
	SELECT DISTINCT destCopyId, archFileId, commcellid
	FROM archChunkToCopyHistory WITH (NOLOCK)
		INNER JOIN @copyTable C ON C.copyId = destCopyId AND adminJobId = @i_jobId
END
ELSE IF (@l_opType = 104 /*AUXCOPY2*/)
BEGIN
	INSERT INTO #destArchFileCopy
	SELECT DISTINCT destCopyId, archFileId, commcellid
	FROM archChunkToReplicate WITH (NOLOCK)
		INNER JOIN @copyTable C ON C.copyId = destCopyId AND adminJobId = @i_jobId
	UNION
	SELECT DISTINCT destCopyId, archFileId, commcellid
	FROM archChunkToReplicateHistory WITH (NOLOCK)
		INNER JOIN @copyTable C ON C.copyId = destCopyId AND adminJobId = @i_jobId
END
SET	@l_retVal	=	@@ERROR
IF	@l_retVal != 0 GOTO CX_EXIT
IF (EXISTS (SELECT	TOP 1 *
			FROM	archChunkMapping ACM WITH (NOLOCK), ArchChunk AC WITH (NOLOCK), @copyTable C
			WHERE	ACM.archCopyId = C.copyId
					AND ACM.archChunkId = AC.id
					AND ACM.chunkCommCellId = AC.CommCellId
					AND AC.createTime >= @i_attempStart
					AND ACM.chunkNumber > 0))
BEGIN
	DECLARE	copyCursor CURSOR FOR
	SELECT	copyId
	FROM	@CopyTable
	OPEN	copyCursor
	FETCH NEXT FROM copyCursor
	INTO @l_archGroupCopyId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM @retVal
		INSERT INTO @retVal
		EXEC markCopiedJobCopies @i_commCellId, @l_archGroupId, @l_archGroupCopyId, @i_jobId, @l_now
		SELECT @l_retCode = val FROM @retVal
		IF @l_retVal = 0
			SELECT @l_retVal = @l_retCode
		FETCH NEXT FROM copyCursor
		INTO @l_archGroupCopyId
	END
	CLOSE		copyCursor
	DEALLOCATE	copyCursor
END
IF	@l_retVal != 0 GOTO CX_EXIT
SELECT	@l_jobUnCompSize = SUM(ISNULL(ACM.unCompSize, 0)),
		@l_attemptUnCompSize = SUM(CASE WHEN AC.createTime >= @i_attempStart THEN ISNULL(ACM.unCompSize, 0) ELSE 0 END)
FROM	#destArchFileCopy H, archChunkMapping ACM WITH (NOLOCK), ArchChunk AC WITH (NOLOCK)
WHERE	H.destCopyId = ACM.archCopyId
		AND H.archFileId = ACM.archFileId
		AND H.commCellId = ACM.CommCellId
		AND ACM.archChunkId = AC.id
		AND ACM.chunkCommCellId = AC.CommCellId
		AND AC.createTime >= @l_jobStartTime
		AND ACM.chunkNumber > 0
IF (@i_attemptUnCompSize != @l_attemptUnCompSize)
BEGIN
	UPDATE	J
	SET		BytesXferred = T.unCompSize
	FROM	JMDataCopiedStatsTable J,
			(SELECT	ACM.archCopyid, SUM(ISNULL(ACM.unCompSize, 0)) AS unCompSize
			FROM	#destArchFileCopy H, archChunkMapping ACM WITH (NOLOCK), ArchChunk AC WITH (NOLOCK)
			WHERE	ACM.archChunkId = AC.id
					AND ACM.chunkCommCellId = AC.CommCellId
					AND AC.createTime >= @l_jobStartTime
					AND ACM.chunkNumber > 0
					AND H.destCopyId = ACM.archCopyId
					AND H.archFileId = ACM.archFileId
					AND H.commCellId = ACM.CommCellId
			GROUP BY ACM.archCopyid) T
	WHERE	jobId =  @i_jobId
			AND CommCellId = @i_commCellId
			AND J.archGrpCopyID = T.archCopyid
END
SET	@l_retVal	=	@@ERROR
IF	@l_retVal != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT @l_retVal, @l_jobUnCompSize, @l_attemptUnCompSize
IF OBJECT_ID('tempdb.dbo.#destArchFileCopy') IS NOT NULL DROP TABLE #destArchFileCopy
GO

IF EXISTS (select * from GxQscripts where name = 'archAuxCopyJobAppSizeCalc')
	delete from GxQscripts where name = 'archAuxCopyJobAppSizeCalc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAuxCopyJobAppSizeCalc')
	delete from GXDBVersions where aliasname = 'archAuxCopyJobAppSizeCalc'
GO

insert into GXDBVersions values(2, 'archAuxCopyJobAppSizeCalc',  '00010002000200040000', 'archAuxCopyJobAppSizeCalc', '00010002000200040000')
GO

