

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAuxCopyFallenBehindAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAuxCopyFallenBehindAlert.sp,v $ $Id: archAuxCopyFallenBehindAlert.sp,v 1.20.12.11 2020/12/30 14:41:18 prasanthm Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archAuxCopyFallenBehindAlert')
BEGIN
	print '>>> Drop Stored Procedure: archAuxCopyFallenBehindAlert <<<'
	drop procedure archAuxCopyFallenBehindAlert
END
IF EXISTS (select * from GxQscripts where name='archAuxCopyFallenBehindAlert')
	delete from GxQscripts where name = 'archAuxCopyFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAuxCopyFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'archAuxCopyFallenBehindAlert'
GO
print '... Creating Procedure: archAuxCopyFallenBehindAlert'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archAuxCopyFallenBehindAlert
  @i_dummy int
AS
--JobId is removed
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(255)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(255)
  DECLARE @o_bytesNotCopied bigint
  DECLARE @o_nMediaNotCopied integer
  DECLARE @o_nJobsNotCopied integer
  DECLARE @o_oldestJobEndTime integer
  DECLARE @o_hoursForCopy integer
  DECLARE @o_nSubClients integer
  DECLARE @o_alertReason integer
  DECLARE @o_onlyEvent integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- We are also using this stored proc for the default event generation where alert in not enabled on copy
-- and there are jobs which are more than 90 days old and not yet copied.
-- We are storing Data Copied criteria in TB corresponding to the property name  "AuxCopyAlertGB".
-- so we put the column name in table @tblAGC1 AuxCopyAlertGB which is used for storing values in TB.
-- Table having copy data with alert configuration.
DECLARE @tblAGC1 TABLE (archCopyId INT, archGroupId INT, commCellId INT, AuxCopyAlertGB INT, AuxCopyAlertDays INT, AuxCopyAlertHours INT, sourceCopyId INT, onlyEvent  INT)
-- Table for having the aggregate data per copy for alert .
DECLARE @tblAGC2 TABLE (archGrpId INT, archGrpCopyId INT, numOfJobs INT, oldestJobEndTime INT, toBeCopiedBytes BIGINT, thPut BIGINT, subClients INT, alertReason INT, onlyEvent INT)
-- Table for having To Be Copied Job Data for each data type.
IF (OBJECT_ID('tempdb.dbo.#tblJobDataType') IS NOT NULL) DROP TABLE #tblJobDataType
CREATE TABLE #tblJobDataType (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT, status INT, toBeCopiedBytes BIGINT, toBeCopiedPhysicalBytes BIGINT
					PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
create index tblJobDataType_temp_idx_1 on #tblJobDataType(status)
-- Table for having aggregate To Be copied Job Data.
IF (OBJECT_ID('tempdb.dbo.#tblJob') IS NOT NULL) DROP TABLE #tblJob
CREATE TABLE #tblJob (jobId INT, commCellId INT, archGrpCopyId INT, jobEndTime INT, toBeCopiedBytes BIGINT, toBeCopiedPhysicalBytes BIGINT
					PRIMARY KEY (jobId, commCellId, archGrpCopyId))
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo ( JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
					PRIMARY KEY (JobId, CommCellId))
-- Table used for having the last auxiliary copy jobs for throughput calculation.
DECLARE @lastAuxJobs TABLE( archCopyId INT, jobId INT, bytesCopied BIGINT, writeTime INT)
DECLARE @l_now	INT
DECLARE @l_lastjobs INT = 10
DECLARE @l_REAL FLOAT
SET @l_REAL = 1.0
SET @l_now = dbo.GetUnixTime(GETDATE())
--Minimum jobs for to be copied throughput from MMConfig table
SELECT @l_lastjobs = ISNULL(value,10)
FROM MMConfigs  WITH (NOLOCK)
WHERE name = 'MMCONFIG_AUXCOPY_FALLEN_BEHIND_ALERT_NUMBER_OF_JOBS_FOR_THROUGHPUT'
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId, onlyEvent)
SELECT MMEP.EntityId, AGC.archGroupid, MMEP.CommCellId, CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END, 0
FROM MMEntityProp MMEP WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE MMEP.EntityId = AGC.id AND AG.id = AGC.archGroupId
	AND MMEP.EntityType = 2
	AND MMEP.propertyName = 'auxCopyAlertEnabled'
	AND MMEP.intVal = 1
	AND AGC.origCCcommCellID in (0,2)
-- Populating Copies data on which alert is not enabled on copy and available in MMEntityProp.
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId, onlyEvent)
SELECT MMEP.EntityId, AGC.archGroupid, MMEP.CommCellId, CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END, 1
FROM MMEntityProp MMEP WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE MMEP.EntityId = AGC.id AND AG.id = AGC.archGroupId
	AND MMEP.EntityType = 2
	AND MMEP.propertyName = 'auxCopyAlertEnabled'
	AND MMEP.intVal = 0
AND AGC.type IN (1, 2)
	AND AGC.id <> AG.defaultCopy
AND AGC.flags & 524288  = 0
AND AGC.extendedFlags & 8 = 0
	AND AGC.origCCcommCellID in (0,2)
-- Populating Copies data on which alert is not enabled on copy and not available in MMEntityProp.
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId, onlyEvent)
SELECT AGC.id, AGC.archGroupid, CASE WHEN AGC.origCCcommCellID = 0 THEN 2 ELSE AGC.origCCcommCellID END, CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END, 1
FROM archGroupCopy AGC WITH (NOLOCK)
	INNER JOIN archGroup AG WITH (NOLOCK)
		ON AG.id = AGC.archGroupId
AND AGC.type IN (1, 2)
		AND AGC.id <> AG.defaultCopy
AND AGC.flags & 524288  = 0
AND AGC.extendedFlags & 8 = 0
	LEFT OUTER JOIN MMEntityProp MMEP WITH (NOLOCK)
		ON MMEP.EntityId = AGC.id AND MMEP.propertyName = 'auxCopyAlertEnabled' AND MMEP.EntityType = 2
	WHERE MMEP.EntityId IS NULL
	AND AGC.origCCcommCellID in (0,2)
-- remove copies that haven't even completed  fallen behind interval since they were created.
DELETE @tblAGC1
FROM @tblAGC1 t1, MMConfigs m WITH (READUNCOMMITTED)
WHERE (@l_now - (SELECT dbo.GetUnixTime(MIN(modified)) FROM archGroupCopyCoreHistory H WITH (READUNCOMMITTED) WHERE t1.archCopyId = H.ArchGroupCopyId))  <= m.value *60*60
	AND m.name = 'MMS2_CONFIG_STRING_AUXCOPY_FALLEN_BEHIND_ALERTS_INTERVAL_HOURS'
--Getting configuration values from MMEntityprop table for each copy
UPDATE AGC
SET AGC.AuxCopyAlertGB = MMEP1.longlongVal,
	AGC.AuxCopyAlertDays = MMEP2.intVal,
	AGC.AuxCopyAlertHours = MMEP3.intVal
FROM @tblAGC1 AGC, MMEntityProp MMEP1 WITH (NOLOCK),
	MMEntityProp MMEP2 WITH (NOLOCK),
	MMEntityProp MMEP3 WITH (NOLOCK)
WHERE 	AGC.archCopyid = MMEP1.EntityId AND AGC.commCellId = MMEP1.CommCellId AND MMEP1.EntityType = 2
	AND AGC.archCopyid = MMEP2.EntityId AND AGC.commCellId = MMEP2.CommCellId AND MMEP2.EntityType = 2
	AND AGC.archCopyid = MMEP3.EntityId AND AGC.commCellId = MMEP3.CommCellId AND MMEP3.EntityType = 2
	AND MMEP1.propertyName  = 'AuxCopyAlertGB'
	AND MMEP2.propertyName  = 'AuxCopyAlertDays'
	AND MMEP3.propertyName  = 'AuxCopyAlertHours'
	AND AGC.onlyEvent = 0
-- updating default event generation criteria to 90 days
UPDATE AGC
SET AGC.AuxCopyAlertGB = 0,
	AGC.AuxCopyAlertDays = 90,
	AGC.AuxCopyAlertHours = 0
FROM @tblAGC1 AGC
	WHERE AGC.onlyEvent = 1
-- Getting all the to be copied Job with data types per copy
-- Data type is considered because we have individual retention criteria for data types ( eg. data, log ...)
-- So for alert about exact to be copied we have to consider each data type to be copied size.
INSERT #tblJobDataType
SELECT JD.jobId, JD.commCellId, JD.archGrpCopyId, JD.dataType, JD.status, 0, 0
FROM JMJobDataStats JD WITH (NOLOCK), JMJobDataStats JS WITH (NOLOCK), @tblAGC1 AGC
WHERE  JD.archGrpId = JS.archGrpId
	AND JD.jobId = JS.jobId
	AND JD.dataType = JS.dataType
	AND JD.commCellId = JS.commCellId
AND (JS.disabled & (1  + 256) = 0)
AND (JD.disabled & (1  + 256) = 0)
	AND JS.status = 100
	AND JD.status IN (101,102,103)
	AND JD.archGrpCopyId = AGC.archCopyId
	AND JS.archGrpCopyId = AGC.sourceCopyId
-- Populating UnCompSize and physicalSize for each Job data type from source copy
UPDATE	JT
SET		JT.toBeCopiedBytes = JS.UnCompSize, JT.toBeCopiedPhysicalBytes = JS.physicalSize
FROM	#tblJobDataType JT, ( SELECT J.archGrpCopyId, J.commCellId, J.jobId, J.dataType, CASE WHEN MIN(AFC.unCompSize) <= 0 THEN -1 ELSE SUM(AFC.unCompSize) END UnCompSize, SUM(physicalSize) physicalSize
FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK), #tblJobDataType J, @tblAGC1 AGC
WHERE AFC.archFileId = AF.id
	AND AFC.commCellId = AF.commcellId
	AND AF.jobId = J.jobId
	AND AF.commCellId =  J.commCellId
	AND  AF.fileType = J.dataType
	AND J.archGrpCopyId = AGC.archCopyId
	AND AFC.archCopyId = AGC.sourceCopyId
	  AND AF.isvalid = 1
	GROUP BY J.archGrpCopyId, J.jobId, J.commCellId, J.dataType ) JS
WHERE JT.jobId = JS.jobId
	AND JT.commCellId = JS.commCellId
	AND JT.dataType = JS.dataType
	AND JT.archGrpCopyId = JS.archGrpCopyId
-- Two Cases where we cannot do any partial data copied subtraction
-- 1. When UnCompSize on Source is -ve or 0, we cannot subtract anything from source.
-- 2. When UnCompSize on Dest is -ve or 0, we do not have any correct value for subtraction.
-- In these above cases we are dependent on physical size which later converted into unCompSize using archGetJobSizeInfo.sp .
UPDATE	JT
SET JT.toBeCopiedBytes =  CASE WHEN JT.toBeCopiedBytes = -1 OR S.UnCompCopiedBytes = -1 THEN -1 ELSE JT.toBeCopiedBytes - S.UnCompCopiedBytes END , JT.toBeCopiedPhysicalBytes = JT.toBeCopiedPhysicalBytes - S.physicalCopiedBytes
FROM #tblJobDataType JT
   JOIN
		(SELECT	J.JobId, J.commCellId, J.archGrpCopyId, J.dataType, CASE WHEN MIN(AFC.unCompSize) <= 0 THEN -1 ELSE SUM(AFC.unCompSize) END UnCompCopiedBytes, SUM(AFC.physicalSize) physicalCopiedBytes
		FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK), #tblJobDataType J
		WHERE AFC.archFileId = AF.Id
			AND AFC.commCellId = AF.commCellId
			AND AF.jobId = J.jobId
			AND AF.fileType  = J.dataType
			AND AFC.archCopyId = J.archGrpCopyId
		    AND J.status <> 101
		GROUP BY J.JobId, J.commCellId, J.archGrpCopyId, J.dataType) S
  ON JT.jobId = S.jobId
	AND JT.commCellId = S.commCellId
	AND JT.archGrpCopyId = S.archGrpCopyId
	AND JT.dataType = S.dataType
-- If for any data type for each job, we get -ve or 0 uncompsize then we will use physical size for unCompSize.
INSERT #tblJob
SELECT	jobId, commCellId, archGrpCopyId, 0 'jobEndTime', CASE WHEN MIN(J.toBeCopiedBytes) <= 0 THEN -1 ELSE SUM(J.toBeCopiedBytes) END, SUM(J.toBeCopiedPhysicalBytes)
FROM #tblJobDataType J
GROUP BY archGrpCopyId, jobId, commCellId
UPDATE	J
SET		J.jobEndTime = B.servEndDate
FROM	#tblJob J, JMBkpStats B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
UPDATE	J
SET		J.jobEndTime = B.servEnd
FROM	#tblJob J, JMadminJobStatsTable B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
INSERT #tmpJobSizeInfo
SELECT DISTINCT jobId, commCellId, 0, 0, 0 FROM  #tblJob
WHERE toBeCopiedBytes <= 0
EXEC archGetJobSizeInfo 0
UPDATE T
SET T.toBeCopiedBytes = CASE WHEN TS.totalBackupSize > 0 THEN  T.toBeCopiedPhysicalBytes*1.00*(TS.totalAppSize + TS.totalIndexSize)/TS.totalBackupSize ELSE (TS.totalAppSize + TS.totalIndexSize) END
FROM #tblJob T , #tmpJobSizeInfo TS
WHERE T.jobId = TS.JobId AND T.commCellId = TS.CommCellId
	AND toBeCopiedBytes <= 0
INSERT @lastAuxJobs
SELECT DISTINCT RN.archGrpCopyId, RN.jobId, RN.BytesXferred,  RN.totalWriteTime*@l_REAL*RN.BytesXferred / RN.EX_TotalSuccess
FROM   @tblAGC1 A
		CROSS APPLY
	(SELECT TOP(@l_lastjobs) J.*, JA.totalWriteTime, JA.EX_TotalSuccess
	FROM JMDataCopiedStatsTable J WITH (NOLOCK), JMAdminJobStatsTable JA WITH (NOLOCK)
	WHERE J.archGrpCopyId = A.archCopyId
	AND J.jobId = JA.jobId
	AND JA.commCellId = J.commCellId
	AND J.commCellId = A.commCellId
	AND JA.opType IN (13, 104)
	AND JA.EX_TotalSuccess > 0
	ORDER BY J.jobId DESC) RN
	WHERE A.onlyEvent = 0
-- Getting the running auxiliary copy jobs throughput.
INSERT @lastAuxJobs
SELECT DISTINCT J.archGrpCopyId, J.jobId, J.BytesXferred, elapsedTime*@l_REAL*J.BytesXferred/RAJ.ObjectsDone
FROM JMDataCopiedStatsTable J WITH (NOLOCK), @tblAGC1 A, RunningAdminJobs RAJ WITH (NOLOCK)
WHERE J.jobId = RAJ.jobId
	AND J.commCellId = RAJ.commCellId
	AND A.archCopyId = J.archGrpCopyId
	AND RAJ.opType IN (13, 104)
	AND RAJ.ObjectsDone  > 0
	AND J.archGrpCopyId NOT IN (SELECT DISTINCT archCopyId FROM @lastAuxJobs)
	AND A.onlyEvent = 0
-- remove jobs that do not fit in deferred category
DELETE J
FROM #tblJob J, archGroupCopy AGC
WHERE (J.jobEndTime + (AGC.delayedDays*24*3600)) > @l_now
AND AGC.id = J.archGrpCopyId
AND AGC.delayedDays <> 0
-- Aggregating the data from #tblJob and @lastAuxJobs table.
INSERT INTO @tblAGC2
SELECT AG.archGroupId, J.archGrpCopyId, J.numofToBeCopiedJobs, J.jobEndTime, J.toBeCopiedBytes,
(CASE WHEN TP.wTime > 0 THEN  TP.BytesTransfer / TP.wTime ELSE  0 END), 0, 0, AG.onlyEvent
FROM @tblAGC1 AG
JOIN (SELECT archGrpCopyId, COUNT(jobId) as numofToBeCopiedJobs, MIN(jobEndTime) as jobEndTime, SUM(toBeCopiedBytes) as toBeCopiedBytes
	FROM #tblJob GROUP BY archGrpCopyId, commCellId) J
	ON AG.archCopyid = J.archGrpCopyId
LEFT OUTER JOIN
( SELECT archCopyId, SUM(bytesCopied) BytesTransfer, SUM(writeTime) wTime
FROM @lastAuxJobs
GROUP BY archCopyId ) TP
ON  AG.archCopyId = TP.archCopyId
UPDATE AG
SET AG.subClients = SC.subclients
FROM @tblAGC2 AG,
(SELECT J.archGrpCopyId , COUNT(DISTINCT J.appId) 'subclients'
FROM JMJobDataStats J WITH (NOLOCK), @tblAGC2 A
WHERE J.archGrpCopyId = A.archGrpCopyId and J.disabled & (256 + 1) = 0 AND J.status IN (100, 101, 102, 103)
GROUP BY J.archGrpCopyId ) SC
WHERE AG.archGrpCopyId = SC.archGrpCopyId
	AND AG.onlyEvent = 0
--Updating the alert reason for each criteria.
UPDATE @tblAGC2
SET alertReason = alertReason | 1
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertDays > 0 AND (@l_now - AGC2.oldestJobEndTime)/24/3600 > AGC1.AuxCopyAlertDays)
UPDATE @tblAGC2
SET alertReason = alertReason | 2
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertGB > 0 AND AGC2.toBeCopiedBytes*@l_REAL/1024/1024/1024/1024 > AGC1.AuxCopyAlertGB)
	 AND AGC2.onlyEvent = 0
UPDATE @tblAGC2
SET alertReason = alertReason | 4
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertHours > 0 AND (AGC2.thPut > 0 AND
	 (AGC1.AuxCopyAlertHours*3600 < AGC2.toBeCopiedBytes/AGC2.thPut)))
	 AND AGC2.onlyEvent = 0
IF (OBJECT_ID('tempdb.dbo.#tblTotalHoursToCopyDetails') IS NOT NULL)
BEGIN
UPDATE @tblAGC2
SET alertReason = alertReason | 4
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertHours > 0 AND (AGC2.thPut > 0))
	 AND AGC2.onlyEvent = 0
	DELETE @tblAGC2
	WHERE alertReason & 4 <> 4
END
ELSE
BEGIN
	-- Deleting the copies data where it do not satisfy the alert or event criteria.
	DELETE @tblAGC2
	WHERE alertReason = 0
END
IF OBJECT_ID('tempdb.dbo.#UncopiedMediaAuxCopyFallenBehindAlert') IS NOT NULL DROP TABLE #UncopiedMediaAuxCopyFallenBehindAlert
CREATE TABLE #UncopiedMediaAuxCopyFallenBehindAlert (
		policyId		integer,
policyName 		NVARCHAR(256),
		copyId			integer,
copyName		NVARCHAR(64),
		streamNum		integer,
		mediaGroupId 	integer,
		mediaId			integer,
uniqueId		char(300),
barCode 		char(256),
		attributes	 	integer,
		guiAttributes	integer,
		libraryId		integer,
libraryName		NVARCHAR(128),
		locationType	integer,
		locationId 		integer,
location		NVARCHAR(1024),
		uncopiedBytes	bigint,
		reason			integer)
IF OBJECT_ID('tempdb.dbo.#tblArchUncopiedMediaInputSps') IS NOT NULL DROP TABLE #tblArchUncopiedMediaInputSps
CREATE TABLE #tblArchUncopiedMediaInputSps(archGrpId INT, copyId INT, defaultCopyId INT)
INSERT INTO #tblArchUncopiedMediaInputSps
SELECT DISTINCT archGrpId,0 , 0 FROM @tblAGC2
INSERT	INTO #UncopiedMediaAuxCopyFallenBehindAlert
EXEC	archUncopiedMedia  0, 0
IF OBJECT_ID('tempdb.dbo.#tblArchUncopiedMediaInputSps') IS NOT NULL DROP TABLE #tblArchUncopiedMediaInputSps
IF (OBJECT_ID('tempdb.dbo.#tblTotalHoursToCopyDetails') IS NOT NULL)
 INSERT INTO #tblTotalHoursToCopyDetails
	SELECT	S.policyId, S.policyName, S.copyId, S.copyName, T.toBeCopiedBytes, S.numOfMedia, T.numOfJobs, T.oldestJobEndTime, (CASE WHEN T.thPut  <> 0 THEN ROUND((T.toBeCopiedBytes*@l_REAL/T.thPut),0) ELSE 0 END), T.subClients, T.alertReason, T.onlyEvent
	FROM	@tblAGC2 T,
			(SELECT	policyId, policyName, copyId, copyName, SUM(uncopiedBytes) AS uncopiedBytes, COUNT(*) AS numOfMedia
			FROM	#UncopiedMediaAuxCopyFallenBehindAlert
			GROUP BY policyId, policyName, copyId, copyName) S
	WHERE	S.copyId = T.archGrpCopyId
ELSE
	SELECT	S.policyId, S.policyName, S.copyId, S.copyName, T.toBeCopiedBytes, S.numOfMedia, T.numOfJobs, T.oldestJobEndTime, (CASE WHEN T.thPut  <> 0 THEN ROUND((T.toBeCopiedBytes*@l_REAL/T.thPut/3600),0) ELSE 0 END), T.subClients, T.alertReason, T.onlyEvent
	FROM	@tblAGC2 T,
			(SELECT	policyId, policyName, copyId, copyName, SUM(uncopiedBytes) AS uncopiedBytes, COUNT(*) AS numOfMedia
			FROM	#UncopiedMediaAuxCopyFallenBehindAlert
			GROUP BY policyId, policyName, copyId, copyName) S
	WHERE	S.copyId = T.archGrpCopyId
IF (OBJECT_ID('tempdb.dbo.#tblJobDataType') IS NOT NULL) DROP TABLE #tblJobDataType
IF (OBJECT_ID('tempdb.dbo.#tblJob') IS NOT NULL) DROP TABLE #tblJob
IF (OBJECT_ID('tempdb.dbo.#UncopiedMediaAuxCopyFallenBehindAlert') IS NOT NULL) DROP TABLE #UncopiedMediaAuxCopyFallenBehindAlert
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archAuxCopyFallenBehindAlert')
	delete from GxQscripts where name = 'archAuxCopyFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAuxCopyFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'archAuxCopyFallenBehindAlert'
GO

insert into GXDBVersions values(2, 'archAuxCopyFallenBehindAlert',  '00010020001200110000', 'archAuxCopyFallenBehindAlert', '00010020001200110000')
GO

