

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAutoDDBVerifyTaskToBeRunEx.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAutoDDBVerifyTaskToBeRunEx.sp,v $ $Id: archAutoDDBVerifyTaskToBeRunEx.sp,v 1.1.2.25 2020/12/10 01:43:05 chandru Exp $";
--
--  +========================================================================+
--  | Stored Procedure:  archAutoDDBVerifyTaskToBeRunEx
--	| Author:	Chandru
--  |
--  | Description:  For a given task ID, check if there are to be copied jobs.
--	|				Then check if there is already a running auxiliary copy job
--	|				for the the storage policy/copy.
--	| Input:		task ID
--	| Output:		o_archGrpId, o_archGrpCopyId, o_errorCode
--	|
--	|	o_errorCode									Action needed
--	|	---------------------------------------------------------------------
--	|  	E_ARCH_INVALID_DDB_VERIFY_TASK_ID			Invalidate task
--	|  	E_ARCH_NO_SP_COPY_FROM_ADMINTASK			Invalidate task
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_SP				No action
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_COPY			No action
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_SIDBSTORE		No action
--	|	E_ARCH_NO_DATA_NEED_VERIFY					No action
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archAutoDDBVerifyTaskToBeRunEx')
BEGIN
	print '>>> Drop Stored Procedure: archAutoDDBVerifyTaskToBeRunEx <<<'
	drop procedure archAutoDDBVerifyTaskToBeRunEx
END
IF EXISTS (select * from GxQscripts where name='archAutoDDBVerifyTaskToBeRunEx')
	delete from GxQscripts where name = 'archAutoDDBVerifyTaskToBeRunEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoDDBVerifyTaskToBeRunEx')
	delete from GXDBVersions where aliasname = 'archAutoDDBVerifyTaskToBeRunEx'
GO
print '... Creating Procedure: archAutoDDBVerifyTaskToBeRunEx'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archAutoDDBVerifyTaskToBeRunEx
  @i_taskId integer,
  @i_today integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archGrpId integer
  DECLARE @o_archGrpCopyId integer
  DECLARE @o_sidbStoreIdId integer
  DECLARE @o_errorCode integer
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
DECLARE @l_subTaskId INT = 0
DECLARE @l_operationType INT = 0
DECLARE @l_subOperationType INT = 0
SELECT  @l_subTaskId = subTaskId, @l_operationType = operationType FROM TM_SubTask WHERE taskId = @i_taskId
DECLARE @l_ddbVerificationLevel NVARCHAR(MAX) = '0'
DECLARE @l_ddbVerificationBackupLevel NVARCHAR(MAX) = '0'
DECLARE @l_error		int = 0
DECLARE @monthsToRunFullQDV2 INT  =  6
SET @monthsToRunFullQDV2 = ISNULL((SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_MONTHS_TO_RUN_QUICK_DV2'),6)
SELECT	@l_ddbVerificationLevel = (CASE WHEN OptionId = 1616894445 THEN value ELSE @l_ddbVerificationLevel END),
@l_subOperationType = (CASE WHEN OptionId = 449788653 THEN value ELSE @l_subOperationType END),
@l_ddbVerificationBackupLevel= (CASE WHEN optionId = 1492218294 THEN value ELSE @l_ddbVerificationBackupLevel END)
FROM	TM_SubTaskOptions
WHERE	subTaskId = @l_subTaskId AND optionId IN (1616894445, 449788653,1492218294)
IF @l_operationType != 4007 OR @l_ddbVerificationLevel NOT IN (1, 2, 3, 4)
BEGIN
SET	@l_error = 163
	GOTO CV_EXIT
END
-- None of these temp tables should ever exist when this procedure is called!
IF OBJECT_ID('TempDb..#DataStats') IS NOT NULL
	DROP TABLE #DataStats
CREATE TABLE #DataStats (
	jobId		INT,
	commCellId	INT,
	dataType	INT,
	archGrpCopyId INT,
	archCheckStatus	INT,
	copiedTime		INT
)
IF OBJECT_ID('TempDb..#StoreIds') IS NOT NULL
	DROP TABLE #StoreIds
CREATE TABLE #StoreIds (
	storeId INT PRIMARY KEY
)
if object_id('tempdb.dbo.#assocTblAutoDDBVerify') is not null
		DROP TABLE #assocTblAutoDDBVerify
CREATE TABLE #assocTblAutoDDBVerify ( policyId INT,  copyId INT, srmReportSet INT, srmReportType INT, trackingPolicyId INT,  mediaAgentId INT, agentLessPolicyId INT, workFlowId INT, sidbStoreId INT, libraryId INT, logMonitoringPolicyId INT,
							entityId INT , entityType INT,	dataSourceId INT,
							 clientGroupId INT DEFAULT 0,
							 clientId INT DEFAULT 0,
							 appTypeId INT DEFAULT 0,
							 instanceId INT DEFAULT 0,
							 backupsetId INT DEFAULT 0,
							 appId INT DEFAULT 0,
							 exclude INT DEFAULT 0,
							 workflowOption NVARCHAR(MAX)
							 PRIMARY KEY (SIDBstoreid, policyId, copyId))
INSERT INTO #assocTblAutoDDBVerify
EXEC	TM_GetAdminEntity @i_taskId, @l_subTaskId
IF NOT EXISTS (SELECT * FROM #assocTblAutoDDBVerify)
BEGIN
SET	@l_error = 38
	GOTO CV_EXIT
END
ALTER TABLE #assocTblAutoDDBVerify ADD error INT DEFAULT 0
UPDATE	#assocTblAutoDDBVerify
SET		error = 0
UPDATE	#assocTblAutoDDBVerify
SET		error = (CASE WHEN J.archGrpCopyId = 0 THEN 26 ELSE 27 END)
FROM	#assocTblAutoDDBVerify T, JMAdminJobInfoTable J WITH (NOLOCK)
WHERE	T.error = 0
		AND J.OpType IN (31)
		AND T.policyId = J.archGrpID
		AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = T.copyId)
		AND T.SIDBStoreId = 0
UPDATE	#assocTblAutoDDBVerify
SET		error = 164
FROM	#assocTblAutoDDBVerify T, JMAdminJobInfoTable J WITH (NOLOCK)
WHERE	T.error = 0
		AND J.OpType IN (99) --MOVEDDB
		AND T.SIDBStoreID = J.CloudId
IF NOT EXISTS (SELECT * FROM #assocTblAutoDDBVerify WHERE error = 0)
	GOTO CV_EXIT
DECLARE @l_archGroupId	int = 0
DECLARE @l_archCopyId	int = 0
DECLARE @l_sidbStoreId	int = 0
DECLARE @l_currentTime  INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @l_currentTimeMinusOneDay INT = @l_currentTime - 24 * 60 * 60
DECLARE @l_agedFlag INT = 256
DECLARE @l_CopiedStatus INT = 100
DECLARE @verifyConflictingJobTable TABLE (conflictingJobID	integer, conflictingJobOptype integer)
DECLARE	copyCursor CURSOR FOR
		SELECT	policyId, copyId, sidbStoreID
		FROM	#assocTblAutoDDBVerify
		WHERE	error = 0
OPEN copyCursor
FETCH NEXT FROM copyCursor INTO @l_archGroupId, @l_archCopyId, @l_sidbStoreId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM @verifyConflictingJobTable
	INSERT INTO @verifyConflictingJobTable
	EXEC archChunkToVerifyCheckConflictingJob @l_archGroupId, @l_archCopyId, @l_sidbStoreId
	IF EXISTS (SELECT * FROM @verifyConflictingJobTable)
	BEGIN
		UPDATE	#assocTblAutoDDBVerify
SET		error = (CASE WHEN (J.CloudId = @l_sidbStoreId) THEN 164 ELSE ((CASE WHEN J.archGrpCopyId = 0 THEN 26 ELSE 27 END)) END)
		FROM	#assocTblAutoDDBVerify T, @verifyConflictingJobTable V, JMAdminJobInfoTable J WITH (NOLOCK)
		WHERE	T.error = 0
				AND T.policyId = @l_archGroupId
				AND T.copyId = @l_archCopyId
				AND T.sidbStoreId = @l_sidbStoreId
				AND V.conflictingJobID = J.JobId
	END
	FETCH NEXT FROM copyCursor INTO @l_archGroupId, @l_archCopyId, @l_sidbStoreId
END
CLOSE copyCursor
DEALLOCATE copyCursor
--drop  INDEX DataStats_idx ON #DataStats
INSERT INTO #DataStats
SELECT DISTINCT jobid, commcellid, datatype, archGrpCopyId, archCheckStatus, copiedTime
FROM JMJobDataStats WITH (READUNCOMMITTED)
WHERE status = @l_CopiedStatus AND (disabled & @l_agedFlag) = 0
CREATE CLUSTERED INDEX DataStats_idx ON #DataStats (jobid, commcellid, datatype, archGrpCopyId, archCheckStatus)
IF 	(@l_ddbVerificationLevel = 4) OR
( EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_RUN_DV2_SIMPLIFIED' AND value = 0) AND (@l_ddbVerificationLevel = 1))
BEGIN
	INSERT INTO #StoreIds (storeId)
	SELECT 	DISTINCT S.SIDBStoreId
	FROM	#assocTblAutoDDBVerify S
			INNER JOIN archFileCopyDedup AFCD WITH (READCOMMITTED) ON S.sidbStoreId = AFCD.SIDBStoreId
			INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.commcellId = AFCD.commcellId
			INNER JOIN #DataStats JDS WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobID AND AF.commcellId = JDS.commcellId AND JDS.archGrpCopyId = AFCD.archCopyId AND JDS.dataType = AF.fileType
	WHERE	S.error = 0
END
ELSE
BEGIN
	IF (@l_ddbVerificationLevel = 2)
	BEGIN
		INSERT INTO #StoreIds (storeId)
			SELECT
				T.sidbStoreId
			FROM	#assocTblAutoDDBVerify T
				INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON T.sidbStoreId = I.SIDBStoreId
				INNER JOIN archFileCopyDedup AFCD WITH (READCOMMITTED) ON T.sidbStoreId = AFCD.SIDBStoreId
				INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.commcellId = AFCD.commcellId
				INNER JOIN #DataStats JDS WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobID AND AF.commcellId = JDS.commcellId AND JDS.archGrpCopyId = AFCD.archCopyId AND JDS.dataType = AF.fileType
			WHERE
				JDS.copiedTime >  I.LastDDBVerificationTime
				AND T.error = 0
			UNION
			SELECT
				T.sidbStoreId
			FROM	#assocTblAutoDDBVerify T
				INNER JOIN archFileCopyDedup AFCD WITH (READCOMMITTED) ON T.sidbStoreId = AFCD.SIDBStoreId
				INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.commcellId = AFCD.commcellId
				INNER JOIN #DataStats JDS WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobID AND AF.commcellId = JDS.commcellId AND JDS.archGrpCopyId = AFCD.archCopyId AND JDS.dataType = AF.fileType
			WHERE
				JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)
				AND T.error = 0
	END
	ELSE
	BEGIN
		INSERT INTO #StoreIds (storeId)
			SELECT
				T.sidbStoreId
			FROM	#assocTblAutoDDBVerify T
				INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON T.sidbStoreId = I.SIDBStoreId
				INNER JOIN archFileCopyDedup AFCD WITH (READCOMMITTED) ON T.sidbStoreId = AFCD.SIDBStoreId
				INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.commcellId = AFCD.commcellId
				INNER JOIN #DataStats JDS WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobID AND AF.commcellId = JDS.commcellId AND JDS.archGrpCopyId = AFCD.archCopyId AND JDS.dataType = AF.fileType
			WHERE
				JDS.copiedTime >  I.LastDataVerificationTime
				AND T.error = 0
			UNION
			SELECT
				T.sidbStoreId
			FROM	#assocTblAutoDDBVerify T
				INNER JOIN archFileCopyDedup AFCD WITH (READCOMMITTED) ON T.sidbStoreId = AFCD.SIDBStoreId
				INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.commcellId = AFCD.commcellId
				INNER JOIN #DataStats JDS WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobID AND AF.commcellId = JDS.commcellId AND JDS.archGrpCopyId = AFCD.archCopyId AND JDS.dataType = AF.fileType
			WHERE
				JDS.archCheckStatus IN (3/*ACS_TOBECHECKED*/,4/*ACS_PARTCHECKED*/)
				AND T.error = 0
	END
END
UPDATE	#assocTblAutoDDBVerify
SET		error =  165
FROM	#assocTblAutoDDBVerify T
		LEFT OUTER JOIN #StoreIds S ON
			T.sidbStoreId = S.storeId
WHERE
	T.error = 0
	AND S.storeId IS NULL
IF (@l_operationType = 4007
	AND @l_ddbVerificationLevel = 4 /*TMMsg::DDBVerificationLevel_DDB_DEFRAGMENTATION*/
AND EXISTS (SELECT TOP 1 TaskId FROM TM_Task WHERE taskId = @i_taskId AND (flags & (CAST(0x40000 AS INT)|CAST(0x4 AS INT))) = (CAST(0x40000 AS INT)|CAST(0x4 AS INT))))
BEGIN
	DECLARE			@currentTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE		@l_lowWaterMarkPercent INTEGER = 50;
	SELECT		@l_lowWaterMarkPercent = value
	FROM		MMConfigs WITH (READUNCOMMITTED)
	WHERE		name = 'MMS2_CONFIG_LOW_WATERMARK_PERC_TO_SUBMIT_DEFRAG_JOB'
	DECLARE		@l_maxJobsAllowedToSubmit INTEGER = 1;
	SELECT		@l_maxJobsAllowedToSubmit = value
	FROM		MMConfigs WITH (READUNCOMMITTED)
	WHERE		name = 'MMS2_CONFIG_MAX_DEFRAG_JOBS_ALLOWED_TO_SUBMIT'
	DECLARE		@l_storeIntervalDays INTEGER = 30;
	SELECT		@l_storeIntervalDays = value
	FROM		MMConfigs WITH (READUNCOMMITTED)
	WHERE		name = 'MMS2_CONFIG_CHECKTWEAK_MPDEFRAGJOBSUBMITONSTORE_INTERVAL_DAYS'
	--
	-- 1. Get libs with drill holes not supported
	--		1A. For Gluster FS Mount path check low water mark stored in MMConfig
	--		1B. For Non Gluster FS Mount Path check low water mark on library
	--		1C. Do not pick cloud mount paths in both conditions
	-- 2. Update for those having less than @i_threshold free space
	-- 3. For each of those ddbs/copies, insert into tm_request to start defrag job
	--
	declare @l_DefragJobLibs		table (libId int, capacityMB bigint, freebytesMB bigint)
	declare @l_DefragJobStores	table (SIDBStoreId int, CopyId int, lastDefragRunTime bigint, taskXml XML)
	insert into @l_DefragJobLibs
	select	mp.LibraryId, sum(ms.totalspacemb), sum(ms.freebytesmb)
	from	mmmountpath mp with (readuncommitted) inner join
			mmmediaside ms with (readuncommitted) ON MP.MediaSideId = MS.MediaSideId inner join
			MMLibrary ML with (readuncommitted) on MP.LibraryId = ML.LibraryId
	where	MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
AND (MP.Attribute & 64) = 64
			AND MP.MountPathTypeId != 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	group by mp.LibraryId, ML.LowWaterMarkMB
	having ((sum(ms.totalspacemb) > 0) AND ((sum(ms.FreeBytesMB) * 100)/sum(ms.totalspacemb) <= @l_lowWaterMarkPercent))
	insert into @l_DefragJobLibs
	select	mp.LibraryId, sum(ms.totalspacemb), sum(ms.freebytesmb)
	from	mmmountpath mp with (readuncommitted) inner join
			mmmediaside ms with (readuncommitted) ON MP.MediaSideId = MS.MediaSideId inner join
			MMLibrary ML with (readuncommitted) on MP.LibraryId = ML.LibraryId
	where	MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
AND (MP.Attribute & 64) = 0
			AND MP.MountPathTypeId != 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	group by mp.LibraryId, ML.LowWaterMarkMB
	having ((sum(ms.totalspacemb) > 0) AND ((sum(ms.FreeBytesMB) * 100)/sum(ms.totalspacemb) <= ML.LowWaterMarkMB))
	INSERT INTO @l_DefragJobStores
	SELECT S.SIDBStoreId, C.CopyId, 0, ''
	FROM
		(SELECT	DISTINCT AGC.id CopyId
		FROM	@l_DefragJobLibs L
					INNER JOIN MMMasterPool MP  WITH (READUNCOMMITTED) ON L.libId = MP.LibraryId
					INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON MP.MasterPoolId = DP.MasterPoolId
					INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPath.DrivePoolId
INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON DPath.CopyId = AGC.id AND ((AGC.dedupeflags & 134217728) = 0)) C,
		archCopySIDBStore S,		#assocTblAutoDDBVerify T
	WHERE	C.CopyId = S.CopyId
			AND S.SIDBStoreId = T.SIDBStoreId
			AND T.error = 0
	-- Remove the stores had Defrag jobs ran in last 30 days
	UPDATE	S
	SET		lastDefragRunTime = T.servStart
	FROM	@l_DefragJobStores S,
			(SELECT	S.SIDBStoreId, MAX(J.servStart) servStart
			FROM	@l_DefragJobStores S,
					JMAdminJobStatsTable J WITH (READUNCOMMITTED)
						LEFT OUTER JOIN  JMAdminJobAttemptStatsTable JA WITH (READUNCOMMITTED)
							ON	J.jobId = JA.JobId
								AND J.CommCellId = JA.CommCellId
								AND JA.attemptNum = 1
								AND JA.phaseNum = 4 /*DEFRAGMENT*/
			WHERE	S.SIDBStoreId = J.CloudId
					AND J.opType = 31
					AND (JA.JobId IS NOT NULL
OR dbo.GetJobOption(J.JobId, 1616894445) = 4 /*TMMsg::DDBVerificationLevel_DDB_DEFRAGMENTATION*/)
			GROUP BY S.SIDBStoreId) T
	WHERE	S.SIDBStoreId = T.SIDBStoreId
	UPDATE	T
SET		error = (CASE WHEN (S.SIDBStoreId IS NULL) THEN 232
WHEN (S.lastDefragRunTime > (@currentTime - (@l_storeIntervalDays * 24 * 3600))) THEN 233
						  ELSE T.error
					END)
	FROM	#assocTblAutoDDBVerify T LEFT OUTER JOIN @l_DefragJobStores S ON S.SIDBStoreId = T.SIDBStoreId
	WHERE	T.error = 0
	-- Remove the stores had Defrag jobs ran in last configured days
	DELETE	S
	FROM	@l_DefragJobStores S
	WHERE	S.lastDefragRunTime > (@currentTime - (@l_storeIntervalDays * 24 * 3600))
	-- Keep only max defrag jobs allowed to submit
	DELETE	S
	FROM	@l_DefragJobStores S
	WHERE	S.SIDBStoreId NOT IN (	SELECT TOP (@l_maxJobsAllowedToSubmit)	T.SIDBStoreId
									FROM	@l_DefragJobStores T, IdxSIDBStore I WITH (READUNCOMMITTED)
									WHERE	T.SIDBStoreId = I.SIDBStoreId
									ORDER BY lastDefragRunTime, I.TotalDataSizeBytes DESC)
	UPDATE	T
SET		error = (CASE WHEN (S.SIDBStoreId IS NULL) THEN 234
						  ELSE T.error
					END)
	FROM	#assocTblAutoDDBVerify T LEFT OUTER JOIN @l_DefragJobStores S ON S.SIDBStoreId = T.SIDBStoreId
	WHERE	T.error = 0
	-- Populate the Stores which did not have OCL phase run after the last full recon
	IF EXISTS (SELECT  Value
				FROM    GXGlobalParam
				WHERE   name = 'EnableOrphanChunkListing'
AND ((CAST(value AS INT) & 0x2) > 0))
	BEGIN
		;WITH  FullReconJobCTE (SIDBStoreId, LastFullReconJobId)
		AS
		(
			SELECT  H.SIDBStoreId, MAX(AdminJobId)
			FROM    IdxSIDBRecoveryHistory H WITH (READUNCOMMITTED)
					LEFT OUTER JOIN @l_DefragJobStores S ON H.SIDBStoreId = S.SIDBStoreId
			WHERE   S.SIDBStoreId IS NULL
AND (H.flags & 4) > 0
					AND H.Status IN (1, 3, 14)
			GROUP BY H.SIDBStoreId
		)
		INSERT INTO @l_DefragJobStores
		SELECT  F.SIDBStoreId, S.CopyId, 0, ''
		FROM	FullReconJobCTE F
				INNER JOIN IdxSIDBRecoveryHistory H WITH (READUNCOMMITTED) ON F.LastFullReconJobId = H.AdminJobId
				INNER JOIN archCopySIDBStore S WITH (READUNCOMMITTED) ON F.SIDBStoreId = S.SIDBStoreId
				INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON S.CopyId = AGC.id
		WHERE	F.LastFullReconJobId > 0
AND (H.flags & 8) = 0
AND ((AGC.dedupeflags & 134217728) = 0)
		BEGIN
			UPDATE	T
			SET		error = 0
			FROM	#assocTblAutoDDBVerify T INNER JOIN @l_DefragJobStores S ON S.SIDBStoreId = T.SIDBStoreId
			WHERE	T.error != 0
		END
	END
END
CV_EXIT:
IF (@l_error > 0)
	SELECT	0, 0, 0, @l_error
ELSE
	SELECT	E.policyId, E.copyId, E.sidbStoreId, MIN(error)
	FROM	#assocTblAutoDDBVerify E
	GROUP BY E.policyId, E.copyId, E.sidbStoreId
GO

IF EXISTS (select * from GxQscripts where name = 'archAutoDDBVerifyTaskToBeRunEx')
	delete from GxQscripts where name = 'archAutoDDBVerifyTaskToBeRunEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoDDBVerifyTaskToBeRunEx')
	delete from GXDBVersions where aliasname = 'archAutoDDBVerifyTaskToBeRunEx'
GO

insert into GXDBVersions values(2, 'archAutoDDBVerifyTaskToBeRunEx',  '00010001000200250000', 'archAutoDDBVerifyTaskToBeRunEx', '00010001000200250000')
GO

