

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAutoCopyTaskToBeRunEx.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAutoCopyTaskToBeRunEx.sp,v $ $Id: archAutoCopyTaskToBeRunEx.sp,v 1.1.4.15 2020/12/19 16:10:21 kjaiswal Exp $";
--
--  +========================================================================+
--  | Stored Procedure:  archAutoCopyTaskToBeRunEx
--	| Author:	Jun Lu
--  |
--  | Description:  For a given task ID, check if there are to be copied jobs.
--	|				Then check if there is already a running auxiliary copy job
--	|				for the the storage policy/copy.
--	| Input:		task ID
--	| Output:		o_archGrpId, o_archGrpCopyId, o_errorCode, o_archGroupName, o_archGroupCopyName
--	|
--	|	o_errorCode									Action needed
--	|	---------------------------------------------------------------------
--	|  	E_ARCH_INVALID_AUXCOPY_TASK_ID				Invalidate task
--	|  	E_ARCH_NO_SP_COPY_FROM_ADMINTASK			Invalidate task
--	|	E_ARCH_COPY_IS_PRIMARY						Invalidate task
--	|	E_ARCH_INVALID_COPY_ID						Invalidate task
--	|	E_ARCH_NO_SECONDARY_COPY					Disable task?
--	|	E_ARCH_AUTOCOPY_FOR_RECENT_FULL_COPY		Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE						Disable task?
--	|	E_ARCH_COPY_NOT_EFFECTIVE					Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE_EFFECTIVE			Disable task?
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_SP				No action
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_COPY			No action
--	|	E_ARCH_NO_TO_BE_COPIED_DATA					No action
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archAutoCopyTaskToBeRunEx')
BEGIN
	print '>>> Drop Stored Procedure: archAutoCopyTaskToBeRunEx <<<'
	drop procedure archAutoCopyTaskToBeRunEx
END
IF EXISTS (select * from GxQscripts where name='archAutoCopyTaskToBeRunEx')
	delete from GxQscripts where name = 'archAutoCopyTaskToBeRunEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoCopyTaskToBeRunEx')
	delete from GXDBVersions where aliasname = 'archAutoCopyTaskToBeRunEx'
GO
print '... Creating Procedure: archAutoCopyTaskToBeRunEx'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archAutoCopyTaskToBeRunEx
  @i_taskId integer,
  @i_today integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archGrpId integer
  DECLARE @o_archGrpCopyId integer
  DECLARE @o_errorCode integer
  DECLARE @o_archGroupName nvarchar(288)
  DECLARE @o_archGroupCopyName nvarchar(128)
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
DECLARE @tblCopy	TABLE (
	id				int,
	archGroupId		int,
	isActive		int,
	type			int,
	startTime		int,
	sourceCopyId	int,
	delayedDays		int,
	extendedFlags	bigint,
	assocId			int,
	error			int,
	assocCopyId		int,
	archGrpName		NVARCHAR(288),
	archGrpCopyName NVARCHAR(128) )
DECLARE @l_archGroupId	int = 0
DECLARE @l_archCopyId	int = 0
DECLARE @l_error		int = 0
DECLARE @l_rowcount		int = 0
DECLARE @nowUtcTime DATETIME = GETUTCDATE()
DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
if object_id('tempdb.dbo.#assocTblAuxCopy') is not null
     DROP TABLE #assocTblAuxCopy
CREATE TABLE #assocTblAuxCopy ( policyId INT DEFAULT 0,
                             copyId INT DEFAULT 0,
                             assocID INT IDENTITY(1,1) PRIMARY KEY(assocId)
			)
INSERT INTO #assocTblAuxCopy(policyId, copyId)
--- CODE BELOW HERE IS FROM TM_GetAdminEntityAuxCopy.spb  ----------
		--STORAGE POLICY JOBS
		SELECT TA.policyId, Ta.copyId			--GET STORAGE POLICY ASSOCIATIONS WITH NO EXCLUDE COPY
		FROM TM_AssocEntity TA WITH (NOLOCK)
		WHERE TA.taskId = @i_taskId AND TA.exclude = 0
		AND TA.agentlessPolicyId = 0 AND TA.clientGroupId = 0 AND TA.clientId = 0
		AND TA.trackingPolicyId = 0 AND TA.MediaAgentId = 0 AND TA.agentlessPolicyId = 0
		AND TA.sidbStoreId = 0 AND TA.libraryId = 0 AND TA.logMonitoringPolicyId = 0
		AND NOT EXISTS(SELECT 1 FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TA.taskId AND exclude=1 AND TA.policyId = policyId)
		AND TA.policyId>0
		UNION
		SELECT AC.archGroupId, AC.id 	--GET STORAGE POLICY ASSOCIATIONS WITH EXCLUDE COPY
		FROM archGroupCopy AC WITH (NOLOCK)
		JOIN TM_AssocEntity TA WITH (NOLOCK) ON TA.policyId = AC.archGroupId AND TA.taskId = @i_taskId
		WHERE TA.agentlessPolicyId = 0 AND TA.clientGroupId = 0 AND TA.clientId = 0
		AND TA.trackingPolicyId = 0 AND TA.MediaAgentId = 0 AND TA.agentlessPolicyId = 0
		AND TA.sidbStoreId = 0 AND TA.libraryId = 0 AND TA.logMonitoringPolicyId = 0
AND TA.workflowId = 0 AND AC.type <> 5 -- REMOVE TRANSITIVE COPY
		AND exclude=1 AND TA.policyId = AC.archGroupId
		AND NOT EXISTS(SELECT 1 FROM archGroup WITH (NOLOCK) WHERE defaultCopy = AC.id)  -- REMOVE BACKUPCOPY ARCH COPY
		AND EXISTS(SELECT 1 FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TA.taskId AND exclude=1 AND TA.policyId = AC.archGroupId)
AND AC.extendedFlags & 32 = 0
		UNION
		SELECT TA.policyId, TA.copyId
		FROM TM_AssocEntity TA WITH (NOLOCK)
		WHERE TA.agentlessPolicyId = 0 AND TA.clientGroupId = 0 AND TA.clientId = 0
		AND TA.trackingPolicyId = 0 AND TA.MediaAgentId = 0 AND TA.agentlessPolicyId = 0
		AND TA.sidbStoreId = 0 AND TA.libraryId = 0 AND TA.logMonitoringPolicyId = 0
		AND TA.workflowId = 0 AND TA.exclude = 0 AND TA.taskId = @i_taskId
		AND NOT EXISTS(SELECT 1 FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TA.taskId AND exclude=1)
		AND TA.policyId>0
		UNION
		-- If policy or copy is excluded then above code will handle it. (--GET STORAGE POLICY ASSOCIATIONS WITH EXCLUDE COPY)
		-- Else just get all relevant policies with copyId as 0 .
		SELECT AGC.archGroupId,
		0
		FROM ArchGroup AG WITH (NOLOCK) INNER JOIN archGroupCopy AGC WITH (NOLOCK)
		ON AGC.archGroupId = AG.Id
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
		AND AGC.type <> 5  -- REMOVE TRANSITIVE COPY
AND AGC.extendedFlags & 32 = 0
AND (AG.flags & ((256|16384 | 8388608 ))= 0)
		AND AGC.isActive != 0 AND AGC.startTime <= @nowUtcUnix
		JOIN TM_AssocEntity TA WITH (NOLOCK) ON TA.taskId = @i_taskId
		AND TA.agentlessPolicyId = 0 AND TA.clientGroupId = 0 AND TA.clientId = 0
		AND TA.trackingPolicyId = 0 AND TA.MediaAgentId = 0 AND TA.agentlessPolicyId = 0
		AND TA.sidbStoreId = 0 AND TA.libraryId = 0 AND TA.logMonitoringPolicyId = 0
		AND TA.workflowId = 0
		AND TA.policyId = 0 -- All storage policies
		AND TA.copyId = 0
AND TA.assocType = 16
		LEFT JOIN TM_AssocEntity ExcludedTA WITH (NOLOCK) ON ExcludedTA.taskId = @i_taskId
		AND ExcludedTA.exclude = 1
		AND ExcludedTA.policyId =  AGC.archGroupId
		WHERE ExcludedTA.taskId IS NULL
--- CODE ABOVE HERE IS FROM TM_GetAdminEntityAuxCopy.spb  ----------
INSERT	INTO @tblCopy
SELECT	ISNULL(AGC.id, A.copyId), ISNULL(AGC.archGroupId, A.policyId), AGC.isActive, AGC.type, AGC.startTime,
		(case when AGC.sourceCopyId > 0 then AGC.sourceCopyId when AGC.isSnapCopy = 1 then AG.defaultSnapCopy else AG.defaultCopy end),
		AGC.delayedDays,AGC.extendedFlags, A.assocId, (CASE
WHEN (AGC.id IS NULL) AND (A.CopyId > 0) THEN 9
WHEN (AGC.id IS NULL) AND (A.CopyId = 0) THEN 8
WHEN (A.copyId > 0 AND (AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy)) THEN 16
WHEN (AGC.isActive = 0 AND AGC.startTime > @i_today) THEN 14
WHEN (AGC.isActive = 0) THEN 12
WHEN (AGC.startTime > @i_today) THEN 13
							ELSE 0 END),
		A.CopyId,AG.name, AGC.name
FROM	#assocTblAuxCopy A WITH (READUNCOMMITTED)
			LEFT OUTER JOIN archGroup AG WITH (READUNCOMMITTED) ON A.policyId = AG.id
			LEFT OUTER JOIN archGroupCopy AGC WITH (READUNCOMMITTED)
				ON	A.policyId = AGC.archGroupId
					AND ((A.copyId = 0 AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy) OR (A.copyId > 0 AND A.copyId = AGC.id))
WHERE	(AG.flags IS NULL OR (AG.flags & ((256|16384| 8388608 ))= 0))
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error = 0 AND @l_rowcount = 0
SET	@l_error = 38
-- AUXILIARY_COPY_ITEM = 7330
IF NOT EXISTS (SELECT * FROM TM_SubTask WITH (READUNCOMMITTED) WHERE taskId = @i_taskId AND operationType = 4003)
BEGIN
	UPDATE @tblCopy
SET		error = 37
	GOTO CV_EXIT
END
IF NOT EXISTS (SELECT * FROM @tblCopy WHERE error = 0)
	GOTO CV_EXIT
DECLARE @useScalableResourceOption INT = 0
SELECT @useScalableResourceOption = value
FROM	TM_SubTask S WITH (READUNCOMMITTED), TM_SubTaskOptions O WITH (READUNCOMMITTED)
WHERE	S.taskId = @i_taskId
		AND S.subTaskId = O.subTaskId
		AND O.optionId = 449788653 /*options[1]/backupOpts[1]/mediaOpt[1]/auxcopyJobOption[1]/@useScallableResourceManagement*/
IF @useScalableResourceOption = 1
BEGIN
	UPDATE	@tblCopy
SET		error = (CASE WHEN J.archGrpCopyId = 0 THEN 26 ELSE 27 END)
	FROM	@tblCopy T, JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	T.error = 0
			AND J.OpType IN (13, 104)
			AND T.archGroupId = J.archGrpID
			AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = T.id)
			AND T.assocCopyId > 0
	UPDATE	@tblCopy
SET		error = (CASE WHEN J.archGrpCopyId = 0 THEN 26 ELSE 27 END)
	FROM	@tblCopy T, JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	T.error = 0
			AND J.OpType IN (13, 104)
			AND T.archGroupId = J.archGrpID
			AND (J.archGrpCopyID = 0 OR
					(J.archGrpCopyID = T.id
					 AND NOT EXISTS(SELECT AGC.id
						FROM archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG  WITH (READUNCOMMITTED)
						WHERE AGC.archGroupId = AG.id AND AG.id = T.archGroupId AND AGC.id != AG.defaultCopy AND AGC.id != AG.defaultSnapCopy AND AGC.id != J.archGrpCopyID)))
			AND T.assocCopyId = 0
END
ELSE
BEGIN
	UPDATE	@tblCopy
SET		error = (CASE WHEN J.archGrpCopyId = 0 THEN 26 ELSE 27 END)
	FROM	@tblCopy T, JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	T.error = 0
			AND J.OpType IN (13, 104)
			AND T.archGroupId = J.archGrpID
			AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = T.id)
END
IF NOT EXISTS (SELECT * FROM @tblCopy WHERE error = 0)
	GOTO CV_EXIT
--
-- BEGIN: archHasJobEligibleForCopy.spb
--
UPDATE	T
SET		error =	(CASE WHEN NOT EXISTS (SELECT TOP 1 D.JobId
									  FROM	JMJobDataStats D WITH (READUNCOMMITTED), JMJobDataStats S WITH (READUNCOMMITTED)
									  WHERE	D.archGrpCopyId = T.id
											AND D.status IN (101, 102, 103)
AND (D.disabled & (1 + 256)) = 0
											AND D.JobID = S.JobId
											AND D.commCellId = S.commCellId
											AND D.dataType = S.dataType
											AND S.archGrpCopyId = T.sourceCopyId
											AND S.status IN (100)
AND (S.disabled & (1 + 256)) = 0)
						 AND NOT EXISTS (SELECT TOP 1 JI.jobId
										 FROM JMJobInfo JI
												INNER JOIN JMJobCopyInfo JCI ON JI.JobId = JCI.JobID AND JI.commCellId = JCI.commCellId AND JCI.archGrpCopyId = T.id,
												archFile AF, archFileCopy src LEFT OUTER JOIN archFileCopy dest
													ON src.archFileId = dest.archFileId AND src.commCellId = dest.commCellId AND src.archCopyId <> dest.archCopyId
										 WHERE JI.jobId = AF.jobId AND JI.commCellId = AF.commCellId
										 AND AF.id = src.archFileId AND AF.commCellId = src.commCellId
										 AND src.archCopyId = T.sourceCopyId
										 AND src.mediaType = 10001
AND AF.flags & 32768 = 0
										 AND (dest.archCopyId IS NULL OR (dest.archCopyId = T.id AND dest.physicalSize < src.physicalSize))
										 AND JI.state NOT IN (4,9,10,11)
AND T.extendedFlags & 32768 > 0)	THEN 31
					ELSE 0
				END)
FROM	@tblCopy T
WHERE	T.error = 0
		AND T.delayedDays = 0
UPDATE	T
SET		error =	(CASE WHEN NOT EXISTS (SELECT TOP 1 D.JobId
									  FROM	JMJobDataStats D WITH (READUNCOMMITTED), JMBkpStats J WITH (READUNCOMMITTED), JMJobDataStats S WITH (READUNCOMMITTED)
									  WHERE	D.archGrpCopyId = T.id
											AND D.status IN (101, 102, 103)
AND (D.disabled & (1 + 256)) = 0
											AND D.jobId = J.JobId
											AND D.CommCellId = J.CommCellId
											AND (@i_today - J.servStartDate ) >= T.delayedDays*86400
											AND D.JobID = S.JobId
											AND D.commCellId = S.commCellId
											AND D.dataType = S.dataType
											AND S.archGrpCopyId = T.sourceCopyId
											AND S.status IN (100)
AND (S.disabled & (1 + 256)) = 0) THEN 31
					ELSE 0
				END)
FROM	@tblCopy T
WHERE	T.error = 0
		AND T.delayedDays > 0
--
-- END: archHasJobEligibleForCopy.spb
--
CV_EXIT:
IF (@l_error > 0)
	SELECT	0, 0, @l_error, '', ''
ELSE
	SELECT t.*, (CASE WHEN t.policyId > 0 THEN ag.name ELSE 'Unknown' END) archGroupName, (CASE WHEN t.copyId > 0 THEN agc.name ELSE 'Unknown' END) archGroupCopyName
    FROM (  SELECT  E.policyId, E.copyId, MIN(error) AS error
    FROM    #assocTblAuxCopy E INNER JOIN @tblCopy T ON T.assocId = E.assocId
    GROUP BY E.assocId, E.policyId, E.copyId
    ) t,  archGroup ag WITH (NOLOCK), archGroupCopy agc WITH (NOLOCK)
    WHERE ag.id = t.policyId AND agc.id = t.copyId
GO

IF EXISTS (select * from GxQscripts where name = 'archAutoCopyTaskToBeRunEx')
	delete from GxQscripts where name = 'archAutoCopyTaskToBeRunEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoCopyTaskToBeRunEx')
	delete from GXDBVersions where aliasname = 'archAutoCopyTaskToBeRunEx'
GO

insert into GXDBVersions values(2, 'archAutoCopyTaskToBeRunEx',  '00010001000400150000', 'archAutoCopyTaskToBeRunEx', '00010001000400150000')
GO

