

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAutoCopyTaskToBeRun.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAutoCopyTaskToBeRun.sp,v $ $Id: archAutoCopyTaskToBeRun.sp,v 1.11.14.7 2020/10/04 00:58:03 abilbrey Exp $";
--
--  +========================================================================+
--  | Stored Procedure:  archAutoCopyTaskToBeRun
--	| Author:	Jun Lu
--  |
--  | Description:  For a given task ID, check if there are to be copied jobs.
--	|				Then check if there is already a running auxiliary copy job
--	|				for the the storage policy/copy.
--	| Input:		task ID
--	| Output:		o_archGrpId, o_archGrpCopyId, o_errorCode, o_archGroupName, o_archGroupCopyName
--	|
--	|	o_errorCode									Action needed
--	|	---------------------------------------------------------------------
--	|  	E_ARCH_INVALID_AUXCOPY_TASK_ID				Invalidate task
--	|  	E_ARCH_NO_SP_COPY_FROM_ADMINTASK			Invalidate task
--	|	E_ARCH_COPY_IS_PRIMARY						Invalidate task
--	|	E_ARCH_INVALID_COPY_ID						Invalidate task
--	|	E_ARCH_NO_SECONDARY_COPY					Disable task?
--	|	E_ARCH_AUTOCOPY_FOR_RECENT_FULL_COPY		Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE						Disable task?
--	|	E_ARCH_COPY_NOT_EFFECTIVE					Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE_EFFECTIVE			Disable task?
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_SP				No action
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_COPY			No action
--	|	E_ARCH_NO_TO_BE_COPIED_DATA					No action
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archAutoCopyTaskToBeRun')
BEGIN
	print '>>> Drop Stored Procedure: archAutoCopyTaskToBeRun <<<'
	drop procedure archAutoCopyTaskToBeRun
END
IF EXISTS (select * from GxQscripts where name='archAutoCopyTaskToBeRun')
	delete from GxQscripts where name = 'archAutoCopyTaskToBeRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoCopyTaskToBeRun')
	delete from GXDBVersions where aliasname = 'archAutoCopyTaskToBeRun'
GO
print '... Creating Procedure: archAutoCopyTaskToBeRun'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAutoCopyTaskToBeRun
  @i_taskId integer,
  @i_today integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archGrpId integer
  DECLARE @o_archGrpCopyId integer
  DECLARE @o_errorCode integer
  DECLARE @o_archGroupName nvarchar(288)
  DECLARE @o_archGroupCopyName nvarchar(128)
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
DECLARE @tblCopy	TABLE (
	id				int,
	archGroupId		int,
	isActive		int,
	type			int,
	startTime		int,
	sourceCopyId	int,
	delayedDays		int,
	extendedFlags	bigint)
DECLARE @tblJobCopy	TABLE (
	jobId			int,
	archGrpCopyId	int,
	dataType		int,
	commCellId		int,
	primary key (jobid, commCellId, archGrpCopyId, dataType)
	)
DECLARE @l_archGroupId	int
DECLARE @l_archCopyId	int
DECLARE @l_error		int
DECLARE @l_rowcount		int
-- AUXILIARY_COPY_ITEM = 7330
IF NOT EXISTS (SELECT * FROM TM_SubTask WITH (NOLOCK) WHERE taskId = @i_taskId AND operationType = 4003)
BEGIN
SET @l_error = 37
	GOTO FINISH
END
SELECT	@l_archCopyId = ISNULL(CONVERT(INT, A.copyId), 0),
		@l_archGroupId = ISNULL(CONVERT(INT, A.policyId), 0)
FROM	TM_AssocEntity A WITH (NOLOCK)
WHERE	A.taskId = @i_taskId
--SELECT	@l_archGroupId = ISNULL(CONVERT(INT, B.value), 0)
--FROM	TM_SubTask A WITH (NOLOCK), TM_SubTaskOptions B WITH (NOLOCK)
--WHERE	A.taskId = @i_taskId AND B.subTaskId = A.subTaskId AND optionId = COM_POLICY_ID
--SELECT	@l_archCopyId = ISNULL(CONVERT(INT, B.value), 0)
--FROM	TM_SubTask A WITH (NOLOCK), TM_SubTaskOptions B WITH (NOLOCK)
--WHERE	A.taskId = @i_taskId AND B.subTaskId = A.subTaskId AND optionId = COM_COPY_ID
IF	@l_archCopyId = 0 AND @l_archGroupId = 0
BEGIN
SET @l_error = 38
	GOTO FINISH
END
ELSE
IF	@l_archCopyId > 0
BEGIN
	IF EXISTS (	SELECT	*
				FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
				WHERE	AGC.id = @l_archCopyId AND AG.id = AGC.archGroupId
					AND (AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy))
	BEGIN
SET	@l_error = 16
		GOTO FINISH
	END
	INSERT	INTO @tblCopy
	SELECT	AGC.id, AGC.archGroupId, AGC.isActive, AGC.type, AGC.startTime,
			(case when AGC.sourceCopyId > 0 then AGC.sourceCopyId when AGC.isSnapCopy = 1 then AG.defaultSnapCopy else AG.defaultCopy end),
			AGC.delayedDays, AGC.extendedFlags
	FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE	AGC.id = @l_archCopyId AND AG.id = AGC.archGroupId
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
AND (AG.flags & (256|16384) = 0)
	SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
	IF	@l_error = 0 AND @l_rowcount = 0
SET	@l_error = 9
END
ELSE
IF	@l_archGroupId > 0
BEGIN
	INSERT	INTO @tblCopy
	SELECT	AGC.id, AGC.archGroupId, AGC.isActive, AGC.type, AGC.startTime,
			(case when AGC.sourceCopyId > 0 then AGC.sourceCopyId when AGC.isSnapCopy = 1 then AG.defaultSnapCopy else AG.defaultCopy end),
			AGC.delayedDays, AGC.extendedFlags
	FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE	AGC.archGroupId = @l_archGroupId AND AG.id = AGC.archGroupId
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
AND (AG.flags & (256|16384) = 0)
	SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
	IF	@l_error = 0 AND @l_rowcount = 0
SET	@l_error = 8
END
IF	@l_error <> 0 GOTO FINISH
IF	NOT EXISTS (SELECT * FROM @tblCopy WHERE isActive = 1)
SET	@l_error = 12
ELSE
IF	NOT EXISTS (SELECT * FROM @tblCopy WHERE startTime <= @i_today)
SET	@l_error = 13
ELSE
IF	NOT EXISTS (SELECT * FROM @tblCopy WHERE isActive = 1 AND startTime <= @i_today)
SET	@l_error = 14
IF	@l_error <> 0 GOTO FINISH
-- when we get to here, at least one copy is active and effective.
DELETE	@tblCopy
WHERE	isActive = 0 OR startTime > @i_today
-- if there is already a running aux copy job for the storage policy or copy
IF	EXISTS (SELECT * FROM JMAdminJobInfoTable WITH (NOLOCK)
			WHERE	opType IN (13, 104) AND archGrpID = @l_archGroupId AND archGrpCopyID = 0)
BEGIN
SET	@l_error = 26
	GOTO FINISH
END
ELSE
BEGIN
	DELETE	@tblCopy
	FROM	@tblCopy A, JMAdminJobInfoTable B WITH (NOLOCK)
	WHERE	opType IN (13, 104) AND B.archGrpCopyID = A.id
	IF	@@ROWCOUNT > 0 AND NOT EXISTS (SELECT * FROM @tblCopy)
	BEGIN
SET	@l_error = 27
		GOTO FINISH
	END
END
INSERT	INTO @tblJobCopy
SELECT	a.jobId, a.archGrpCopyId, a.dataType, a.commCellId
FROM	JMJobDataStats a WITH (NOLOCK), @tblCopy b
WHERE	a.archGrpCopyId = b.id
AND a.status IN (101, 102, 103) AND (a.disabled & (1 + 256)) = 0
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
-- delete jobs on delayed copies if they are not older than delayedDays
DELETE	@tblJobCopy
FROM	@tblJobCopy a, @tblCopy b, JMBkpStats c WITH (NOLOCK)
WHERE	a.archGrpCopyId = b.id AND b.delayedDays > 0
	AND c.jobId = a.jobId AND c.commCellId = a.commCellId
	AND (@i_today - c.servStartDate ) < b.delayedDays*86400
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
-- delete jobs that are not available on source copy
DELETE  @tblJobCopy
FROM    @tblJobCopy AS T
		INNER JOIN @tblCopy b ON T.archGrpCopyId = b.id
        LEFT JOIN JMJobDataStats c WITH (NOLOCK)
			ON     c.dataType = T.dataType
                    AND b.sourceCopyId = c.archGrpCopyId
                    AND c.jobId = T.jobId
                    AND c.commCellId = T.commCellId
                    AND c.status = 100
AND c.disabled & (1 + 256) = 0
WHERE  c.jobId IS NULL
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
INSERT	INTO @tblJobCopy
SELECT JI.jobId,t.id, AF.filetype,JI.commCellId
FROM JMJobInfo JI INNER JOIN JMJobCopyInfo JCI ON JI.JobId = JCI.JobID AND JI.commCellId = JCI.commCellId,
		@tblCopy t, archFile AF, archFileCopy src LEFT OUTER JOIN archFileCopy dest
			ON src.archFileId = dest.archFileId AND src.commCellId = dest.commCellId AND src.archCopyId <> dest.archCopyId
WHERE JI.jobId = AF.jobId AND JI.commCellId = AF.commCellId
AND AF.id = src.archFileId AND AF.commCellId = src.commCellId
AND src.archCopyId = t.sourceCopyId
AND src.mediaType = 10001
AND AF.flags & 32768 = 0
AND (dest.archCopyId IS NULL OR (dest.archCopyId = t.id AND dest.physicalSize < src.physicalSize))
AND JI.state NOT IN (4,9,10,11)
AND t.delayedDays <= 0
AND t.extendedFlags & 32768 > 0
AND JCI.archGrpCopyId = T.id
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
IF	NOT EXISTS (SELECT * FROM @tblJobCopy)
SET	@l_error = 31
FINISH:
SELECT	@l_archGroupId, @l_archCopyId, @l_error , CASE WHEN @l_archGroupId > 0 THEN ag.name ELSE 'Unknown' END, CASE WHEN @l_archCopyId > 0 THEN agc.name ELSE 'Unknown' END
FROM archGroup ag, archGroupCopy agc
WHERE ag.id = @l_archGroupId AND agc.id = @l_archCopyId
GO

IF EXISTS (select * from GxQscripts where name = 'archAutoCopyTaskToBeRun')
	delete from GxQscripts where name = 'archAutoCopyTaskToBeRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoCopyTaskToBeRun')
	delete from GXDBVersions where aliasname = 'archAutoCopyTaskToBeRun'
GO

insert into GXDBVersions values(2, 'archAutoCopyTaskToBeRun',  '00010011001400070000', 'archAutoCopyTaskToBeRun', '00010011001400070000')
GO

