

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAreAllPreviousSnapsInOtherSPMaterialized.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archAreAllPreviousSnapsInOtherSPMaterialized				  */
/*                                                                            */
/*  Description :  This is to be called by JM before starting 				  */
/*				   offline backup copy on a storage policy to know			  */
/*				   if there are any previous snaps for the subclient in other */
/*				   policies waiting to be materialized						  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAreAllPreviousSnapsInOtherSPMaterialized.sp,v $ $Id: archAreAllPreviousSnapsInOtherSPMaterialized.sp,v 1.2.88.1 2018/03/22 01:09:38 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archAreAllPreviousSnapsInOtherSPMaterialized <<<'

IF EXISTS (select * from sysobjects where name='archAreAllPreviousSnapsInOtherSPMaterialized')
	drop procedure archAreAllPreviousSnapsInOtherSPMaterialized
IF EXISTS (select * from GxQscripts where name='archAreAllPreviousSnapsInOtherSPMaterialized')
	delete from GxQscripts where name = 'archAreAllPreviousSnapsInOtherSPMaterialized'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAreAllPreviousSnapsInOtherSPMaterialized')
	delete from GXDBVersions where aliasname = 'archAreAllPreviousSnapsInOtherSPMaterialized'
GO
print '... Creating Procedure: archAreAllPreviousSnapsInOtherSPMaterialized'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAreAllPreviousSnapsInOtherSPMaterialized
  @i_appId integer,
  @i_archGroupId integer
AS
  DECLARE @r_allMaterialized integer;
  DECLARE @r_pendingJobId integer;
  DECLARE @r_pendingCommCellId integer;
  DECLARE @r_pendingArchGroup NVARCHAR(144);
  DECLARE @r_errCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @r_allMaterialized = 0
SET @r_pendingJobId = 0
SET @r_pendingArchGroup = N''
SET @r_errCode = 0
DECLARE @lt_nonMatJobs table (jobId int, commcellId int, archGrpId int, servStartDate int)
DECLARE @l_minJobStartTime int
--Get the start time of oldest job for the subclient in this storage policy to be materialized
SELECT @l_minJobStartTime = min(JBKP.servStartDate)
FROM JMJobSnapShotStats JSS WITH(NOLOCK) inner join JMBkpStats JBKP WITH(NOLOCK) ON JSS.jobId = JBKP.jobId AND JSS.commcellId = JBKP.commcellId
WHERE JSS.archGrpId = @i_archGroupId AND JSS.appId = @i_appId AND JSS.disabled = 0 AND JSS.materializationStatus in (101, 102,103)
--No job exists in this policy to be materialized
IF (@l_minJobStartTime is null)
	SET @l_minJobStartTime = 0
--Get jobs in other storage policies for this subclient that are to be materialized
INSERT INTO @lt_nonMatJobs
SELECT jobId, commcellId, archGrpId, 0
FROM JMJobSnapShotStats WITH(NOLOCK)
WHERE archGrpId <> @i_archGroupId AND appId = @i_appId AND disabled = 0 AND materializationStatus in (101, 102,103)
SET @r_errCode = @@ERROR
IF (@r_errCode <> 0)
	GOTO PROC_EXIT
--No job in other policies to be materialized
IF NOT EXISTS (SELECT 1 FROM @lt_nonMatJobs)
BEGIN
	SET @r_allMaterialized = 1
	GOTO PROC_EXIT
END
--Set job start time
UPDATE @lt_nonMatJobs SET servStartDate = JBKP.servStartDate
FROM @lt_nonMatJobs J1 inner join JMBkpStats JBKP WITH(NOLOCK) ON J1.jobId = JBKP.jobId	AND J1.commcellId = JBKP.commcellId
WHERE J1.servStartDate = 0
SET @r_errCode = @@ERROR
IF (@r_errCode <> 0)
	GOTO PROC_EXIT
--Ignore the jobs in other storage policies that are created after 	jobs in this storage policy
DELETE FROM @lt_nonMatJobs
WHERE servStartDate > @l_minJobStartTime
SET @r_errCode = @@ERROR
IF (@r_errCode <> 0)
	GOTO PROC_EXIT
--No job in other storage policy created after the earliest job in this storage policy to be materialized
IF NOT EXISTS(SELECT 1 FROM @lt_nonMatJobs)
BEGIN
	SET @r_allMaterialized = 1
	GOTO PROC_EXIT
END
--Ignore jobs that do not have a valid snap copy from which we can materialize
DELETE @lt_nonMatJobs
FROM @lt_nonMatJobs J1 left outer join
(
SELECT J2.jobId, J2.commcellId FROM @lt_nonMatJobs J2 inner join JMJobDataStats JDS WITH(NOLOCK) ON J2.jobId = JDS.jobId AND J2.commcellId = JDS.commcellId AND JDS.status = 100 AND JDS.disabled & 256 = 0
inner join archGroupCopy AGC WITH(NOLOCK) on jds.archGrpCopyId = AGC.id AND AGC.isSnapCopy = 1
) T
ON J1.jobId = T.jobId AND J1.commcellId = T.commcellId
WHERE T.jobId is null
SET @r_errCode = @@ERROR
IF (@r_errCode <> 0)
	GOTO PROC_EXIT
--No job in other storage policy to be materialized with valid data in snap copy
IF NOT EXISTS(SELECT 1 FROM @lt_nonMatJobs)
BEGIN
	SET @r_allMaterialized = 1
	GOTO PROC_EXIT
END
--If we are here we have older jobs in other storage policies which needs to be materialized first. Return the top 1
SELECT top 1 @r_pendingJobId = jobId, @r_pendingCommCellId = J.commcellId, @r_pendingArchGroup = AG.name
FROM @lt_nonMatJobs J inner join archGroup AG WITH(NOLOCK) ON J.archGrpId = AG.id
ORDER BY J.servStartDate
SET @r_errCode = @@ERROR
PROC_EXIT:
SELECT @r_allMaterialized, @r_pendingJobId, @r_pendingCommCellId, @r_pendingArchGroup, @r_errCode
GO

IF EXISTS (select * from GxQscripts where name = 'archAreAllPreviousSnapsInOtherSPMaterialized')
	delete from GxQscripts where name = 'archAreAllPreviousSnapsInOtherSPMaterialized'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAreAllPreviousSnapsInOtherSPMaterialized')
	delete from GXDBVersions where aliasname = 'archAreAllPreviousSnapsInOtherSPMaterialized'
GO

insert into GXDBVersions values(2, 'archAreAllPreviousSnapsInOtherSPMaterialized',  '00010002008800010000', 'archAreAllPreviousSnapsInOtherSPMaterialized', '00010002008800010000')
GO

