

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAllowJobForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAllowJobForCopy.sp,v $ $Id: archAllowJobForCopy.sp,v 1.52.34.19 2020/01/24 08:15:06 daruloli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archAllowJobForCopy')
BEGIN
	print '>>> Drop Stored Procedure: archAllowJobForCopy <<<'
	drop procedure archAllowJobForCopy
END
IF EXISTS (select * from GxQscripts where name='archAllowJobForCopy')
	delete from GxQscripts where name = 'archAllowJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAllowJobForCopy')
	delete from GXDBVersions where aliasname = 'archAllowJobForCopy'
GO
print '... Creating Procedure: archAllowJobForCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAllowJobForCopy
  @i_jobId integer,
  @i_commCellId integer,
  @i_copyId integer,
  @i_recopy integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@AGED_DONOTCOPY INT
SET @AGED_DONOTCOPY = 1 + 256
DECLARE	@tblJobDataStats TABLE (
	jobId int, archGrpId int, archGrpCopyId int, dataType int, status int, disabled int, appId int, commCellId int)
DECLARE @l_now integer
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
SET @retVal = -1
DECLARE	@l_archGrpId	int
DECLARE	@l_defCopyId	int
DECLARE	@l_srcCopyId	int
DECLARE	@l_SIDBStoreId	int
DECLARE	@l_dedupeFlags	int
DECLARE	@l_isSnapCopy	int
DECLARE	@l_isMirrorCopy	int
DECLARE	@magneticBytes	bigint
DECLARE @t_extendedFlags bigint
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
SELECT	@l_archGrpId = archGroupId, @l_srcCopyId = sourceCopyId, @l_SIDBStoreId = SIDBStoreId, @l_dedupeFlags = dedupeFlags, @l_isSnapCopy = isSnapCopy, @l_isMirrorCopy = isMirrorCopy,
		@t_extendedFlags = extendedFlags
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_copyId
SELECT	@l_defCopyId = (case when @l_isSnapCopy = 0 then defaultCopy else defaultSnapCopy end)
FROM	archGroup WITH (READUNCOMMITTED)
WHERE	id = @l_archGrpId
IF	@i_recopy <> 0
BEGIN
	IF	@l_defCopyId = @i_copyId
	BEGIN
		SET @retVal = 5
		GOTO FINISH
	END
	IF	@l_isSnapCopy <> 0
	BEGIN
		SET @retVal = 6
		GOTO FINISH
	END
END
IF @l_defCopyId = @i_copyId
	SET @l_srcCopyId = 0
ELSE
IF @l_srcCopyId = 0
	SET @l_srcCopyId = @l_defCopyId
IF @i_recopy <> 0
BEGIN
		DECLARE	@tblOpType TABLE (opType INT, AdminJobId INT, CommCellId INT)
		INSERT	INTO @tblOpType
		SELECT	DISTINCT B.opType, B.JobId, B.CommCellId
		FROM	JMAdminJobInfoTable B WITH (READUNCOMMITTED)
		WHERE	B.opType IN (13, 104, 74)
		AND 	B.commCellId = @i_commCellId
		AND 	(B.archGrpCopyID > 0  AND ( B.archGrpCopyId = @i_copyId OR (SELECT sourceCopyId FROM archGroupCopy agc WITH (READUNCOMMITTED) WHERE agc.id = B.archGrpCopyId ) = @i_copyId OR ( B.opType = 74 AND B.archGrpCopyID = (SELECT destMediaCopyId FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = @i_copyId AND destMediaCopyId > 0))) )
				OR ( B.archGrpCopyId = 0
				    AND (B.archGrpid = @l_archGrpId OR ( B.opType = 74 AND B.archGrpID = (SELECT AG.id FROM archGroup AG WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED) WHERE AGC.id = @i_copyId AND AG.defaultCopy = AGC.destMediaCopyId AND AGC.destMediaCopyId > 0))) )
		IF 	(EXISTS (SELECT 1 FROM @tblOpType WHERE opType IN (13, 104))
					AND	EXISTS (SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED)
										WHERE	jobId = @i_jobId
										AND 	commCellId = @i_commCellId
										AND 	(status IN (101, 102, 103) OR
													(status = 100 AND EXISTS (
																			SELECT 1 FROM @tblOpType WHERE auxCopyJobId = AdminJobId AND (opType = 13 OR opType = 104)))
											)
										AND		 archGrpCopyId =  @i_copyId
AND 	(disabled & (1|256)) = 0
									))
			OR	(EXISTS (SELECT 1 FROM @tblOpType WHERE opType = 74)
					AND	EXISTS (SELECT 1 FROM JMJobDataStats WITH (READUNCOMMITTED)
										WHERE	jobId = @i_jobId
										AND 	commCellId = @i_commCellId
										AND 	archGrpCopyId  = @i_copyId
AND 	(disabled & 256) = 0
									))
			OR	(EXISTS (SELECT 1 FROM @tblOpType WHERE opType = 104 OR opType = 74)
					AND	EXISTS (SELECT 1 FROM archChunkToReplicate R WITH (READUNCOMMITTED), @tblOpType T
										WHERE	R.adminJobId = T.adminJobId
										AND		(T.opType = 104 OR T.opType = 74)
										AND		R.BackupJobId = @i_jobId
										AND 	R.commCellId = @i_commCellId
										AND 	R.srcCopyId  = @i_copyId
AND 	R.Status NOT IN (2, 9, 4, 6, 7)
									))
			OR	(EXISTS (SELECT 1 FROM @tblOpType WHERE opType = 13)
					AND	EXISTS (SELECT 1 FROM archCHunkToCopy R WITH (READUNCOMMITTED), @tblOpType T
										WHERE	R.adminJobId = T.adminJobId
										AND		T.opType = 13
										AND		R.BackupJobId = @i_jobId
										AND 	R.commCellId = @i_commCellId
										AND 	R.archCopyId  = @i_copyId
									))
		BEGIN
			SET @retVal = 8
			GOTO FINISH
		END
END
INSERT	INTO @tblJobDataStats
SELECT	jobId, archGrpId, archGrpCopyId, dataType, status, disabled, appId, commCellId
FROM	JMJobDataStats WITH (READUNCOMMITTED)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
	AND (archGrpCopyId = @i_copyId OR @l_defCopyId <> @i_copyId AND archGrpCopyId = @l_srcCopyId)
--	AND appId <> @l_siloAppId
IF @i_recopy = 0 AND ((@l_dedupeFlags  & 262144) > 0)
	AND EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId
AND status IN (102, 103) AND (disabled & @AGED_DONOTCOPY) = 1)
BEGIN
	DECLARE	@tblAF TABLE (archFileId int)
	INSERT	INTO @tblAF
	SELECT	AFC.archFileId
	FROM	archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1 AND (AF.flags & 2) = 0
		AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = @i_copyId
		AND AFC.isValid = 0 AND AFC.physicalSize > 0
	IF	EXISTS (SELECT	AF.archFileId
				FROM	@tblAF AF, archChunkMapping ACM WITH (READUNCOMMITTED), archChunk AC WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
				WHERE	ACM.archFileId = AF.archFileId AND ACM.commCellId = @i_commCellId AND ACM.archCopyId = @i_copyId
					AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
AND V.VolumeId = AC.volumeId AND V.SIDBStoreId NOT IN (SELECT SIDBStoreId FROM archCopySIDBStore CS WHERE CS.copyId = @i_copyId AND ((CS.Flags & 4) > 0)))
	BEGIN
		SET @retVal = 4
		GOTO FINISH
	END
END
IF NOT EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId)
BEGIN
	IF (@l_isSnapCopy = 1)
	BEGIN
		DELETE	JDS
		FROM	@tblJobDataStats JDS, SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED), SMSnap S WITH (READUNCOMMITTED), SMSnapShotEngine E WITH (READUNCOMMITTED)
		WHERE	JDS.jobId = V.jobId AND @i_commCellId = V.commCellId
			AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
			AND S.SnapShotEngineId = E.SnapShotEngineId
AND ((( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @l_isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags &  (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3, 48))))
		DELETE	T
		FROM	@tblJobDataStats T, JMVSAAppJobLink J WITH (READUNCOMMITTED)
					LEFT OUTER JOIN  SMVolume V WITH (READUNCOMMITTED)
						ON V.jobId = J.parentJobId AND V.commCellId = J.CommCellId
					LEFT OUTER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED)
						ON VS.SMVolumeId = V.SMVolumeId
					LEFT OUTER JOIN SMSnap S WITH (READUNCOMMITTED)
						ON S.SMSnapId = VS.SMSnapId
					LEFT OUTER JOIN SMSnapShotEngine E WITH (READUNCOMMITTED)
						ON S.SnapShotEngineId = E.SnapShotEngineId
		WHERE	J.childJobId = T.JobId AND J.commCellId = @i_commCellId
				AND NOT EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = J.CommCellId AND JDS.archGrpCopyId = @i_copyId AND JDS.dataType != 6 AND JDS.Status != 100)
				-- AND NOT EXISTS (SELECT TOP 1 SMVolumeID FROM SMVolume V2 WITH (READUNCOMMITTED) WHERE V2.jobId = J.parentJobId AND V2.commCellId = J.CommCellId AND V2.CopyId = @i_copyId)
				AND (V.SMVolumeId IS NULL
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @l_isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags &  (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3))))
		IF NOT EXISTS (SELECT * FROM @tblJobDataStats)
		BEGIN
			SET	@retVal = 11
			GOTO FINISH
		END
	END
	INSERT	INTO JMJobDataStats
	SELECT	jobId, archGrpId, @i_copyId, dataType, 13, 0, 101, 0, appId, commCellId, 0, 0, 0, 0, 0, 0, 0, @l_now, 0, 0, 0, @l_now, 101, -1
	FROM	@tblJobDataStats, APP_Application A WITH (READUNCOMMITTED)
	WHERE	jobId = @i_jobId AND archGrpCopyId = @l_srcCopyId AND commCellId = @i_commCellId
		AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 0
		AND appId = A.id
AND (@SkipTransactionalLogs = 0 OR dataType != 4 OR A.appTypeId != 81)
	SET @retVal = 0
	if (@l_isSnapCopy = 1 AND @l_isMirrorCopy = 0 AND (EXISTS (SELECT * FROM archGroupCopy WHERE sourceCopyId = @i_copyId AND isMirrorCopy = 1)))
	BEGIN
		INSERT	INTO JMJobDataStats
		SELECT	jobId, archGrpId, AGC.id, dataType, 13, 0, 101, 0, appId, commCellId, 0, 0, 0, 0, 0, 0, 0, @l_now, 0, 0, 0, @l_now, 101, -1
		FROM	@tblJobDataStats, archGroupCopy AGC, APP_Application A WITH (READUNCOMMITTED)
		WHERE	jobId = @i_jobId AND archGrpCopyId = @l_srcCopyId AND commCellId = @i_commCellId
			AND status = 100 AND (disabled & @AGED_DONOTCOPY) = 0
			AND AGC.sourceCopyId = @i_copyId AND isMirrorCopy = 1
			AND appId = A.id
AND (@SkipTransactionalLogs = 0 OR dataType != 4 OR A.appTypeId != 81)
	END
END
ELSE
IF @i_recopy = 0 AND EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId
AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 1)
BEGIN
	-- This below condition is for pick for copy when we want to pick job for copying , not the allow copy on source copy where data is available.
	IF @l_srcCopyId <> 0 AND EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId AND status IN (101, 102, 103) )
			AND NOT EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @l_srcCopyId AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 0)
	BEGIN
		SET @retVal = 1
		GOTO FINISH
	END
	DECLARE @tblJobCopyToSet TABLE (jobId INT, archGrpCopyId INT, commCellId INT, sourceCopyId INT, toBeSet INT)
	DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
	INSERT INTO @tblCopyToSet
	EXEC ArchDestinationCopyList @i_copyId
	INSERT	INTO @tblJobCopyToSet
	SELECT	DISTINCT J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId, 0
	FROM	JMJobDataStats J, @tblCopyToSet C
	WHERE	J.jobId = @i_jobId AND J.archGrpCopyId = C.copyId AND J.commCellId = @i_commCellId
AND status IN (100, 101, 102, 103) AND J.status <> 100 AND (J.disabled & @AGED_DONOTCOPY) = 1
	INSERT	INTO @tblJobCopyToSet
	SELECT	@i_jobId, @i_copyId, @i_commCellId, 0, 1
	WHILE @@ROWCOUNT > 0
		UPDATE	@tblJobCopyToSet SET toBeSet = 1
		WHERE	toBeSet = 0 AND sourceCopyId IN (SELECT archGrpCopyId FROM @tblJobCopyToSet WHERE toBeSet = 1)
	UPDATE 	JMJobDataStats
SET		disabled =  (J.disabled & ~(1+32768)), modifiedTime = @l_now, jobSelectionTime = @l_now
	FROM	JMJobDataStats J, @tblJobCopyToSet T
	WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archGrpCopyId AND J.commCellId = T.commCellId
AND (J.disabled & @AGED_DONOTCOPY) = 1 AND T.toBeSet = 1
	SET @retVal = 0
END
ELSE
IF @l_defCopyId <> @i_copyId
BEGIN
	--For GRC we sync the job status to destination CS, if job is recopied on source then we mark the job as recopy before merging.
	--In case of GRC source copy may not have the job on destination so skip below checks for GRC.
	DECLARE @IsForGRC bit = 0
	IF OBJECT_ID('tempdb..#GRC_IMPORT_IS_RUNNING') IS NOT NULL
		SET @IsForGRC = 1
	IF @IsForGRC = 0 AND NOT EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @l_srcCopyId AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 0)
		SET @retVal = 1
	ELSE
IF EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId AND (@i_recopy <> 0 OR status = 1000 OR disabled & 256 <> 0))
	BEGIN
		CREATE TABLE #ToBeAgedAFC (
			archFileId INT, commCellId INT, archCopyId INT, fileType INT,
			PRIMARY KEY (archFileId, commCellId, archCopyId))
		SET @retVal = 0
		INSERT	INTO #ToBeAgedAFC
		SELECT	DISTINCT AF.id, AF.commCellId, @i_copyId, AF.fileType
		FROM	archFile AF WITH (READUNCOMMITTED), archFileCOpy AFC WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.archGroupId = @l_archGrpId AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = AGC.id AND AGC.isSnapCopy = 0 AND (AF.flags & 2) = 0 AND AF.isValid = 1
		IF @IsForGRC = 0
		BEGIN
			-- Can't recopy pruned archive files on a spool copy
			IF EXISTS (SELECT copyId FROM archAgingRule WHERE copyId = @l_srcCopyId AND retentionDays = 0 AND fullCycles = 0)
				DELETE	#ToBeAgedAFC
				FROM	#ToBeAgedAFC T LEFT OUTER JOIN archFileCopy AFC
					ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = @l_srcCopyId
WHERE	AFC.archFileId Is Null OR (AFC.flags & 256) <> 0
			ELSE
				DELETE	#ToBeAgedAFC
				WHERE	fileType IN
					(
						SELECT	DISTINCT T.fileType
						FROM	#ToBeAgedAFC T LEFT OUTER JOIN archFileCopy AFC
							ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = @l_srcCopyId
WHERE	AFC.archFileId Is Null OR (AFC.flags & 256) <> 0
					)
		END
		IF NOT EXISTS (SELECT * FROM #ToBeAgedAFC)
		BEGIN
			SET @retVal = 1
			GOTO FINISH
		END
		UPDATE	JMJobDataStats
SET 	status = 101, disabled = disabled & 2, archCheckEndTime = 0, archCheckStatus = 0,
				copiedTime = 0, agedTime = 0, mediaDeletedTime = 0, modifiedTime = @l_now, jobSelectionTime = @l_now,
				auxCopyStatus = 101, unCompSize = -1
		FROM	JMJobDataStats J, (SELECT DISTINCT fileType FROM #ToBeAgedAFC) AS T
		WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId AND J.archGrpCopyId = @i_copyId AND J.dataType = T.fileType
AND (@i_recopy <> 0 OR status = 1000 OR (J.disabled & 256) <> 0)
		--
		-- Jai - Form 10971
		-- If recopy for dedup copy, set dummy param as below
		-- so that archFileDeleteViaTable puts large AFId in mmdeletedaf table
		--
		declare @i_dummyParam integer
		set @i_dummyParam	=	0
		if (@i_recopy <> 0)
		begin
set @i_dummyParam	=	1
		end
		EXEC @retVal = archFileDeleteViaTable @i_dummyParam, @magneticBytes OUTPUT
		IF @@ERROR <> 0 OR @retVal <> 0
			SET @retVal = 2
		DROP TABLE #ToBeAgedAFC
	END
END
IF (@retVal = 0)
BEGIN
	DECLARE @parentJobId INT = 0
	DECLARE @parentCommCellId INT = 0
	SELECT	DISTINCT @parentJobId = A.parentJobId, @parentCommCellId = A.commCellId
	FROM	JMVSAAppJobLink A WITH (READUNCOMMITTED)
	WHERE	A.parentJobId <> A.childJobId AND A.childJobId = @i_jobId AND A.commCellId = @i_commCellId
	IF (@parentJobId != 0)
	BEGIN
		DECLARE @tempTableCreated INT = 0
		IF OBJECT_ID('tempdb..#tmpResutSetForArchAllowJobForCopy') IS NULL
		BEGIN
			CREATE TABLE #tmpResutSetForArchAllowJobForCopy (retValue int)
			SET @tempTableCreated = 1
		END
		EXEC archAllowJobForCopy @parentJobId, @parentCommCellId, @i_copyId, @i_recopy
		SELECT	TOP 1 @retVal = retValue
		FROM	#tmpResutSetForArchAllowJobForCopy
		IF @tempTableCreated = 1
		BEGIN
			IF OBJECT_ID('tempdb..#tmpResutSetForArchAllowJobForCopy') IS NOT NULL DROP TABLE #tmpResutSetForArchAllowJobForCopy
			SET @tempTableCreated = 0
		END
		ELSE
			IF OBJECT_ID('tempdb..#tmpResutSetForArchAllowJobForCopy') IS NOT NULL DELETE FROM #tmpResutSetForArchAllowJobForCopy
	END
END
FINISH:
IF OBJECT_ID('tempdb..#tmpResutSetForArchAllowJobForCopy') IS NOT NULL
BEGIN
	INSERT INTO #tmpResutSetForArchAllowJobForCopy
	SELECT @retVal
END
ELSE
	SELECT @retVal
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archAllowJobForCopy')
	delete from GxQscripts where name = 'archAllowJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAllowJobForCopy')
	delete from GXDBVersions where aliasname = 'archAllowJobForCopy'
GO

insert into GXDBVersions values(2, 'archAllowJobForCopy',  '00010052003400190000', 'archAllowJobForCopy', '00010052003400190000')
GO

