

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAgingRuleExtendedUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAgingRuleExtendedUpdate.sp,v $ $Id: archAgingRuleExtendedUpdate.sp,v 1.3.200.2 2018/03/22 01:19:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archAgingRuleExtendedUpdate <<<'

IF EXISTS (select * from sysobjects where name='archAgingRuleExtendedUpdate')
	drop procedure archAgingRuleExtendedUpdate
IF EXISTS (select * from GxQscripts where name='archAgingRuleExtendedUpdate')
	delete from GxQscripts where name = 'archAgingRuleExtendedUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAgingRuleExtendedUpdate')
	delete from GXDBVersions where aliasname = 'archAgingRuleExtendedUpdate'
GO
print '... Creating Procedure: archAgingRuleExtendedUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archAgingRuleExtendedUpdate
  @i_copyId INTEGER,
  @i_ruleXml XML
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE	TABLE #ExtAgingRule (RetentionRule INT, RetentionDays INT, GraceDays INT, EveryXHours INT)
INSERT	INTO #ExtAgingRule
SELECT	T.item.value('@Rule', 'INT'),
		T.item.value('@RetentionDays', 'INT'),
		T.item.value('@GraceDays', 'INT'),
		T.item.value('@EveryXHours', 'INT')
FROM	@i_ruleXml.nodes('/GalaxyOperations_AgingRules/Extended') T(item)
DECLARE	@errorCode		INT
DECLARE	@copyFlags		INT
SET		@errorCode = 0
SELECT	@copyFlags = flags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
IF	((@copyFlags & 16777216) <> 0)
BEGIN
	DECLARE	@OldRule TABLE (RetentionRule INT, RetentionDays INT, GraceDays INT , EveryXHours INT)
	INSERT	INTO @OldRule
	SELECT	RetentionRule, RetentionDays, GraceDays ,EveryXHours
	FROM	archAgingRuleExtended
	WHERE	copyId = @i_copyId
	IF	EXISTS (
		SELECT *
		FROM	@OldRule R, #ExtAgingRule T
		WHERE	R.RetentionRule = T.RetentionRule
			AND T.RetentionDays > 0 AND (R.RetentionDays < 0 OR T.RetentionDays < R.RetentionDays)
		)
	BEGIN
SET	@errorCode = 93
	END
	ELSE
	IF	EXISTS (
		SELECT *
		FROM	@OldRule
		WHERE	RetentionRule NOT IN (SELECT RetentionRule FROM #ExtAgingRule)
		)
	BEGIN
SET	@errorCode = 94
	END
	ELSE
	BEGIN
		UPDATE	archAgingRuleExtended
		SET		retentionDays = T.RetentionDays, GraceDays = T.GraceDays , EveryXHours = T.EveryXHours
		FROM	archAgingRuleExtended R, #ExtAgingRule T
		WHERE	R.copyId = @i_copyId AND R.RetentionRule = T.RetentionRule
			AND (R.retentionDays <> T.RetentionDays OR R.GraceDays <> T.GraceDays OR R.EveryXHours <> T.EveryXHours)
		INSERT	INTO archAgingRuleExtended
		SELECT	@i_copyId, RetentionDays, RetentionRule, 0, 0, 0, 0, GraceDays,EveryXHours
		FROM	#ExtAgingRule
		WHERE	RetentionRule NOT IN (SELECT RetentionRule FROM @OldRule)
	END
END
ELSE
BEGIN
	DELETE	archAgingRuleExtended
	WHERE	copyId = @i_copyId
	INSERT	INTO archAgingRuleExtended
	SELECT	@i_copyId, RetentionDays, RetentionRule, 0, 0, 0, 0, GraceDays, EveryXHours
	FROM	#ExtAgingRule
END
CX_EXIT:
DROP TABLE #ExtAgingRule
SELECT	@errorCode
RETURN	@errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archAgingRuleExtendedUpdate')
	delete from GxQscripts where name = 'archAgingRuleExtendedUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAgingRuleExtendedUpdate')
	delete from GXDBVersions where aliasname = 'archAgingRuleExtendedUpdate'
GO

insert into GXDBVersions values(2, 'archAgingRuleExtendedUpdate',  '00010003020000020000', 'archAgingRuleExtendedUpdate', '00010003020000020000')
GO

