

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAgeDataSetMembers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAgeDataSetMembers.sp,v $ $Id: archAgeDataSetMembers.sp,v 1.11.2.8 2019/01/25 18:07:49 prathi Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archAgeDataSetMembers')
BEGIN
	print '>>> Drop Stored Procedure: archAgeDataSetMembers <<<'
	drop procedure archAgeDataSetMembers
END
IF EXISTS (select * from GxQscripts where name='archAgeDataSetMembers')
	delete from GxQscripts where name = 'archAgeDataSetMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAgeDataSetMembers')
	delete from GXDBVersions where aliasname = 'archAgeDataSetMembers'
GO
print '... Creating Procedure: archAgeDataSetMembers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAgeDataSetMembers
  @i_JobId int
AS
  DECLARE @retVal int;
  DECLARE @nProcessed int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempJobs') IS NOT NULL DROP TABLE #tempJobs
IF OBJECT_ID('tempdb.dbo.#tempAppIds') IS NOT NULL DROP TABLE #tempAppIds
CREATE TABLE #tempJobs
(
    JobId       INTEGER,
    CommCellId  INTEGER,
    AppId       INTEGER,
    ControlHostId   INTEGER,
    SMRelationId    INTEGER,
    DestCopyId      INTEGER,
    SrcCopyId      INTEGER
)
CREATE TABLE #tempAppIds
(
    AppId       INTEGER,
    ControlHostId   INTEGER,
    SMRelationId    INTEGER,
    Copied      INTEGER
)
DECLARE @l_currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @l_opType INTEGER = 0
DECLARE @l_dataArchGroupId INTEGER = 0
SET @retVal = 0
SET @nProcessed = 0
--
-- Check if DA is enabled before proceeding
--
declare @l_isDAEnabled integer
set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
if (@l_isDAEnabled = 0)
begin
set @retVal = -1000
	GOTO ERR_EXIT
end
DECLARE	@EnableDSAndMemberPruning		INTEGER
SET			@EnableDSAndMemberPruning		= 0
SELECT @EnableDSAndMemberPruning = isnull(value, 0)
FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'DA_CONFIG_SNAP_ENABLE_DS_AND_MEMBER_PRUNING'
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
--Do not prune DataSet Members if pruning is disabled
IF @EnableDSAndMemberPruning = 0
	GOTO ERR_EXIT
SELECT  @l_opType = opType
FROM    JMJobStats WITH (READUNCOMMITTED)
WHERE   JobId = @i_JobId
        AND CommCellId = 2
--Find all the jobs copied by current AuxCopy / LREP backup job
IF (@l_opType = 13) --AUXCOPY
BEGIN
    INSERT INTO #tempJobs (JobId, CommCellId, AppId, ControlHostId, SMRelationId, DestCopyId, SrcCopyId)
    SELECT  DISTINCT backupJobId, CommCellId, appId, 0, 0, destCopyId, archCopyId       -- fileMarkerNo - ControlHostId, VolumeId - SMRelationId,
    FROM    archChunkToCopyHistory WITH (READUNCOMMITTED)
    WHERE   adminJobId = @i_JobID
AND (extraFlags & 4) > 0
    SELECT  @retVal = @@ERROR
    IF  @retVal <> 0 GOTO ERR_EXIT
    UPDATE  J
    SET     SMRelationId = C.SMRelationId,
            ControlHostId = C.ControlHostId
    FROM    #tempJobs J, SMCopyToRelationMap C
    WHERE   J.DestCopyId = C.ArchGroupCopyId
    SELECT  @retVal = @@ERROR
    IF  @retVal <> 0 GOTO ERR_EXIT
END
ELSE IF (@l_opType = 104) --AUXCOPY2
BEGIN
    INSERT INTO #tempJobs (JobId, CommCellId, AppId, ControlHostId, SMRelationId, DestCopyId, SrcCopyId)
    SELECT  DISTINCT backupJobId, CommCellId, appId, 0, 0, DestCopyId, SrcCopyId       -- fileMarkerNo - ControlHostId, VolumeId - SMRelationId,
    FROM    ArchChunkToReplicate WITH (READUNCOMMITTED)
    WHERE   adminJobId = @i_JobID
AND (extraFlags & 4) > 0
    SELECT  @retVal = @@ERROR
    IF  @retVal <> 0 GOTO ERR_EXIT
    UPDATE  J
    SET     SMRelationId = C.SMRelationId,
            ControlHostId = C.ControlHostId
    FROM    #tempJobs J, SMCopyToRelationMap C
    WHERE   J.DestCopyId = C.ArchGroupCopyId
    SELECT  @retVal = @@ERROR
    IF  @retVal <> 0 GOTO ERR_EXIT
END
ELSE IF (@l_opType = 59) --BACKUP FOR LREP
BEGIN
	SELECT  @l_dataArchGroupId = dataArchGrpId
	FROM    JMBkpStats WITH (READUNCOMMITTED)
	WHERE   JobId = @i_JobId
			AND CommCellId = 2
    INSERT INTO #tempJobs (JobId, CommCellId, AppId, ControlHostId, SMRelationId, DestCopyId, SrcCopyId)
    SELECT  JDS.jobId, JDS.commCellId, JDS.appId, SCRM.ControlHostId, SCRM.SMRelationId, AG.defaultSnapCopy, 0
    FROM    JMJobDataStats JDS WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED), SMCopyToRelationMap SCRM WITH (READUNCOMMITTED)
    WHERE   JDS.jobId = @i_JobId
            AND JDS.commCellId = 2
            AND JDS.archGrpId = AG.id
            AND AG.defaultSnapCopy = JDS.archGrpCopyId
            AND JDS.status = 100
			AND AG.defaultSnapCopy = SCRM.archGroupCopyId
    SELECT  @retVal = @@ERROR
    IF  @retVal <> 0 GOTO ERR_EXIT
END
--Assume All SubClients in each relation is fully copied
INSERT INTO #tempAppIds (AppId, ControlHostId, SMRelationId, Copied)
SELECT  DISTINCT AppId, ControlHostId, SMRelationId, 1
FROM    #tempJobs J
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
--DO NOT prune Members associated with subclient of non-FS agents
DELETE 	#tempAppIds
FROM 		#tempAppIds T, App_Application APP WITH (READUNCOMMITTED)
WHERE 	T.AppId = APP.id
AND 		APP.appTypeId NOT IN (13,
17,
19,
21,
29,
33,
106
														 )
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
--DO NOT prune Members associated with subclient if one of the job is in uncopied state
UPDATE  #tempAppIds
SET     Copied = 0
WHERE   EXISTS (SELECT  1
                FROM    #tempJobs J, JMJobDataStats JDS WITH (READUNCOMMITTED)
                WHERE   J.JobID = JDS.JobId
                        AND J.DestCopyId = JDS.archGrpCopyId
                        -- AND JDS.DataType IN (1, 6)
                        AND J.CommCellId = JDS.CommCellId
                        AND (JDS.Status != 100)
                        AND J.AppId = #tempAppIds.AppId
                        AND J.ControlHostId = #tempAppIds.ControlHostId
                        AND J.SMRelationId = #tempAppIds.SMRelationId)
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
--Do Not Age DataSetMember when most recent Job for subclient has missing snaps flag on source or destination copy or job is not completed with success status (Completed with Errors or Completed with Warnings are not considered as Success)
IF ((@l_opType = 13) OR (@l_opType = 104))
BEGIN
	UPDATE  #tempAppIds
	SET     Copied = 0
	WHERE   EXISTS (SELECT  1
	                FROM    (SELECT MAX(JobId) MaxJobId, CommCellId, AppId, ControlHostId, SMRelationId, DestCopyId, SrcCopyId
							FROM	#tempJobs
							GROUP BY  CommCellId, AppId, ControlHostId, SMRelationId, DestCopyId, SrcCopyId) J,
							JMJobDataStats SrcJDS WITH (READUNCOMMITTED), JMJobDataStats DestJDS WITH (READUNCOMMITTED), JMBkpStats JBS WITH (READUNCOMMITTED)
	                WHERE   J.MaxJobId = SrcJDS.JobId
	                        AND J.SrcCopyId = SrcJDS.archGrpCopyId
	                        AND J.CommCellId = SrcJDS.CommCellId
							AND J.MaxJobId = DestJDS.JobId
	                        AND J.CommCellId = DestJDS.CommCellId
	                        AND J.SrcCopyId = DestJDS.archGrpCopyId
							AND J.MaxJobId = JBS.JobId
	                        AND J.CommCellId = JBS.CommCellId
AND ((SrcJDS.Disabled & 16384) > 0 OR (DestJDS.Disabled & 16384) > 0 OR JBS.Status != 1)
	                        AND J.AppId = #tempAppIds.AppId
	                        AND J.ControlHostId = #tempAppIds.ControlHostId
	                        AND J.SMRelationId = #tempAppIds.SMRelationId)
END
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
-- For AppId, if there exist snap entry in SMSnap but not in SMSnapToDatasetMemberMap then do not age any DataSetMembers
-- For Upgraded Media Agent untill all older snap are pruned we cannot age dataset members
-- With 11.0 or higer CS, 10.0 or earlier media agents creating snap entries will not create any entry in SMSnapToDataSetMemberMap so above aging cannot be applied until all MAs are upgraded to 11.0 for AppId
UPDATE  #tempAppIds
SET     Copied = 0
WHERE   EXISTS (SELECT  1
                FROM    SMCopyToRelationMap SCR WITH (READUNCOMMITTED), SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED) LEFT OUTER JOIN SMSnapToDatasetMemberMap SDM WITH (READUNCOMMITTED) ON VS.SMSnapId = SDM.SMSnapId
                WHERE   #tempAppIds.AppId = V.AppId
						AND #tempAppIds.ControlHostId = SCR.ControlHostId
						AND #tempAppIds.SMRelationId = SCR.SMRelationId
						AND V.CopyId = SCR.ArchGroupCopyId
						AND V.SMVolumeId = VS.SMVolumeId
						AND SDM.SMSnapId IS NULL)
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
DELETE FROM #tempAppIds
WHERE   Copied = 0
SELECT  @retVal = @@ERROR
IF  @retVal <> 0 GOTO ERR_EXIT
IF (@l_opType = 59) --BACKUP FOR LREP
BEGIN
	IF OBJECT_ID('tempdb.dbo.#MM_SMProcessDatasetsForPruningResultTable') IS NOT NULL DROP TABLE #MM_SMProcessDatasetsForPruningResultTable
	CREATE TABLE #MM_SMProcessDatasetsForPruningResultTable ( errCode	INT, errMsg	VARCHAR(255))
	EXEC MM_SMProcessDatasetsForPruning
	SELECT	@retVal = errCode
	FROM	#MM_SMProcessDatasetsForPruningResultTable
	IF  @retVal <> 0 GOTO ERR_EXIT
	UPDATE  SMDataSetMember
SET     Flags = DM.Flags | 256, AgedTime = @l_currentTime, AgedBy = DM.AgedBy | CAST (17179869184 AS BIGINT)
	FROM    SMDataSetMember DM, #tempAppIds T
	WHERE   DM.AppId = T.AppId
			AND DM.SMRelationId = T.SMRelationId
AND NOT EXISTS (SELECT 1 FROM SMDataSet SMD WITH (READUNCOMMITTED) WHERE SMD.DataSetId = DM.DataSetId AND (SMD.Flags & 1024 > 0))
			AND NOT EXISTS (SELECT 1 FROM SMSnapToDatasetMemberMap D WITH (READUNCOMMITTED) WHERE D.DSMemberId = DM.DataSetMemberId)
			AND (DM.Flags & 4) != 4
			AND (DM.Flags & 2) != 2
			AND NOT EXISTS (
							SELECT	1
							FROM	SMDataSetMember PD WITH (READUNCOMMITTED), SMDataSetMember SD WITH (READUNCOMMITTED), SMDataSetToSubClientMap M WITH (READUNCOMMITTED)
							WHERE	PD.SMRelationId = DM.SMRelationId
									AND PD.DataSetId = DM.DataSetID
									AND PD.appId = DM.AppId
									AND (DM.Flags & 1) = 1
									AND SUBSTRING(PD.ExtDataSetMemberName, LEN(PD.ExtDataSetMemberName) - 36 + 1, 36) = SUBSTRING(DM.ExtDataSetMemberName, LEN(DM.ExtDataSetMemberName) - 36 + 1, 36)
									AND PD.appId = SD.appID
									AND (PD.Flags & 2) = 2
AND (SD.Flags & (256 | 1)) = 1
									AND PD.ExtDataSetMemberId = SD.ExtDataSetMemberId
									AND PD.SMRelationID != SD.SMRelationId
									AND SD.appId = M.AppId
									AND SD.SMRelationId = M.SMRelationId
									AND M.archGroupId = @l_dataArchGroupId
							)
	SELECT  @retVal = @@ERROR, @nProcessed = @@ROWCOUNT
END
ELSE
BEGIN
	UPDATE  SMDataSetMember
SET     Flags = DM.Flags | 256, AgedTime = @l_currentTime, AgedBy = DM.AgedBy | CAST (17179869184 AS BIGINT)
	FROM    SMDataSetMember DM, SMDataset DS, #tempAppIds T
	WHERE   DM.AppId = T.AppId
			AND DM.SMRelationId = T.SMRelationId
			AND DM.DataSetId = DS.DataSetId
AND (DS.Flags & 1024) = 0
			AND NOT EXISTS (SELECT * FROM SMSnapToDatasetMemberMap D WITH (READUNCOMMITTED) WHERE D.DSMemberId = DM.DataSetMemberId)
			AND (DM.Flags & 1) = 1 --look for only primary members
-- MR 228487 - To handle NetApp Metrocluster switchover scenarios.
	UPDATE DM
SET	Flags = DM.Flags & ~256
	FROM SMDataSetMember DM
	WHERE EXISTS (SELECT TOP 1 * FROM SMDataSetMember DM2 WITH (READUNCOMMITTED)
					WHERE DM.AppId = DM2.AppId AND DM.DataSetId = DM2.DataSetId
						AND DM.ExtDataSetMemberName = DM2.ExtDataSetMemberName AND DM.DataSetMemberId != DM2.DataSetMemberId
AND ((DM2.Flags & 256) = 0))
AND ((DM.Flags & 256) = 256)
	SELECT  @retVal = @@ERROR, @nProcessed = @@ROWCOUNT
	IF  @retVal <> 0 GOTO ERR_EXIT
END
ERR_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempJobs') IS NOT NULL DROP TABLE #tempJobs
IF OBJECT_ID('tempdb.dbo.#tempAppIds') IS NOT NULL DROP TABLE #tempAppIds
SELECT @retVal, @nProcessed
GO

IF EXISTS (select * from GxQscripts where name = 'archAgeDataSetMembers')
	delete from GxQscripts where name = 'archAgeDataSetMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAgeDataSetMembers')
	delete from GXDBVersions where aliasname = 'archAgeDataSetMembers'
GO

insert into GXDBVersions values(2, 'archAgeDataSetMembers',  '00010011000200080000', 'archAgeDataSetMembers', '00010011000200080000')
GO

