

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAddEncKeyProvider.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAddEncKeyProvider.sp,v $ $Id: archAddEncKeyProvider.sp,v 1.1.2.10 2020/04/17 00:35:44 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archAddEncKeyProvider"								|
--	|																		|
--	| Adds encryption key provider											|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archAddEncKeyProvider')
BEGIN
	print '>>> Drop Stored Procedure: archAddEncKeyProvider <<<'
	drop procedure archAddEncKeyProvider
END
IF EXISTS (select * from GxQscripts where name='archAddEncKeyProvider')
	delete from GxQscripts where name = 'archAddEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAddEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archAddEncKeyProvider'
GO
print '... Creating Procedure: archAddEncKeyProvider'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archAddEncKeyProvider
  @i_userId int,
  @i_keyProviderName NVARCHAR(1024),
  @i_keyProviderType int,
  @i_EncType int,
  @i_EncKeyLength int,
  @i_Properties xml,
  @i_secAssocXml xml,
  @i_localeId bigint
AS
BEGIN
  DECLARE @o_errorCode int;
  DECLARE @o_errorString NVARCHAR(1024);
  DECLARE @o_passphrase uniqueidentifier;
  DECLARE @o_passphraseFileName varchar(2048);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
SET @o_errorCode = 0
	DECLARE @now int = dbo.getunixtime(getutcdate())
	DECLARE @l_keyProviderId int
	DECLARE @l_keyProviderGUID uniqueidentifier
	-- Validation
	IF EXISTS(SELECT 1 FROM ArchEncKeyProvider WHERE KeyProviderName = @i_keyProviderName)
	BEGIN
SET @o_errorCode = 173
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (192 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
        SET @o_errorString = REPLACE(@o_errorString, '^1%s', @i_keyProviderName)
		GOTO CX_EXIT
	END
	SELECT @l_keyProviderGUID = newid()
	--PASSPHRASE KMS:  we need generate passphrase and form passphrase file name and update properties with fileName
IF @i_keyProviderType = 6 /*CVA_ENC_KEY_PROVIDER_PASSPHRASE*/
	BEGIN
		--
		-- Check if any duplicate export location is specified.
		-- Duplicates are not allowed
		--
		IF EXISTS
		(
			SELECT 1
			FROM (SELECT 	col.value('client[1]/@clientId', 'int') clientId,
							(CASE WHEN RIGHT(col.value('filePath[1]/@path', 'varchar(max)'), 1) IN ('/', '\')
									THEN LEFT(col.value('filePath[1]/@path', 'varchar(max)'), LEN(col.value('filePath[1]/@path', 'varchar(max)')) - 1)
									ELSE col.value('filePath[1]/@path', 'varchar(max)')
							END) path
					FROM 	@i_Properties.nodes('App_EncKeyProviderProperties/passphraseClient') as node(col)) AS T
			GROUP BY T.clientId, T.path
			HAVING COUNT(*) > 1
		)
		BEGIN
SET @o_errorCode = 225
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (250 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
			GOTO CX_EXIT
		END
		--Random GUID will be used as passphrase if user opts to generate it
		SET @o_passphrase = newid()
		--Passphrase file name will be in format "Passphrase_<KeyProviderGUID>_<Timestamp>"
		SET @o_passphraseFileName = 'Passphrase_' + cast(@l_keyProviderGUID as varchar(36)) + '_' + cast(@now as varchar(10))
		IF @i_Properties.exist('/App_EncKeyProviderProperties/@passphraseFileName') > 0
			SET @i_Properties.modify('replace value of (/App_EncKeyProviderProperties[1]/@passphraseFileName) with sql:variable("@o_passphraseFileName")')
		ELSE
			SET @i_Properties.modify('insert attribute passphraseFileName {sql:variable("@o_passphraseFileName")} into (/App_EncKeyProviderProperties[1])')
	END
	-- Add provider
	INSERT INTO ArchEncKeyProvider ( KeyProviderName, KeyProviderType, EncType, EncKeyLength, Properties, Modified, Created, GUID )
	VALUES (@i_keyProviderName, @i_keyProviderType, @i_EncType, @i_EncKeyLength, cast(@i_Properties as nvarchar(max)), @now, @now, @l_keyProviderGUID)
	SELECT @l_keyProviderId = SCOPE_IDENTITY(), @o_errorCode = @@ERROR
	IF @o_errorCode <> 0
	BEGIN
SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	--
	--Security Association for creator
	--
	DECLARE @l_permissionsList NVARCHAR(MAX)
SET @l_permissionsList = CAST(1 AS NVARCHAR) + ',' + CAST(107 AS NVARCHAR)  --Administrative Management and Change security settings
EXEC sec_setCreatorForEntity @i_userId, 0, @l_permissionsList, @o_errorCode OUTPUT, @o_errorString OUTPUT, 178, @l_keyProviderId
	IF @o_errorCode <> 0
	BEGIN
SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	--
	--Security Associations specified by user
	--
	IF @i_secAssocXml.exist('*') > 0
	BEGIN
		IF OBJECT_ID('tempdb..#lt_Error') IS NOT NULL DROP TABLE #lt_Error
		CREATE TABLE #lt_Error (errorCode int, errorString nvarchar(1024))
		INSERT INTO #lt_Error
		EXEC sec_setSecurityAssociationsFromEntity
					@xmlIn = @i_secAssocXml,
					@userId = @i_userId,
					@isCmdLine = 0,
					@skipSecurityCheck = 1,
@entityType1 = 178 /*KEY_MANAGEMENT_SERVER_ENTITY*/,
					@entityId1 = @l_keyProviderId,
					@entityType2 = 0,
					@entityId2 = 0,
					@entityType3 = 0,
					@entityId3 = 0,
					@entityType4 = 0,
					@entityId4 = 0,
					@entityType5 = 0,
					@entityId5 = 0
		SELECT @o_errorCode = errorCode, @o_errorString = errorString FROM #lt_Error
	END
CX_EXIT:
IF OBJECT_ID('tempdb..#lt_Error') IS NOT NULL DROP TABLE #lt_Error
SELECT @o_errorCode ErrorCode, @o_errorString ErrorString, @o_passphrase Passphrase, @o_passphraseFileName PassphraseFileName
END

IF EXISTS (select * from GxQscripts where name = 'archAddEncKeyProvider')
	delete from GxQscripts where name = 'archAddEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAddEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archAddEncKeyProvider'
GO

insert into GXDBVersions values(2, 'archAddEncKeyProvider',  '00010001000200100000', 'archAddEncKeyProvider', '00010001000200100000')
GO

