

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/addSysDefaultSchedPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/addSysDefaultSchedPolicy.sp,v $ $Id: addSysDefaultSchedPolicy.sp,v 1.15.294.1 2018/03/20 00:49:27 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: addSysDefaultSchedPolicy
--  |
--  | Description:
--  |  Add JMJobDataStats table entries for the given backup job and copy.
--  |
--  |   Revisions  Author    Description
--  |   ---------  -------   ---------------------------------------------
--  |   1.0        Muath Ali Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: addSysDefaultSchedPolicy <<<'

IF EXISTS (select * from sysobjects where name='addSysDefaultSchedPolicy')
	drop procedure addSysDefaultSchedPolicy
IF EXISTS (select * from GxQscripts where name='addSysDefaultSchedPolicy')
	delete from GxQscripts where name = 'addSysDefaultSchedPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addSysDefaultSchedPolicy')
	delete from GXDBVersions where aliasname = 'addSysDefaultSchedPolicy'
GO
print '... Creating Procedure: addSysDefaultSchedPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure addSysDefaultSchedPolicy
  @i_reserved INTEGER,
  @i_name NVARCHAR(64),
  @i_description NVARCHAR(256)
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
BEGIN TRANSACTION
DECLARE @PolicyId          INTEGER;
DECLARE @PolicyInstanceId  INTEGER;
DECLARE @ScheduleId        INTEGER;
DECLARE @TaskId            INTEGER;
DECLARE @NextEvent         VARCHAR(64);
DECLARE @NextWeekDay       INTEGER;
DECLARE @NextDate          DATETIME;
DECLARE @startDate		   INTEGER;
   INSERT INTO schedTemplate
   VALUES      (4, 0, @i_name, @i_description, 10, 0)
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @policyId = @@IDENTITY
   -- Mon to Thu 6:00 PM
   INSERT INTO schedTemplateinstance
   VALUES      (@policyId)
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @policyInstanceId = @@IDENTITY
   SET @NextDate = getdate()
   SET @startDate = dbo.getunixtime(getutcdate())
   IF (SELECT CONVERT(varchar, datepart(hh, @NextDate), 120)) >= 18  SET @NextDate = getdate()+1
   SET @NextWeekDay = CONVERT(int, datepart(weekday, @NextDate), 120)
   IF @NextWeekDay = 6
      SET @NextDate = @NextDate + 3
   ELSE IF @NextWeekDay = 7
      SET @NextDate = @NextDate + 2
   ELSE IF @NextWeekDay = 1
      SET @NextDate = @NextDate + 1
   SET @NextEvent = CONVERT(varchar(10), @NextDate, 120) + ' ' + '18:00:00.000'
   INSERT INTO schedule
   VALUES      (0, 8, 19, 0, 0, 0, 1, 0, 1, 1, 0, 1, 30, 0, 0, 0, 64800, 0, -1, @startDate, 0, 1, 300, '(GMT-05:00) Eastern Time (US & Canada)', '', @nextEvent, 0, 0, 0, @policyInstanceId, 0, 100, 100, 1)
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @ScheduleId = @@IDENTITY
   INSERT INTO SchedBackupTask
   VALUES      (@ScheduleId, 0, 1, 0, 0, 6357010, 0, 0, 0, 0, 0, '', 2, 0, N'')
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @TaskId = @@IDENTITY
   UPDATE Schedule
   SET    taskId = @TaskId
   WHERE  id = @ScheduleId
   IF @@ERROR <> 0 GOTO RETURN_PROC
   INSERT INTO SchedBackupTaskOptions
   values (@TaskId, 'ExtendedOptions', '10')
   INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'JobRetryNumbers' , '-1')
   INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'JobRetryHrs' , '0')
   IF @@ERROR <> 0 GOTO RETURN_PROC
   -- Friday
   INSERT INTO schedTemplateinstance
   VALUES      (@policyId)
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @policyInstanceId = @@IDENTITY
   SET @NextDate = getdate()
   IF (SELECT CONVERT(varchar, datepart(hh, @NextDate), 120)) >= 18  SET @NextDate = getdate()+1
   SET @NextWeekDay = CONVERT(int, datepart(weekday, @NextDate), 120)
   IF @NextWeekDay = 1
      SET @NextDate = @NextDate + 5
   ELSE IF @NextWeekDay = 2
      SET @NextDate = @NextDate + 4
   ELSE IF @NextWeekDay = 3
      SET @NextDate = @NextDate + 3
   ELSE IF @NextWeekDay = 4
      SET @NextDate = @NextDate + 2
   ELSE IF @NextWeekDay = 5
      SET @NextDate = @NextDate + 1
   ELSE IF @NextWeekDay = 7
      SET @NextDate = @NextDate + 6
   SET @NextEvent = CONVERT(varchar(10), @NextDate, 120) + ' ' + '18:00:00.000'
   INSERT INTO schedule
   VALUES      (0, 8, 19, 0, 0, 0, 1, 0, 1, 1, 0, 1, 32, 0, 0, 0, 64800, 0, -1,@startDate,  0, 1, 300, '(GMT-05:00) Eastern Time (US & Canada)', '', @nextEvent, 0, 0, 0, @policyInstanceId, 0, 100, 100, 1)
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @ScheduleId = @@IDENTITY
   INSERT INTO SchedBackupTask
   VALUES      (@ScheduleId, 0, 1, 0, 0, 6357009, 0, 0, 0, 0, 0, '', 2, 0, N'')
   IF @@ERROR <> 0 GOTO RETURN_PROC
   SET @TaskId = @@IDENTITY
   UPDATE Schedule
   SET    taskId = @TaskId
   WHERE  id = @ScheduleId
   IF @@ERROR <> 0 GOTO RETURN_PROC
   INSERT INTO SchedBackupTaskOptions
   values (@TaskId, 'ExtendedOptions', '10')
   INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'JobRetryNumbers' , '-1')
   INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'JobRetryHrs' , '0')
   IF @@ERROR <> 0 GOTO RETURN_PROC
RETURN_PROC:
   SET @retVal = @@ERROR
   IF @retVal = 0
      COMMIT   TRANSACTION
   IF @retVal <> 0
      ROLLBACK TRANSACTION
   SELECT @retVal
   RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'addSysDefaultSchedPolicy')
	delete from GxQscripts where name = 'addSysDefaultSchedPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addSysDefaultSchedPolicy')
	delete from GXDBVersions where aliasname = 'addSysDefaultSchedPolicy'
GO

insert into GXDBVersions values(2, 'addSysDefaultSchedPolicy',  '00010015029400010000', 'addSysDefaultSchedPolicy', '00010015029400010000')
GO

