

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/addSQL_LinkedServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/addSQL_LinkedServer.sp,v $ $Id: addSQL_LinkedServer.sp,v 1.4.60.1 2018/03/22 02:59:24 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: addSQL_LinkedServer <<<'

IF EXISTS (select * from sysobjects where name='addSQL_LinkedServer')
	drop procedure addSQL_LinkedServer
IF EXISTS (select * from GxQscripts where name='addSQL_LinkedServer')
	delete from GxQscripts where name = 'addSQL_LinkedServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addSQL_LinkedServer')
	delete from GXDBVersions where aliasname = 'addSQL_LinkedServer'
GO
print '... Creating Procedure: addSQL_LinkedServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure addSQL_LinkedServer
  @bDeleteIfExists INTEGER,
  @i_xml XML
AS
  DECLARE @r_xml XML
SET NOCOUNT ON
DECLARE		@serverInstanceName		VARCHAR(MAX)
DECLARE		@linkedServerName		VARCHAR(1024)
DECLARE		@userName		VARCHAR(1024)
DECLARE		@password		VARCHAR(1024)
DECLARE		@l_provStr		VARCHAR(MAX)
DECLARE		@errorCode		INTEGER
DECLARE		@errorString	VARCHAR(1024)
SET NOCOUNT OFF
SET @errorCode = 0
SELECT
		@serverInstanceName	=	param.value('@sqlServerName', 'VARCHAR(MAX)'),
		@linkedServerName =		param.value('@linkedServerName',  'VARCHAR(1024)'),
		@userName	=	usrparam.value('@userName', 'VARCHAR(1024)'),
		@password	=	usrparam.value('@password', 'VARCHAR(1024)')
FROM @i_xml.nodes('/TMMsg_SqlLinkedServer') AS sqlServerInfo(param),
@i_xml.nodes('/TMMsg_SqlLinkedServer/sqlUserAccount') AS sqlServerUsrInfo(usrparam)
IF EXISTS (	select server_id
			from sys.servers
			where name=@linkedServerName)
BEGIN
	IF(@bDeleteIfExists = 0)
	BEGIN
		set @errorCode = 1
		set @errorString = 'Linked server '+@linkedServerName+' is already existing for instance '+@serverInstanceName
		GOTO PROC_EXIT
	END
	BEGIN
		EXEc sp_droplinkedsrvlogin @rmtsrvname = @linkedServerName, @locallogin = NULL
		EXEC sp_dropserver @server = @linkedServerName
	END
	IF(@@ERROR <> 0)
	BEGIN
		set @errorCode = @@ERROR
		set @errorString = 'Failed to drop linked server '+@linkedServerName
		GOTO	PROC_EXIT
	END
END
EXEC sp_addlinkedserver
@server = @linkedServerName,
@srvproduct = '',
@provider = N'SQLNCLI',
@datasrc = @serverInstanceName
DECLARE @loginStr NVARCHAR(MAX)
EXEC sp_addlinkedsrvlogin
	@rmtsrvname=@linkedServerName,
	@useself='FALSE',
	@locallogin=NULL,
	@rmtuser=@userName,
	@rmtpassword=@password
IF(@@ERROR <> 0)
BEGIN
		set @errorCode = @@ERROR
		set @errorString = 'Failed to add linked server '+@linkedServerName+' for instance '+@serverInstanceName
		GOTO	PROC_EXIT
	END
PROC_EXIT:
	SET @r_xml = (SELECT '<?xml version="1.0" encoding="utf-16" ?>' +
		(SELECT
		@errorCode			     as '@errorCode',
		@errorString	         as '@errorMessage'
	FOR XML PATH('CVGui_GenericResp')))
 SELECT @r_xml
GO

IF EXISTS (select * from GxQscripts where name = 'addSQL_LinkedServer')
	delete from GxQscripts where name = 'addSQL_LinkedServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addSQL_LinkedServer')
	delete from GXDBVersions where aliasname = 'addSQL_LinkedServer'
GO

insert into GXDBVersions values(2, 'addSQL_LinkedServer',  '00010004006000010000', 'addSQL_LinkedServer', '00010004006000010000')
GO

