

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/addJobDataStatsForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/addjobdatastatsforauxcopy.sp,v $ $Id: addjobdatastatsforauxcopy.sp,v 1.35.12.11 2019/10/11 21:46:50 chandru Exp $";
--
--  +========================================================================+
--  | Stored Precedure: addJobDataStatsForAuxCopy
--  |
--  | Description:
--  |  Add JMJobDataStats table entries for the given backup job and copy.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jun Lu   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='addJobDataStatsForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: addJobDataStatsForAuxCopy <<<'
	drop procedure addJobDataStatsForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='addJobDataStatsForAuxCopy')
	delete from GxQscripts where name = 'addJobDataStatsForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addJobDataStatsForAuxCopy')
	delete from GXDBVersions where aliasname = 'addJobDataStatsForAuxCopy'
GO
print '... Creating Procedure: addJobDataStatsForAuxCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure addJobDataStatsForAuxCopy
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_copyId INTEGER,
  @i_primaryCopy INTEGER,
  @i_modifyTime INTEGER,
  @i_periodStart INTEGER,
  @i_periodEnd INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_archGroupId	INT
DECLARE	@l_copyType		INT
DECLARE	@l_IsSnapCopy	INT
DECLARE	@l_BkpLevel		INT
DECLARE	@l_fullCycleNum		INT
DECLARE	@l_AppId		INT
DECLARE @l_flags	INT
DECLARE @l_servStartDate INT = 0
DECLARE @l_isAdminJob INT = 0
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
	CREATE TABLE #tblSelectedJobs (jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER)
CREATE INDEX Idx_tmptblSelectedJobs_1 ON #tblSelectedJobs (jobId, commcellId, copyId)
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
DECLARE @mirrorCopyIds TABLE(copyId integer)
INSERT INTO @mirrorCopyIds
SELECT id
FROM archgroupCopy WITH (READUNCOMMITTED) WHERE isMirrorCopy > 0 AND sourceCopyId = @i_copyId
SELECT	@l_archGroupId = archGroupId, @l_copyType = type, @l_IsSnapCopy = isSnapCopy, @l_flags = flags
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_copyId
SELECT @l_AppId = appId, @l_servStartDate = servStartDate, @l_BkpLevel = bkpLevel, @l_FullCycleNum = fullCycleNum FROM JMBkpStats WITH(NOLOCK)
WHERE jobId = @i_jobId AND commcellId = @i_commcellId
IF(@@ROWCOUNT = 0) --We did not find a row in JMBkpStats, could be an admin job
BEGIN
	SELECT @l_AppId = appId, @l_servStartDate = servStart, @l_BkpLevel = ER_BkpLevel, @l_FullCycleNum = fullCycleNum from JMAdminJobStatsTable WITH(NOLOCK)
	WHERE jobId = @i_jobId AND commcellId = @i_commcellId
	IF(@@ROWCOUNT > 0)
		SET @l_isAdminJob = 1
END
IF	@i_primaryCopy = 0
	SELECT @i_primaryCopy = (CASE @l_IsSnapCopy WHEN 0 THEN defaultCopy ELSE defaultSnapCopy END) FROM archGroup WITH (READUNCOMMITTED) WHERE id = @l_archGroupId
--If option set to avoid duplicates among selective copies do not copy when there is any selective copy which has a job copied in this period already and the copy is for first full
IF EXISTS(SELECT 1 FROM archGroup WITH(NOLOCK) WHERE id = @l_archGroupId  AND flags & 4194304 > 0)
AND EXISTS(SELECT 1 FROM archSelectiveCopy WITH(NOLOCK) WHERE copyId = @i_copyId AND type IN(10, 3, 2, 4, 6))
AND @i_periodStart != 0
BEGIN
	DECLARE @tempCopies table(copyId int, startPeriod int, nextPeriod int, prevPeriodBegin int, nextPeriodEnd int, periodDuration int)
	DECLARE @currCopyPeriodDuration int = @i_periodEnd - @i_periodStart
	DECLARE @l_clientId int = 0
	SELECT @l_clientId = clientId FROM App_Application WITH(NOLOCK) WHERE id = @l_AppId
	INSERT INTO @tempCopies
	SELECT copyId, startPeriod, nextPeriod, prevPeriodBegin, nextPeriodEnd, (nextPeriod - startPeriod)
	FROM archSelectiveCopy ASCP WITH(NOLOCK) INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON ASCP.copyId = AGC.id AND AGC.archGroupId = @l_archGroupId
AND ASCP.type IN (10, 3, 2, 4, 6)
	AND AGC.isActive >= 1
	DECLARE @l_TimeZone		VARCHAR(255) = ''
	DECLARE @l_csTimeZone	VARCHAR(255) = ''
	SET		@l_TimeZone		= dbo.ArchGroupTimeZone(@l_archGroupId, @l_clientId)
	SET		@l_csTimeZone	= dbo.GetClientTimeZone(2)
	DECLARE @jobStartTimes table(copyId int, jobStartDate int)
	IF(@l_isAdminJob = 0)
	BEGIN
		INSERT INTO @jobStartTimes
		SELECT C.copyId, JBKP.servStartDate FROM
		JMBkpStats JBKP WITH(NOLOCK) INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId
		INNER JOIN @tempCopies C ON JDS.archGrpCopyId = C.copyId
WHERE JDS.status >= 100 AND (JDS.disabled & (1 | 256) = 0)
		AND JBKP.appId = @l_appId AND JBKP.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND JBKP.status IN (1, 3, 14)
	END
	ELSE
	BEGIN
		INSERT INTO @jobStartTimes
		SELECT C.copyId, JBKP.servStart FROM
		JMAdminJobStatsTable JBKP WITH(NOLOCK) INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId
		INNER JOIN @tempCopies C ON JDS.archGrpCopyId = C.copyId
WHERE JDS.status >= 100 AND (JDS.disabled & (1 | 256) = 0)
		AND JBKP.appId = @l_appId AND JBKP.ER_BkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND JBKP.status IN (1, 3, 14)
	END
	IF @l_TimeZone <> @l_csTimeZone
		UPDATE @jobStartTimes
		SET jobStartDate = jobStartDate + dbo.GetDiffFromCSTimeZone(jobStartDate, @l_TimeZone, @l_csTimeZone)
	--We have a job for the subclient
	IF EXISTS(
	SELECT 1 FROM
	@jobStartTimes JDS INNER JOIN @tempCopies C ON JDS.copyId = C.copyId
	WHERE C.periodDuration >= @currCopyPeriodDuration
	AND jobStartDate >= @i_periodStart
	AND jobStartDate < @i_periodEnd
	AND (
(@l_flags & 4096 = 0 AND jobStartDate <= @l_servStartDate)
		OR
(@l_flags & 4096 > 0 AND jobStartDate >= @l_servStartDate)
		)
	)
	BEGIN
		SET @retVal = 1
		GOTO RETURN_PROC
	END
END
IF NOT EXISTS (SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED) WHERE jobId = @i_jobId
               AND archGrpCopyId = @i_copyId AND commCellId = @i_commCellId )
BEGIN
	IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
		DROP TABLE #tmpAppIdList
	CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
	INSERT INTO #tmpAppIdList
	SELECT @l_AppId, 0, 0, 0, 0
	--Set unsupported flag
	EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
	INSERT INTO JMJobDataStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
	INTO #tblSelectedJobs
	SELECT JDS.jobId, JDS.archGrpId, @i_copyId, JDS.dataType, 13, 0, 101, 0, JDS.appId, JDS.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
	FROM   JMJobDataStats JDS, APP_Application A WITH (READUNCOMMITTED), #tmpAppIdList T
	WHERE  JDS.jobId = @i_jobId AND JDS.archGrpCopyId = @i_primaryCopy AND JDS.commCellId = @i_commCellId
AND (JDS.dataType = 2 OR @l_copyType <> 4)
		AND JDS.AppId = T.AppId
		AND T.unSupportedAlways = 0
		AND JDS.status IN (100, 101, 102, 103)
	AND JDS.appId = A.id
AND (@SkipTransactionalLogs = 0 OR dataType != 4 OR A.appTypeId != 81)
	SET @retVal = @@ERROR
	IF (@retVal <> 0)
	BEGIN
		GOTO RETURN_PROC
	END
	IF (@l_IsSnapCopy = 1)
	BEGIN
		IF (@l_BkpLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_commCellId, @i_copyId) = 1)
		BEGIN
			DECLARE	@l_fullJobID INT = 0
			SELECT	@l_fullJobID = JobId
			FROM	JMBkpStats
			WHERE	appId = @l_AppId
				AND fullCycleNum = @l_fullCycleNum
				AND bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
			ORDER BY JobID
			IF NOT EXISTS (SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED) WHERE jobId = @l_fullJobID
						   AND archGrpCopyId = @i_copyId AND commCellId = @i_commCellId )
			BEGIN
			   INSERT INTO JMJobDataStats
			   OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
			   INTO #tblSelectedJobs
			   SELECT jobId, archGrpId, @i_copyId, dataType, 13, 0, 101, 0, appId, commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
			   FROM   JMJobDataStats, APP_Application A WITH (READUNCOMMITTED)
			   WHERE  jobId = @l_fullJobID AND archGrpCopyId = @i_primaryCopy AND commCellId = @i_commCellId
AND (dataType = 2 OR @l_copyType <> 4)
				AND status IN (100, 101, 102, 103)
				AND appId = A.id
AND (@SkipTransactionalLogs = 0 OR dataType != 4 OR A.appTypeId != 81)
			END
		END
	END
	GOTO RETURN_PROC
END
UPDATE JMJobDataStats SET disabled = (disabled & ~1), modifiedTime = @i_modifyTime
   OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
   INTO #tblSelectedJobs
   WHERE  jobId = @i_jobId AND archGrpCopyId = @i_copyId AND commCellId = @i_commCellId
   SET @retVal = @@ERROR
RETURN_PROC:
   if @retVal = 0 AND EXISTS (SELECT 1 FROM @mirrorCopyIds)
   BEGIN
UPDATE JMJobDataStats SET disabled = (disabled & ~1), modifiedTime = @i_modifyTime
		FROM JMJobDataStats jds, @mirrorCopyIds c, #tblSelectedJobs tjobs
		WHERE tjobs.jobId = jds.jobId  AND jds.commCellId = tjobs.commCellId AND jds.archGrpCopyId = c.copyId
		SET @retVal = @@ERROR
		INSERT INTO JMJobDataStats
			SELECT  DISTINCT jds.jobId, jds.archGrpId, c.copyId, jds.dataType, 13, 0, 101, 0, jds.appId, jds.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
			FROM   JMJobDataStats jds, APP_Application A WITH (READUNCOMMITTED), #tblSelectedJobs tjobs,@mirrorCopyIds c
			WHERE  jds.jobId = tjobs.jobId AND jds.archGrpCopyId = tjobs.copyID AND jds.commCellId = tjobs.commcellId
					AND jds.dataType = tjobs.dataType
					AND NOT EXISTS (SELECT 1 FROM JMJobDataStats dest WHERE dest.jobID = tjobs.jobId AND dest.dataType = tjobs.dataType AND dest.archGrpCopyId = c.CopyId)
					AND jds.appId = A.id
AND (@SkipTransactionalLogs = 0 OR jds.dataType != 4 OR A.appTypeId != 81)
		SET @retVal = @@ERROR
   END
   --Apply job retention option (if applicable)
	 EXEC archPinJobsBasedOnJobOption 0
   SELECT @retVal
   RETURN @retVal;
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
GO

IF EXISTS (select * from GxQscripts where name = 'addJobDataStatsForAuxCopy')
	delete from GxQscripts where name = 'addJobDataStatsForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addJobDataStatsForAuxCopy')
	delete from GXDBVersions where aliasname = 'addJobDataStatsForAuxCopy'
GO

insert into GXDBVersions values(2, 'addJobDataStatsForAuxCopy',  '00010035001200110000', 'addJobDataStatsForAuxCopy', '00010035001200110000')
GO

