

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/addClientProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : addClientProperties.sp
--
--  Description : This SP is to add storage policy of default subclient in client properties
--                This will be used for NTT Communications.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/addClientProperties.sp,v $ $Id: addClientProperties.sp,v 1.1.2.2 2020/12/24 07:27:09 lviswambharan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='addClientProperties')
BEGIN
	print '>>> Drop Stored Procedure: addClientProperties <<<'
	drop procedure addClientProperties
END
IF EXISTS (select * from GxQscripts where name='addClientProperties')
	delete from GxQscripts where name = 'addClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addClientProperties')
	delete from GXDBVersions where aliasname = 'addClientProperties'
GO
print '... Creating Procedure: addClientProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure addClientProperties
  @i_xmlText XML,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#clientProperties') IS NOT null DROP TABLE #clientProperties
	CREATE TABLE #clientProperties
	(
		clientId INT,
		storagePolicyId INT,
		storagePolicyName NVARCHAR(288)
	)
	CREATE CLUSTERED INDEX clientProperties_clientId_idx ON #clientProperties(clientId)
	--insert input values : clientIds
	INSERT  INTO #clientProperties (clientId)
	SELECT  ref.value('@clientId', 'int') AS clientId
	FROM    @i_xmlText.nodes('App_GetClientPropertiesRequest/association/entity') R ( ref )
	-- add storage policy details
	 UPDATE #clientProperties SET  storagePolicyId = ag.id, storagePolicyName = ag.name
		 FROM #clientProperties clients
         INNER JOIN APP_Application subclient WITH(NOLOCK) ON subclient.clientId = clients.clientId
         INNER JOIN APP_BackupSetName BkpSet WITH(NOLOCK) ON subclient.backupSet = BkpSet.id
         INNER JOIN archgroup ag WITH(NOLOCK) ON subclient.dataArchGrpID = ag.id
         INNER JOIN APP_AppTypeGroupAssoc ATGA ON subclient.appTypeId = ATGA.appTypeId
         WHERE ATGA.appGroupId = 35 -- APPGRP_FileSystemIDA
         AND (subclient.dataArchGrpID > 1) -- 1 is for storagePolicy CV_DEFAULT
AND ((subclient.subclientStatus & 0x00008) = 0x00008) AND ((BkpSet.STATUS & 0x00008) = 0x00008)
	--form output xml
	SET @o_xmlText = ISNULL((SELECT
							(SELECT(SELECT clients.clientId AS '@clientId' FOR XML PATH('clientEntity'), TYPE) FOR XML PATH('client'), TYPE),
							(SELECT(SELECT clients.storagePolicyId AS '@storagePolicyId' , clients.storagePolicyName AS '@storagePolicyName' FOR XML PATH('dataBackupStoragePolicy'), TYPE) FOR XML PATH('clientProps'), TYPE)
							from #clientProperties AS clients
							FOR XML PATH('clientProperties'), ROOT('App_GetClientPropertiesResponse'), TYPE),
						 '<App_GetClientPropertiesResponse/>')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_xmlText = '<App_GetClientPropertiesResponse/>'
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'addClientProperties')
	delete from GxQscripts where name = 'addClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='addClientProperties')
	delete from GXDBVersions where aliasname = 'addClientProperties'
GO

insert into GXDBVersions values(2, 'addClientProperties',  '00010001000200020000', 'addClientProperties', '00010001000200020000')
GO

