

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WebReportsTagOperations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =============================================
-- Author:		Vibhor Mishra
-- Create date: 06/14/2013
-- Description:	Get the register commcell ids for given user
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='WebReportsTagOperations')
BEGIN
	print '>>> Drop Stored Procedure: WebReportsTagOperations <<<'
	drop procedure WebReportsTagOperations
END
IF EXISTS (select * from GxQscripts where name='WebReportsTagOperations')
	delete from GxQscripts where name = 'WebReportsTagOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WebReportsTagOperations')
	delete from GXDBVersions where aliasname = 'WebReportsTagOperations'
GO
print '... Creating Procedure: WebReportsTagOperations'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure WebReportsTagOperations
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @req XML,
  @locale varchar(255) = 'default'
AS
  DECLARE @response xml
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/*
Message  Tag
{
		int		id		-- tag Id
		string	name	-- tag name
}
Message  ReportEdit
{
        int			id				-- report Id
		string		type			-- report type
		int			publishToAll
		list<Tag>	tagList
}
Message TagViewEditReq
{
      int			userId
	  Tag			tag
	  ReportEdit	reportEdit
	  int			entityType
}
Message TagViewEditResp
{
	  int		tagId
	  string	tagName
	  int		reportId
	  string	reportType
}
*/
DECLARE @o_errorString varchar(511) = 'Success'
DECLARE @userId INT =ISNULL((select T.n.value('@userId','int')
				from @req.nodes('WebReport_TagViewEditReq') T(n) ),-1)
DECLARE @entityType INT = ISNULL((select T.n.value('@entityType','int')
				from @req.nodes('WebReport_TagViewEditReq') T(n) ),0)
DECLARE @containerName varchar(255)
IF @entityType =  83
	SET @containerName = 'Workflow Tag'
ELSE
	SET @containerName = 'WebReports Tag'
IF EXISTS(SELECT 1 FROM UMUsers (NOLOCK) WHERE id = @userId)
BEGIN
DECLARE @userName varchar(255) = (Select login from UMUsers (NOLOCK) where id = @userId)
DECLARE @containerGUID VARCHAR(36) = ISNULL((SELECT TOP(1) containerGuid FROM DM2Container WHERE containerName=@containerName), '')
DECLARE @dummyUserID INT = -30
DECLARE @webReportsTagAttribute INT = 5
DECLARE @tagEntityType	INT = 9504	-- TAG_ENTITY in EntityTypes.h
IF OBJECT_ID('tempdb.dbo.#WebReportsTagOperations_userObject') IS NOT null
		DROP TABLE #WebReportsTagOperations_userObject
create table  #WebReportsTagOperations_userObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 2018, 0, '#WebReportsTagOperations_userObject'
DECLARE @hasAdminRights INT = (SELECT CASE
										WHEN EXISTS(SELECT * FROM #WebReportsTagOperations_userObject U
													WHERE
													 (U.capabilities & 16384 = 16384)
													AND (
U.commCellId=2 AND U.clientGroupId=0 AND U.clientId=0 AND U.appTypeId=0 AND U.instanceId=0 AND U.backupsetId=0 AND U.subClientId=0 AND U.mediaAgentId=0 AND U.libraryId=0 AND U.archGroupId=0 AND U.vtContainerId=0 AND U.vtPolicyId=0 AND U.vtShelfId=0 AND U.reviewSetId=0 AND U.querySetId=0 AND U.downloadSetId=0 AND U.ermId=0 AND U.legalHoldId=0 AND U.tagId=0 AND U.cdPolicyId=0 AND U.complianceReportId=0 AND U.taskId=0 AND U.workflowId=0 AND U.logMonitoringPolicyId=0 AND U.arrayId=0 AND U.cloudId=0 AND U.userGroupId=0 AND U.providerId=0 AND U.entityId1=0 AND U.entityId2=0 AND U.entityId3=0 AND U.entityId4=0 AND U.entityId5=0									AND U.entityId6=0 AND U.entityId7=0 AND U.entityId8=0 AND U.entityId9=0
														)
													)
									THEN 1
								ELSE 0 END)
IF OBJECT_ID('tempdb..#UserTagInfo') IS NOT NULL
	DROP TABLE #UserTagInfo
IF OBJECT_ID('tempdb..#GlobalTagsInfo') IS NOT NULL
	DROP TABLE #GlobalTagsInfo
IF OBJECT_ID('tempdb.dbo.#WebReportsTagOperations_userObject') IS NOT null
		DROP TABLE #WebReportsTagOperations_userObject
CREATE TABLE #UserTagInfo (
		TagId INT,
		TagName nvarchar(255),
		reportId int,
		reportType nvarchar(255)
		)
IF NOT EXISTS(SELECT * FROM UserToTagXML WHERE userId = @dummyUserID AND entityType = @entityType)
	INSERT INTO UserToTagXML(userId, TagXML, entityType) VALUES(@dummyUserID, NULL, @entityType)
SELECT
	A.TagId,
	D.TagDesc AS TagName,
	R.n.value('@id','int') reportId,
	R.n.value('@type','nvarchar(65)') reportType,
	R.n.value('@lastmodifiedby','nvarchar(max)') lastModifiedBy,
	D.CreatedBy
INTO #GlobalTagsInfo
FROM
(
SELECT T.n.value('@id','int') TagId,
		T.n.query('./report') reportInfo
	FROM UserToTagXML U
				CROSS APPLY  U.TagXML.nodes('rootTag/tag') T(n)
				WHERE userId = @dummyUserID AND entityType = @entityType) A
CROSS APPLY A.reportInfo.nodes('report') R(n)
INNER JOIN DM2DocTags D ON A.TagId=D.id AND containerGuid = @containerGUID
INSERT INTO #UserTagInfo(TagId,TagName,reportId,reportType)
SELECT TagId,TagName,reportId,reportType FROM #GlobalTagsInfo
--Delete unused/unreferenced Global tags
IF object_id('tempdb.dbo.#IdsToDelete') is not null DROP TABLE #IdsToDelete
CREATE TABLE #IdsToDelete (id INT)
INSERT INTO #IdsToDelete
	SELECT id from DM2DocTags D LEFT OUTER JOIN #GlobalTagsInfo T ON D.id = T.TagId where ownerUserId = @dummyUserID AND T.TagId IS NULL AND containerGuid = @containerGUID
DELETE D FROM DM2DocTags D
	INNER JOIN #IdsToDelete i ON i.id = d.id
DROP TABLE #IdsToDelete
DECLARE @userDifferenceXMLTbl table (tagId int, tagname nvarchar(255), reportId int, reportType nvarchar(255),deleted int)
IF NOT EXISTS(select * from UserToTagXML where userid = @userId AND entityType = @entityType)
	INSERT INTO UserToTagXML(userId, TagXML, entityType) values(@userId,NULL,@entityType)				-- First time login to webconsole
ELSE IF (select tagXML from UserToTagXML where userid = @userId AND entityType = @entityType) IS NOT NULL
BEGIN
	INSERT INTO @userDifferenceXMLTbl
	select T.n.value('@tagId','int'),
			D.TagDesc,
			T.n.value('@reportId','int'),
			T.n.value('@reportType','varchar(255)'),
			T.n.value('@deleted','int')
	from UserToTagXML U
				CROSS APPLY U.tagXML.nodes('reportInfo') T(n)
				INNER JOIN DM2DocTags D ON T.n.value('@tagId','int') = D.id AND containerGuid = @containerGUID
	where U.userid = @userId AND entityType = @entityType
	DELETE T
	From #UserTagInfo T INNER JOIN @userDifferenceXMLTbl X ON T.TagId=X.tagId AND T.reportId = X.reportId AND T.reportType = X.reportType AND X.deleted = 1
	INSERT INTO #UserTagInfo(TagId,tagname,reportId,reportType)
	SELECT distinct TagId,tagname,reportId,reportType from @userDifferenceXMLTbl where deleted <> 1
END
IF @req IS NOT NULL
BEGIN
	--INSERT INTO TagLogs(userid , reqXML , userXML , globalXML, created )
	--values(@userId,@req,(select  tagXML from UserToTagXML where userid=@userId AND entityType = @entityType),(select  tagXML from UserToTagXML where userid=@dummyUserID AND entityType = @entityType), dbo.getunixtimebig(GETUTCDATE()))
	DECLARE @differenceXML XML
	DECLARE @opMsgId INT
	DECLARE @opEvMsgId INT
	DECLARE @opId INT
	DECLARE @dataIsEvent INT
	DECLARE @paramMsgId INT
	BEGIN TRY
		--Edit operation
		IF @req.exist('WebReport_TagViewEditReq/reportEdit') = 1
		BEGIN
			DECLARE @tagListFromReq table (tagId int, tagname nvarchar(255))
			DECLARE @reportId INT = 0
			DECLARE @reportName nvarchar(MAX) = N''
			DECLARE @reportType varchar(30) = ''
			DECLARE @publishToAll int = 0
			DECLARE @createdTime INT = 0
			DECLARE @flags INT = 0
			SELECT @reportId = T.n.value('@id','int'),
				   @reportType = T.n.value('@type','varchar(24)'),
				   @reportName = ISNULL(T.n.value('@reportName','nvarchar(MAX)'),''),
				   @publishToAll = 	T.n.value('@publishToAll','int'),
				   @flags = ISNULL(T.n.value('@flags','int'),0)
				FROM @req.nodes('WebReport_TagViewEditReq/reportEdit') T(n)
			INSERT INTO @tagListFromReq
			SELECT
				R.n.value('@tagId','int') AS 'TagId',
				R.n.value('@tagName','nvarchar(255)') AS 'TagName'
			FROM
			@req.nodes('WebReport_TagViewEditReq/reportEdit/tagList') R(n)
			-- Setting proper tagId's in @tagListFromReq table so that XMLs in UserToTagXML table can be modifed accordingly
			IF @publishToAll = 1
			BEGIN
				UPDATE R set tagId = D.id
				FROM @tagListFromReq R
					inner join DM2DocTags D
					ON D.ownerUserId= @dummyUserID AND D.TagDesc= R.tagname AND containerGuid = @containerGUID AND ((@flags = 1 AND CreatedBy = 'Default') OR @flags = 0)--AND R.tagId=-1
				SET @createdTime = dbo.getunixtimebig(GETUTCDATE())
				INSERT INTO DM2DocTags(ownerUserId,TagValue,Attribute,TagDesc,CreatedBy,TagId,containerGuid)
				SELECT @dummyUserID,
						NEWID(),
						@createdTime ,
						tagname,
						CASE @flags WHEN 1 THEN 'Default' ELSE @userName END,
						NEWID(),
						@containerGUID
						from @tagListFromReq R INNER JOIN DM2DocTags D ON R.tagId = D.id WHERE D.ownerUserId <> @dummyUserID AND containerGuid = @containerGUID
				UPDATE R set tagId = D.id FROM @tagListFromReq R inner join DM2DocTags D
											ON D.ownerUserId=@dummyUserID
											AND D.TagDesc= R.tagname  AND D.Attribute = @createdTime AND containerGuid = @containerGUID
				UPDATE DM2DocTags SET TagValue = CAST(id AS VARCHAR(5)), Attribute = @webReportsTagAttribute
				WHERE Attribute = @createdTime AND ownerUserId = @dummyUserID AND containerGuid = @containerGUID
			END
			ELSE
			BEGIN
				UPDATE R set tagId = D.id
				FROM @tagListFromReq R
					inner join DM2DocTags D
					ON D.ownerUserId=@userId AND D.TagDesc= R.tagname AND R.tagId=-1 AND containerGuid = @containerGUID
			END
			--Inserting rows for new tags added by user
			IF EXISTS(SELECT * from @tagListFromReq where tagid = -1)
			BEGIN
				SET @createdTime = dbo.getunixtimebig(GETUTCDATE())
				INSERT INTO DM2DocTags(ownerUserId,TagValue,Attribute,TagDesc,CreatedBy,TagId,containerGuid)
				SELECT (CASE @publishToAll WHEN 1 THEN @dummyUserID ELSE @userId END),
						NEWID(),
						@createdTime ,
						tagname,
						CASE @publishToAll & @flags WHEN 1 THEN 'Default' ELSE @userName END,	-- 'Default' only valid for @publishToAll = 1 case
						NEWID(),
						@containerGUID
						from @tagListFromReq where tagid = -1
				UPDATE R set tagId = D.id FROM @tagListFromReq R inner join DM2DocTags D
											ON D.ownerUserId=(CASE @publishToAll WHEN 1 THEN @dummyUserID ELSE @userId END)
											AND D.TagDesc= R.tagname AND R.tagId=-1 AND D.Attribute = @createdTime AND containerGuid = @containerGUID
				UPDATE DM2DocTags SET TagValue = CAST(id AS VARCHAR(5)), Attribute = @webReportsTagAttribute
				WHERE Attribute = @createdTime AND ownerUserId = (CASE @publishToAll WHEN 1 THEN @dummyUserID ELSE @userId END) AND containerGuid = @containerGUID
			END
			-- Updating XML in UserToTagXML table corresponding to user Id : -30 as user has published these changes to all
			--check if tags exists prior to deletion
			DECLARE @tagsExisted INT =0
			IF EXISTS  (SELECT *  from #GlobalTagsInfo where reportId = @reportId)
				BEGIN
					SET @tagsExisted = 1
				END
			IF @publishToAll = 1
			BEGIN
				DECLARE @lastModifiedBy varchar(max) = (select top 1 lastModifiedBy from #GlobalTagsInfo where reportId = @reportId	and reportType = @reportType)
				SET @lastModifiedBy=ISNULL(@lastModifiedBy+ ','+cast(@userId AS varchar(3)),cast(@userId AS varchar(3)))
				DELETE FROM #GlobalTagsInfo where reportId = @reportId	and reportType = @reportType AND ((@flags = 1 AND CreatedBy = 'Default') OR @flags = 0)
				INSERT INTO #GlobalTagsInfo(TagId,TagName,reportId,reportType,lastModifiedBy, CreatedBy)
				SELECT R.tagId,R.tagname,@reportId,@reportType,@lastModifiedBy, CASE @flags WHEN 1 THEN 'Default' ELSE @userName END
					from @tagListFromReq R
						INNER JOIN DM2DocTags D
							ON R.tagId = D.id AND ((@flags = 1 AND CreatedBy = 'Default') OR @flags = 0)
				SET @differenceXML = (
					SELECT T.TagId AS '@id',
					(SELECT distinct  reportId AS '@id',
							 reportType AS '@type',
							 lastModifiedBy AS '@lastmodifiedby'
						FROM #GlobalTagsInfo G WHERE  G.TagId=T.TagId
						FOR XML PATH('report'), type
						)
				   FROM (select TagId from #GlobalTagsInfo group by TagId) T
				   FOR XML path ('tag'), type, root('rootTag')
				)
				UPDATE UserToTagXML SET tagXML = @differenceXML WHERE userid = @dummyUserID AND entityType = @entityType
			END
			-- These 2 below operations are for edits on #UserTagInfo which will be used to form difference XML to be updated in UserToTagXML
			DELETE FROM U
			FROM #UserTagInfo U
				INNER JOIN DM2DocTags D
					ON U.tagId = D.id AND ((@flags = 1 AND CreatedBy = 'Default') OR @flags = 0)
				WHERE reportId = @reportId and reportType = @reportType
			INSERT INTO #UserTagInfo(TagId,tagname,reportId,reportType)
			SELECT distinct R.tagId,tagname,@reportId,@reportType
				FROM @tagListFromReq R
					INNER JOIN DM2DocTags D
						ON R.tagId = D.id AND ((@flags = 1 AND CreatedBy = 'Default') OR @flags = 0)
			---------------------------------
			--CREATE GUI AUDIT TRAIL ENTRIES
			---------------------------------
			DECLARE @tagList NVARCHAR(MAX) = ISNULL(STUFF((SELECT ', '+tagname FROM @tagListFromReq FOR XML PATH('')),1,1,''),'')
SET @opMsgId = (434 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			--if no tags existed before and we are not adding any new tags now, there is no need to create an audit entry
			--in all other cases (adding, updating, deleting tags), create an audit entry
			IF (@tagsExisted <> 0 OR @tagList <> '')
				BEGIN
				EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 13, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
				END
			SET @dataIsEvent = 0
			IF @publishToAll = 1
SET @paramMsgId = CASE WHEN @tagList = '' THEN (1148 | (CAST(POWER(2, 24) AS BIGINT) * 85))		-- GuiAuditParamsLocale.tab
ELSE (1146 | (CAST(POWER(2, 24) AS BIGINT) * 85)) END
			ELSE
SET @paramMsgId = CASE WHEN @tagList = '' THEN (1149 | (CAST(POWER(2, 24) AS BIGINT) * 85))
ELSE (1147 | (CAST(POWER(2, 24) AS BIGINT) * 85)) END
			EXEC EvGuiAuditSetParamData @opId, @userName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @reportName, @dataIsEvent
			IF @tagList <> ''
				EXEC EvGuiAuditSetParamData @opId, @tagList, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			-----------------------------------------------------------------------------------------------------------------------------
			-----------------------------------------------------------------------------------------------------------------------------
		END
		ELSE IF @req.exist('WebReport_TagViewEditReq/tag') = 1				-- Tag renaming request
		BEGIN
			--DECLARE @renameTagReq XML = '<WebReport_TagViewEditReq userId="1"><tag tagId="2" tagName="Job"></tag></WebReport_TagViewEditReq>'
			DECLARE @tagId INT = 0,
					@newTagName nvarchar(255) = '',
					@oldTagName nvarchar(255) = ''
			SELECT @tagId = R.n.value('@tagId','int'),
				   @newTagName = R.n.value('@tagName','nvarchar(255)')
				   FROM @req.nodes('WebReport_TagViewEditReq/tag') R(n)
			SELECT @oldTagName = TagDesc  FROM DM2DocTags WHERE id = @tagId
			---------------------------------
			--CREATE GUI AUDIT TRAIL ENTRIES
			---------------------------------
SET @opMsgId = (434 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 13, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
			SET @dataIsEvent = 0
			IF @hasAdminRights = 1 AND EXISTS(SELECT * FROM DM2DocTags WHERE tagdesc = @oldTagName AND ownerUserId = @dummyUserId AND containerGuid = @containerGUID)
SET @paramMsgId = (1150 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			ELSE IF NOT EXISTS(SELECT * FROM DM2DocTags WHERE tagdesc = @oldTagName AND ownerUserId = @dummyUserId AND containerGuid = @containerGUID)
SET @paramMsgId = (1151 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			ELSE
SET @paramMsgId = (1152 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @userName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @oldTagName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @newTagName, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			-----------------------------------------------------------------------------------------------------------------------------
			-----------------------------------------------------------------------------------------------------------------------------
			IF (@hasAdminRights = 1)
			BEGIN
				-- This handles case where Admin edits a tag name which is present globally and also, a tag with same name presents locally to his user
				UPDATE DM2DocTags set TagDesc = @newTagName where ownerUserId IN (@userId,@dummyUserID) and tagDesc = @oldTagName AND containerGuid = @containerGUID
				UPDATE G SET TagName=D.tagDesc FROM #GlobalTagsInfo G INNER JOIN DM2DocTags D ON G.TagId = D.id AND containerGuid = @containerGUID
			END
			ELSE
			BEGIN
				-- This is for handling renaming for non-admin users
				--In case the tag renamed is private to that particular user, simply update the new tag name
				IF EXISTS(select * from DM2DocTags where ownerUserId = @userId and id = @tagId AND containerGuid = @containerGUID)
				BEGIN
					UPDATE DM2DocTags set TagDesc = @newTagName where ownerUserId = @userId and id = @tagId AND containerGuid = @containerGUID
					UPDATE U set U.TagName = D.tagDesc FROM #UserTagInfo U INNER JOIN DM2DocTags D ON D.id = U.tagId AND containerGuid = @containerGUID
				END
				ELSE
				BEGIN
					-- If user(non-admin) edits a tag which is global to all users, then a tag with the new name is created private to that user.
					SET @createdTime = dbo.getunixtimebig(GETUTCDATE())
					INSERT INTO DM2DocTags(ownerUserId,TagValue,Attribute,TagDesc,CreatedBy,TagId,containerGuid)
					SELECT @userId,NEWID(),@createdTime,@newTagName,@userName,NEWID(),@containerGUID
					-- Fetch tag id corresponding to new added tag
					DECLARE @newTagId INT = (select id from DM2DocTags where ownerUserId = @userId AND Attribute = @createdTime AND TagDesc = @newTagName AND containerGuid = @containerGUID)
					UPDATE DM2DocTags SET TagValue = CAST(id AS VARCHAR(5)), Attribute = @webReportsTagAttribute
					WHERE Attribute = @createdTime AND ownerUserId = @userId AND containerGuid = @containerGUID
					IF @containerName = 'WebReports Tag'
					BEGIN
						-- Remove custom reports that are not visible to the user.
						DECLARE @customReportsList table(id int)
						IF object_id('tempdb.dbo.#APPReportsListing_Objects') is not null DROP TABLE #APPReportsListing_Objects
						CREATE TABLE #APPReportsListing_Objects (reportId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 131, 132, '#APPReportsListing_Objects'
						INSERT INTO @customReportsList(id)
						SELECT r.reportId
							FROM APP_Reports r
								WHERE r.[type] = 0 AND r.flags & 1 = 0 AND
									(r.reportId IN (SELECT reportId FROM #APPReportsListing_Objects) OR r.flags & 2 > 0) --reports only visible to user
						DELETE U FROM #UserTagInfo U LEFT OUTER JOIN @customReportsList C ON U.reportId = C.id WHERE C.id IS NULL AND U.reportType = 'custom'
					END
					-- Update old tag id's to new ones.
					UPDATE #UserTagInfo set TagId = @newTagId where TagId = @tagId
				END
			END
		END
		IF @req.exist('WebReport_TagViewEditReq/reportEdit') = 1 OR (@req.exist('WebReport_TagViewEditReq/tag') = 1 AND NOT exists(select * from DM2DocTags where ownerUserId = @userId and id = @tagId AND containerGuid = @containerGUID))
		BEGIN
			-- As of now, we have updated/modified the #UserTagInfo table corresponding the opertion req
			-- Below query computes the difference of #UserTagInfo and #GlobalTagsInfo and stores the difference in the UserToTagXML table corresponding to that userId.
			SET @differenceXML = (
					SELECT ISNULL(B.TagId,T.TagId) '@tagId',
							ISNULL(B.reportId,T.reportId) '@reportId',
							ISNULL(B.reportType,T.reportType) '@reportType',
							CASE WHEN T.TagId IS NULL THEN 1 ELSE 0 END '@deleted'
					FROM #GlobalTagsInfo B
					FULL OUTER JOIN #UserTagInfo T
					ON B.TagId=T.TagId AND B.reportId = T.reportId AND B.reportType = T.reportType
					LEFT JOIN DM2DocTags D ON ISNULL(B.TagId,T.TagId)=D.id
					WHERE B.TagId IS NULL or T.TagId IS NULL
					FOR XML PATH('reportInfo') )
				UPDATE UserToTagXML SET tagXML = @differenceXML WHERE userid = @userId AND entityType = @entityType
		END
		-- Delete all user associated tags(non-global) which are not referred in #UserTagInfo table
		DELETE D FROM DM2DocTags D
					LEFT OUTER JOIN #UserTagInfo T
						ON D.id = T.TagId
					LEFT OUTER JOIN #GlobalTagsInfo G
						ON D.id = G.TagId
					WHERE D.ownerUserId = @userId AND T.TagId IS NULL AND G.TagId IS NULL AND D.containerGuid = @containerGUID
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorString = 'Error ' + CONVERT(varchar(50), ERROR_NUMBER()) +
          ', Severity ' + CONVERT(varchar(5), ERROR_SEVERITY()) +
          ', State ' + CONVERT(varchar(5), ERROR_STATE()) +
          ', Procedure ' + ISNULL(ERROR_PROCEDURE(), '-') +
          ', Line ' + CONVERT(varchar(5), ERROR_LINE()) + ' Message ' + ERROR_MESSAGE();
	END CATCH
	SET @response = (select @o_errorString AS '@errorString'
						FOR XML PATH ('WebReport_TagViewEditResp') )
END
-- Computes response to eb sent to GUI. There could be possiblity that two tagId's can have same tag name. We have show reports under each of them in same tag.
--So, groups reports with same tag name and assign tagid's in following way:
--	1) Give priority to usertag. If user has that tag created, assign that tag id to that common tag name.
--	2) If somehow, that tag dooesn't belong to user, assign tagId corresponding to -30(dummyuserid) owneruserId for that common tag. (just to be cautious so that we don't return null tagId.)
SET @response =
	(SELECT @o_errorString AS '@errorString',
		(SELECT A.[@tagId], ISNULL(AT.localeValue, A.[@tagName]) AS '@tagName', A.[@reportId], A.[@reportType],A.[@tagName] AS '@tagKeyName' FROM
			(SELECT DISTINCT CASE
							WHEN I.TagName IS NOT NULL
							THEN ISNULL((SELECT TOP 1 id from DM2DocTags WHERE ownerUserId = @userId and TagDesc = I.TagName ORDER BY id),(SELECT TOP 1 id FROM DM2DocTags where ownerUserId = @dummyUserID and TagDesc = I.TagName ORDER BY id))
					ELSE T.TagId END AS '@tagId',
					D.TagDesc AS '@tagName',
					T.reportId AS '@reportId',
					T.reportType AS '@reportType'
				 FROM  #UserTagInfo T
				 LEFT OUTER JOIN (SELECT  TagName FROM (SELECT TagName,TagId FROM #UserTagInfo GROUP BY TagName,TagId) A GROUP BY TagName HAVING COUNT(*)>1 ) I
					ON T.TagName = I.TagName
				 LEFT OUTER join DM2DocTags D ON D.id = T.TagId
			  UNION
				SELECT DISTINCT G.tagId AS '@tagId',
				   G.tagname AS '@tagName',
				   -1 AS '@reportId',
				   '' AS '@reportType'
				 FROM #GlobalTagsInfo G
				 LEFT OUTER JOIN (SELECT D.id AS tagId,D.TagDesc AS tagName FROM #UserTagInfo T INNER JOIN DM2DocTags D ON D.id = T.TagId ) Sub
					ON G.tagName = Sub.tagName WHERE Sub.tagId IS NULL
			) A
			LEFT OUTER JOIN App_Translations AT
				ON AT.entityType = @tagEntityType AND AT.entityId = 0 AND A.[@tagName] = AT.localeKey AND AT.locale = @locale
where (A.[@reportType] <> 'workflow' AND @entityType <> 83) OR (A.[@reportType] = 'workflow' AND @entityType = 83) -- Workflow response is not in use.
			FOR XML PATH('tagInfoList'), type
		)
FOR XML PATH ('WebReport_TagViewEditResp')	)
DROP TABLE #UserTagInfo
DROP TABLE #GlobalTagsInfo
END
ELSE
BEGIN
SET @o_errorString = 'Invalid user Id.'
SET @response =
	(SELECT @o_errorString AS '@errorString' FOR XML PATH ('WebReport_TagViewEditResp')	)
END
SELECT @response AS response
GO

IF EXISTS (select * from GxQscripts where name = 'WebReportsTagOperations')
	delete from GxQscripts where name = 'WebReportsTagOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WebReportsTagOperations')
	delete from GXDBVersions where aliasname = 'WebReportsTagOperations'
GO

insert into GXDBVersions values(2, 'WebReportsTagOperations',  '00000000000000000000', 'WebReportsTagOperations', '00000000000000000000')
GO

