

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WR_StorageSummary.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WR_StorageSummary.sp,v $ $Id: WR_StorageSummary.sp,v 1.48.34.2 2018/03/20 00:35:39 jiechen Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Jun Lu
-- Create date: 09/11/2010
-- Description:	generates Storage Summary report
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WR_StorageSummary <<<'

IF EXISTS (select * from sysobjects where name='WR_StorageSummary')
	drop procedure WR_StorageSummary
IF EXISTS (select * from GxQscripts where name='WR_StorageSummary')
	delete from GxQscripts where name = 'WR_StorageSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WR_StorageSummary')
	delete from GXDBVersions where aliasname = 'WR_StorageSummary'
GO
print '... Creating Procedure: WR_StorageSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WR_StorageSummary
  @i_req XML,
  @i_userId INT
AS
  DECLARE @o_StorageSummary NVARCHAR(MAX);
SET NOCOUNT ON
DECLARE	@i_reqModeFlags				INT
DECLARE	@i_storageType				INT
DECLARE	@i_mediaOrderBy				INT
DECLARE	@i_mediaStatusFlags			INT
DECLARE	@i_mediaGroupTypeFlags		INT
DECLARE	@i_bothStatusAndGroupType	INT
DECLARE	@i_mediaStateOption			INT
DECLARE	@i_mediaFilterFlags			INT
DECLARE	@i_mediaExportedOption		INT
DECLARE	@i_includeAllLibraries		INT
DECLARE	@i_libraryFilter			NVARCHAR(MAX)
DECLARE	@i_includeAllLocations		INT
DECLARE	@i_locationFilter			NVARCHAR(MAX)
DECLARE	@i_includeAllPolicies		INT
DECLARE	@i_includeAllCopies			INT
DECLARE	@i_copyTypeOption			INT
DECLARE	@i_copyFilter				NVARCHAR(MAX)
DECLARE	@i_timeRangeType			INT
DECLARE	@i_startTime				INT
DECLARE	@i_endTime					INT
DECLARE	@i_localeId					INT
DECLARE @i_mediaPageSize			INT
DECLARE @i_mediaPageNo				INT
DECLARE @i_mediaSortColumnNo		INT
DECLARE @i_mediaSortOrder			INT
DECLARE	@i_columnFilter				NVARCHAR(MAX)
SET @i_reqModeFlags					= @i_req.value('/WebReport_StorageReportReq[1]/@reqModeFlags', 'int')
SET @i_storageType					= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@storageType', 'int'), 0)
SET @i_mediaOrderBy					= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaOrderBy', 'int'), 0)
SET @i_mediaStatusFlags				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusFlags', 'int'), 0)
SET @i_mediaGroupTypeFlags			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupTypeFlags', 'int'), 0)
SET @i_bothStatusAndGroupType		= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@bothStatusAndGroupType', 'int'), 0)
SET @i_mediaStateOption				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStateOption', 'int'), 0)
SET @i_mediaFilterFlags				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaFilterFlags', 'int'), 0)
SET @i_mediaExportedOption			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaExportedOption', 'int'), 0)
SET @i_includeAllLibraries			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/libraryFilter[1]/@includeAll', 'int'), 1)
SET @i_libraryFilter				= CAST(@i_req.query('/WebReport_StorageReportReq[1]/libraryFilter[1]') AS NVARCHAR(MAX))
SET @i_includeAllLocations			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/locationFilter[1]/@includeAll', 'int'), 1)
SET @i_locationFilter				= CAST(@i_req.query('/WebReport_StorageReportReq[1]/locationFilter[1]') AS NVARCHAR(MAX))
SET @i_includeAllPolicies			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/spCopyFilter[1]/@includeAll', 'int'), 1)
SET @i_copyTypeOption				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/spCopyFilter[1]/@copyType', 'int'), 1)
SET @i_copyFilter					= CAST(@i_req.query('/WebReport_StorageReportReq[1]/spCopyFilter[1]') AS NVARCHAR(MAX))
SET @i_timeRangeType				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@timeRangeType', 'int'), 0)
SET @i_startTime					= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@startTime', 'int'), 0)
SET @i_endTime						= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@endTime', 'int'), 0)
SET @i_localeId						= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/localeId[1]/@localeId', 'int'), 0)
SET @i_mediaPageSize				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@pageSize', 'int'), 20)
SET @i_mediaPageNo					= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@pageNo', 'int'), 1)
SET @i_mediaSortColumnNo			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaSortColumnNo', 'int'), 1)
SET @i_mediaSortOrder				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaSortOrder', 'int'), 0)
SET @i_columnFilter					= CAST(@i_req.query('/WebReport_StorageReportReq[1]') AS NVARCHAR(MAX))
DECLARE	@i_mediaStatusAll			BIT
DECLARE	@i_mediaStatusActive		BIT
DECLARE	@i_mediaStatusAppendable	BIT
DECLARE	@i_mediaStatusFull			BIT
DECLARE	@i_mediaStatusNew			BIT
DECLARE	@i_mediaStatusAged			BIT
DECLARE	@i_mediaStatusUndiscovered	BIT
DECLARE	@i_mediaGroupAll			BIT
DECLARE	@i_mediaGroupScratch		BIT
DECLARE	@i_mediaGroupRetired		BIT
DECLARE	@i_mediaGroupForeign		BIT
DECLARE	@i_mediaGroupCleaning		BIT
DECLARE	@i_mediaGroupOverwriteProtected	BIT
DECLARE	@i_mediaGroupCatalog		BIT
DECLARE	@i_filterNone				BIT
DECLARE	@i_filterWithErrorOnly		BIT
DECLARE	@i_filterPreventExport		BIT
DECLARE	@i_filterDeconfiguredClient	BIT
DECLARE	@i_filterExtendedRetention	BIT
DECLARE	@i_filterBasicRetention		BIT
SET @i_mediaStatusAll				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusAll', 'int'), 0)
SET @i_mediaStatusActive			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusActive', 'int'), 0)
SET @i_mediaStatusAppendable		= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusAppendable', 'int'), 0)
SET @i_mediaStatusFull				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusFull', 'int'), 0)
SET @i_mediaStatusNew				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusNew', 'int'), 0)
SET @i_mediaStatusAged				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusAged', 'int'), 0)
SET @i_mediaStatusUndiscovered		= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaStatusUndiscovered', 'int'), 0)
SET @i_mediaGroupAll				= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupAll', 'int'), 0)
SET @i_mediaGroupScratch			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupScratch', 'int'), 0)
SET @i_mediaGroupRetired			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupRetired', 'int'), 0)
SET @i_mediaGroupForeign			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupForeign', 'int'), 0)
SET @i_mediaGroupCleaning			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupCleaning', 'int'), 0)
SET @i_mediaGroupOverwriteProtected	= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupOverwriteProtected', 'int'), 0)
SET @i_mediaGroupCatalog			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@mediaGroupCatalog', 'int'), 0)
SET @i_filterNone					= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@filterNone', 'int'), 0)
SET @i_filterWithErrorOnly			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@filterWithErrorOnly', 'int'), 0)
SET @i_filterPreventExport			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@filterPreventExport', 'int'), 0)
SET @i_filterDeconfiguredClient		= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@filterDeconfiguredClient', 'int'), 0)
SET @i_filterExtendedRetention		= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@filterExtendedRetention', 'int'), 0)
SET @i_filterBasicRetention			= ISNULL(@i_req.value('/WebReport_StorageReportReq[1]/@filterBasicRetention', 'int'), 0)
IF	@i_includeAllPolicies = 1 AND @i_copyTypeOption = 0
	SET @i_includeAllCopies = 1
ELSE
	SET @i_includeAllCopies = 0
DECLARE	@l_mediaAll	INT = 1
IF	@i_mediaStatusAll = 0 OR @i_mediaGroupAll = 0 OR @i_filterNone = 0
 OR @i_mediaStateOption <> 0 OR @i_mediaExportedOption <> 0
 OR @i_includeAllLibraries = 0 OR @i_includeAllLocations = 0 OR @i_includeAllCopies = 0
 OR @i_timeRangeType <> 0
	SET	@l_mediaAll = 0
IF	@i_mediaStatusAll = 1
	SET @i_mediaStatusFlags	= 0
ELSE
	SET @i_mediaStatusFlags	= @i_mediaStatusActive * 1
							| @i_mediaStatusAppendable * 2
							| @i_mediaStatusFull * 4
							| @i_mediaStatusNew * 8
							| @i_mediaStatusAged * 16
							| @i_mediaStatusUndiscovered * 128
IF	@i_mediaGroupAll = 1
	SET @i_mediaGroupTypeFlags	= 0
ELSE
	SET @i_mediaGroupTypeFlags	= @i_mediaGroupScratch * 1
								| @i_mediaGroupRetired * 8
								| @i_mediaGroupForeign * 16
								| @i_mediaGroupCleaning * 32
								| @i_mediaGroupOverwriteProtected * 64
								| @i_mediaGroupCatalog * 128
IF	@i_filterNone = 1
	SET @i_mediaFilterFlags	= 0
ELSE
	SET @i_mediaFilterFlags	= @i_filterWithErrorOnly * 1
							| @i_filterPreventExport * 2
							| @i_filterDeconfiguredClient * 4
							| @i_filterExtendedRetention * 8
							| @i_filterBasicRetention * 16
DECLARE @filterHandle		INT
DECLARE @dateFormat			INT = 0
DECLARE @bias				INT
SET @bias = dbo.getUnixTime(GetDate()) - dbo.getUnixTime(GetUTCDate())
DECLARE @userPreferences xml = (SELECT value FROM UMUserWebPrefs WITH (NOLOCK) WHERE userId = @i_userId)
IF	@userPreferences IS NOT NULL
BEGIN
	IF	@i_mediaPageSize IS NULL
		SET @i_mediaPageSize = ISNULL(@userPreferences.value('/userPreferences[1]/general[1]/@rowsPerPage', 'int'), 20)
	SET @dateFormat = ISNULL(@userPreferences.value('/userPreferences[1]/general[1]/@dateFormat', 'int'), 1)
END
IF	@i_mediaPageNo < 1
	SET @i_mediaPageNo = 1
IF	@i_mediaPageSize IS NULL
	SET @i_mediaPageSize = 20
ELSE
IF	@i_mediaPageSize < 0
BEGIN
	SET @i_mediaPageSize = 0x7FFFFFFF
	SET @i_mediaPageNo = 1
END
DECLARE	@l_totalMedia INT = 0
DECLARE	@l_endTime	INT
IF	@i_endTime = 0
	SET @l_endTime = dbo.getUnixTime(GETUTCDATE())
ELSE
	SET @l_endTime = @i_endTime
CREATE	TABLE #tblSummary (
		storageType			INT,
		LibraryId			INT,
		MountPathId			INT,
		MountPathName		NVARCHAR(1024),
		CopyId				INT,
		NumberOfMedia		INT,
		DataOnMediaMB		BIGINT,
		FreeSpaceMB			BIGINT)
CREATE	TABLE #tblMedia (
		storageType			INT DEFAULT(3),
		MediaId				INT,
        Barcode				VARCHAR(256),
		Location			NVARCHAR(1024),
		LibraryId			INT,
        LibraryName			NVARCHAR(128) DEFAULT(''),
        LibraryOrigCCId		INT DEFAULT(0),
        MediaLocation		INT DEFAULT(0),
        ContainerId			INT DEFAULT(0),
        MediaTypeId			INT DEFAULT(0),
		MediaTypeName		VARCHAR(32) DEFAULT(''),
        MediaStatus			INT DEFAULT(0),
        MediaFlags			INT DEFAULT(0),
        MediaAttributes		INT DEFAULT(0),
		IsCleaningMedia		INT DEFAULT(0),
        IsAged				INT DEFAULT(0),
        IsInMediaGroup		INT DEFAULT(0),
        LastExportTime		INT DEFAULT(0),
		RetentionFlags		INT DEFAULT(0),
		RetentionExpireTime	INT DEFAULT(0),
		PinMediaExpireTime	INT DEFAULT(0),
		MountPathId			INT DEFAULT(0),
		MediaGroupId		INT DEFAULT(0),
		SpareGroupId		INT DEFAULT(0),
		SpareGroupType		INT DEFAULT(0),
		CopyId				INT DEFAULT(0),
		StorageGroup		NVARCHAR(1024) DEFAULT(''),
		ExportableTime		INT DEFAULT(0),
		VolumeFlags			INT DEFAULT(0),
		LastBackupTime		INT DEFAULT(0),
		LastRestoreTime		INT DEFAULT(0),
		MediaInfoFlags		INT DEFAULT(0),
		DataOnMediaMB		BIGINT DEFAULT(0),
		MediaStateName		NVARCHAR(1024) DEFAULT(''),
		MediaStatusName		NVARCHAR(1024) DEFAULT('N/A'),
		MediaGroupTypeName	NVARCHAR(1024) DEFAULT('N/A'),
		RetainedBy			NVARCHAR(1024) DEFAULT('N/A'),
		PreventExport		NVARCHAR(1024) DEFAULT('N/A'))
CREATE	TABLE #tblMediaSorted (
		MediaId				INT,
        Barcode				VARCHAR(256),
		MediaTypeId			INT,
		MediaTypeName		VARCHAR(32),
		LibraryName			NVARCHAR(128),
		StorageGroup		NVARCHAR(1024),
		Location			NVARCHAR(1024),
		RetainDataUntil		INT,
		RetainDataUntilStr	VARCHAR(128),
		ExportableTime		INT,
		ExportableTimeStr	VARCHAR(128),
		MediaStatus			INT,
		MediaGroupType		INT,
		MediaInfoFlags		INT,
		DataOnMediaMB		BIGINT,
		MediaStateName		NVARCHAR(1024),
		MediaStatusName		NVARCHAR(1024),
		MediaGroupTypeName	NVARCHAR(1024),
		RetainedBy			NVARCHAR(1024),
		PreventExport		NVARCHAR(1024))
DECLARE	@tblVolumeFlagsFilter	TABLE (VolumeFlags INT)
DECLARE	@tblLibraryFilter		TABLE (id INT, name NVARCHAR(128), type INT, storageType INT)
DECLARE	@tblLocationFilter		TABLE (id INT, name NVARCHAR(1024))
DECLARE @tblSPFilter			TABLE (policyId INT, policyName NVARCHAR(1024), primaryCopyId INT, primarySnapCopyId INT)
DECLARE	@tblCopyFilter			TABLE (policyId INT, policyName NVARCHAR(1024), copyId INT, copyName NVARCHAR(1024))
DECLARE	@tblUserVisibleLib		TABLE (id INT)
DECLARE	@tblUserVisibleSP		TABLE (id INT)
DECLARE	@tblColumnFilter		TABLE (columnName NVARCHAR(128), filterValue NVARCHAR(1024), filterCondition NVARCHAR(16))
DECLARE @userVisibleAll			INT = 1
IF	@i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	IF NOT EXISTS (SELECT * FROM #rptUserObjects WHERE libraryId = 0)
	BEGIN
		SET @userVisibleAll = 0
		INSERT	INTO @tblUserVisibleLib
		SELECT	LibraryId
		FROM	#rptUserObjects
		WHERE	LibraryId > 0
		TRUNCATE TABLE #rptUserObjects
		EXEC sec_getUserObjects @i_userId, 2231, 0, '#rptUserObjects'	-- 2231 = ARCHIVE_GROUP_ITEM
		IF NOT EXISTS (SELECT * FROM #rptUserObjects WHERE archGroupId = 0)
			INSERT	INTO @tblUserVisibleSP
			SELECT	archGroupId
			FROM	#rptUserObjects
			WHERE	archGroupId > 0
	END
	DROP TABLE #rptUserObjects
END
EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_columnFilter
INSERT	INTO @tblColumnFilter
SELECT	columnName, filterValue, filterCondition
FROM	OPENXML (@filterHandle, '/WebReport_StorageReportReq[1]/filters', 1)
WITH(	columnName		NVARCHAR(128)	'@columnName',
		filterValue		NVARCHAR(1024)	'@filterValue',
		filterCondition	NVARCHAR(16)	'@filterCondition' )
-- 1 -- get media list
IF	(@i_reqModeFlags & 4) > 0 OR @l_mediaAll = 0
BEGIN
	DECLARE	@tblLibrary		TABLE (LibraryId INT, LibraryName NVARCHAR(128), LibraryTypeId INT, LibraryOrigCCId INT)
	DECLARE	@tblSpareGroup	TABLE (SpareGroupId INT, LibraryId INT)
	DECLARE	@tblMediaGroup	TABLE (CopyId INT, MediaGroupId INT, SpareGroupId INT, LibraryId INT, PRIMARY KEY (MediaGroupId))
	DECLARE @l_mediaGroupTypeFlags	INT = (1|2|4|8|16|32|64|128)
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 1) > 0	-- ACTIVE
		INSERT	INTO @tblVolumeFlagsFilter VALUES (1)
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 2) > 0	-- APPENDABLE
	BEGIN
		INSERT	INTO @tblVolumeFlagsFilter VALUES (7)
		INSERT	INTO @tblVolumeFlagsFilter VALUES (8)
	END
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 4) > 0	-- FULL
		INSERT	INTO @tblVolumeFlagsFilter VALUES (2)
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 8) > 0	-- NEW
		INSERT	INTO @tblVolumeFlagsFilter VALUES (0)
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 16) > 0	-- AGED
		INSERT	INTO @tblVolumeFlagsFilter VALUES (6)
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 32) > 0	-- READ_ONLY
		INSERT	INTO @tblVolumeFlagsFilter VALUES (3)
	IF	@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 64) > 0	-- BAD
		INSERT	INTO @tblVolumeFlagsFilter VALUES (4)
	IF	@i_mediaGroupTypeFlags > 0
	BEGIN
		SET	@l_mediaGroupTypeFlags	= @i_mediaGroupTypeFlags
		IF	(@l_mediaGroupTypeFlags & 1) > 0
			SET @l_mediaGroupTypeFlags = (@l_mediaGroupTypeFlags | 2)
	END
	IF	@i_includeAllLibraries > 0
		INSERT	INTO @tblLibrary
		SELECT	LibraryId, AliasName, LibraryTypeId, origCCId
		FROM	MMLibrary WITH (NOLOCK)
		WHERE	LibraryId > 0
	ELSE
	BEGIN
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_libraryFilter
		INSERT	INTO @tblLibraryFilter
		SELECT	0, name, 0, 3
		FROM	OPENXML (@filterHandle, 'libraryFilter/entities', 1)
		WITH(	name		NVARCHAR(255)	'@name' )
		INSERT	INTO @tblLibrary
		SELECT	LibraryId, AliasName, LibraryTypeId, origCCId
		FROM	@tblLibraryFilter, MMLibrary WITH (NOLOCK)
		WHERE	AliasName = name
		UPDATE	@tblLibraryFilter
		SET		id = LibraryId, type = LibraryTypeId
		FROM	@tblLibrary
		WHERE	LibraryName = name
		IF	NOT EXISTS (SELECT * FROM @tblLibraryFilter)
			SET @i_includeAllLibraries = 1
	END
	IF	@userVisibleAll = 0
		DELETE	@tblLibrary
		WHERE	LibraryId NOT IN (SELECT id FROM @tblUserVisibleLib)
	IF	@i_includeAllLocations = 0
	BEGIN
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_locationFilter
		INSERT	INTO @tblLocationFilter
		SELECT	0, name
		FROM	OPENXML (@filterHandle, 'locationFilter/entities', 1)
		WITH(	name		NVARCHAR(255)	'@entityName' )
		UPDATE	@tblLocationFilter
		SET		id = EL.ExportLocationId
		FROM	@tblLocationFilter T, MMExportLocation EL WITH (NOLOCK)
		WHERE	T.name <> N'' AND EL.ExportLocation = T.name
		IF	NOT EXISTS (SELECT * FROM @tblLocationFilter)
			SET @i_includeAllLocations = 1
	END
	IF	@i_includeAllPolicies = 0
	BEGIN
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_copyFilter
		INSERT	INTO @tblSPFilter
		SELECT	0, policyName, 0, 0
		FROM	OPENXML (@filterHandle, 'spCopyFilter/storagePolicies', 1)
		WITH (	policyName	NVARCHAR(255)	'@entityName' )
		UPDATE	@tblSPFilter
		SET		policyId = G.id, primaryCopyId = G.defaultCopy, primarySnapCopyId = G.defaultSnapCopy
		FROM	@tblSPFilter T, archGroup G WITH (NOLOCK)
		WHERE	T.policyName <> N'' AND G.name = T.policyName
		IF	@userVisibleAll = 0
			DELETE	@tblSPFilter
			WHERE	policyId NOT IN (SELECT id FROM @tblUserVisibleSP)
		INSERT	INTO @tblCopyFilter
		SELECT	T.policyId, T.policyName, C.id, C.name
		FROM	@tblSPFilter T, archGroupCopy C WITH (NOLOCK)
		WHERE	C.archGroupId = T.policyId
			AND (@i_copyTypeOption = 0
				OR @i_copyTypeOption = 1 AND C.id IN (T.primaryCopyId, T.primarySnapCopyId)
				OR @i_copyTypeOption = 2 AND C.id NOT IN (T.primaryCopyId, T.primarySnapCopyId))
AND C.type <> 5
	END
	ELSE
	IF	@userVisibleAll = 0
		INSERT	INTO @tblCopyFilter
		SELECT	AG.id, AG.name, AGC.id, AGC.name
		FROM	@tblUserVisibleSP U, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = U.id AND AG.type <> 4
AND AGC.archGroupId = AG.id AND AGC.type <> 5
			AND (@i_copyTypeOption = 0
				OR @i_copyTypeOption = 1 AND AGC.id IN (AG.defaultCopy, AG.defaultSnapCopy)
				OR @i_copyTypeOption = 2 AND AGC.id NOT IN (AG.defaultCopy, AG.defaultSnapCopy))
		ORDER BY AG.name, AGC.name
	ELSE
	IF	@i_copyTypeOption <> 0
		INSERT	INTO @tblCopyFilter
		SELECT	AG.id, AG.name, AGC.id, AGC.name
		FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id > 1 AND AG.type <> 4
AND AGC.archGroupId = AG.id AND AGC.type <> 5
			AND (@i_copyTypeOption = 0
				OR @i_copyTypeOption = 1 AND AGC.id IN (AG.defaultCopy, AG.defaultSnapCopy)
				OR @i_copyTypeOption = 2 AND AGC.id NOT IN (AG.defaultCopy, AG.defaultSnapCopy))
		ORDER BY AG.name, AGC.name
	INSERT	INTO @tblSpareGroup
	SELECT	SpareGroupId, LibraryId
	FROM	MMSpareGroup WITH (NOLOCK)
WHERE	LibraryId IN (SELECT LibraryId FROM @tblLibrary WHERE LibraryTypeId NOT IN (3, 8))
	INSERT	INTO @tblMediaGroup
	SELECT	S.archGroupCopyId, MG.MediaGroupId, MG.SpareGroupId, 0
	FROM	archStream S, MMMediaGroup MG WITH (NOLOCK)
	WHERE	MG.MediaGroupId = S.mediaGroupId
		AND (@i_includeAllCopies = 1 AND @userVisibleAll = 1 OR S.archGroupCopyId IN (SELECT copyId FROM @tblCopyFilter))
	UPDATE	@tblMediaGroup
	SET		LibraryId = SG.LibraryId
	FROM	@tblMediaGroup MG, @tblSpareGroup SG
	WHERE	MG.SpareGroupId = SG.SpareGroupId
	-- media in libraries
	IF	@i_mediaExportedOption IN (0, 1)
	BEGIN
		-- spare nondisk media
		IF (@i_bothStatusAndGroupType = 0 OR @i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & (8|16)) > 0)
		AND @i_storageType IN (0, 3)
		AND @i_includeAllCopies = 1
			INSERT	INTO #tblMedia (MediaId, Barcode, LibraryId, MediaLocation, MediaTypeId, MediaFlags, MediaAttributes,
									IsAged, IsInMediaGroup, LastExportTime, RetentionFlags, RetentionExpireTime, PinMediaExpireTime,
									SpareGroupId, SpareGroupType, StorageGroup, MediaGroupId, VolumeFlags, LastBackupTime, LastRestoreTime)
			SELECT	M.MediaId, M.BarCode, M.LibraryId, M.MediaLocation, M.MediaTypeId, M.MediaFlags, M.Attributes,
					M.IsAged, M.IsInMediaGroup, M.LastExportTime, M.RetentionFlags, M.RetentionExpireTime, M.PinMediaExpireTime,
					M.SpareGroupId, (CASE WHEN S.SpareGroupType = 2 THEN 1 ELSE S.SpareGroupType END), S.SpareGroupName,
					V.MediaGroupId, V.VolumeFlags, V.LastBackupTime, V.LastRestoreTime
			FROM	MMMedia M WITH (NOLOCK)
					INNER JOIN MMSpareGroup S WITH (NOLOCK) ON S.SpareGroupId = M.SpareGroupId
					INNER JOIN MMVolume V WITH (NOLOCK) ON V.MediaId = M.MediaId
			WHERE	(@i_includeAllLibraries = 1 AND @userVisibleAll = 1 OR M.LibraryId IN (SELECT id FROM @tblLibraryFilter))
				AND M.MediaTypeId <> 10001 AND M.MediaLocation <> 3 AND M.MediaId > 0 AND M.IsInMediaGroup = 0
				AND (@i_bothStatusAndGroupType = 1
						AND (@i_mediaStatusFlags = 0 OR (S.SpareGroupType & 32) = 0
							AND ((@i_mediaStatusFlags &  8) > 0 AND M.IsAged = 0
							  OR (@i_mediaStatusFlags & 16) > 0 AND M.IsAged = 1))
						AND (@i_mediaGroupTypeFlags = 0
							OR (S.SpareGroupType & @l_mediaGroupTypeFlags) > 0)
				 OR  @i_bothStatusAndGroupType = 0
						AND (@i_mediaStatusFlags = 0
							OR (@i_mediaStatusFlags &  8) > 0 AND M.IsAged = 0
							OR (@i_mediaStatusFlags & 16) > 0 AND M.IsAged = 1
							OR  @i_mediaGroupTypeFlags = 0
							OR (S.SpareGroupType & @l_mediaGroupTypeFlags) > 0))
		-- assigned nondisk media
		IF	(@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & (1|2|4|32)) > 0)
		AND @i_storageType IN (0, 3)
			INSERT	INTO #tblMedia (MediaId, Barcode, LibraryId, MediaLocation, MediaTypeId, MediaFlags, MediaAttributes,
									IsAged, IsInMediaGroup, LastExportTime, RetentionFlags, RetentionExpireTime, PinMediaExpireTime,
									CopyId, MediaGroupId, VolumeFlags, LastBackupTime, LastRestoreTime, dataOnMediaMB)
			SELECT	M.MediaId, M.BarCode, M.LibraryId, M.MediaLocation, M.MediaTypeId, M.MediaFlags, M.Attributes,
					M.IsAged, M.IsInMediaGroup, M.LastExportTime, M.RetentionFlags, M.RetentionExpireTime, M.PinMediaExpireTime,
					MG.CopyId, V.MediaGroupId, V.VolumeFlags, V.LastBackupTime, V.LastRestoreTime, V.physicalBytesMB
			FROM	MMMedia M WITH (NOLOCK)
					INNER JOIN MMSpareGroup S WITH (NOLOCK) ON S.SpareGroupId = M.SpareGroupId
					INNER JOIN MMVolume V WITH (NOLOCK) ON V.MediaId = M.MediaId
					INNER JOIN @tblMediaGroup MG ON MG.MediaGroupId = V.MediaGroupId
			WHERE	(@i_includeAllLibraries = 1 AND @userVisibleAll = 1 OR M.LibraryId IN (SELECT id FROM @tblLibraryFilter))
				AND M.MediaTypeId <> 10001 AND M.MediaLocation <> 3 AND M.MediaId > 0 AND M.IsInMediaGroup > 0
				AND (@i_bothStatusAndGroupType = 1
						AND (@i_mediaStatusFlags = 0 OR V.VolumeFlags IN (SELECT VolumeFlags FROM @tblVolumeFlagsFilter))
						AND (@i_mediaGroupTypeFlags = 0 OR (S.SpareGroupType & @l_mediaGroupTypeFlags) > 0)
				 OR  @i_bothStatusAndGroupType = 0
						AND (@i_mediaStatusFlags = 0 OR V.VolumeFlags IN (SELECT VolumeFlags FROM @tblVolumeFlagsFilter)
						 OR  @i_mediaGroupTypeFlags = 0 OR (S.SpareGroupType & @l_mediaGroupTypeFlags) > 0))
				AND (@i_timeRangeType = 0
					OR @i_timeRangeType = 1 AND M.LastBackupTime > @i_startTime AND M.LastBackupTime < @l_endTime
					OR @i_timeRangeType = 2 AND M.LastBackupTime > @i_startTime AND M.LastBackupTime < @l_endTime
											AND M.LastRestoreTime> @i_startTime AND M.LastRestoreTime< @l_endTime
					OR @i_timeRangeType = 3 AND M.LastExportTime > @i_startTime AND M.LastExportTime < @l_endTime)
		UPDATE	#tblMedia
		SET		Location = MMSlot.SlotName
		FROM	MMSlot WITH (NOLOCK)
		WHERE	#tblMedia.MediaLocation = 1 AND #tblMedia.MediaId = MMSlot.MediaId
		UPDATE	#tblMedia
		SET		Location = MMDrive.AliasName
		FROM	MMDrive WITH (NOLOCK)
		WHERE	#tblMedia.MediaLocation = 2 AND #tblMedia.MediaId = MMDrive.MediaId
		-- undiscovered media
		IF	(@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 128) > 0)
		AND (@i_bothStatusAndGroupType = 0 OR @i_mediaGroupTypeFlags = 0)
		AND @i_storageType IN (0, 3)
		AND @i_includeAllCopies = 1
			INSERT	INTO #tblMedia (MediaId, Barcode, Location, MediaTypeName, LibraryId, MediaStatus, StorageGroup)
			SELECT	DISTINCT S.MediaId, S.BarCode, S.SlotName, 'Unknown', B.LibraryId,
(CASE WHEN (S.MediaStatus & 1) = 0 THEN 128 ELSE 256 END), 'N/A'
			FROM	MMSlot S WITH (NOLOCK), MMBay B WITH (NOLOCK)
			WHERE	S.BayId = B.BayId AND B.LibraryId > 0
				AND (@i_includeAllLibraries = 1 AND @userVisibleAll = 1 OR B.LibraryId IN (SELECT id FROM @tblLibraryFilter))
				AND S.IsGalaxyMedia = 1 AND (S.MediaId = 0 OR S.MediaStatus > 2) AND S.IsOccupied = 1
		-- disk
		IF	(@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & 1) > 0)
		AND (@i_bothStatusAndGroupType = 0 OR @i_mediaGroupTypeFlags = 0)
		AND @i_storageType IN (0, 1, 2, 4)
			INSERT	INTO #tblMedia (StorageType, MediaId, Barcode, Location, LibraryId, MediaTypeId, IsInMediaGroup, MountPathId, CopyId, MediaStatus, DataOnMediaMB)
			SELECT	(CASE WHEN MP.CenteraId > 0  THEN 4 WHEN D.DeviceTypeId > 1 AND D.DeviceTypeId < 64 THEN 2 ELSE 1 END),
					MP.MediaId, 'Magnetic', MP.MountPathName, MP.LibraryId, 10001, 1, MP.MountPathId, MS.CopyId,
					(CASE WHEN MP.IsOffline = 0 AND MP.IsEnabled = 1 THEN 512 ELSE 1024 END), MS.PhysicalBytesMB
			FROM	MMS2getMountPathNameGUIView MP, MMDevice D WITH (NOLOCK),
					(SELECT	MG.CopyId, V.MediaSideId, SUM(V.PhysicalBytesMB) AS PhysicalBytesMB
					FROM	MMVolume V WITH (NOLOCK) INNER JOIN @tblMediaGroup MG ON MG.MediaGroupId = V.MediaGroupId
					GROUP BY MG.CopyId, V.MediaSideId) MS
			WHERE	MP.MediaSideId = MS.MediaSideId
				AND MP.DeviceId = D.DeviceId
				AND (@i_includeAllLibraries = 1 AND @userVisibleAll = 1 OR MP.LibraryId IN (SELECT id FROM @tblLibraryFilter))
				AND	(@i_mediaStatusFlags = 0 OR (@i_mediaStatusFlags & (CASE WHEN MP.IsOffline = 0 AND MP.IsEnabled = 1 THEN 1 ELSE 0 END)) > 0)
				AND (@i_storageType = 0 OR @i_storageType = (CASE WHEN MP.CenteraId > 0  THEN 4 WHEN D.DeviceTypeId > 1 AND D.DeviceTypeId < 64 THEN 2 ELSE 1 END))
	END
	-- exported media
	IF	@i_mediaExportedOption IN (0, 2)
		AND @i_storageType IN (0, 3)
	BEGIN
		INSERT	INTO #tblMedia (MediaId, Barcode, Location, LibraryId, ContainerId, MediaLocation, MediaTypeId, MediaFlags,
								MediaAttributes, IsAged, IsInMediaGroup, LastExportTime, RetentionFlags, RetentionExpireTime, PinMediaExpireTime,
								SpareGroupId, SpareGroupType, CopyId, MediaGroupId, VolumeFlags, LastBackupTime, LastRestoreTime, DataOnMediaMB)
		SELECT	DISTINCT M.MediaId, M.BarCode, EL.ExportLocation, M.LastWriteLibraryId, M.ContainerId, M.MediaLocation, M.MediaTypeId, M.MediaFlags,
						M.Attributes, M.IsAged, M.IsInMediaGroup, M.LastExportTime, M.RetentionFlags, M.RetentionExpireTime, M.PinMediaExpireTime,
						M.SpareGroupId, (CASE WHEN M.IsInMediaGroup > 0 THEN 0 WHEN S.SpareGroupType = 2 THEN 1 ELSE S.SpareGroupType END),
						MG.CopyId, V.MediaGroupId, V.VolumeFlags, V.LastBackupTime, V.LastRestoreTime, V.PhysicalBytesMB
		FROM	MMMedia M WITH (NOLOCK)
				INNER JOIN MMSpareGroup S WITH (NOLOCK) ON S.SpareGroupId = M.SpareGroupId
				INNER JOIN MMVolume V WITH (NOLOCK) ON V.MediaId = M.MediaId
				INNER JOIN @tblMediaGroup MG ON MG.MediaGroupId = V.MediaGroupId
				INNER JOIN MMExportLocation EL WITH (NOLOCK) ON M.ExportLocationId = EL.ExportLocationId
		WHERE	M.MediaTypeId <> 10001 AND M.MediaLocation = 3 AND M.MediaId > 0
			AND	(M.LastWriteLibraryId IN (SELECT LibraryId FROM @tblLibrary)
				OR M.IsInMediaGroup = 0 AND M.SpareGroupId IN (SELECT SpareGroupId FROM @tblSpareGroup)
				OR M.IsInMediaGroup > 0 AND MG.LibraryId > 0)
			AND (@i_includeAllLocations = 1 AND @userVisibleAll = 1 OR M.ExportLocationId IN (SELECT id FROM @tblLocationFilter))
			AND (@i_bothStatusAndGroupType = 1
					AND (@i_mediaStatusFlags = 0 OR V.VolumeFlags IN (SELECT VolumeFlags FROM @tblVolumeFlagsFilter))
					AND (@i_mediaGroupTypeFlags = 0 OR (S.SpareGroupType & @l_mediaGroupTypeFlags) > 0)
			 OR  @i_bothStatusAndGroupType = 0
					AND (@i_mediaStatusFlags = 0 OR V.VolumeFlags IN (SELECT VolumeFlags FROM @tblVolumeFlagsFilter)
					 OR  @i_mediaGroupTypeFlags = 0 OR (S.SpareGroupType & @l_mediaGroupTypeFlags) > 0))
			AND (@i_timeRangeType = 0
				OR @i_timeRangeType = 1 AND M.LastBackupTime > @i_startTime AND M.LastBackupTime < @l_endTime
				OR @i_timeRangeType = 2 AND M.LastBackupTime > @i_startTime AND M.LastBackupTime < @l_endTime
										AND M.LastRestoreTime> @i_startTime AND M.LastRestoreTime< @l_endTime
				OR @i_timeRangeType = 3 AND M.LastExportTime > @i_startTime AND M.LastExportTime < @l_endTime)
		UPDATE	#tblMedia
		SET		LibraryId = SG.LibraryId
		FROM	@tblSpareGroup SG
		WHERE	MediaLocation = 3 AND IsInMediaGroup = 0 AND #tblMedia.SpareGroupId > 0
			AND #tblMedia.SpareGroupId = SG.SpareGroupId
		UPDATE	#tblMedia
		SET		LibraryId = MG.LibraryId
		FROM	@tblMediaGroup MG
		WHERE	MediaLocation = 3 AND IsInMediaGroup > 0 AND MG.LibraryId > 0
			AND #tblMedia.MediaGroupId = MG.MediaGroupId
	END
	IF	@i_timeRangeType = 4
	BEGIN
		DELETE	#tblMedia
		FROM	#tblMedia T
				INNER JOIN MMVolume V	WITH (NOLOCK) ON V.MediaId = T.MediaId
				LEFT OUTER JOIN (SELECT	DISTINCT volumeId FROM archChunk C WITH (NOLOCK)
								WHERE	C.CreateTime < @i_startTime AND C.CreateTime > @l_endTime) C
						ON V.VolumeId = C.volumeId
		WHERE	C.volumeId IS NULL
	END
	UPDATE	#tblMedia
	SET		LibraryName = L.LibraryName, LibraryOrigCCId = L.LibraryOrigCCId
	FROM	@tblLibrary L
	WHERE	#tblMedia.LibraryId > 0 AND L.LibraryId = #tblMedia.LibraryId
	UPDATE	#tblMedia
	SET		MediaTypeName = CASE WHEN MT.MediaTypeId = 10001 THEN 'Disk' ELSE MT.MediaTypeName END, IsCleaningMedia = MT.IsCleaningMedia
	FROM	MMMediaType MT WITH (NOLOCK)
	WHERE	#tblMedia.MediaTypeId > 0 AND MT.MediaTypeId = #tblMedia.MediaTypeId
	UPDATE	#tblMedia
	SET		Location = #tblMedia.Location + '(' + C.ContainerName + ')'
	FROM	MMContainer C WITH (NOLOCK)
	WHERE	#tblMedia.ContainerId > 0 AND C.ContainerId = #tblMedia.ContainerId
	UPDATE	#tblMedia
	SET		StorageGroup = AG.name + '(' + AGC.name + ')'
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AGC.id = #tblMedia.CopyId AND AG.id = AGC.archGroupId AND #tblMedia.CopyId > 0
	UPDATE	#tblMedia
	SET		MediaStatus = (CASE VolumeFlags WHEN 1 THEN 1
											WHEN 2 THEN 4
											WHEN 3 THEN 32
											WHEN 4 THEN 64
											WHEN 5 THEN 8
											WHEN 6 THEN 16
											WHEN 7 THEN 2
											WHEN 8 THEN 1
											ELSE VolumeFlags END)
	WHERE	VolumeFlags > 0 AND MediaTypeId <> 10001 AND IsAged = 0
	UPDATE	#tblMedia
	SET		MediaStatus = (CASE MediaFlags  WHEN 2 THEN 64
											WHEN 3 THEN 256
											WHEN 4 THEN 32
											ELSE MediaStatus END)
	WHERE	MediaTypeId <> 10001 AND IsAged = 0
	UPDATE	#tblMedia
	SET		MediaStatus = 16
	WHERE	MediaTypeId <> 10001 AND IsAged = 1
	UPDATE	#tblMedia
	SET		MediaStatus = 2048, DataOnMediaMB = -1, RetentionExpireTime = 0, PinMediaExpireTime = 0
	WHERE	IsCleaningMedia = 1
	-- set media info flags
UPDATE #tblMedia SET MediaInfoFlags = (MediaInfoFlags | 1) WHERE (MediaAttributes & 1) > 0
UPDATE #tblMedia SET MediaInfoFlags = (MediaInfoFlags | 2 | 16) WHERE (MediaAttributes & 536870912) > 0
UPDATE #tblMedia SET MediaInfoFlags = (MediaInfoFlags | 2 | 4) WHERE (MediaAttributes & 16777216) > 0
	UPDATE #tblMedia SET MediaInfoFlags = (MediaInfoFlags | CASE WHEN (RetentionFlags & 128) > 0 THEN 128 ELSE 8 END) WHERE RetentionFlags > 0
	UPDATE #tblMedia SET MediaInfoFlags = (MediaInfoFlags |16) WHERE MediaId IN (
			SELECT MediaId FROM VTAction a WITH (NOLOCK), VTActionMedia b WITH (NOLOCK) WHERE a.actionId = b.actionId AND actionType = 2)
	UPDATE #tblMedia SET MediaInfoFlags = (MediaInfoFlags |32) WHERE LibraryOrigCCId > 2 AND LibraryOrigCCId IN (
			SELECT id FROM APP_Commcell WITH (NOLOCK) WHERE type = 100) -- NBU
	-- delete the media in sparegroups if the last write time, last read time, data creation time is selected
	IF	@i_timeRangeType IN (1, 2, 4)
		DELETE FROM #tblMedia WHERE SpareGroupType = 1
	-- delete dummy media which is created by galaxy when media was not stamped and data protection job use it directly
	DELETE FROM #tblMedia WHERE BarCode LIKE 'StdAln_' + CAST(MediaId AS VARCHAR(MAX))
	-- Apply media state filter
	IF	@i_mediaStateOption = 1 -- exclude BAD media
		DELETE FROM #tblMedia WHERE MediaFlags <> 1
	ELSE
	IF	@i_mediaStateOption = 2 -- BAD media only
		DELETE FROM #tblMedia WHERE MediaFlags <> 2
	-- Apply media filter
	IF	(@i_mediaFilterFlags & 1) > 0 -- WITH_ERROR_ONLY
		DELETE	#tblMedia
		FROM	MMMediaSide MS
		WHERE	MS.MediaId = #tblMedia.MediaId AND MS.NumberOfSoftErrors <= 0 AND MS.NumberOfHardErrors <= 0
	IF	(@i_mediaFilterFlags & 2) > 0 -- PREVENT_EXPORT_ONLY
DELETE FROM #tblMedia WHERE (MediaAttributes & (16777216 | 536870912)) = 0
	IF	(@i_mediaFilterFlags & 8) > 0 -- EXTENDED_RETENTION_ONLY
		DELETE FROM #tblMedia WHERE RetentionFlags = 0 OR (MediaStatus & (1|2|4)) = 0
	ELSE
	IF	(@i_mediaFilterFlags & 16) > 0 -- BASIC_RETENTION_ONLY
		DELETE FROM #tblMedia WHERE RetentionFlags > 0 OR (MediaStatus & (1|2|4)) = 0
	IF	(@i_mediaFilterFlags & 4) > 0 -- DECONFIGURED_CLIENT_ONLY
	BEGIN
		CREATE TABLE #TEMP_MEDIA_CLIENT(MediaId INT, VolumeId INT, AppId INT, ClientId INT, Deconfigured INT)
		INSERT	INTO #TEMP_MEDIA_CLIENT
		SELECT	DISTINCT T.MediaId, T.VolumeId, AF.appId, 0, 0
		FROM	archFile AF WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK),
				(SELECT	DISTINCT V.VolumeId, V.MediaId
				FROM	MMVolume V WITH (NOLOCK), #tblMedia M
				WHERE	V.MediaId = M.MediaId) T
		WHERE	AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1
			AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId AND (ACM.flags & 256) = 0
			AND AC.volumeId = T.VolumeId AND (AC.flags & 256) = 0
		UPDATE	#TEMP_MEDIA_CLIENT
		SET		ClientId = A.clientId
		FROM	APP_Application A WITH (NOLOCK)
		WHERE	#TEMP_MEDIA_CLIENT.AppId = A.id
		UPDATE #TEMP_MEDIA_CLIENT
		SET		Deconfigured = 1
		WHERE	ClientId IN (
				SELECT	T.ClientId
				FROM	APP_Client C
						INNER JOIN (SELECT DISTINCT ClientId FROM #TEMP_MEDIA_CLIENT) T ON C.id = T.ClientId
						LEFT OUTER JOIN LicUsage L WITH (NOLOCK) ON C.id = L.CId AND AppType < 1000 AND OpType = 'Install'
				WHERE	L.CId IS NULL)
		DELETE	#tblMedia
		FROM	#tblMedia LEFT OUTER JOIN
				(SELECT DISTINCT MediaId FROM #TEMP_MEDIA_CLIENT WHERE Deconfigured = 1) T
				ON	#tblMedia.MediaId = T.MediaId
		WHERE	T.MediaId IS NULL
		DROP TABLE #TEMP_MEDIA_CLIENT
	END
	-- Update the MediaAgent Names for magnetic librarires(multiple MA's if it is Shared Mount Path)
	DECLARE @l_MountPathId INT
	DECLARE GetMountPathId CURSOR FOR
	SELECT	DISTINCT MountPathId FROM #tblMedia WHERE MountPathId <> 0
	OPEN GetMountPathId
	FETCH NEXT FROM GetMountPathId into @l_MountPathId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @MA_Names	nvarchar(1024)
		DECLARE @l_name		nvarchar(50)
		SET @MA_Names = ''
		DECLARE	GetMANameForMountPath CURSOR FOR
		SELECT	CL.name
		FROM	MMMountPath MP, MMLibraryController LC, APP_Client CL
		WHERE	MP.MountPathID = @l_MountPathId and MP.LibraryId = LC.LibraryId and LC.ClientId = CL.id
		OPEN GetMANameForMountPath
		FETCH NEXT FROM GetMANameForMountPath into @l_name
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @MA_Names = ''
				SET @MA_Names = @l_name
			ELSE
				SET @MA_Names = @MA_Names +', '+ @l_name
			FETCH NEXT FROM getMANameForMountPath INTO @l_name
		END
		UPDATE	#tblMedia SET LibraryName = LibraryName + '[' + @MA_Names + ']'
		WHERE	MountPathId = @l_MountPathId
		CLOSE GetMANameForMountPath
		DEALLOCATE GetMANameForMountPath
		FETCH NEXT FROM GetMountPathId INTO @l_MountPathId
	END
	CLOSE GetMountPathId
	DEALLOCATE GetMountPathId
	UPDATE	#tblMedia
	SET		MediaStateName		= CASE WHEN (MediaInfoFlags & 64) = 0 THEN N'Good' ELSE N'Bad' END,
			MediaStatusName		= dbo.WR_GetMediaStatusString(@i_localeId, MediaStatus),
			MediaGroupTypeName	= dbo.WR_GetMediaGroupTypeString(@i_localeId, SpareGroupType),
			RetainedBy			= CASE WHEN (MediaTypeId = 10001 OR IsCleaningMedia = 1) THEN N'N/A'
									   WHEN (MediaInfoFlags & 128) > 0 THEN N'User'
									   WHEN (MediaInfoFlags & 8) > 0 THEN N'Extended Retention'
									   WHEN MediaStatus IN (1,2,4) THEN N'Basic Retention'
									   ELSE N'N/A' END,
			PreventExport		= CASE WHEN (MediaTypeId = 10001 OR IsCleaningMedia = 1) THEN N'N/A'
									   WHEN (MediaInfoFlags & 2) > 0 THEN N'Yes'
									   ELSE N'No' END
	-- sort media
	IF	@i_mediaSortOrder = 0
		INSERT	INTO #tblMediaSorted
		SELECT	MediaId, Barcode, MediaTypeId, MediaTypeName, LibraryName, StorageGroup, Location,
				RetentionExpireTime, CASE RetentionExpireTime WHEN -1 THEN 'Infinite' WHEN 0 THEN 'N/A' ELSE dbo.GetDateTimeFormatString(RetentionExpireTime + @bias, NULL, @dateFormat) END,
				PinMediaExpireTime,  CASE WHEN PinMediaExpireTime <= 0 THEN 'N/A' ELSE dbo.GetDateTimeFormatString(PinMediaExpireTime + @bias, NULL, @dateFormat) END,
				MediaStatus, SpareGroupType, MediaInfoFlags, DataOnMediaMB,
				MediaStateName, MediaStatusName, MediaGroupTypeName, RetainedBy, PreventExport
		FROM	#tblMedia
		ORDER BY (CASE @i_mediaSortColumnNo
					WHEN 1	THEN Barcode
					WHEN 2	THEN MediaTypeName
					WHEN 3	THEN MediaStateName
					WHEN 4	THEN MediaStatusName
					WHEN 5	THEN MediaGroupTypeName
					WHEN 6	THEN StorageGroup
					WHEN 7	THEN LibraryName
					WHEN 10	THEN RetainedBy
					WHEN 11	THEN Location
					WHEN 12	THEN PreventExport
					ELSE	''
					END) ASC,
					(CASE @i_mediaSortColumnNo
					WHEN 8	THEN DataOnMediaMB
					WHEN 9	THEN RetentionExpireTime
					WHEN 13	THEN PinMediaExpireTime
					ELSE	0
					END) ASC,
					(CASE @i_mediaSortColumnNo WHEN 1 THEN '' ELSE LibraryName  END)ASC,
					(CASE @i_mediaSortColumnNo WHEN 7 THEN '' ELSE Barcode END) ASC
	ELSE
		INSERT	INTO #tblMediaSorted
		SELECT	MediaId, Barcode, MediaTypeId, MediaTypeName, LibraryName, StorageGroup, Location,
				RetentionExpireTime, CASE RetentionExpireTime WHEN -1 THEN 'Infinite' WHEN 0 THEN 'N/A' ELSE dbo.GetDateTimeFormatString(RetentionExpireTime + @bias, NULL, @dateFormat) END,
				PinMediaExpireTime,  CASE WHEN PinMediaExpireTime <= 0 THEN 'N/A' ELSE dbo.GetDateTimeFormatString(PinMediaExpireTime + @bias, NULL, @dateFormat) END,
				MediaStatus, SpareGroupType, MediaInfoFlags, DataOnMediaMB,
				MediaStateName, MediaStatusName, MediaGroupTypeName, RetainedBy, PreventExport
		FROM	#tblMedia
		ORDER BY (CASE @i_mediaSortColumnNo
					WHEN 1	THEN Barcode
					WHEN 2	THEN MediaTypeName
					WHEN 3	THEN MediaStateName
					WHEN 4	THEN MediaStatusName
					WHEN 5	THEN MediaGroupTypeName
					WHEN 6	THEN StorageGroup
					WHEN 7	THEN LibraryName
					WHEN 10	THEN RetainedBy
					WHEN 11	THEN Location
					WHEN 12	THEN PreventExport
					ELSE	''
					END) DESC,
					(CASE @i_mediaSortColumnNo
					WHEN 8	THEN DataOnMediaMB
					WHEN 9	THEN RetentionExpireTime
					WHEN 13	THEN PinMediaExpireTime
					ELSE	0
					END) DESC,
					(CASE @i_mediaSortColumnNo WHEN 1 THEN '' ELSE LibraryName  END)ASC,
					(CASE @i_mediaSortColumnNo WHEN 7 THEN '' ELSE Barcode END) ASC
	DECLARE	@l_columnName		NVARCHAR(128)
	DECLARE	@l_filtervalue		NVARCHAR(1024)
	DECLARE	@l_filterCondition	NVARCHAR(16)
	DECLARE @l_likeStr			NVARCHAR(1024)
	DECLARE @l_number			BIGINT
	DECLARE ColumnFilterCur CURSOR FOR
	SELECT	columnName, filtervalue, filterCondition
	FROM	@tblColumnFilter
	OPEN	ColumnFilterCur
	FETCH	ColumnFilterCur INTO @l_columnName, @l_filtervalue, @l_filterCondition
	WHILE   @@FETCH_STATUS = 0
	BEGIN
		SET	@l_likeStr = '%' + @l_filtervalue + '%'
		IF	@l_columnName = 'barcode'
			DELETE	#tblMediaSorted WHERE Barcode NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'mediaTypeName'
			DELETE	#tblMediaSorted WHERE MediaTypeName NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'libraryName'
			DELETE	#tblMediaSorted WHERE LibraryName NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'Location'
			DELETE	#tblMediaSorted WHERE Location NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'storageGroup'
			DELETE	#tblMediaSorted WHERE StorageGroup NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'dataOnMediaMB'
		BEGIN
			IF @l_filterCondition = 'LIKE'
				DELETE	#tblMediaSorted WHERE dbo.GetAutoSizeStr(DataOnMediaMB) NOT LIKE @l_likeStr
			ELSE IF ISNUMERIC(@l_filtervalue) = 1
			BEGIN
				SET @l_number = CAST(@l_filtervalue AS BIGINT)
				IF @l_filterCondition = '='
					DELETE	#tblMediaSorted WHERE DataOnMediaMB <> @l_number
				ELSE IF @l_filterCondition = '>'
					DELETE	#tblMediaSorted WHERE DataOnMediaMB <= @l_number
				ELSE IF @l_filterCondition = '>='
					DELETE	#tblMediaSorted WHERE DataOnMediaMB <  @l_number
				ELSE IF @l_filterCondition = '<'
					DELETE	#tblMediaSorted WHERE DataOnMediaMB >= @l_number
				ELSE IF @l_filterCondition = '<='
					DELETE	#tblMediaSorted WHERE DataOnMediaMB >  @l_number
			END
		END
		ELSE IF	@l_columnName = 'mediaStateName'
			DELETE	#tblMediaSorted WHERE MediaStateName NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'mediaStatusName'
			DELETE	#tblMediaSorted WHERE MediaStatusName NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'mediaGroupTypeName'
			DELETE	#tblMediaSorted WHERE MediaGroupTypeName NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'retainedBy'
			DELETE	#tblMediaSorted WHERE RetainedBy NOT LIKE @l_likeStr
		ELSE IF	@l_columnName = 'retainDataUntil'
		BEGIN
			IF @l_filterCondition = 'LIKE'
				DELETE	#tblMediaSorted WHERE RetainDataUntilStr NOT LIKE @l_likeStr
			ELSE IF ISDATE(@l_filtervalue) = 1
			BEGIN
				SET @l_number = dbo.GetUnixTime(@l_filtervalue) - @bias
				IF @l_filterCondition = '='
					DELETE	#tblMediaSorted WHERE RetainDataUntil <> @l_number
				ELSE IF @l_filterCondition = '>'
					DELETE	#tblMediaSorted WHERE RetainDataUntil <= @l_number AND RetainDataUntil > 0
				ELSE IF @l_filterCondition = '>='
					DELETE	#tblMediaSorted WHERE RetainDataUntil <  @l_number AND RetainDataUntil > 0
				ELSE IF @l_filterCondition = '<'
					DELETE	#tblMediaSorted WHERE RetainDataUntil >= @l_number OR  RetainDataUntil < 0
				ELSE IF @l_filterCondition = '<='
					DELETE	#tblMediaSorted WHERE RetainDataUntil >  @l_number OR  RetainDataUntil < 0
			END
		END
		ELSE IF	@l_columnName = 'exportableTime'
		BEGIN
			IF @l_filterCondition = 'LIKE'
				DELETE	#tblMediaSorted WHERE ExportableTimeStr NOT LIKE @l_likeStr
			ELSE IF ISDATE(@l_filtervalue) = 1
			BEGIN
				SET @l_number = dbo.GetUnixTime(@l_filtervalue) - @bias
				IF @l_filterCondition = '='
					DELETE	#tblMediaSorted WHERE ExportableTime <> @l_number
				ELSE IF @l_filterCondition = '>'
					DELETE	#tblMediaSorted WHERE ExportableTime <= @l_number
				ELSE IF @l_filterCondition = '>='
					DELETE	#tblMediaSorted WHERE ExportableTime <  @l_number
				ELSE IF @l_filterCondition = '<'
					DELETE	#tblMediaSorted WHERE ExportableTime >= @l_number OR ExportableTime <= 0
				ELSE IF @l_filterCondition = '<='
					DELETE	#tblMediaSorted WHERE ExportableTime >  @l_number OR ExportableTime <= 0
			END
		END
		ELSE IF	@l_columnName = 'preventExport'
			DELETE	#tblMediaSorted WHERE PreventExport NOT LIKE @l_likeStr
		FETCH	ColumnFilterCur INTO @l_columnName, @l_filtervalue, @l_filterCondition
	END
	CLOSE	ColumnFilterCur
	DEALLOCATE ColumnFilterCur
	SELECT	@l_totalMedia = COUNT(*) FROM #tblMediaSorted
	IF	@i_mediaPageSize <= 0
		SET @i_mediaPageSize = @l_totalMedia
	ELSE
	IF	@i_mediaPageNo > 1 AND @i_mediaPageSize > 0
		DELETE	TOP (@i_mediaPageSize*(@i_mediaPageNo-1))
		FROM	#tblMediaSorted
END
-- 2 -- get summary
IF	(@i_reqModeFlags & 1) > 0
BEGIN
	IF	(@i_reqModeFlags & 4) = 0 AND @l_mediaAll = 1
	BEGIN
		-- undiscovered media
		INSERT	INTO #tblSummary
		SELECT	DISTINCT 3, B.LibraryId, 0, N'', 0, COUNT(DISTINCT S.MediaId), 0, 0
		FROM	MMSlot S WITH (NOLOCK), MMBay B WITH (NOLOCK)
		WHERE	S.IsGalaxyMedia = 1 AND (S.MediaId = 0 OR S.MediaStatus > 2) AND S.IsOccupied = 1
			AND S.BayId = B.BayId AND B.LibraryId > 0
			AND (@userVisibleAll = 1 OR B.LibraryId IN (SELECT id FROM @tblUserVisibleLib))
		GROUP BY B.LibraryId
		-- non-disk media
		INSERT	INTO #tblSummary
		SELECT	3, M.LibraryId, 0, N'', ISNULL(S.archGroupCopyId, 0),
				COUNT(DISTINCT ISNULL(V.MediaSideId, 0)),
				SUM(ISNULL(CASE WHEN M.IsInMediaGroup = 1 THEN V.PhysicalBytesMB ELSE 0 END, 0)),
				SUM(CAST(CASE WHEN M.MediaFlags = 1 AND V.VolumeFlags IN (1,5,6,7,8) AND MS.TotalSpaceMB > 0 THEN MS.FreeBytesMB ELSE 0 END AS BIGINT))
		FROM	MMMedia M WITH (NOLOCK)
				INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MS.MediaId = M.MediaId
				LEFT OUTER JOIN MMVolume V WITH (NOLOCK) ON V.MediaSideId = MS.MediaSideId
				LEFT OUTER JOIN archStream S WITH (NOLOCK) ON V.MediaGroupId = S.mediaGroupId AND M.IsInMediaGroup = 1
		WHERE	M.MediaTypeId <> 10001 AND M.LibraryId > 0
			AND (@userVisibleAll = 1 OR M.LibraryId IN (SELECT id FROM @tblUserVisibleLib))
		GROUP BY M.LibraryId, ISNULL(S.archGroupCopyId, 0)
		-- disk media
		INSERT	INTO #tblSummary
		SELECT	T.StorageType, T.LibraryId, T.MountPathId, T.MountPathName, ISNULL(S.archGroupCopyId, 0), 1,
				SUM(ISNULL(V.PhysicalBytesMB, 0)), 0
		FROM	(SELECT	MP.MediaSideId, MP.LibraryId, MP.MountPathId, MP.MountPathName,
				(CASE WHEN SD.CenteraId > 0 THEN 4 WHEN D.DeviceTypeId > 1 AND D.DeviceTypeId < 64 THEN 2 ELSE 1 END) AS StorageType
				FROM	MMMountPath MP WITH (NOLOCK), MMMountPathToStorageDevice SD WITH (NOLOCK), MMDevice D WITH (NOLOCK)
				WHERE	MP.MountPathId > 0 AND SD.MountPathId = MP.MountPathId AND D.DeviceId = SD.DeviceId) T
				LEFT OUTER JOIN MMVolume V WITH (NOLOCK) ON V.MediaSideId = T.MediaSideId AND V.SiloStatus <> 3
				LEFT OUTER JOIN archStream S WITH (NOLOCK) ON V.MediaGroupId = S.mediaGroupId
		WHERE	(V.VolumeId IS NULL OR V.VolumeId > 0 AND S.archGroupId IS NOT NULL)
			AND (@userVisibleAll = 1 OR T.LibraryId IN (SELECT id FROM @tblUserVisibleLib))
		GROUP BY T.StorageType, T.LibraryId, T.MountPathId, T.MountPathName, ISNULL(S.archGroupCopyId, 0)
		IF	@userVisibleAll = 0
			DELETE	#tblSummary
			WHERE	CopyId > 0 AND CopyId NOT IN (SELECT CopyId FROM @tblCopyFilter)
	END
	ELSE
	BEGIN
		INSERT	INTO #tblSummary
		SELECT	M.StorageType, M.LibraryId, 0, N'', M.CopyId,
				COUNT(DISTINCT ISNULL(V.MediaSideId, 0)),
				SUM(ISNULL(CASE WHEN M.IsAged = 0 THEN V.PhysicalBytesMB ELSE 0 END, 0)),
				SUM(CAST(CASE WHEN M.MediaTypeId <> 10001 AND M.MediaFlags = 1 AND V.VolumeFlags IN (1,5,6,7,8) AND MS.TotalSpaceMB > 0 THEN MS.FreeBytesMB ELSE 0 END AS BIGINT))
		FROM	#tblMedia M
				INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MS.MediaId = M.MediaId
				LEFT OUTER JOIN MMVolume V WITH (NOLOCK) ON V.MediaSideId = MS.MediaSideId AND V.SiloStatus <> 3
				LEFT OUTER JOIN archStream S WITH (NOLOCK) ON V.MediaGroupId = S.mediaGroupId AND S.archGroupCopyId = M.CopyId
		WHERE	M.MediaTypeId <> 10001 AND (V.VolumeId IS NULL OR V.MediaGroupId = 0 OR S.archGroupCopyId IS NOT NULL)
		GROUP BY M.StorageType, M.LibraryId, M.CopyId
		-- disk media
		INSERT	INTO #tblSummary
		SELECT	T.StorageType, T.LibraryId, T.MountPathId, T.MountPathName, ISNULL(S.archGroupCopyId, 0), 1,
				SUM(ISNULL(V.PhysicalBytesMB, 0)), 0
		FROM	(SELECT	MP.MediaSideId, MP.LibraryId, MP.MountPathId, MP.MountPathName,
				(CASE WHEN SD.CenteraId > 0 THEN 4 WHEN D.DeviceTypeId > 1 AND D.DeviceTypeId < 64 THEN 2 ELSE 1 END) AS StorageType
				FROM	MMMountPath MP WITH (NOLOCK), MMMountPathToStorageDevice SD WITH (NOLOCK), MMDevice D WITH (NOLOCK)
				WHERE	MP.MountPathId > 0 AND SD.MountPathId = MP.MountPathId AND D.DeviceId = SD.DeviceId) T
				INNER JOIN #tblMedia M ON T.MountPathId = M.MountPathId
				LEFT OUTER JOIN MMVolume V WITH (NOLOCK) ON V.MediaSideId = T.MediaSideId AND V.SiloStatus <> 3
				LEFT OUTER JOIN archStream S WITH (NOLOCK) ON V.MediaGroupId = S.mediaGroupId
		WHERE	(V.VolumeId IS NULL OR V.VolumeId > 0 AND S.archGroupId IS NOT NULL)
			AND (@i_includeAllCopies = 1 AND @userVisibleAll = 1 OR S.archGroupCopyId IN (SELECT CopyId FROM @tblCopyFilter))
		GROUP BY T.StorageType, T.LibraryId, T.MountPathId, T.MountPathName, ISNULL(S.archGroupCopyId, 0)
	END
	-- set freeSpaceMB for disk libraries
	UPDATE	#tblSummary
	SET		MountPathName = A.MountPathName, FreeSpaceMB = CASE WHEN StorageType = 2 THEN -1 ELSE A.FreeBytesMB END
	FROM	(SELECT	MP.MountPathId, MP.MountPathName, CAST(MS.FreeBytesMB AS BIGINT) AS FreeBytesMB
			FROM	MMMountPath MP WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
			WHERE	MS.MediaSideId = MP.MediaSideId AND MP.LibraryId IN (SELECT DISTINCT LibraryId FROM #tblSummary)) A
	WHERE	#tblSummary.MountPathId = A.MountPathId
END
-- 3 -- fill the filters
IF	(@i_reqModeFlags & 2) > 0
BEGIN
	IF	NOT EXISTS (SELECT id FROM @tblLibraryFilter)
		INSERT	INTO @tblLibraryFilter
		SELECT	LibraryId, AliasName, LibraryTypeId, 3
		FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryId > 0 AND LibraryTypeId <> 8
			AND (@userVisibleAll = 1 OR LibraryId IN (SELECT id FROM @tblUserVisibleLib))
		ORDER BY AliasName
	UPDATE	@tblLibraryFilter
	SET		storageType = (CASE WHEN MP.CenteraId > 0 THEN 4 WHEN D.DeviceTypeId > 1 AND D.DeviceTypeId < 64 THEN 2 ELSE 1 END)
	FROM	@tblLibraryFilter ML, MMS2getMountPathNameGUIView MP, MMDevice D WITH (NOLOCK)
	WHERE	MP.LibraryId = ML.id AND MP.DeviceId = D.DeviceId
	IF	NOT EXISTS (SELECT id FROM @tblLocationFilter)
		INSERT	INTO @tblLocationFilter
		SELECT	ExportLocationId, ExportLocation
		FROM	MMExportLocation WITH (NOLOCK)
		WHERE	ExportLocationId > 0
		ORDER BY ExportLocation
	IF	NOT EXISTS (SELECT * FROM @tblSPFilter)
		INSERT	INTO @tblSPFilter
		SELECT	id, name, defaultCopy, defaultSnapCopy
		FROM	archGroup WITH (NOLOCK)
WHERE	id > 1 AND type <> 4
			AND (@userVisibleAll = 1 OR id IN (SELECT id FROM @tblUserVisibleSP))
		ORDER BY name
END
SELECT
    -- request
    (SELECT @i_userId					AS '@userId',
            @i_localeId					AS '@localeId',
            @i_reqModeFlags				AS '@reqModeFlags',
            @i_mediaOrderBy				AS '@mediaOrderBy',
            @i_mediaStatusFlags			AS '@mediaStatusFlags',
            @i_mediaGroupTypeFlags		AS '@mediaGroupTypeFlags',
            @i_bothStatusAndGroupType	AS '@bothStatusAndGroupType',
            @i_mediaStateOption			AS '@mediaStateOption',
            @i_mediaFilterFlags			AS '@mediaFilterFlags',
            @i_mediaExportedOption		AS '@mediaExportedOption',
            @i_timeRangeType			AS '@timeRangeType',
            @i_startTime				AS '@startTime',
            @i_endTime					AS '@endTime',
            (SELECT @i_includeAllLibraries AS '@includeAll',
(SELECT COUNT(id) FROM  @tblLibraryFilter WHERE type  = 3) AS '@numberOfDiskLib',
(SELECT COUNT(id) FROM  @tblLibraryFilter WHERE type <> 3) AS '@numberOfTapeLib',
(SELECT (CASE WHEN type = 3 THEN 1 ELSE 0 END)	AS '@isDisk',
                        name			AS '@name',
						storageType		AS '@libraryType'
                 FROM   @tblLibraryFilter
                 ORDER BY name
                 FOR XML PATH('entities'), TYPE)
            FOR XML PATH('libraryFilter'), TYPE),
            (SELECT @i_includeAllLocations AS '@includeAll',
                (SELECT id				AS '@entityId',
                        name			AS '@entityName'
                 FROM   @tblLocationFilter
                 ORDER BY name
                 FOR XML PATH('entities'), TYPE)
            FOR XML PATH('locationFilter'), TYPE),
            (SELECT @i_includeAllPolicies AS '@includeAll',
                    0					AS '@copyType',
                (SELECT policyId		AS '@entityId',
						policyName		AS '@entityName'
                 FROM   @tblSPFilter
                 ORDER BY policyName
                 FOR XML PATH('storagePolicies'), TYPE)
            FOR XML PATH('spCopyFilter'), TYPE)
     FOR XML PATH('req'), TYPE),
     -- storage summary
    (SELECT
		(SELECT T.StorageType			AS '@storageType',
				T.LibraryId				AS '@libraryId',
				L.AliasName				AS '@libraryName',
				T.MountPathId			AS '@mountPathId',
				T.MountPathName			AS '@mountPathName',
				AGC.archGroupId			AS '@policyId',
                (CASE WHEN AG.id = 1 THEN 'Not Assigned' ELSE AG.name END) AS '@policyName',
				T.CopyId				AS '@copyId',
                (CASE WHEN AGC.id = 0 THEN 'Not Assigned' ELSE AGC.name END) AS '@copyName',
                T.NumberOfMedia			AS '@numberOfMedia',
                T.DataOnMediaMB			AS '@dataOnMediaMB',
                T.FreeSpaceMB			AS '@freeSpaceMB'
         FROM   #tblSummary T, MMLibrary L WITH (NOLOCK), archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
         WHERE	L.LibraryId = T.LibraryId AND AG.id = AGC.archGroupId AND AGC.id = T.copyId
         ORDER  BY T.StorageType, L.AliasName, (CASE WHEN AG.id = 1 THEN 'Not Assigned' ELSE AG.name END), (CASE WHEN AGC.id = 1 THEN 'Not Assigned' ELSE AGC.name END)
         FOR    XML PATH('matrix'),TYPE)
     FOR XML PATH('storageSummary'),TYPE),
     -- media list
    (SELECT
		@i_mediaPageSize				AS '@pageSize',
		@i_mediaPageNo					AS '@mediaPageNo',
		@l_totalMedia					AS '@totalMedia',
		(SELECT TOP (@i_mediaPageSize)
				MediaId					AS '@mediaId',
                Barcode					AS '@barcode',
                MediaTypeId				AS '@mediaTypeId',
                MediaTypeName			AS '@mediaTypeName',
                LibraryName				AS '@libraryName',
                StorageGroup			AS '@storageGroup',
                Location				AS '@location',
                RetainDataUntilStr		AS '@retainDataUntil',
                ExportableTimeStr		AS '@exportableTime',
                MediaStatus				AS '@mediaStatus',
				MediaGroupType			AS '@mediaGroupType',
                MediaInfoFlags			AS '@mediaInfoFlags',
                DataOnMediaMB			AS '@dataOnMediaMB',
				MediaStateName			AS '@mediaStateName',
				MediaStatusName			AS '@mediaStatusName',
				MediaGroupTypeName		AS '@mediaGroupTypeName',
				RetainedBy				AS '@retainedBy',
				PreventExport			AS '@preventExport'
         FROM   #tblMediaSorted
         FOR    XML PATH('mediaDetails'),TYPE)
     FOR XML PATH('mediaList'),TYPE)
FOR XML PATH ('WebReport_StorageReportResp')
DROP TABLE #tblSummary
DROP TABLE #tblMedia
DROP TABLE #tblMediaSorted
GO

IF EXISTS (select * from GxQscripts where name = 'WR_StorageSummary')
	delete from GxQscripts where name = 'WR_StorageSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WR_StorageSummary')
	delete from GXDBVersions where aliasname = 'WR_StorageSummary'
GO

insert into GXDBVersions values(2, 'WR_StorageSummary',  '00010048003400020000', 'WR_StorageSummary', '00010048003400020000')
GO

