

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WR_DedupSummary.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WR_DedupSummary.sp,v $ $Id: WR_DedupSummary.sp,v 1.16.88.3 2018/11/08 22:36:36 chandru Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Jun Lu
-- Create date: 09/11/2010
-- Description:	generates Dedup Information report
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WR_DedupSummary')
BEGIN
	print '>>> Drop Stored Procedure: WR_DedupSummary <<<'
	drop procedure WR_DedupSummary
END
IF EXISTS (select * from GxQscripts where name='WR_DedupSummary')
	delete from GxQscripts where name = 'WR_DedupSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WR_DedupSummary')
	delete from GXDBVersions where aliasname = 'WR_DedupSummary'
GO
print '... Creating Procedure: WR_DedupSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WR_DedupSummary
  @i_req XML,
  @i_userId INT
AS
  DECLARE @o_DedupSummary NVARCHAR(MAX);
SET NOCOUNT ON
DECLARE	@i_localeId				INT
DECLARE	@i_reqModeFlags			INT
DECLARE	@i_includeAllLibraries	INT
DECLARE	@i_libraryFilter		NVARCHAR(MAX)
DECLARE	@i_includeAllCopies		INT = 1
DECLARE	@i_includeAllPolicies	INT
DECLARE	@i_copyType				INT
DECLARE	@i_spCopyFilter			NVARCHAR(MAX)
DECLARE @filterHandle			INT
SET @i_localeId				= ISNULL(@i_req.value('/WebReport_DedupReportReq[1]/localeId[1]/@localeId', 'int'), 0)
SET @i_reqModeFlags			= @i_req.value('/WebReport_DedupReportReq[1]/@reqModeFlags', 'int')
SET @i_includeAllLibraries	= ISNULL(@i_req.value('/WebReport_DedupReportReq[1]/libraryFilter[1]/@includeAll', 'int'), 1)
SET @i_libraryFilter		= CAST(@i_req.query('/WebReport_DedupReportReq[1]/libraryFilter[1]') AS NVARCHAR(MAX))
SET @i_includeAllPolicies	= ISNULL(@i_req.value('/WebReport_DedupReportReq[1]/spCopyFilter[1]/@includeAll', 'int'), 1)
SET @i_copyType				= ISNULL(@i_req.value('/WebReport_DedupReportReq[1]/spCopyFilter[1]/@copyType', 'int'), 0)
SET @i_spCopyFilter			= CAST(@i_req.query('/WebReport_DedupReportReq[1]/spCopyFilter[1]') AS NVARCHAR(MAX))
DECLARE @userPreferences	XML = (SELECT value FROM UMUserWebPrefs WITH (NOLOCK) WHERE userId = @i_userId)
DECLARE @dateFormat			INT = 0
DECLARE @bias				INT = 0
IF	@userPreferences IS NOT NULL
	SET @dateFormat = ISNULL(@userPreferences.value('/userPreferences[1]/general[1]/@dateFormat', 'int'), 1)
SET @bias = dbo.getUnixTime(GetDate()) - dbo.getUnixTime(GetUTCDate())
DECLARE	@maxSIDBPrimaryRecords	BIGINT
DECLARE	@maxSIDBAverageQITime	INT
SELECT	@maxSIDBPrimaryRecords = CAST(value AS BIGINT)*1000000
FROM	MMConfigs
WHERE	name = 'MMCONFIG_MAX_PRIMARYRECS_IN_SIDB_MIL'
IF	@maxSIDBPrimaryRecords IS NULL
	SET @maxSIDBPrimaryRecords = 1000000000
SELECT	@maxSIDBAverageQITime = CAST(value AS INT)
FROM	MMConfigs
WHERE	name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'
IF	@maxSIDBAverageQITime IS NULL
	SET @maxSIDBAverageQITime = 1000
CREATE TABLE #LibraryFilter (LibraryId INT)
CREATE TABLE #MediaSideFilter (MediaSideId INT)
CREATE TABLE #StoreFilter (SIDBStoreId INT)
IF	@i_includeAllLibraries = 0
BEGIN
	EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_libraryFilter
	INSERT	INTO #LibraryFilter
	SELECT	LibraryId
	FROM	MMLibrary
	WHERE	AliasName IN (SELECT name FROM OPENXML(@filterHandle, 'libraryFilter/entities', 1) WITH(name NVARCHAR(255) '@entityName'))
	IF	NOT EXISTS (SELECT * FROM #LibraryFilter)
		SET @i_includeAllLibraries = 1
	ELSE
		INSERT	INTO #MediaSideFilter
		SELECT	MediaSideId
		FROM	MMMountPath
		WHERE	LibraryId IN (SELECT LibraryId FROM #LibraryFilter)
END
IF	@i_spCopyFilter IS NOT NULL
BEGIN
	IF	@i_includeAllPolicies = 0
	BEGIN
		SET @i_includeAllCopies = 0
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_spCopyFilter
		INSERT	INTO #StoreFilter
		SELECT	CS.SIDBStoreId
		FROM	archGroup AG,
				archGroupCopy AGC
INNER JOIN archCopySIDBStore CS ON AGC.id = CS.copyId AND ((CS.Flags & 4) > 0),
				(SELECT	name AS policyName
				FROM	OPENXML(@filterHandle,	'spCopyFilter/storagePolicies', 1)
				WITH (	name	NVARCHAR(255)	'@entityName' )) T
WHERE	AGC.archGroupId = AG.id AND ((AGC.dedupeFlags & 262144) > 0) AND (AGC.dedupeFlags & 134217728) = 0
			AND AG.name = T.policyName
			AND (@i_copyType = 0 OR @i_copyType = 1 AND AGC.id = AG.defaultCopy OR @i_copyType = 2 AND AGC.id <> AG.defaultCopy)
	END
	ELSE
	IF  @i_copyType <> 0
	BEGIN
		SET @i_includeAllCopies = 0
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_spCopyFilter
		INSERT	INTO #StoreFilter
		SELECT	CS.SIDBStoreId
		FROM	archGroup AG,
				archGroupCopy AGC
INNER JOIN archCopySIDBStore CS ON AGC.id = CS.copyId AND ((CS.Flags & 4) > 0)
WHERE	AGC.archGroupId = AG.id AND ((AGC.dedupeFlags & 262144) > 0) AND (AGC.dedupeFlags & 134217728) = 0
			AND (@i_copyType = 1 AND AGC.id = AG.defaultCopy OR @i_copyType = 2 AND AGC.id <> AG.defaultCopy)
	END
END
CREATE TABLE #StoreToCopy (SIDBStoreId INT, CopyId INT)
CREATE TABLE #DedupCopyDisk (CopyId INT, CopyName NVARCHAR(1024), PolicyId INT, PolicyName NVARCHAR(1024),
		LibraryId INT, LibraryName NVARCHAR(1024), MediaAgentName NVARCHAR(1024), MountPathName NVARCHAR(1024), MediaSideId INT,
		FreeSpaceMB BIGINT, Application	BIGINT, ToBeFreedAppBytes BIGINT, DataWritten BIGINT)
CREATE TABLE #DedupCopyDiskAggr (CopyId INT, CopyName NVARCHAR(1024), PolicyId INT, PolicyName NVARCHAR(1024),
		FreeSpaceMB BIGINT, Application	BIGINT, ToBeFreedAppBytes BIGINT, DataWritten BIGINT, ToBeSiloedMB BIGINT, SiloedDataMB BIGINT)
CREATE	TABLE #DedupDiskLibAggr (LibraryId INT, LibraryName NVARCHAR(1024),
		MediaAgentName NVARCHAR(1024), MountPathName NVARCHAR(1024), MediaSideId INT,
		FreeSpaceMB BIGINT, Application	BIGINT, ToBeFreedAppBytes BIGINT, DataWritten BIGINT)
CREATE TABLE #DedupedJobSize (
		MediaSideId INT, JobId INT, CommCellId INT, CopyId INT, SIDBStoreId INT, DataWritten BIGINT, AppSize BIGINT)
CREATE TABLE #DedupedAppSize (
		MediaSideId INT, CopyId INT, DataWritten BIGINT, Application BIGINT, ToBeFreedAppBytes BIGINT)
CREATE TABLE #SiloedDataSize (
		MediaSideId INT, CopyId INT, ToBeSiloedMB BIGINT, SiloedDataMB BIGINT)
CREATE TABLE #ToBeFreedAppSize (
		MediaSideId INT, CopyId INT, SIDBStoreId INT, ToBeFreedAppBytes BIGINT)
CREATE	TABLE #CopySubStore (CopyId INT, SubStoreId INT, MediaAgentName NVARCHAR(1024), Path VARCHAR(1024),
		PrimaryEntries BIGINT, SecondaryEntries BIGINT, AvgQITime INT, EstPruningSize BIGINT,
		DedupDBSizeMB BIGINT, FreeDiskSpaceMB BIGINT, MinimumFreeSpaceMB BIGINT, FreeSpaceWarningMB BIGINT)
CREATE	TABLE #StoreSummary (
		CopyId INT, SIDBStoreId INT, DataWritten BIGINT, Application BIGINT, ToBeFreedAppBytes BIGINT, CreationTime INT, SealedTime INT)
CREATE	TABLE #CopyBaselineSize (copyId INT, baselineSize BIGINT)
INSERT	INTO #StoreToCopy
SELECT	CS.SIDBStoreId, CS.CopyId
FROM	archGroupCopy AGC, archCopySIDBStore CS
WHERE	CS.CopyId = AGC.id AND (AGC.dedupeFlags & 134217728) = 0
AND ((CS.Flags & 4) > 0)
INSERT	INTO #ToBeFreedAppSize
SELECT	V.MediaSideId, 0, DAF.SIDBStoreId, SUM(DAF.appSizeFreedBytes)
FROM	MMDeletedAF DAF WITH (NOLOCK)
		INNER JOIN MMVolume V ON V.VolumeId = DAF.VolumeId AND DAF.SIDBStoreId > 0
GROUP BY V.MediaSideId, DAF.SIDBStoreId
INSERT	INTO #DedupCopyDisk
SELECT	AGC.id, AGC.name, AGC.archGroupId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = AGC.archGroupId),
		MP.LibraryId, (SELECT AliasName FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = MP.LibraryId),
		(SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = DPT.HostClientId),
		MP.MountPathName, MP.MediaSideId,
		(SELECT FreeBytesMB FROM MMMediaSide WITH (NOLOCK) WHERE MediaSideId = MP.MediaSideId), 0, 0, 0
FROM	(SELECT DISTINCT id, archGroupId,
CASE WHEN (dedupeFlags & 268435456) = 0 THEN name ELSE 'Global Deduplication' END AS name
		FROM	archGroupCopy WITH (NOLOCK)
INNER JOIN archCopySIDBStore CS ON id = CS.copyId AND ((CS.Flags & 4) > 0)
WHERE	((dedupeFlags & 262144) > 0) AND (dedupeFlags & 134217728) = 0
			AND (@i_includeAllCopies = 1 OR CS.SIDBStoreId IN (SELECT SIDBStoreId FROM #StoreFilter))) AGC,
		MMDataPath DPT WITH (NOLOCK), MMDrivePool DPL WITH (NOLOCK), MMS2getMountPathNameGUIView MP
WHERE	DPT.CopyId = AGC.id
	AND DPL.DrivePoolId = DPT.DrivePoolId
	AND MP.MasterPoolId = DPL.MasterPoolId
	AND (@i_includeAllLibraries = 1 OR MP.LibraryId IN (SELECT LibraryId FROM #LibraryFilter))
INSERT	INTO #DedupedJobSize
SELECT	V.MediaSideId, ACM.jobId, ACM.commCellId, S.CopyId, V.SIDBStoreId, SUM(ACM.dedupedSize), 0
FROM	MMVolume V WITH (NOLOCK)
		INNER JOIN #StoreToCopy S
			ON S.SIDBStoreId = V.SIDBStoreId
		INNER JOIN archChunk AC WITH (NOLOCK)
			ON AC.volumeId = V.VolumeID AND V.SIDBStoreId > 0
		INNER JOIN archChunkMapping ACM WITH (NOLOCK)
			ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
WHERE	(@i_includeAllCopies = 1 OR V.SIDBStoreId IN (SELECT SIDBStoreId FROM #StoreFilter))
	AND (@i_includeAllLibraries = 1 OR V.MediaSideId IN (SELECT MediaSideId FROM #MediaSideFilter))
GROUP BY V.MediaSideId, ACM.jobId, ACM.commCellId, S.CopyId, V.SIDBStoreId
UPDATE	#DedupedJobSize
SET		AppSize = B.totalUncompBytes
FROM	JMBkpStats B WITH (NOLOCK)
WHERE	B.jobId = #DedupedJobSize.JobId AND B.commCellId = #DedupedJobSize.CommCellId
UPDATE	#DedupedJobSize
SET		AppSize = A.uncompBytes
FROM	JMAdminJobStatsTable A WITH (NOLOCK)
WHERE	A.jobId = #DedupedJobSize.JobId AND A.commCellId = #DedupedJobSize.CommCellId
UPDATE	#DedupedJobSize
SET		AppSize = (1.0*DataWritten/T.JobSizeOnMedia)*AppSize
FROM	(SELECT	JobId, CommCellId, CopyId, SIDBStoreId, SUM(DataWritten) AS JobSizeOnMedia, COUNT(MediaSideId) AS NumOfMediaSide
		FROM	#DedupedJobSize
		GROUP BY JobId, CommCellId, CopyId, SIDBStoreId
		HAVING	SUM(DataWritten) > 0 AND COUNT(MediaSideId) > 1) T
WHERE	T.jobId = #DedupedJobSize.JobId AND T.commCellId = #DedupedJobSize.CommCellId AND T.CopyId = #DedupedJobSize.CopyId AND T.SIDBStoreId = #DedupedJobSize.SIDBStoreId
INSERT	INTO #DedupedAppSize
SELECT	MediaSideId, CopyId, SUM(DataWritten), SUM(AppSize), 0
FROM	#DedupedJobSize
GROUP BY MediaSideId, CopyId
UPDATE	#DedupedAppSize
SET		ToBeFreedAppBytes = T.ToBeFreedAppBytes
FROM	(SELECT MediaSideId, CopyId, SUM(ToBeFreedAppBytes) AS ToBeFreedAppBytes
		FROM	#ToBeFreedAppSize
		GROUP BY MediaSideId, CopyId) T
WHERE	#DedupedAppSize.MediaSideId = T.MediaSideId AND #DedupedAppSize.CopyId = T.CopyId
INSERT	INTO #StoreSummary
SELECT	CopyId, SIDBStoreId, SUM(DataWritten), SUM(AppSize), 0, 0, 0
FROM	#DedupedJobSize
GROUP BY CopyId, SIDBStoreId
UPDATE	#StoreSummary
SET		ToBeFreedAppBytes = T.ToBeFreedAppBytes
FROM	(SELECT	CopyId, SIDBStoreId, SUM(ToBeFreedAppBytes) AS ToBeFreedAppBytes
		FROM	#ToBeFreedAppSize
		GROUP BY CopyId, SIDBStoreId) T
WHERE	#StoreSummary.CopyId = T.CopyId AND #StoreSummary.SIDBStoreId = T.SIDBStoreId
UPDATE	#StoreSummary
SET		CreationTime = S.CreatedTime, SealedTime = S.SealedTime
FROM	IdxSIDBStore S
WHERE	#StoreSummary.SIDBStoreId = S.SIDBStoreId
DROP TABLE #DedupedJobSize
INSERT	INTO #SiloedDataSize
SELECT	V.MediaSideId, S.CopyId,
		ISNULL(SUM(CASE WHEN SiloStatus = 1 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END), 0),
		ISNULL(SUM(CASE WHEN SiloStatus IN (2, 3) THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END), 0)
FROM	MMVolume V WITH (NOLOCK)
		INNER JOIN #StoreToCopy S
			ON S.SIDBStoreId = V.SIDBStoreId AND V.SIDBStoreId > 0
WHERE	(@i_includeAllCopies = 1 OR V.SIDBStoreId IN (SELECT SIDBStoreId FROM #StoreFilter))
	AND (@i_includeAllLibraries = 1 OR V.MediaSideId IN (SELECT MediaSideId FROM #MediaSideFilter))
GROUP BY V.MediaSideId, S.CopyId
UPDATE	#DedupCopyDisk
SET		Application	= #DedupedAppSize.Application,
		DataWritten = #DedupedAppSize.DataWritten,
		ToBeFreedAppBytes = #DedupedAppSize.ToBeFreedAppBytes
FROM	#DedupedAppSize
WHERE	#DedupCopyDisk.MediaSideId = #DedupedAppSize.MediaSideId
	AND #DedupCopyDisk.CopyId = #DedupedAppSize.CopyId
INSERT	INTO #DedupCopyDiskAggr
SELECT	B.CopyId, B.CopyName, B.PolicyId, B.PolicyName,
		SUM(B.FreeSpaceMB), SUM(B.Application), SUM(B.ToBeFreedAppBytes), SUM(B.DataWritten), SUM(ISNULL(C.SiloedDataMB, 0)), SUM(ISNULL(C.ToBeSiloedMB, 0))
FROM	#DedupCopyDisk B
		LEFT OUTER JOIN #SiloedDataSize C
			ON C.MediaSideId = B.MediaSideId AND C.CopyId = B.CopyId
GROUP BY B.CopyId, B.CopyName, B.PolicyId, B.PolicyName
INSERT	INTO #DedupDiskLibAggr
SELECT	LibraryId, LibraryName, MediaAgentName, MountPathName, MediaSideId,
		SUM(FreeSpaceMB), SUM(Application), SUM(ToBeFreedAppBytes), SUM(DataWritten)
FROM	#DedupCopyDisk
GROUP BY LibraryId, LibraryName, MediaAgentName, MountPathName, MediaSideId
INSERT	INTO #CopySubStore
SELECT	C.CopyId, SS.SubStoreId, (SELECT name FROM APP_Client WHERE id = AP.ClientId), AP.Path,
		ISNULL(UH.PrimaryEntries, 0), ISNULL(UH.SecondaryEntries, 0), ISNULL(UH.AvgQITime, 0), ISNULL(UH.DataSizeToPrune, 0), ISNULL(UH.SizeOccupied, 0),
		(SELECT (CASE WHEN FreeDiskSpaceMB < 0 THEN 0 ELSE FreeDiskSpaceMB END) FROM IdxCache WHERE IdxCacheId = SS.IdxCacheId),
		AP.DiskFreeThresholdMB, AP.DiskFreeWarningThreshholdMB
FROM	#StoreToCopy C
		INNER JOIN IdxSIDBSubStore SS
			ON SS.SIDBStoreId = C.SIDBStoreId
		INNER JOIN IdxAccessPath AP
			ON AP.IdxAccessPathId = SS.IdxAccessPathId
		LEFT OUTER JOIN IdxSIDBUsageHistory UH
			ON UH.SIDBStoreId = SS.SIDBStoreId AND UH.SubStoreId = SS.SubStoreId AND UH.CommCellId = SS.CommCellId
		INNER JOIN (SELECT	SIDBStoreId, SubStoreId, CommCellId, MAX(ModifiedTime) AS LastModifiedTime
					FROM	IdxSIDBUsageHistory
					GROUP BY SIDBStoreId, SubStoreId, CommCellId) LM
			ON LM.SIDBStoreId = UH.SIDBStoreId AND LM.SubStoreId = UH.SubStoreId AND LM.CommCellId = UH.CommCellId AND LM.LastModifiedTime = UH.ModifiedTime
WHERE	(@i_includeAllCopies = 1 OR C.SIDBStoreId IN (SELECT SIDBStoreId FROM #StoreFilter))
CREATE	TABLE #CopyAppId (archGrpCopyId INT, appId INT)
CREATE	TABLE #AppBaselineSize (appId INT, baselineSize BIGINT)
INSERT	INTO #CopyAppId
SELECT	DISTINCT J.archGrpCopyId, J.appId
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN (SELECT	DISTINCT SS.CopyId
					FROM	archCopySIDBStore SS WITH (NOLOCK), #StoreToCopy C
					WHERE	SS.SIDBStoreId = C.SIDBStoreId) T
		ON J.archGrpCopyId = T.CopyId
WHERE	J.status = 100
INSERT	INTO #AppBaselineSize
SELECT	J.appId, J.totalBackupSize
FROM	JMBkpStats J WITH (NOLOCK) INNER JOIN
		(SELECT	B.appId, MAX(B.servStartDate) AS maxFullStartDate
		FROM	JMBkpStats B WITH (NOLOCK) INNER JOIN (SELECT DISTINCT appId FROM #CopyAppId) A ON B.appId = A.appId
		WHERE	B.bkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) AND B.status IN (1, 3, 14)
		GROUP BY B.appId) T ON J.appId = T.appId AND J.servStartDate = T.maxFullStartDate
INSERT	INTO #CopyBaselineSize
SELECT	archGrpCopyId, SUM(B.baselineSize)*1.2
FROM	#AppBaselineSize B INNER JOIN #CopyAppId C ON B.appId = C.appId
GROUP BY archGrpCopyId
DROP TABLE #CopyAppId
DROP TABLE #AppBaselineSize
DECLARE	@t_copyId		INT
DECLARE	@t_storeId		INT
DECLARE	@t_startTime	INT
DECLARE	@t_endTime		INT
DECLARE	@tmpStartTime	INT
DECLARE	@tmpEndTime		INT
DECLARE	@t_datetime		DATETIME
DECLARE	@t_interval		INT
DECLARE	@tblPeriod TABLE (CopyId INT, SIDBStoreId INT, StartTime INT, EndTime INT)
DECLARE	GrowthPeriodCursor CURSOR FOR
SELECT	C.CopyId, C.SIDBStoreId, MIN(UH.ModifiedTime), MAX(UH.ModifiedTime)
FROM	#StoreToCopy C
		INNER JOIN IdxSIDBUsageHistory UH ON UH.SIDBStoreId = C.SIDBStoreId
WHERE	(@i_includeAllCopies = 1 OR C.SIDBStoreId IN (SELECT SIDBStoreId FROM #StoreFilter)) AND UH.HistoryType = 1
GROUP BY C.CopyId, C.SIDBStoreId
ORDER BY C.CopyId
OPEN GrowthPeriodCursor
FETCH NEXT FROM GrowthPeriodCursor INTO @t_copyId, @t_storeId, @t_startTime, @t_endTime
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @t_interval = (@t_endTime - @t_startTime)/(24*3600)/10
	IF	@t_interval = 0 SET @t_interval = 1
	SET	@tmpEndTime = @t_endTime
	SET	@t_datetime	= dbo.getDateTime(@t_endTime)
	WHILE (@tmpEndTime >= @t_startTime)
	BEGIN
		SET	@t_datetime		= DATEADD(DAY, -@t_interval, @t_datetime)
		SET @tmpStartTime	= dbo.GetUnixTime(@t_datetime)
		INSERT	INTO @tblPeriod
		SELECT	@t_copyId, @t_storeId, @tmpStartTime, @tmpEndTime
		SET	@tmpEndTime = @tmpStartTime
	END
	FETCH NEXT FROM GrowthPeriodCursor INTO @t_copyId, @t_storeId, @t_startTime, @t_endTime
END
CLOSE GrowthPeriodCursor
DEALLOCATE GrowthPeriodCursor
DECLARE	@tblSubStoreGrowth TABLE (CopyId INT, EndTime INT, SubStoreId INT, Counts INT, UniqueBlocks BIGINT, AvgQITime BIGINT)
INSERT	INTO @tblSubStoreGrowth
SELECT	P.CopyId, P.EndTime, UH.SubStoreId, COUNT(*), SUM(UH.PrimaryEntries), SUM(UH.AvgQITime)
FROM	IdxSIDBUsageHistory UH INNER JOIN @tblPeriod P
	ON	UH.SIDBStoreId = P.SIDBStoreId AND UH.ModifiedTime > P.StartTime AND UH.ModifiedTime <= P.EndTime AND UH.HistoryType = 1
GROUP BY P.CopyId, P.EndTime, UH.SubStoreId
INSERT	INTO @tblSubStoreGrowth
SELECT	P.CopyId, P.EndTime, SS.SubStoreId, 1, 0, 0
FROM	@tblPeriod P
		INNER JOIN IdxSIDBSubStore SS ON SS.SIDBStoreId = P.SIDBStoreId
		LEFT OUTER JOIN @tblSubStoreGrowth G ON G.CopyId = P.CopyId AND G.EndTime = P.EndTime AND G.SubStoreId = SS.SubStoreId
WHERE	G.EndTime IS NULL
SELECT
    -- request
--    (SELECT
--    FOR XML PATH('req'), TYPE),
	@maxSIDBPrimaryRecords	AS '@primaryRecordsMax',
	@maxSIDBAverageQITime	AS '@averageQITimeMax',
	(SELECT	L.LibraryName		AS '@libraryName',
			L.Application		AS '@application',
			L.ToBeFreedAppBytes	AS '@toBeFreedAppBytes',
			L.DataWritten		AS '@dataWritten',
			L.FreeSpaceMB		AS '@freeSpaceMB',
			CASE WHEN (L.Application + L.ToBeFreedAppBytes) > L.DataWritten
				 THEN CAST(100.0*(L.Application + L.ToBeFreedAppBytes - L.DataWritten)/(L.Application + L.ToBeFreedAppBytes) AS DECIMAL(8,2)) ELSE 0 END
								AS '@dedupSaving',
			(SELECT A.MediaAgentName	AS '@mediaAgent',
					A.MountPathName		AS '@mountPathName',
					A.Application		AS '@application',
					A.ToBeFreedAppBytes	AS '@toBeFreedAppBytes',
					A.DataWritten		AS '@dataWritten',
					A.FreeSpaceMB		AS '@freeSpaceMB',
					CASE WHEN (A.Application + A.ToBeFreedAppBytes) > A.DataWritten
						 THEN CAST(100.0*(A.Application + A.ToBeFreedAppBytes - A.DataWritten)/(A.Application + A.ToBeFreedAppBytes) AS DECIMAL(8,2)) ELSE 0 END
										AS '@dedupSaving',
					(SELECT	B.PolicyName		AS '@policyName',
							B.CopyName			AS '@copyName',
							B.Application		AS '@application',
							B.ToBeFreedAppBytes	AS '@toBeFreedAppBytes',
							B.DataWritten		AS '@dataWritten',
							CASE WHEN (B.Application + B.ToBeFreedAppBytes) > B.DataWritten
								 THEN CAST(100.0*(B.Application + B.ToBeFreedAppBytes - B.DataWritten)/(B.Application + B.ToBeFreedAppBytes) AS DECIMAL(8,2)) ELSE 0 END
												AS '@dedupSaving',
							ISNULL(C.SiloedDataMB, 0)	AS '@dataMovedToSilo',
							ISNULL(C.ToBeSiloedMB, 0)	AS '@dataToBeMovedToSilo'
					FROM	#DedupCopyDisk B
							LEFT OUTER JOIN #SiloedDataSize C
								ON C.MediaSideId = B.MediaSideId AND C.CopyId = B.CopyId
					WHERE	B.MediaSideId = A.MediaSideId
					ORDER BY B.Application DESC
					FOR		XML PATH('diskCopyEntities'),TYPE)
			FROM	#DedupDiskLibAggr A
			WHERE	LibraryId = L.LibraryId
			ORDER BY A.Application DESC
			FOR XML PATH('diskEntities'),TYPE)
	FROM	(SELECT	LibraryId, LibraryName,
					SUM(FreeSpaceMB) AS FreeSpaceMB, SUM(Application) AS Application,
					SUM(ToBeFreedAppBytes) AS ToBeFreedAppBytes, SUM(DataWritten) AS DataWritten
			FROM	#DedupDiskLibAggr
			GROUP BY LibraryId, LibraryName) L
	ORDER BY L.Application DESC
	FOR XML PATH('librarySummary'),TYPE),
	(SELECT D.PolicyName		AS '@policyName',
			D.Application		AS '@application',
			D.ToBeFreedAppBytes	AS '@toBeFreedAppBytes',
			D.DataWritten		AS '@dataWritten',
			CASE WHEN (D.Application + D.ToBeFreedAppBytes) > D.DataWritten
				 THEN CAST(100.0*(D.Application + D.ToBeFreedAppBytes - D.DataWritten)/(D.Application + D.ToBeFreedAppBytes) AS DECIMAL(8,2)) ELSE 0 END
								AS '@dedupSaving',
			(SELECT A.PolicyName		AS '@policyName',
					A.CopyName			AS '@copyName',
					A.Application		AS '@application',
					ISNULL((SELECT baselineSize FROM #CopyBaselineSize WHERE copyId = A.CopyId), 0)
										AS '@baselineSize',
					A.ToBeFreedAppBytes	AS '@toBeFreedAppBytes',
					A.DataWritten		AS '@dataWritten',
					CASE WHEN (A.Application + A.ToBeFreedAppBytes) > A.DataWritten
						 THEN CAST(100.0*(A.Application + A.ToBeFreedAppBytes - A.DataWritten)/(A.Application + A.ToBeFreedAppBytes) AS DECIMAL(8,2)) ELSE 0 END
										AS '@dedupSaving',
					B.PrimaryEntries/B.Partitions AS '@primaryRecords',
					CAST(100.0*B.PrimaryEntries/@maxSIDBPrimaryRecords/B.Partitions AS DECIMAL(8,2))
										AS '@capacityMeter',
					B.AvgQITime/B.Partitions AS '@averageQITime',
					CAST(100.0*B.AvgQITime/@maxSIDBAverageQITime/B.Partitions AS DECIMAL(8,2))
										AS '@performanceMeter',
					A.SiloedDataMB		AS '@dataMovedToSilo',
					A.ToBeSiloedMB		AS '@dataToBeMovedToSilo',
					(SELECT MediaAgentName		AS '@mediaAgent',
							Path				AS '@partitionPath',
							SubStoreId			AS '@partitionNo',
							DedupDBSizeMB		AS '@dedupDBSizeMB',
							EstPruningSize		AS '@estimatedPruningSize',
							MinimumFreeSpaceMB	AS '@minimumFreeSpaceMB',
							FreeSpaceWarningMB	AS '@freeSpaceWarningMB',
							FreeDiskSpaceMB		AS '@freeDiskSpaceMB',
							CASE WHEN (DedupDBSizeMB + FreeDiskSpaceMB) > 0	THEN CAST(100.0*FreeDiskSpaceMB/(DedupDBSizeMB + FreeDiskSpaceMB) AS DECIMAL(8,2)) ELSE 0 END
												AS '@freeDiskSpaceMBPercent',
							CASE WHEN (DedupDBSizeMB + FreeDiskSpaceMB) > 0	THEN CAST(100.0*DedupDBSizeMB/(DedupDBSizeMB + FreeDiskSpaceMB) AS DECIMAL(8,2)) ELSE 0 END
												AS '@capacityMeter',
							AvgQITime			AS '@averageQITime',
							CAST(100.0*AvgQITime/@maxSIDBAverageQITime AS DECIMAL(8,2))
												AS '@averageQITimeMeter',
							PrimaryEntries		AS '@primaryRecords',
							CAST(100.0*PrimaryEntries/@maxSIDBPrimaryRecords AS DECIMAL(8,2))
												AS '@primaryRecordsMeter',
							SecondaryEntries	AS '@secondaryRecords',
							0					AS '@secondaryRecordsMeter',
							(SELECT	EndTime				AS '@date',
									UniqueBlocks/Counts	AS '@value'
							FROM	@tblSubStoreGrowth
							WHERE	CopyId = A.CopyId AND SubStoreId = S.SubStoreId
							ORDER	BY EndTime
							FOR XML PATH('capacityGrowthList'),TYPE),
							(SELECT	EndTime				AS '@date',
									AvgQITime/Counts	AS '@value'
							FROM	@tblSubStoreGrowth
							WHERE	CopyId = A.CopyId AND SubStoreId = S.SubStoreId
							ORDER	BY EndTime
							FOR XML PATH('avgQITimeGrowthList'),TYPE)
					FROM	#CopySubStore S
					WHERE	CopyId = A.CopyId
					ORDER BY SubStoreId
					FOR    XML PATH('storeEntities'),TYPE),
					(SELECT dbo.GetDateTimeFormatString(CreationTime + @bias, NULL, @dateFormat)
												AS '@creationTime',
							CASE WHEN SealedTime > 0 THEN dbo.GetDateTimeFormatString(SealedTime + @bias, NULL, @dateFormat) ELSE 'Active' END
												AS '@sealedTime',
							Application			AS '@application',
							ToBeFreedAppBytes	AS '@toBeFreedAppBytes',
							DataWritten			AS '@dataWritten',
							CASE WHEN (Application + ToBeFreedAppBytes) > DataWritten
								 THEN CAST(100.0*(Application + ToBeFreedAppBytes - DataWritten)/(Application + ToBeFreedAppBytes) AS DECIMAL(8,2)) ELSE 0 END
												AS '@dedupSaving'
					FROM	#StoreSummary
					WHERE	CopyId = A.CopyId
					ORDER BY CreationTime DESC
					FOR    XML PATH('storeSummary'),TYPE)
			FROM	#DedupCopyDiskAggr A,
					(SELECT	CopyId, SUM(PrimaryEntries) AS PrimaryEntries, SUM(AvgQITime) AS AvgQITime, COUNT(*) AS Partitions
					FROM	#CopySubStore
					GROUP BY CopyId) B
			WHERE	A.PolicyId = D.PolicyId AND B.CopyId = A.CopyId
			ORDER BY A.Application DESC
			FOR XML PATH('copyEntities'),TYPE)
	FROM	(SELECT	PolicyId, PolicyName, SUM(Application) AS Application, SUM(ToBeFreedAppBytes) AS ToBeFreedAppBytes, SUM(DataWritten) AS DataWritten
			FROM	#DedupCopyDiskAggr
			GROUP BY PolicyId, PolicyName) D
	ORDER BY D.Application DESC
	FOR XML PATH('policySummary'),TYPE),
    (SELECT AG.id		AS '@policyId',
            AG.name		AS '@policyName',
            AGC.id		AS '@copyId',
CASE WHEN (AGC.dedupeFlags & 268435456) = 0 THEN AGC.name ELSE 'Global Deduplication' END
						AS '@copyName'
		FROM	archGroup AG, archGroupCopy AGC
	WHERE	AG.id = AGC.archGroupId
AND AGC.SIDBStoreId > 0 AND (AGC.dedupeFlags & 134217728) = 0
	ORDER BY AG.name, AGC.name
	FOR XML PATH('copyList'), TYPE),
    (SELECT LibraryId	AS '@entityId',
            AliasName	AS '@entityName'
	FROM	MMLibrary
	WHERE	LibraryTypeId = 3
	ORDER BY AliasName
	FOR XML PATH('libraryList'),TYPE)
FOR XML PATH ('WebReport_DedupReportResp')
DROP TABLE #StoreToCopy
DROP TABLE #LibraryFilter
DROP TABLE #MediaSideFilter
DROP TABLE #StoreFilter
DROP TABLE #DedupCopyDisk
DROP TABLE #DedupedAppSize
DROP TABLE #SiloedDataSize
DROP TABLE #ToBeFreedAppSize
DROP TABLE #CopySubStore
DROP TABLE #DedupCopyDiskAggr
DROP TABLE #DedupDiskLibAggr
DROP TABLE #CopyBaselineSize
DROP TABLE #StoreSummary
GO

IF EXISTS (select * from GxQscripts where name = 'WR_DedupSummary')
	delete from GxQscripts where name = 'WR_DedupSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WR_DedupSummary')
	delete from GXDBVersions where aliasname = 'WR_DedupSummary'
GO

insert into GXDBVersions values(2, 'WR_DedupSummary',  '00010016008800030000', 'WR_DedupSummary', '00010016008800030000')
GO

