

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WR_ArraySnapSummary.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WR_ArraySnapSummary.sp,v $ $Id: WR_ArraySnapSummary.sp,v 1.6.48.2 2018/03/20 00:29:14 jiechen Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Jun Lu
-- Create date: 09/11/2010
-- Description:	generates Array and Snapshot Summary report
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WR_ArraySnapSummary <<<'

IF EXISTS (select * from sysobjects where name='WR_ArraySnapSummary')
	drop procedure WR_ArraySnapSummary
IF EXISTS (select * from GxQscripts where name='WR_ArraySnapSummary')
	delete from GxQscripts where name = 'WR_ArraySnapSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WR_ArraySnapSummary')
	delete from GXDBVersions where aliasname = 'WR_ArraySnapSummary'
GO
print '... Creating Procedure: WR_ArraySnapSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WR_ArraySnapSummary
  @i_req XML,
  @i_userId INT
AS
  DECLARE @o_ArraySnapSummary NVARCHAR(MAX);
SET NOCOUNT ON
DECLARE @i_reqModeFlags				INT
DECLARE @i_snapOrderBy				INT
DECLARE @i_groupBy					INT
DECLARE @i_includeAllSubclients		INT
DECLARE @i_subclientFilter			NVARCHAR(MAX)
DECLARE @i_includeAllArrays			INT
DECLARE @i_arrayFilter				NVARCHAR(MAX)
DECLARE @i_includeAllHosts			INT
DECLARE @i_hostFilter				NVARCHAR(MAX)
DECLARE @i_includeAllCopies			INT
DECLARE @i_copyFilter				NVARCHAR(MAX)
DECLARE @i_arrayVolumeId			INT
DECLARE @i_startTime				INT
DECLARE @i_endTime					INT
DECLARE @i_pageSize					INT
DECLARE @i_pageNo					INT
DECLARE @i_snapSortColumnNo			INT
DECLARE @i_snapSortOrder			INT
DECLARE @i_localeId					INT
SET @i_reqModeFlags					= @i_req.value('/WebReport_ArraySnapReportReq[1]/@reqModeFlags', 'int')
SET @i_snapOrderBy					= @i_req.value('/WebReport_ArraySnapReportReq[1]/@snapOrderBy', 'int')
SET @i_groupBy						= @i_req.value('/WebReport_ArraySnapReportReq[1]/@groupBy', 'int')
SET @i_includeAllSubclients			= @i_req.value('/WebReport_ArraySnapReportReq[1]/@includeAllSubclients', 'int')
SET @i_subclientFilter				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@subclientFilter', 'nvarchar(2000)')
SET @i_includeAllArrays				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@includeAllArrays', 'int')
SET @i_arrayFilter					= @i_req.value('/WebReport_ArraySnapReportReq[1]/@arrayFilter', 'nvarchar(2000)')
SET @i_includeAllHosts				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@includeAllHosts', 'int')
SET @i_hostFilter					= @i_req.value('/WebReport_ArraySnapReportReq[1]/@hostFilter', 'nvarchar(2000)')
SET @i_includeAllCopies				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@includeAllCopies', 'int')
SET @i_copyFilter					= @i_req.value('/WebReport_ArraySnapReportReq[1]/@copyFilter', 'nvarchar(2000)')
SET @i_arrayVolumeId				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@arrayVolumeId', 'int')
SET @i_startTime					= @i_req.value('/WebReport_ArraySnapReportReq[1]/@startTime', 'int')
SET @i_endTime						= @i_req.value('/WebReport_ArraySnapReportReq[1]/@endTime', 'int')
SET @i_pageSize						= @i_req.value('/WebReport_ArraySnapReportReq[1]/@pageSize', 'int')
SET @i_pageNo						= @i_req.value('/WebReport_ArraySnapReportReq[1]/@pageNo', 'int')
SET @i_snapSortColumnNo				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@snapSortColumnNo', 'int')
SET @i_snapSortOrder				= @i_req.value('/WebReport_ArraySnapReportReq[1]/@snapSortOrder', 'int')
SET @i_localeId						= @i_req.value('/WebReport_ArraySnapReportReq[1]/localeId[1]/@localeId', 'int')
DECLARE @userPreferences xml = (SELECT value FROM UMUserWebPrefs WITH (NOLOCK) WHERE userId = @i_userId)
IF	@userPreferences IS NOT NULL
BEGIN
	IF	@i_pageSize IS NULL
		SET @i_pageSize = ISNULL(@userPreferences.value('/Common_CVUserPreferences[1]/@rowsPerPage', 'int'), 20)
END
IF	@i_pageSize IS NULL
	SET @i_pageSize = 20
DECLARE	@l_endTime	INT
IF	@i_endTime = 0
	SET @l_endTime = dbo.getUnixTime(GETUTCDATE())
ELSE
	SET @l_endTime = @i_endTime
DECLARE @totalSnaps	INT = 0
DECLARE @pageStart	INT = 0
SET	@pageStart  = @i_pageNo * @i_pageSize
CREATE TABLE #SubclientFilter
(
	commCellId          INT,
	groupId             INT,
	clientId            INT,
	appTypeId           INT,
	instanceId          INT,
	backupsetId         INT,
	subclientId         INT,
	logDeletedClient    INT,
	logDeletedSubclient INT
)
DECLARE	@TblArrayFilter	TABLE (id INT, name NVARCHAR(128))
DECLARE	@TblHostFilter	TABLE (id INT, name NVARCHAR(1024))
DECLARE	@TblCopyFilter	TABLE (policyId INT, policyName NVARCHAR(1024), copyId INT, copyName NVARCHAR(1024))
DECLARE	@TblArrayHostVolume	TABLE (
		ArrayId INT, ControlHostId INT, HostClientId INT, SnapShotEngineName NVARCHAR(1024),
		ArrayVolumeId INT, ArrayVolumeName NVARCHAR(1024), VolumeTotalSpaceMB BIGINT, VolumeFreeSpaceMB BIGINT,
		LunCount INT, SnapshotCount INT, SnapJobCount INT, SnapSizeMB BIGINT)
DECLARE	@TblAppVolume	TABLE (
		AppTypeId INT, SourceClientId INT, ArrayVolumeId INT, SnapJobCount INT, SnapshotCount INT, SnapSizeMB BIGINT)
DECLARE	@TblCopyVolume	TABLE (
		CopyId INT, ArrayVolumeId INT, SnapJobCount INT, SnapshotCount INT, SnapSizeMB BIGINT)
DECLARE	@TblSnapCopy	TABLE (
		policyId INT, policyName NVARCHAR(1024), copyId INT, copyName NVARCHAR(1024), copyType INT)
DECLARE @TblArrayHost	TABLE (
		ArrayId INT, ArrayName NVARCHAR(1024), SnapshotEngineName NVARCHAR(1024), ControlHostId INT, ControlHostClientId INT, ControlHostName NVARCHAR(1024))
CREATE TABLE #SnapshotPage (
		sourceClientName NVARCHAR(1024), sourcePath NVARCHAR(1024), appTypeName NVARCHAR(1024), snapName NVARCHAR(1024),
		snapStatus INT, snapCreationTime INT, snapSizeMB BIGINT, jobId INT, jobStartTime INT, jobEndTime INT, jobAgingTime BIGINT, movedToTape INT,
		arrayName NVARCHAR(1024), volumeName NVARCHAR(1024), snapEngineName NVARCHAR(1024), controlHostName NVARCHAR(1024),
		policyName NVARCHAR(1024), copyName NVARCHAR(1024), copyType INT)
-- 1 -- get summary
IF	(@i_reqModeFlags & 1) > 0
BEGIN
	-- Tab 1: Summary by Array
	-- Tab 2: Summary by Control Host
	INSERT	INTO @TblArrayHostVolume
	SELECT	M.ArrayId, H.ControlHostId, H.ClientId, H.SnapShotEngineName,
			V.Id, V.Name, V.TotalSpaceMB, V.FreeSpaceMB,
			0, 0, 0, 0
	FROM	SMArray A
			INNER JOIN SMArrayCtrlHostMap M WITH (NOLOCK) ON M.ArrayId = A.Id
			INNER JOIN SMControlHost H WITH (NOLOCK) ON H.ControlHostId = M.ControlHostId
			INNER JOIN SMArrayVolume V WITH (NOLOCK) ON V.ClientId = H.ClientId
	UPDATE	@TblArrayHostVolume
	SET		SnapshotCount = B.SnapshotCount, SnapJobCount = B.SnapJobCount, SnapSizeMB = B.SnapSizeMB
	FROM	@TblArrayHostVolume A,
			(SELECT	S.ArrayVolumeId, COUNT(DISTINCT S.SMSnapId) AS SnapshotCount,
					COUNT(DISTINCT V.jobId) AS SnapJobCount, SUM(S.UsedSpaceBytes)/1024/1024 AS SnapSizeMB
			FROM	@TblArrayHostVolume T
					INNER JOIN SMSnap S WITH (NOLOCK) ON S.ArrayVolumeId = T.ArrayVolumeId
					INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
					INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
			GROUP BY S.ArrayVolumeId) AS B
	WHERE	A.ArrayVolumeId = B.ArrayVolumeId
	UPDATE	@TblArrayHostVolume
	SET		LunCount = B.LunCount
	FROM	@TblArrayHostVolume A,
			(SELECT	L.ArrayVolumeId, COUNT(DISTINCT L.id) AS LunCount
			FROM	@TblArrayHostVolume T
					INNER JOIN SMLUN AS L WITH (NOLOCK)
						ON L.ArrayVolumeId = T.ArrayVolumeId
			GROUP BY L.ArrayVolumeId) B
	WHERE	A.ArrayVolumeId = B.ArrayVolumeId
	-- Tab 3: Summary by Application
	INSERT	INTO @TblAppVolume
	SELECT	V.AppTypeId,
			CASE V.AppTypeId WHEN 13 THEN V.OriginClientId ELSE V.SourceClientId END,
			S.ArrayVolumeId,
			COUNT (DISTINCT V.JobId),
			COUNT(S.SMSnapId),
			SUM(S.UsedSpaceBytes)/1024/1024
	FROM	SMSnap S WITH (NOLOCK)
			INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
			INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
	GROUP BY V.AppTypeId, CASE V.AppTypeId WHEN 13 THEN V.OriginClientId ELSE V.SourceClientId END, S.ArrayVolumeId
	-- Tab 4: Summary by Storage Policy Copy
	INSERT	INTO @TblSnapCopy
	SELECT	AG.id, AG.name, AGC.id, AGC.name, case when AGC.id = AG.defaultSnapCopy then 0 when AGC.isMirrorCopy = 0 then 1 else 2 end
	FROM	archGroupCopy AGC WITH (NOLOCK)
			INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = AGC.archGroupId AND AGC.isSnapCopy = 1
	INSERT	INTO @TblCopyVolume
	SELECT	V.CopyId,
			S.ArrayVolumeId,
			COUNT (DISTINCT V.JobId),
			COUNT(S.SMSnapId),
			SUM(S.UsedSpaceBytes)/1024/1024
	FROM	SMSnap S WITH (NOLOCK)
			INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
			INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
	GROUP BY V.CopyId, S.ArrayVolumeId
END
-- 2 -- get snapshot list for Snapshot Details
IF	(@i_reqModeFlags & 4) > 0
BEGIN
	CREATE TABLE #SnapshotList (
			jobId INT, commCellId INT, copyId INT, appId INT, sourceClientId INT, sourcePath NVARCHAR(1024),
			snapName NVARCHAR(1024), snapStatus INT, snapCreationTime INT, snapSizeMB BIGINT, arrayVolumeId INT,
			arrayName NVARCHAR(1024), controlHostName NVARCHAR(1024), snapEngineName NVARCHAR(1024))
	CREATE TABLE #snapJobList (
			jobId INT, commCellId INT, appId INT, appTypeId INT, jobStartTime INT, jobEndTime INT, jobStatus INT,
			archGrpId INT, archGrpCopyId INT, retentionFlags INT, retentionDays BIGINT, pinEndTime BIGINT, movedToTape INT)
	CREATE TABLE #copyBasicAging (copyId INT, retentionDays BIGINT, flags INT, jobBasedAging INT)
	IF	@i_includeAllSubclients = 0
	BEGIN
		EXEC wr_UserCellSelection @i_userId, N'#SubclientFilter', 0, 1, 1, N'WebReport_ReportEntities', @i_subclientFilter
		DELETE  #SubclientFilter
		WHERE	(groupId = 0 AND @i_groupBy = 4)
			OR  (groupId <> 0 AND @i_groupBy <> 4)
	END
	DECLARE @filterHandle	INT
	IF	@i_includeAllArrays = 0
	BEGIN
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_arrayFilter
		INSERT	INTO @tblArrayFilter
		SELECT	id, name
		FROM	OPENXML (@filterHandle, 'WebReport_MediaReportFilter/entities', 1)
		WITH(	id			INT				'@entityId',
				name		NVARCHAR(255)	'@entityName' )
	END
	IF	@i_includeAllHosts = 0
	BEGIN
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_hostFilter
		INSERT	INTO @tblHostFilter
		SELECT	id, name
		FROM	OPENXML (@filterHandle, 'WebReport_MediaReportFilter/entities', 1)
		WITH(	id			INT				'@entityId',
				name		NVARCHAR(255)	'@entityName' )
	END
	IF	@i_includeAllCopies = 0
	BEGIN
		EXEC sp_xml_preparedocument @filterHandle OUTPUT, @i_copyFilter
		INSERT	INTO @tblCopyFilter
		SELECT	policyId, policyName, copyId, copyName
		FROM	OPENXML (@filterHandle, 'WebReport_StoragePolicyCopyFilter/entities', 1)
		WITH(	policyId	INT				'@policyId',
				policyName	NVARCHAR(255)	'@policyName',
				copyId		INT				'@copyId',
				copyName	NVARCHAR(255)	'@copyName' )
		INSERT	INTO @tblCopyFilter
		SELECT	T.policyId, T.policyName, C.id, C.name
		FROM	@tblCopyFilter T, archGroupCopy C WITH (NOLOCK)
		WHERE	T.copyId = 0 AND C.archGroupId = T.policyId AND C.isSnapCopy = 1
		DELETE	FROM @tblCopyFilter WHERE copyId = 0
	END
	INSERT	INTO @TblArrayHost
	SELECT	A.Id, A.ArrayName, H.SnapshotEngineName, H.ControlHostId, H.ClientId, CL.name
	FROM	SMArray A WITH (NOLOCK)
			INNER JOIN SMArrayCtrlHostMap M WITH (NOLOCK) ON M.ArrayId = A.Id
			INNER JOIN SMControlHost H WITH (NOLOCK) ON H.ControlHostId = M.ControlHostId
			INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = H.ClientId
	WHERE	(@i_includeAllArrays = 1 OR M.ArrayId IN (SELECT id FROM @TblArrayFilter))
		AND (@i_includeAllHosts = 1 OR H.ClientId IN (SELECT id FROM @TblHostFilter))
	IF @i_includeAllArrays = 0 AND EXISTS (SELECT * FROM @TblArrayFilter)
	OR @i_includeAllHosts = 0 AND EXISTS (SELECT * FROM @TblHostFilter)
	OR @i_arrayVolumeId > 0
		INSERT	INTO #snapshotList
		SELECT	DISTINCT V.jobId, V.commCellId, V.CopyId, V.appId, V.SourceClientId, V.SourcePath,
				S.UniqueIdentifier, S.SnapStatus, S.CreationTime, S.UsedSpaceBytes/1024/1024, S.ArrayVolumeId,
				H.ArrayName, H.ControlHostName, H.SnapshotEngineName
		FROM	@TblArrayHost H
				INNER JOIN SMSnap S WITH (NOLOCK) ON S.ControlHostId = H.ControlHostId AND (@i_arrayVolumeId = 0 OR S.arrayVolumeId = @i_arrayVolumeId)
				INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
				INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
	ELSE
	IF @i_includeAllSubclients = 0 AND EXISTS (SELECT * FROM #SubclientFilter)
		INSERT	INTO #snapJobList
		SELECT	DISTINCT B.jobId, B.commCellId, B.appId, B.appType, B.servStartDate, B.servEndDate, B.status,
				J.archGrpId, J.archGrpCopyId, J.retentionFlags,  0, (case when (J.disabled & 2 = 0) then 0 else J.manualRetentionEndTime end), 0
		FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK), #SubclientFilter T
		WHERE	B.appId = T.subclientId
			AND B.servStartDate >= @i_startTime AND B.servStartDate < @l_endTime
			AND B.opType IN (59, 65) AND B.status IN (1, 3, 14) AND B.dataStatus = 0
			AND J.jobId = B.jobId AND J.commCellId = B.commCellId
			AND J.dataType IN (1, 4) AND J.status = 100 AND (J.disabled & 256) = 0
	ELSE
 	IF @i_includeAllCopies = 0 AND EXISTS (SELECT * FROM @TblCopyFilter)
		INSERT	INTO #snapJobList
		SELECT	DISTINCT B.jobId, B.commCellId, B.appId, B.appType, B.servStartDate, B.servEndDate, B.status,
				J.archGrpId, J.archGrpCopyId, J.retentionFlags,  0, (case when (J.disabled & 2 = 0) then 0 else J.manualRetentionEndTime end), 0
		FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK), @TblCopyFilter T
		WHERE	J.archGrpCopyId = T.copyId
			AND J.dataType IN (1, 4) AND J.status = 100 AND (J.disabled & 256) = 0
			AND B.jobId = J.jobId AND B.commCellId = J.commCellId
			AND B.servStartDate >= @i_startTime AND B.servStartDate < @l_endTime
			AND B.opType IN (59, 65) AND B.status IN (1, 3, 14) AND B.dataStatus = 0
	ELSE
		INSERT	INTO #snapJobList
		SELECT	DISTINCT B.jobId, B.commCellId, B.appId, B.appType, B.servStartDate, B.servEndDate, B.status,
				J.archGrpId, J.archGrpCopyId, J.retentionFlags,  0, (case when (J.disabled & 2 = 0) then 0 else J.manualRetentionEndTime end), 0
		FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK)
		WHERE	B.jobId = J.jobId AND B.commCellId = J.commCellId
			AND B.servStartDate >= @i_startTime AND B.servStartDate < @l_endTime
			AND B.opType IN (59, 65) AND B.status IN (1, 3, 14) AND B.dataStatus = 0
			AND J.dataType IN (1, 4) AND J.status = 100 AND (J.disabled & 256) = 0
	IF NOT EXISTS (SELECT * FROM #snapJobList)
		INSERT	INTO #snapJobList
		SELECT	DISTINCT B.jobId, B.commCellId, B.appId, B.appType, B.servStartDate, B.servEndDate, B.status,
				J.archGrpId, J.archGrpCopyId, J.retentionFlags,  0, (case when (J.disabled & 2 = 0) then 0 else J.manualRetentionEndTime end), 0
		FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK), #snapshotList T
		WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = T.CopyId
			AND J.dataType IN (1, 4) AND J.status = 100 AND (J.disabled & 256) = 0
			AND B.jobId = J.jobId AND B.commCellId = J.commCellId
			AND B.servStartDate >= @i_startTime AND B.servStartDate < @l_endTime
			AND B.opType IN (59, 65) AND B.status IN (1, 3, 14) AND B.dataStatus = 0
	IF NOT EXISTS (SELECT * FROM #snapshotList)
		INSERT	INTO #snapshotList
		SELECT	V.jobId, V.commCellId, V.CopyId, V.appId, V.SourceClientId, V.SourcePath,
				S.UniqueIdentifier, S.SnapStatus, S.CreationTime, S.UsedSpaceBytes/1024/1024, S.ArrayVolumeId,
 				H.ArrayName, H.ControlHostName, H.SnapshotEngineName
		FROM	#snapJobList T
				INNER JOIN SMVolume V WITH (NOLOCK) ON V.jobId = T.jobId AND V.commCellId = T.commCellId AND V.CopyId = T.archGrpCopyId
				INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMVolumeId = V.SMVolumeId
				INNER JOIN SMSnap S WITH (NOLOCK) ON S.SMSnapId = M.SMSnapId
				INNER JOIN @TblArrayHost H ON H.ControlHostId = S.ControlHostId
	UPDATE	#snapJobList
	SET		movedToTape = (case when J.materializationStatus = 100 then 1
								when J.materializationStatus in (102, 103) AND J.disabled = 0 then 2
								when J.materializationStatus = 101 AND J.disabled = 0 then 3
							end)
	FROM	#snapJobList T, JMJobSnapshotStats J WITH (NOLOCK)
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.materializationStatus = 100
	-- set snap job retentionDays
	UPDATE	#snapJobList
	SET		retentionFlags = (
			case
			when retentionFlags & (64|4096) <> 0 then 64
			when retentionFlags & (32|2048) <> 0 then 32
			when retentionFlags & (16|1024) <> 0 then 16
			when retentionFlags & (8 | 512) <> 0 then 8
			when retentionFlags & (4 | 256) <> 0 then 4
			when retentionFlags & (524288 | 8388608) <> 0 then 524288
			when retentionFlags & (262144 | 4194304) <> 0 then 262144
			when retentionFlags & 2 <> 0 then 2
			end)
	WHERE	retentionFlags <> 0
	INSERT	INTO #copyBasicAging
	SELECT	AR.copyId, AR.retentionDays, AR.flags, CASE WHEN ((AR.flags & 128) > 0 AND AR.retentionJobs > 0) THEN 1 ELSE 0 END	--AM_AGING_FLAGS_JOB_BASED_RETENTION
	FROM	archAgingRule AR WITH (NOLOCK),
			(SELECT	DISTINCT archGrpCopyId FROM #snapJobList) T
	WHERE	AR.copyId = T.archGrpCopyId
	UPDATE	#snapJobList
	SET		retentionDays = b.retentionDays
	FROM	#snapJobList a, #copyBasicAging b
	WHERE	b.copyId = a.archGrpCopyId
	UPDATE	#snapJobList
	SET		retentionDays = b.retentionDays
	FROM	#snapJobList a,
			(SELECT AR.copyId, AR.retentionRule, AR.retentionDays
			FROM	archAgingRuleExtended AR WITH (NOLOCK), #copyBasicAging T
			WHERE	AR.copyId = T.copyId) b
	WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.retentionFlags
		AND (b.retentionDays < 0 OR b.retentionDays > a.retentionDays)
	UPDATE	#snapJobList
	SET		retentionDays = -2
	FROM	#snapJobList a, #copyBasicAging b
	WHERE	b.copyId = a.archGrpCopyId AND b.jobBasedAging = 1
		AND a.appTypeId NOT IN (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE ignoreJobRetention = 1)
	SELECT	@totalSnaps = COUNT(*) FROM #snapshotList
	IF	@i_snapSortOrder = 0
		INSERT	INTO #SnapshotPage
		SELECT	TOP (@i_pageSize) B.sourceClientName, B.sourcePath, B.appTypeName, B.snapName, B.snapStatus, B.snapCreationTime, B.snapSizeMB,
				B.jobId, B.jobStartTime, B.jobEndTime, B.jobAgingTime, B.movedToTape, B.arrayName, B.volumeName, B.snapEngineName, B.controlHostName,
				B.policyName, B.copyName, B.copyType
		FROM (  SELECT  ROW_NUMBER() OVER (ORDER BY
				CASE	@i_snapSortColumnNo
						WHEN 1	THEN A.sourceClientName
						WHEN 2	THEN A.sourcePath
						WHEN 3	THEN A.appTypeName
						WHEN 4	THEN A.snapName
						WHEN 5	THEN A.snapStatus
						WHEN 12 THEN A.movedToTape
						WHEN 13	THEN A.arrayName
						WHEN 14	THEN A.volumeName
						WHEN 15	THEN A.snapEngineName
						WHEN 16	THEN A.controlHostName
						WHEN 17	THEN A.policyName
						WHEN 18	THEN A.copyName
						WHEN 19 THEN A.copyType
				END ASC,
				CASE	@i_snapSortColumnNo
						WHEN 6	THEN A.snapCreationTime
						WHEN 7	THEN A.snapSizeMB
						WHEN 8	THEN A.jobId
						WHEN 9	THEN A.jobStartTime
						WHEN 10	THEN A.jobEndTime
						WHEN 11	THEN A.jobAgingTime
				END ASC,
				A.jobId ASC) AS __rowNumber, *
				FROM (	SELECT	CL.name				AS sourceClientName,
								S.sourcePath		AS sourcePath,
								IDA.name			AS appTypeName,
								S.snapName			AS snapName,
								dbo.GetJobStatusString(@i_localeId, S.snapStatus)	AS snapStatus,
								S.snapCreationTime	AS snapCreationTime,
								S.snapSizeMB		AS snapSizeMB,
								J.jobId				AS jobId,
								J.jobStartTime		AS jobStartTime,
								J.jobEndTime		AS jobEndTime,
								case when J.retentionDays < 0 then J.retentionDays
									 when J.pinEndTime < 0 OR J.pinEndTime > (J.jobStartTime + J.retentionDays*86400) then J.pinEndTime
									 else (J.jobStartTime + J.retentionDays*86400)
								end					AS jobAgingTime,
								case J.movedToTape  when 1	then dbo.WR_TranslateString(@i_localeId, 0, N'Moved')
													when 2	then dbo.WR_TranslateString(@i_localeId, 0, N'Partial')
													when 3	then dbo.WR_TranslateString(@i_localeId, 0, N'To be moved')
															else dbo.WR_TranslateString(@i_localeId, 0, N'No')
								end					AS movedToTape,
								S.arrayName			AS arrayName,
								V.Name				AS volumeName,
								S.snapEngineName	AS snapEngineName,
								S.controlHostName	AS controlHostName,
								AG.name				AS policyName,
								AGC.name			AS copyName,
								case when AGC.id = AG.defaultSnapCopy then dbo.WR_TranslateString(@i_localeId, 0, N'Snap Primary')
									when AGC.isMirrorCopy = 0 then dbo.WR_TranslateString(@i_localeId, 0, N'Snap Vault')
									else dbo.WR_TranslateString(@i_localeId, 0, N'Snap Mirror')
								end					AS copyType
						FROM	#snapshotList S
								INNER JOIN #snapJobList J ON J.jobId = S.jobId AND J.commCellId = S.commCellId
								INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = S.SourceClientId
								INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = J.appTypeId
								INNER JOIN SMArrayVolume V WITH (NOLOCK) ON V.Id = S.ArrayVolumeId
								INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = J.archGrpId
								INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = J.archGrpCopyId
					) A
				) B
		WHERE B.__rowNumber > @pageStart
	ELSE
		INSERT	INTO #SnapshotPage
		SELECT	TOP (@i_pageSize) B.sourceClientName, B.sourcePath, B.appTypeName, B.snapName, B.snapStatus, B.snapCreationTime, B.snapSizeMB,
				B.jobId, B.jobStartTime, B.jobEndTime, B.jobAgingTime, B.movedToTape, B.arrayName, B.volumeName, B.snapEngineName, B.controlHostName,
				B.policyName, B.copyName, B.copyType
		FROM (  SELECT  ROW_NUMBER() OVER (ORDER BY
				CASE	@i_snapSortColumnNo
						WHEN 1	THEN A.sourceClientName
						WHEN 2	THEN A.sourcePath
						WHEN 3	THEN A.appTypeName
						WHEN 4	THEN A.snapName
						WHEN 5	THEN A.snapStatus
						WHEN 12 THEN A.movedToTape
						WHEN 13	THEN A.arrayName
						WHEN 14	THEN A.volumeName
						WHEN 15	THEN A.snapEngineName
						WHEN 16	THEN A.controlHostName
						WHEN 17	THEN A.policyName
						WHEN 18	THEN A.copyName
						WHEN 19 THEN A.copyType
				END DESC,
				CASE	@i_snapSortColumnNo
						WHEN 6	THEN A.snapCreationTime
						WHEN 7	THEN A.snapSizeMB
						WHEN 8	THEN A.jobId
						WHEN 9	THEN A.jobStartTime
						WHEN 10	THEN A.jobEndTime
						WHEN 11	THEN A.jobAgingTime
				END DESC,
				A.jobId DESC) AS __rowNumber, *
				FROM (	SELECT	CL.name				AS sourceClientName,
								S.sourcePath		AS sourcePath,
								IDA.name			AS appTypeName,
								S.snapName			AS snapName,
								dbo.GetJobStatusString(@i_localeId, S.snapStatus)	AS snapStatus,
								S.snapCreationTime	AS snapCreationTime,
								S.snapSizeMB		AS snapSizeMB,
								J.jobId				AS jobId,
								J.jobStartTime		AS jobStartTime,
								J.jobEndTime		AS jobEndTime,
								case when J.retentionDays < 0 then J.retentionDays
									 when J.pinEndTime < 0 OR J.pinEndTime > (J.jobStartTime + J.retentionDays*86400) then J.pinEndTime
									 else (J.jobStartTime + J.retentionDays*86400)
								end					AS jobAgingTime,
								case J.movedToTape  when 1	then dbo.WR_TranslateString(@i_localeId, 0, N'Moved')
													when 2	then dbo.WR_TranslateString(@i_localeId, 0, N'Partial')
													when 3	then dbo.WR_TranslateString(@i_localeId, 0, N'To be moved')
															else dbo.WR_TranslateString(@i_localeId, 0, N'No')
								end					AS movedToTape,
								S.arrayName			AS arrayName,
								V.Name				AS volumeName,
								S.snapEngineName	AS snapEngineName,
								S.controlHostName	AS controlHostName,
								AG.name				AS policyName,
								AGC.name			AS copyName,
								case when AGC.id = AG.defaultSnapCopy then dbo.WR_TranslateString(@i_localeId, 0, N'Snap Primary')
									 when AGC.isMirrorCopy = 0 then dbo.WR_TranslateString(@i_localeId, 0, N'Snap Vault')
									 else dbo.WR_TranslateString(@i_localeId, 0, N'Snap Mirror')
								end					AS copyType
						FROM	#snapshotList S
								INNER JOIN #snapJobList J ON J.jobId = S.jobId AND J.commCellId = S.commCellId
								INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = S.SourceClientId
								INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = J.appTypeId
								INNER JOIN SMArrayVolume V WITH (NOLOCK) ON V.Id = S.ArrayVolumeId
								INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = J.archGrpId
								INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = J.archGrpCopyId
					) A
				) B
		WHERE B.__rowNumber > @pageStart
	DROP TABLE #SnapshotList
	DROP TABLE #SnapJobList
	DROP TABLE #copyBasicAging
END
-- 3 -- fill the filters
IF	(@i_reqModeFlags & 2) > 0
BEGIN
	IF	NOT EXISTS (SELECT id FROM @tblArrayFilter)
		INSERT	INTO @tblArrayFilter
		SELECT	Id, ArrayName
		FROM	SMArray WITH (NOLOCK)
		ORDER BY ArrayName
	IF	NOT EXISTS (SELECT id FROM @tblHostFilter)
		INSERT	INTO @tblHostFilter
		SELECT	CL.id, CL.name
		FROM	SMControlHost CH WITH (NOLOCK), APP_Client CL WITH (NOLOCK)
		WHERE	CL.id = CH.ClientId AND CH.ControlHostId > 0
		ORDER BY CL.name
	IF	NOT EXISTS (SELECT * FROM @tblCopyFilter)
		INSERT	INTO @tblCopyFilter
		SELECT	AG.id, AG.name, AGC.id, AGC.name
		FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id > 1 AND AG.type <> 4
			AND AGC.archGroupId = AG.id AND AGC.isSnapCopy = 1
		ORDER BY AG.name, AGC.name
END
SELECT
    -- request
    (SELECT @i_userId					AS '@userId',
            @i_localeId					AS '@localeId',
            @i_reqModeFlags				AS '@reqModeFlags',
            @i_snapOrderBy				AS '@snapOrderBy',
            @i_startTime				AS '@startTime',
            @i_endTime					AS '@endTime',
            (SELECT @i_includeAllArrays AS '@includeAll',
                (SELECT id				AS '@entityId',
                        name			AS '@entityName'
                 FROM   @tblArrayFilter
                 ORDER BY name
                 FOR XML PATH('entities'), TYPE)
            FOR XML PATH('arrayFilter'), TYPE),
            (SELECT @i_includeAllHosts AS '@includeAll',
                (SELECT id				AS '@entityId',
                        name			AS '@entityName'
                 FROM   @tblHostFilter
                 ORDER BY name
				 FOR XML PATH('entities'), TYPE)
            FOR XML PATH('hostFilter'), TYPE),
            (SELECT @i_includeAllCopies AS '@includeAll',
                (SELECT policyId		AS '@policyId',
                        policyName		AS '@policyName',
                        copyId			AS '@copyId',
                        copyName		AS '@copyName'
                 FROM   @tblcopyFilter
                 ORDER BY policyName, copyName
                 FOR XML PATH('entities'), TYPE)
            FOR XML PATH('copyFilter'), TYPE)
     FOR XML PATH('req'),TYPE),
     -- arraySummary
    (SELECT
		(SELECT	A.Id					AS '@arrayId',
				A.ArrayName				AS '@arrayName',
				A.SoftState				AS '@arrayStatus',
				C.SnapJobCount			AS '@jobCount',
                B.SnapshotCount			AS '@snapCount',
				ISNULL(D.LunCount, 0)	AS '@lunCount',
                (SELECT COUNT(DISTINCT ArrayVolumeId) FROM @TblArrayHostVolume WHERE ArrayId = A.Id)
										AS '@volumeCount',
                A.TotalSpaceMB - A.FreeSpaceMB	AS '@usedSpaceMB',
                A.FreeSpaceMB			AS '@freeSpaceMB',
                B.SnapSizeMB			AS '@snapSizeMB'
		FROM	SMArray A WITH (NOLOCK)
				INNER JOIN
				(SELECT	T.ArrayId, COUNT(DISTINCT S.SMSnapId) AS SnapshotCount, SUM(S.UsedSpaceBytes)/1024/1024 AS SnapSizeMB
				FROM	@TblArrayHostVolume T
						INNER JOIN SMSnap S WITH (NOLOCK) ON S.ArrayVolumeId = T.ArrayVolumeId
				GROUP BY T.ArrayId) B ON B.ArrayId = A.Id
				INNER JOIN
				(SELECT	T.ArrayId, COUNT(DISTINCT V.jobId) AS SnapJobCount
				FROM	@TblArrayHostVolume T
						INNER JOIN SMSnap S WITH (NOLOCK) ON S.ArrayVolumeId = T.ArrayVolumeId
						INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
						INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
				GROUP BY T.ArrayId) AS C ON C.ArrayId = A.Id
				LEFT OUTER JOIN
				(SELECT	T.ArrayId, COUNT(DISTINCT L.id) AS LunCount
				FROM	@TblArrayHostVolume T
						INNER JOIN SMLUN AS L WITH (NOLOCK)	ON L.ArrayVolumeId = T.ArrayVolumeId
				GROUP BY T.ArrayId) D ON D.ArrayId = A.Id
		ORDER BY A.ArrayName
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('arraySummary'), TYPE),
 	-- hostSummary
    (SELECT
		(SELECT	CL.id					AS '@hostClientId',
				CL.name					AS '@hostClientName',
				C.SnapJobCount			AS '@jobCount',
                B.SnapshotCount			AS '@snapCount',
				ISNULL(D.LunCount, 0)	AS '@lunCount',
                (SELECT COUNT(DISTINCT ArrayVolumeId) FROM @TblArrayHostVolume WHERE HostClientId = CL.id)
										AS '@volumeCount',
                B.SnapSizeMB			AS '@snapSizeMB'
		FROM	APP_Client CL WITH (NOLOCK)
				INNER JOIN
				(SELECT	T.HostClientId, COUNT(DISTINCT S.SMSnapId) AS SnapshotCount, SUM(S.UsedSpaceBytes)/1024/1024 AS SnapSizeMB
				FROM	@TblArrayHostVolume T
						INNER JOIN SMSnap S WITH (NOLOCK) ON S.ArrayVolumeId = T.ArrayVolumeId
				GROUP BY T.HostClientId) B ON B.HostClientId = CL.id
				INNER JOIN
				(SELECT	T.HostClientId, COUNT(DISTINCT V.jobId) AS SnapJobCount
				FROM	@TblArrayHostVolume T
						INNER JOIN SMSnap S WITH (NOLOCK) ON S.ArrayVolumeId = T.ArrayVolumeId
						INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
						INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
				GROUP BY T.HostClientId) AS C ON C.HostClientId = CL.id
				LEFT OUTER JOIN
				(SELECT	T.HostClientId, COUNT(DISTINCT L.id) AS LunCount
				FROM	@TblArrayHostVolume T
						INNER JOIN SMLUN AS L WITH (NOLOCK)	ON L.ArrayVolumeId = T.ArrayVolumeId
				GROUP BY T.HostClientId) D ON D.HostClientId = CL.id
		ORDER BY CL.name
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('hostSummary'), TYPE),
	-- arrayVolumeSummary
    (SELECT
		(SELECT	arrayId					AS '@arrayId',
				hostClientId			AS '@hostClientId',
				arrayVolumeId			AS '@arrayVolumeId',
				arrayVolumeName			AS '@arrayVolumeName',
				SnapJobCount			AS '@jobCount',
                SnapshotCount			AS '@snapCount',
				LunCount				AS '@lunCount',
				VolumeTotalSpaceMB - VolumeFreeSpaceMB		AS '@usedSpaceMB',
                VolumeFreeSpaceMB		AS '@freeSpaceMB',
                SnapSizeMB				AS '@snapSizeMB'
		FROM	@TblArrayHostVolume
		ORDER BY arrayVolumeName
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('arrayVolumeSummary'), TYPE),
	-- appSummary
    (SELECT
		(SELECT	A.appTypeId				AS '@appTypeId',
				D.name					AS '@appTypeName',
				A.sourceClientId		AS '@sourceClientId',
				C.name					AS '@sourceClientName',
				A.arrayVolumeId			AS '@arrayVolumeId',
                V.Name					AS '@arrayVolumeName',
				A.SnapJobCount			AS '@jobCount',
                A.SnapshotCount			AS '@snapCount',
                SnapSizeMB				AS '@snapSizeMB'
		FROM	@TblAppVolume A
				INNER JOIN SMArrayVolume V WITH (NOLOCK) ON V.Id = A.arrayVolumeId
				INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = A.SourceClientId
				INNER JOIN APP_iDAType D WITH (NOLOCK) ON D.type = A.AppTypeId
		ORDER BY D.name, C.name, V.Name
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('appSummary'), TYPE),
	-- policySummary
    (SELECT
		(SELECT	C.policyId				AS '@policyId',
				C.policyName			AS '@policyName',
				COUNT(DISTINCT C.copyId) AS '@snapCopyCount',
				COUNT(DISTINCT V.JobId)	AS '@jobCount',
				SUM(case when J.jobId is not null and J.materializationStatus = 100 then 1 else 0 end)
										AS '@jobsOnTape',
				SUM(case when J.jobId is not null and J.materializationStatus in (101, 102, 103) AND J.disabled = 0 then 1 else 0 end)
										AS '@jobsToMove',
                COUNT(S.SMSnapId)		AS '@snapCount',
                SUM(S.UsedSpaceBytes)/1024/1024		AS '@snapSizeMB'
		FROM	SMSnap S WITH (NOLOCK)
				INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
				INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
				INNER JOIN @TblSnapCopy C ON C.copyId = V.CopyId
				LEFT OUTER JOIN JMJobSnapshotStats J WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId
		GROUP BY C.policyId, C.policyName
		ORDER BY C.policyName
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('policySummary'), TYPE),
	-- copySummary
    (SELECT
		(SELECT	C.policyId				AS '@policyId',
				C.copyId				AS '@copyId',
				C.copyName				AS '@copyName',
				C.copyType				AS '@copyType',
				COUNT(DISTINCT V.JobId)	AS '@jobCount',
                COUNT(S.SMSnapId)		AS '@snapCount',
                SUM(S.UsedSpaceBytes)/1024/1024		AS '@snapSizeMB'
		FROM	SMSnap S WITH (NOLOCK)
				INNER JOIN SMVolSnapMap M WITH (NOLOCK) ON M.SMSnapId = S.SMSnapId
				INNER JOIN SMVolume V WITH (NOLOCK) ON V.SMVolumeId = M.SMVolumeId
				INNER JOIN @TblSnapCopy C ON C.copyId = V.CopyId
		GROUP BY C.policyId, C.copyId, C.copyName, C.copyType
		ORDER BY C.copyName
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('copySummary'), TYPE),
	-- copyVolumeSummary
    (SELECT
		(SELECT	C.policyId				AS '@policyId',
				C.copyId				AS '@copyId',
				A.ArrayVolumeId			AS '@arrayVolumeId',
				B.ArrayVolumeName		AS '@arrayVolumeName',
				A.SnapJobCount			AS '@jobCount',
                A.SnapshotCount			AS '@snapCount',
                A.SnapSizeMB			AS '@snapSizeMB'
		FROM	@TblCopyVolume A
				INNER JOIN @TblArrayHostVolume B ON B.ArrayVolumeId = A.ArrayVolumeId
				INNER JOIN @TblSnapCopy C ON C.copyId = A.CopyId
		ORDER BY B.ArrayVolumeName
        FOR XML PATH('entities'), TYPE)
	FOR XML PATH('copyVolumeSummary'), TYPE),
     -- snapshot list
    (SELECT
		@totalSnaps						AS '@totalSnaps',
		@i_pageSize						AS '@pageSize',
		(SELECT sourceClientName		AS '@sourceClientName',
                sourcePath				AS '@sourcePath',
                appTypeName				AS '@appTypeName',
                snapName				AS '@snapName',
                snapStatus				AS '@snapStatus',
                snapCreationTime		AS '@snapCreationTime',
				snapSizeMB				AS '@snapSizeMB',
                jobId					AS '@jobId',
                jobStartTime			AS '@jobStartTime',
				jobEndTime				AS '@jobEndTime',
				jobAgingTime			AS '@jobAgingTime',
				movedToTape				AS '@movedToTape',
                arrayName				AS '@arrayName',
				volumeName				AS '@volumeName',
                snapEngineName			AS '@snapEngineName',
                controlHostName			AS '@controlHostName',
				policyName				AS '@policyName',
				copyName				AS '@copyName',
				copyType				AS '@copyType'
		FROM	#SnapshotPage
		FOR XML PATH('snapDetails'),TYPE)
	FOR XML PATH('snapList'),TYPE)
FOR XML PATH ('WebReport_ArraySnapReportResp')
DROP TABLE #SubclientFilter
DROP TABLE #SnapshotPage
GO

IF EXISTS (select * from GxQscripts where name = 'WR_ArraySnapSummary')
	delete from GxQscripts where name = 'WR_ArraySnapSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WR_ArraySnapSummary')
	delete from GXDBVersions where aliasname = 'WR_ArraySnapSummary'
GO

insert into GXDBVersions values(2, 'WR_ArraySnapSummary',  '00010006004800020000', 'WR_ArraySnapSummary', '00010006004800020000')
GO

