

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetWorkflowProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetWorkflowProperties.sp,v $ $Id: WFSetWorkflowProperties.sp,v 1.5.2.7 2020/07/29 21:27:07 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 07/22/2013
-- Description:	updates the properties of a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFSetWorkflowProperties')
BEGIN
	print '>>> Drop Stored Procedure: WFSetWorkflowProperties <<<'
	drop procedure WFSetWorkflowProperties
END
IF EXISTS (select * from GxQscripts where name='WFSetWorkflowProperties')
	delete from GxQscripts where name = 'WFSetWorkflowProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowProperties')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowProperties'
GO
print '... Creating Procedure: WFSetWorkflowProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetWorkflowProperties
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId int
DECLARE @name nvarchar(255)
DECLARE @description nvarchar(max)
DECLARE @disabled int
DECLARE @autoDeploy int
DECLARE @hidden int
SELECT	@workflowId = ISNULL(ref.value('@workflowId','int'), 0),
		@name = ISNULL(ref.value('@workflowName','nvarchar(255)'), '')
FROM @i_xmlText.nodes('Workflow_SetWorkflowProperties/workflow') R(ref)
SELECT 	@description = ref.value('@description','nvarchar(max)'),
		@disabled = ISNULL(ref.value('@disabled','int'), -1),
		@autoDeploy = ISNULL(ref.value('@autoDeploy','int'), -1),
		@hidden = ISNULL(ref.value('@hidden','int'), -1)
FROM @i_xmlText.nodes('Workflow_SetWorkflowProperties') R(ref)
IF (@workflowId = 0)
BEGIN
	IF LEN(@name) = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'workflow not specified'
		GOTO FINISH
	END
	ELSE
	BEGIN
		SELECT @workflowId=ISNULL(WorkflowId, 0)
		FROM WF_Definition
		WHERE Name = @name
	END
END
IF NOT EXISTS(SELECT * FROM WF_Definition Where WorkflowId = @workflowId)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'workflow not found'
	GOTO FINISH
END
IF LEN(@name) = 0
BEGIN
	SELECT @name = Name from WF_Definition Where WorkflowId = @workflowId
END
DECLARE @currentFlags INT
DECLARE @currentlyDisabled INT = 0
SELECT @currentFlags = CASE WHEN flags < 0 THEN 0 ELSE flags END FROM WF_Definition WHERE WorkflowId = @workflowId
DECLARE @hasRights INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 112, @hasRights OUTPUT, 83, @workflowId
IF @hasRights = 0
BEGIN
	EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
END
IF @hasRights = 1
BEGIN
		IF @autoDeploy = 0
		BEGIN
			SET @currentFlags = @currentFlags & ~2
		END
		ELSE IF @autoDeploy = 1
		BEGIN
			SET @currentFlags = @currentFlags | 2
		END
		IF @hidden = 0
		BEGIN
			SET @currentFlags = @currentFlags & ~16
		END
		ELSE IF @hidden = 1
		BEGIN
			SET @currentFlags = @currentFlags | 16
		END
		UPDATE WF_Definition
		SET Description = @description, flags = @currentFlags, Modified = GETUTCDATE()
		WHERE WorkflowId = @workflowId
		IF (@disabled = -1)
		BEGIN
			GOTO FINISH
		END
		IF (@currentFlags & 1) > 0
		BEGIN
			SET @currentlyDisabled = 1
		END
		--audit if the workflow has been enabled/disabled
		IF (@currentlyDisabled <> @disabled)
		BEGIN
			DECLARE @opMsgId INTEGER
			DECLARE @opEvMsgId INTEGER
			DECLARE @opId INTEGER
			DECLARE @paramMsgId INTEGER
			DECLARE @enabled INT
			DECLARE @eventName varchar(50)
			IF (@disabled = 0)
			BEGIN
				SET @enabled = 1
				SET @eventName = 'Enable'
SET @opMsgId = (459 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				SET @currentFlags = @currentFlags & ~1
			END
			ELSE
			BEGIN
				SET @enabled = 0
				SET @eventName = 'Disable'
SET @opMsgId = (460 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				SET @currentFlags = @currentFlags | 1
			END
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			EXEC EvGuiAuditSetParamData @opId, @name, 0
SET @paramMsgId = (276 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			exec WFProcessAuthorizations @workflowId, @eventName, @i_userId, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT
			IF @o_ErrorCode != 0
			BEGIN
				GOTO FINISH
			END
			UPDATE WF_Definition
			SET flags = @currentFlags
			WHERE WorkflowId = @workflowId
			UPDATE App_MessageHandler SET enabled = @enabled WHERE workflowname = @name
		END
END
ELSE
BEGIN
SET @o_ErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
		IF dbo.isNewSecurity() = 0
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 34), 0,2))
		ELSE
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 112), 0,2))
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^3%s', @name)
END
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetWorkflowProperties')
	delete from GxQscripts where name = 'WFSetWorkflowProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowProperties')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowProperties'
GO

insert into GXDBVersions values(2, 'WFSetWorkflowProperties',  '00010005000200070000', 'WFSetWorkflowProperties', '00010005000200070000')
GO

