

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetWorkflowOwner.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetWorkflowOwner.sp,v $ $Id: WFSetWorkflowOwner.sp,v 1.4.48.5 2020/12/04 12:57:05 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 07/22/2013
-- Description:	changes the owner of a workflow
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='WFSetWorkflowOwner')
BEGIN
	print '>>> Drop Stored Procedure: WFSetWorkflowOwner <<<'
	drop procedure WFSetWorkflowOwner
END
IF EXISTS (select * from GxQscripts where name='WFSetWorkflowOwner')
	delete from GxQscripts where name = 'WFSetWorkflowOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowOwner')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowOwner'
GO
print '... Creating Procedure: WFSetWorkflowOwner'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure WFSetWorkflowOwner
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId int
DECLARE @name nvarchar(255)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','int'), 0),
		@name = ref.value('@workflowName','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_SetWorkflowOwner/workflow') R(ref)
IF (@workflowId = 0)
BEGIN
	IF LEN(@name) = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'workflow not specified'
		GOTO FINISH
	END
	ELSE
	BEGIN
		SELECT @workflowId=ISNULL(WorkflowId, 0)
		FROM WF_Definition
		WHERE Name = @name
	END
END
IF NOT EXISTS(SELECT 1 FROM WF_Definition Where WorkflowId = @workflowId)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'workflow not found'
	GOTO FINISH
END
EXEC sec_setWorkFlowCreator @i_userId, @workflowId, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetWorkflowOwner')
	delete from GxQscripts where name = 'WFSetWorkflowOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowOwner')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowOwner'
GO

insert into GXDBVersions values(2, 'WFSetWorkflowOwner',  '00010004004800050000', 'WFSetWorkflowOwner', '00010004004800050000')
GO

