

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetWorkflowMessage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetWorkflowMessage.sp,v $ $Id: WFSetWorkflowMessage.sp,v 1.10.200.1 2018/03/27 08:02:40 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	sends a message to the workflow engine
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFSetWorkflowMessage <<<'

IF EXISTS (select * from sysobjects where name='WFSetWorkflowMessage')
	drop procedure WFSetWorkflowMessage
IF EXISTS (select * from GxQscripts where name='WFSetWorkflowMessage')
	delete from GxQscripts where name = 'WFSetWorkflowMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowMessage')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowMessage'
GO
print '... Creating Procedure: WFSetWorkflowMessage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetWorkflowMessage
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @clientId int,
  @message XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
INSERT INTO WF_MessageQueue(ClientId,MessageRequest,Created)
VALUES (@clientId, cast(@message as nvarchar(max)), getUTCDate())
DECLARE @messageId int
SELECT @messageId = @@IDENTITY
SET @o_xmlText = (
	SELECT	1			as TAG,
			0			as Parent,
			@messageId as [Workflow_SetWorkflowMessageResponse!1!messageId]
	FOR XML EXPLICIT)
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetWorkflowMessage')
	delete from GxQscripts where name = 'WFSetWorkflowMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowMessage')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowMessage'
GO

insert into GXDBVersions values(2, 'WFSetWorkflowMessage',  '00010010020000010000', 'WFSetWorkflowMessage', '00010010020000010000')
GO

