

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetWorkflowConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetWorkflowConfig.sp,v $ $Id: WFSetWorkflowConfig.sp,v 1.1.2.5 2018/03/27 08:06:44 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 04/14/2016
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFSetWorkflowConfig <<<'

IF EXISTS (select * from sysobjects where name='WFSetWorkflowConfig')
	drop procedure WFSetWorkflowConfig
IF EXISTS (select * from GxQscripts where name='WFSetWorkflowConfig')
	delete from GxQscripts where name = 'WFSetWorkflowConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowConfig')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowConfig'
GO
print '... Creating Procedure: WFSetWorkflowConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetWorkflowConfig
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N''
DECLARE @workflowId INT
DECLARE @workflowName nvarchar(255)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','INT'), 0),
		@workflowName = ref.value('@workflowName','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_SetConfigurationSettings/workflow') R(ref)
DECLARE @configXml nvarchar(MAX)
SELECT	@configXml = ISNULL(ref.value('@configSettings','nvarchar(MAX)'), 0)
FROM @i_xmlText.nodes('Workflow_SetConfigurationSettings') R(ref)
DECLARE @hasRights INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 112, @hasRights OUTPUT, 83, @workflowId
IF @hasRights = 0
	EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
IF @hasRights = 0
BEGIN
SET @o_ErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
	SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 133), 0,2))
	SET @o_ErrorString = REPLACE(@o_ErrorString, '^3%s', @workflowName)
	GOTO FINISH
END
IF EXISTS(Select * From APP_ComponentProp Where componentType = 13 And componentId = @workflowId And propertyTypeId = 18)
BEGIN
	UPDATE APP_ComponentProp
	SET stringVal = @configXml
	Where componentType = 13 And componentId = @workflowId And propertyTypeId = 18
END
ELSE
BEGIN
	INSERT INTO APP_ComponentProp(componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
	VALUES (13, @workflowId, 18, 1, 0, 0, @configXml, dbo.GetUnixTime(GETUTCDATE()), 0)
END
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetWorkflowConfig')
	delete from GxQscripts where name = 'WFSetWorkflowConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowConfig')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowConfig'
GO

insert into GXDBVersions values(2, 'WFSetWorkflowConfig',  '00010001000200050000', 'WFSetWorkflowConfig', '00010001000200050000')
GO

