

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetWorkflowComment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetWorkflowComment.sp,v $ $Id: WFSetWorkflowComment.sp,v 1.4.2.2 2018/03/27 08:08:06 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 07/22/2013
-- Description:	updates a comment on a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFSetWorkflowComment <<<'

IF EXISTS (select * from sysobjects where name='WFSetWorkflowComment')
	drop procedure WFSetWorkflowComment
IF EXISTS (select * from GxQscripts where name='WFSetWorkflowComment')
	delete from GxQscripts where name = 'WFSetWorkflowComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowComment')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowComment'
GO
print '... Creating Procedure: WFSetWorkflowComment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetWorkflowComment
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId int
DECLARE @name nvarchar(255)
DECLARE @version int
DECLARE @workflowComment nvarchar(max)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','int'), 0),
		@name = ref.value('@workflowName','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_SetWorkflowComment/workflow') R(ref)
SELECT 	@workflowComment = ref.value('@workflowComment','nvarchar(max)'),
		@version = ISNULL(ref.value('@version','int'), 0)
FROM @i_xmlText.nodes('Workflow_SetWorkflowComment') R(ref)
IF (@name IS NULL)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'workflow name not specified'
	GOTO FINISH
END
IF (@workflowId = 0)
BEGIN
	IF EXISTS(SELECT * FROM WF_Definition WHERE WorkflowId = @workflowId)
	BEGIN
		SELECT @workflowId=ISNULL(WorkflowId, 0)
		FROM WF_Definition
		WHERE Name = @name
	END
	ELSE
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'workflow does not exist'
		GOTO FINISH
	END
END
IF (@version = 0)
BEGIN
	SELECT @version = MAX(Version) FROM WF_DefinitionHistory WHERE WorkflowId = @workflowId
END
DECLARE @two BIGINT
SET @two = 2
DECLARE @hasRights INT = 0
IF dbo.isNewSecurity() = 0
BEGIN
	--make sure user has edit capabilities on workflow
	IF object_id('tempdb.dbo.#WFSetWorkflowComment_UserObjects') is not null DROP TABLE #WFSetWorkflowComment_UserObjects
create table  #WFSetWorkflowComment_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 14033, @workflowId, '#WFSetWorkflowComment_UserObjects'
IF EXISTS(SELECT * FROM #WFSetWorkflowComment_UserObjects WHERE (Capabilities & power(@two, 34-1) > 0) AND (workflowId = @workflowId OR commCellId = 2))
	BEGIN
		SET @hasRights = 1
	END
	ELSE
	BEGIN
		SET @hasRights = 0
	END
	DROP TABLE #WFSetWorkflowComment_UserObjects
END
ELSE
BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 112, @hasRights OUTPUT, 83, @workflowId
END
IF @hasRights = 0
BEGIN
	EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
END
IF @hasRights = 0
BEGIN
SET @o_ErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
		IF dbo.isNewSecurity() = 0
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 34), 0,2))
		ELSE
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 112), 0,2))
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^3%s', @name)
END
ELSE
BEGIN
		UPDATE WF_DefinitionHistory
		SET Description = @workflowComment
		WHERE Name = @name
		AND Version = @version
END
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetWorkflowComment')
	delete from GxQscripts where name = 'WFSetWorkflowComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflowComment')
	delete from GXDBVersions where aliasname = 'WFSetWorkflowComment'
GO

insert into GXDBVersions values(2, 'WFSetWorkflowComment',  '00010004000200020000', 'WFSetWorkflowComment', '00010004000200020000')
GO

