

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetWorkflow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetWorkflow.sp,v $ $Id: WFSetWorkflow.sp,v 1.53.2.7 2020/05/05 17:56:51 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	saves a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFSetWorkflow')
BEGIN
	print '>>> Drop Stored Procedure: WFSetWorkflow <<<'
	drop procedure WFSetWorkflow
END
IF EXISTS (select * from GxQscripts where name='WFSetWorkflow')
	delete from GxQscripts where name = 'WFSetWorkflow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflow')
	delete from GXDBVersions where aliasname = 'WFSetWorkflow'
GO
print '... Creating Procedure: WFSetWorkflow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetWorkflow
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId int
DECLARE @name nvarchar(255)
DECLARE @description nvarchar(max)
DECLARE @location nvarchar(255)
DECLARE @definition XML
DECLARE @version int
DECLARE @flags int
DECLARE @workflowComment nvarchar(max)
DECLARE @uniqueGuid nvarchar(255)
--DECLARE @revisionTag nvarchar(255)
DECLARE @revision nvarchar(255)
DECLARE @checkExisting bit
DECLARE @userRevision int
DECLARE @restricted int
SELECT	@workflowId = ISNULL(ref.value('@workflowId','int'), 0),
		@name = ref.value('@name','nvarchar(255)'),
		--@version = ISNULL(ref.value('@version','int'), 0),
		@description = ref.value('@description','nvarchar(max)'),
		@uniqueGuid = ref.value('@uniqueGuid','nvarchar(255)'),
		@revision = ref.value('@revision','nvarchar(255)'),
		@restricted = ISNULL(ref.value('@restricted','int'), 0)
FROM @i_xmlText.nodes('Workflow_SetWorkflowRequest/workflow') R(ref)
SELECT 	@definition = ref.query('workflow'),
		@location = ref.value('@sourceLocation', 'nvarchar(256)'),
		@flags = ISNULL(ref.value('@flags','int'), -1),
		@workflowComment = ref.value('@workflowComment','nvarchar(max)'),
		@checkExisting = ISNULL(ref.value('@checkExisting','bit'), 0),
		@userRevision = ISNULL(ref.value('@userRevision','int'), 1)
FROM @i_xmlText.nodes('Workflow_SetWorkflowRequest') R(ref)
IF (@name IS NULL)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'workflow name not specified'
	GOTO FINISH
END
--IF (LEN(@revisionTag) > 12)
--BEGIN
--	DECLARE @revisionStr nvarchar(255)
--	SET @revisionStr = SUBSTRING(@revisionTag, 11, LEN(@revisionTag)-11);
--	IF (ISNUMERIC(@revisionStr) = 1)
--		SET @revision = CAST(@revisionStr as float)
--END
IF (LEN(@uniqueGuid) > 0)
BEGIN
	SELECT @workflowId = ISNULL(WorkflowId, 0) FROM WF_Definition WHERE uniqueGuid = @uniqueGuid
END
IF (@workflowId = 0)
BEGIN
	SELECT @workflowId=ISNULL(WorkflowId, 0)
	FROM WF_Definition
	WHERE Name = @name
	IF (@checkExisting = 1 AND @workflowId > 0)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'workflow already exists'
		GOTO FINISH
	END
END
DECLARE @two BIGINT
SET @two = 2
DECLARE @hasRights INT = 0
EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
IF (@workflowId > 0)
BEGIN
	DECLARE @currentFlags INT
	DECLARE @currentRev INT
	DECLARE @currentRestriction INT
	SELECT @currentFlags = flags, @currentRev = UserRevision, @currentRestriction = Restricted FROM WF_Definition WHERE WorkflowId = @workflowId
	IF @currentRestriction = 1
	BEGIN
		SET @restricted = 1
	END
	IF @hasRights = 0
	BEGIN
		IF dbo.isNewSecurity() = 0
		BEGIN
			--make sure user has edit capabilities on workflow
			IF object_id('tempdb.dbo.#WFSetWorkflow_UserObjects') is not null DROP TABLE #WFSetWorkflow_UserObjects
create table  #WFSetWorkflow_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
			EXEC sec_getUserObjects @i_userId, 14033, @workflowId, '#WFSetWorkflow_UserObjects'
IF EXISTS(SELECT * FROM #WFSetWorkflow_UserObjects WHERE (Capabilities & power(@two, 34-1) > 0) AND (workflowId = @workflowId OR commCellId = 2))
			BEGIN
				SET @hasRights = 1
			END
			ELSE
			BEGIN
				SET @hasRights = 0
			END
		END
		ELSE
		BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 112, @hasRights OUTPUT, 83, @workflowId
		END
	END
	IF @hasRights = 1
	BEGIN
		SELECT @version = Version FROM WF_Definition WHERE WorkflowId = @WorkflowId
		IF (@currentFlags & 8 = 8)
		BEGIN
SET @o_ErrorCode = (936 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (936 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
			GOTO FINISH
		END
		IF (@flags = -1)
		BEGIN
			SET @flags = @currentFlags
		END
		-- make sure CV_WORKFLOW is unset so we don't overwrite these changes with updates
		SET @flags = @flags & ~4
		SET @version = @version + 1
		UPDATE WF_Definition
		SET Name = @name,
			Description = @description,
			Definition = @definition,
			Version = @version,
			flags = @flags,
			uniqueGuid = @uniqueGuid,
			revision = @revision,
			Modified = GETUTCDATE(),
			location = @location,
			UserRevision = @userRevision,
			Restricted = @restricted
		WHERE WorkflowId = @workflowId
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId, location)
		SELECT WorkflowId, @version, Name, @workflowComment, Definition, dbo.GetUnixTime(GETUTCDATE()), @i_userId, @location
		FROM WF_Definition
		WHERE WorkflowId = @workflowId
		/*
		DECLARE @prevDisabled int = @currentFlags & 1
		DECLARE @nowDisabled  int = @flags & 1
		IF (@prevDisabled <> @nowDisabled)
		BEGIN
			DECLARE @opMsgId INTEGER
			DECLARE @opEvMsgId INTEGER
			DECLARE @opId INTEGER
			DECLARE @paramMsgId INTEGER
			IF (@nowDisabled = 0)
SET @opMsgId = (459 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			ELSE
SET @opMsgId = (460 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			EXEC EvGuiAuditSetParamData @opId, @name, 0
SET @paramMsgId = (276 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		*/
	END
	ELSE
	BEGIN
SET @o_ErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
		IF dbo.isNewSecurity() = 0
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 34), 0,2))
		ELSE
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 112), 0,2))
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^3%s', @name)
		GOTO FINISH
	END
END
ELSE
BEGIN
	IF @hasRights = 0
	BEGIN
exec sec_userHasCapability @i_userId,0,@hasRights OUTPUT,0,0,'133'
	END
	IF @hasRights = 0
	BEGIN
SET @o_ErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 133), 0,2))
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^3%s', @name)
		GOTO FINISH
	END
	SET @version = 1
	IF (@flags = -1)
	BEGIN
		SET @flags = 0
	END
	IF @restricted = 1
	BEGIN
		SET @flags = @flags | 1
	END
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, uniqueGuid, revision, location, UserRevision, Restricted)
	SELECT @name, @description, @definition, @version, GETUTCDATE(), GETUTCDATE(), @i_userId, @flags, @uniqueGuid, @revision, @location, @userRevision, @restricted
	SELECT @workflowId = @@IDENTITY
	EXEC sec_setWorkFlowCreator @i_userId, @workFlowId, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT
	exec dbo.sec_updateUserCredentials @i_userId, 1
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId, location)
	SELECT WorkflowId, @version, Name, @workflowComment, Definition, dbo.GetUnixTime(GETUTCDATE()), @i_userId, @location
	FROM WF_Definition
	WHERE WorkflowId = @workflowId
END
SET @o_xmlText = (
	SELECT	WorkflowId '@workflowId',
			Name '@workflowName'
	FROM WF_Definition
	WHERE WorkflowId = @workflowId
	FOR XML PATH('workflow'), ROOT('Workflow_SetWorkflowResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_SetWorkflowResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetWorkflow')
	delete from GxQscripts where name = 'WFSetWorkflow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetWorkflow')
	delete from GXDBVersions where aliasname = 'WFSetWorkflow'
GO

insert into GXDBVersions values(2, 'WFSetWorkflow',  '00010053000200070000', 'WFSetWorkflow', '00010053000200070000')
GO

