

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetSchemaLocation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetSchemaLocation.sp,v $ $Id: WFSetSchemaLocation.sp,v 1.17.84.1 2018/03/27 07:59:50 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/15/2010
-- Description:	updates/creates schema locations
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFSetSchemaLocation <<<'

IF EXISTS (select * from sysobjects where name='WFSetSchemaLocation')
	drop procedure WFSetSchemaLocation
IF EXISTS (select * from GxQscripts where name='WFSetSchemaLocation')
	delete from GxQscripts where name = 'WFSetSchemaLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetSchemaLocation')
	delete from GXDBVersions where aliasname = 'WFSetSchemaLocation'
GO
print '... Creating Procedure: WFSetSchemaLocation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetSchemaLocation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @schemaLocationId	INT
DECLARE @schemaLocationUrl nvarchar(255)
DECLARE @locationType INT
DECLARE @xmlInfo nvarchar(MAX)
DECLARE @serviceUrl nvarchar(255)
DECLARE @modified INT
SELECT	@locationType = ref.value('@locationType','INT'),
		@xmlInfo = ref.value('@xmlInfo','nvarchar(MAX)'),
		@serviceUrl = ref.value('@serviceUrl','nvarchar(255)'),
		@modified = ISNULL(ref.value('@modified','INT'), 0)
FROM @i_xmlText.nodes('Workflow_SetSchemaLocationRequest/location') R(ref)
SELECT	@schemaLocationId = ISNULL(ref.value('@schemaLocationId','INT'), 0),
		@schemaLocationUrl = ref.value('@schemaLocationUrl','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_SetSchemaLocationRequest/location/location') R(ref)
IF (@schemaLocationUrl IS NULL)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'schemaLocationUrl not specified'
	GOTO FINISH
END
IF (@locationType IS NULL)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'locationType not specified'
	GOTO FINISH
END
IF (@modified = 0)
BEGIN
	SET @modified = dbo.GetUnixTime(GetUTCDate())
END
IF (@schemaLocationId = 0)
BEGIN
	SELECT @schemaLocationId=ISNULL(LocationId,0)
	FROM WF_SchemaLocation
	WHERE LocationUrl=@schemaLocationUrl
END
IF (@schemaLocationId > 0)
BEGIN
	UPDATE WF_SchemaLocation
	SET LocationUrl = @schemaLocationUrl, LocationType = @locationType, xmlInfo = @xmlInfo, serviceUrl = @serviceUrl, Modified = @modified
	WHERE LocationId = @schemaLocationId
END
ELSE
BEGIN
	INSERT INTO WF_SchemaLocation(LocationUrl, LocationType, xmlInfo, serviceUrl, Modified)
	VALUES (@schemaLocationUrl, @locationType, @xmlInfo, @serviceUrl, @modified)
	SELECT @schemaLocationId = @@IDENTITY
END
SET @o_xmlText = (
	SELECT	LocationId '@schemaLocationId',
			LocationUrl '@schemaLocationUrl'
	FROM WF_SchemaLocation
	WHERE LocationId = @schemaLocationId
	FOR XML PATH('location'), ROOT('Workflow_SetSchemaLocationResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_SetSchemaLocationResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetSchemaLocation')
	delete from GxQscripts where name = 'WFSetSchemaLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetSchemaLocation')
	delete from GXDBVersions where aliasname = 'WFSetSchemaLocation'
GO

insert into GXDBVersions values(2, 'WFSetSchemaLocation',  '00010017008400010000', 'WFSetSchemaLocation', '00010017008400010000')
GO

