

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetInteraction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetInteraction.sp,v $ $Id: WFSetInteraction.sp,v 1.6.56.4 2018/03/27 08:01:03 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	deletes the individual interaction
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFSetInteraction <<<'

IF EXISTS (select * from sysobjects where name='WFSetInteraction')
	drop procedure WFSetInteraction
IF EXISTS (select * from GxQscripts where name='WFSetInteraction')
	delete from GxQscripts where name = 'WFSetInteraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetInteraction')
	delete from GXDBVersions where aliasname = 'WFSetInteraction'
GO
print '... Creating Procedure: WFSetInteraction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetInteraction
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N''
DECLARE @interactionId int
DECLARE @interactionGuid nvarchar(40)
DECLARE @inputXml nvarchar(MAX)
DECLARE @action nvarchar(255)
SELECT	@interactionId = ISNULL(ref.value('@interactionId','int'), 0),
		@interactionGuid = ISNULL(ref.value('@interactionGuid','nvarchar(40)'), ''),
		@inputXml = ref.value('@inputXml','nvarchar(MAX)'),
		@action = ISNULL(ref.value('@action','nvarchar(255)'), '')
FROM @i_xmlText.nodes('Workflow_SetWebFormInteractionRequest') R(ref)
IF EXISTS(SELECT InteractionId FROM WF_Interaction WHERE interactionGuid = @interactionGuid)
BEGIN
	SELECT @interactionId = InteractionId FROM WF_Interaction WHERE interactionGuid = @interactionGuid
END
IF NOT EXISTS(SELECT InteractionId FROM WF_Interaction WHERE InteractionId = @interactionId)
BEGIN
	SET @o_ErrorCode = -1
	SET @o_ErrorString = 'interaction does not exist'
	GOTO FINISH
END
IF NOT EXISTS(SELECT * FROM dbo.GetUserInteractions(@i_userId, 1) WHERE InteractionId = @interactionId)
BEGIN
	SET @o_ErrorCode = -2
	--SET @o_ErrorString = 'user is not authorized to modify interaction'
	SET @o_ErrorString = (SELECT TOP 1 value FROM GXGlobalParam Where name = 'WorkflowActionPermissionError')
	IF (@o_ErrorString IS NULL OR LEN(@o_ErrorString) = 0)
		SET @o_ErrorString = 'You are not permitted to perform this Action'
	GOTO FINISH
END
DECLARE @currentStatus int
DECLARE @completedBy nvarchar(255)
DECLARE @interationType int
SELECT @currentStatus = i.[status], @interationType = interactionType, @completedBy = u.login
FROM WF_Interaction i
LEFT OUTER JOIN UMUsers u ON i.completedBy = u.id
WHERE i.InteractionId = @interactionId
IF (@currentStatus = 1)
BEGIN
	SET @o_ErrorCode = -3
	SET @o_ErrorString = @completedBy
	GOTO FINISH
END
IF (@currentStatus > 1)
BEGIN
	SET @o_ErrorCode = -4
	SET @o_ErrorString = 'interaction was cancelled'
	GOTO FINISH
END
UPDATE WF_Interaction
SET completedBy=@i_userId,
	completed=dbo.GetUnixTime(GETUTCDATE()),
	[status] = 1,
	xmlResults=@inputXml,
	inputSchema=@action
WHERE InteractionId = @interactionId
--SET @o_ErrorString = @interactionId
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [App_GenericResp!1!errorCode],
			@o_ErrorString	as [App_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetInteraction')
	delete from GxQscripts where name = 'WFSetInteraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetInteraction')
	delete from GXDBVersions where aliasname = 'WFSetInteraction'
GO

insert into GXDBVersions values(2, 'WFSetInteraction',  '00010006005600040000', 'WFSetInteraction', '00010006005600040000')
GO

