

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetEmailApproval.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetEmailApproval.sp,v $ $Id: WFSetEmailApproval.sp,v 1.1.2.4 2020/01/27 17:28:46 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/14/2015
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFSetEmailApproval')
BEGIN
	print '>>> Drop Stored Procedure: WFSetEmailApproval <<<'
	drop procedure WFSetEmailApproval
END
IF EXISTS (select * from GxQscripts where name='WFSetEmailApproval')
	delete from GxQscripts where name = 'WFSetEmailApproval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetEmailApproval')
	delete from GXDBVersions where aliasname = 'WFSetEmailApproval'
GO
print '... Creating Procedure: WFSetEmailApproval'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetEmailApproval
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N''
DECLARE @approvalEnabled	BIT
DECLARE @approvalEnabledString	nvarchar(255)
DECLARE @approvalHost nvarchar(255)
DECLARE @approvalMailBox nvarchar(255)
DECLARE @approvalPassword nvarchar(255)
DECLARE @updatePassword nvarchar(255)
DECLARE @approvalFolder nvarchar(255)
SELECT	@approvalEnabled = ISNULL(ref.value('@isEnabled','BIT'), 0),
		@approvalHost = ISNULL(ref.value('@host','nvarchar(255)'), ''),
		@approvalMailBox = ISNULL(ref.value('@mailbox','nvarchar(255)'), ''),
		@approvalPassword = ISNULL(ref.value('@password','nvarchar(255)'), ''),
		@updatePassword = ref.value('@password','nvarchar(255)'),
		@approvalFolder = ISNULL(ref.value('@folder','nvarchar(255)'), '')
FROM @i_xmlText.nodes('Workflow_SetEmailApprovalRequest/approval') R(ref)
IF @approvalEnabled = 0
	SET @approvalEnabledString = 'false'
ELSE
	SET @approvalEnabledString = 'true'
IF NOT EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'WorkflowEmailApprovalEnabled')
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES ('WorkflowEmailApprovalEnabled', @approvalEnabledString, dbo.GetUnixTime(getdate()), 0)
END
ELSE
BEGIN
	UPDATE GXGlobalParam
	SET value = @approvalEnabledString
	WHERE name = 'WorkflowEmailApprovalEnabled'
END
IF NOT EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'WorkflowEmailApprovalHost')
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES ('WorkflowEmailApprovalHost', @approvalHost, dbo.GetUnixTime(getdate()), 0)
END
ELSE
BEGIN
	UPDATE GXGlobalParam
	SET value = @approvalHost
	WHERE name = 'WorkflowEmailApprovalHost'
END
IF NOT EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'WorkflowEmailApprovalMailbox')
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES ('WorkflowEmailApprovalMailbox', @approvalMailBox, dbo.GetUnixTime(getdate()), 0)
END
ELSE
BEGIN
	UPDATE GXGlobalParam
	SET value = @approvalMailBox
	WHERE name = 'WorkflowEmailApprovalMailbox'
END
IF NOT EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'WorkflowEmailApprovalPassword')
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES ('WorkflowEmailApprovalPassword', @approvalPassword, dbo.GetUnixTime(getdate()), 0)
END
ELSE
BEGIN
	IF @updatePassword IS NOT null
	BEGIN
		UPDATE GXGlobalParam
		SET value = @updatePassword
		WHERE name = 'WorkflowEmailApprovalPassword'
	END
END
IF NOT EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'WorkflowEmailApprovalFolder')
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES ('WorkflowEmailApprovalFolder', @approvalFolder, dbo.GetUnixTime(getdate()), 0)
END
ELSE
BEGIN
	UPDATE GXGlobalParam
	SET value = @approvalFolder
	WHERE name = 'WorkflowEmailApprovalFolder'
END
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetEmailApproval')
	delete from GxQscripts where name = 'WFSetEmailApproval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetEmailApproval')
	delete from GXDBVersions where aliasname = 'WFSetEmailApproval'
GO

insert into GXDBVersions values(2, 'WFSetEmailApproval',  '00010001000200040000', 'WFSetEmailApproval', '00010001000200040000')
GO

