

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFSetActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFSetActivity.sp,v $ $Id: WFSetActivity.sp,v 1.16.74.3 2018/03/27 08:03:36 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/15/2010
-- Description:	updates/creates activity sets
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFSetActivity <<<'

IF EXISTS (select * from sysobjects where name='WFSetActivity')
	drop procedure WFSetActivity
IF EXISTS (select * from GxQscripts where name='WFSetActivity')
	delete from GxQscripts where name = 'WFSetActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetActivity')
	delete from GXDBVersions where aliasname = 'WFSetActivity'
GO
print '... Creating Procedure: WFSetActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFSetActivity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @activityIdLong	BIGINT
DECLARE @activityId	INT
DECLARE @activityName nvarchar(255)
DECLARE @displayName nvarchar(255)
DECLARE @description nvarchar(MAX)
DECLARE @className nvarchar(255)
DECLARE @operation nvarchar(255)
DECLARE @cellClass nvarchar(255)
DECLARE @inputEditor nvarchar(255)
DECLARE @definition nvarchar(MAX)
DECLARE @activitySchema XML
DECLARE @icon nvarchar(max)
DECLARE @schemaFile nvarchar(max)
DECLARE @activitySetId INT = 0
DECLARE @activitySetName nvarchar(255)
DECLARE @schemaId INT
DECLARE @schemaNamespace nvarchar(255)
DECLARE @deleteActivity BIT
DECLARE @overwriteActivity BIT
SELECT	@deleteActivity = ISNULL(ref.value('@deleteActivity','bit'), 0),
		@overwriteActivity = ISNULL(ref.value('@overwriteActivity','bit'), 0)
FROM @i_xmlText.nodes('Workflow_SetActivityRequest') R(ref)
SELECT	@icon = ref.value('@icon','nvarchar(max)'),
		@className = ref.value('@className','nvarchar(255)'),
		@operation = ref.value('@operation','nvarchar(255)'),
		@displayName = ref.value('@displayName','nvarchar(255)'),
		@cellClass = ref.value('@cellClass','nvarchar(255)'),
		@inputEditor = ref.value('@inputEditor','nvarchar(255)'),
		@schemaFile = ref.value('@schema','nvarchar(MAX)'),
		@definition = ref.value('@definition','nvarchar(MAX)'),
		@description = ref.value('@description','nvarchar(MAX)'),
		@activitySchema = ref.query('activitySchema')
FROM @i_xmlText.nodes('Workflow_SetActivityRequest/activity') R(ref)
SELECT	@activitySetName = ISNULL(ref.value('@activitySetName','nvarchar(255)'), '')
FROM @i_xmlText.nodes('Workflow_SetActivityRequest/activitySet') R(ref)
SELECT	@activityIdLong = ISNULL(ref.value('@activityId','BIGINT'), 0),
		@activityName = ref.value('@activityName','nvarchar(255)'),
		@schemaId = ISNULL(ref.value('@schemaId','INT'), 0),
		@schemaNamespace = ref.value('@schemaNamespace','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_SetActivityRequest/activity/activity') R(ref)
IF @activityIdLong ^ 0xFFFFFFFF = 31999
	SET @activityId = 0
ELSE
	SET @activityId = @activityIdLong
IF (@schemaId = 0)
BEGIN
	SELECT @schemaId = ISNULL(SchemaId, 0) From WF_Schema WHERE Namespace = @schemaNamespace
END
IF (@schemaId = 0)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'schemaId required'
	GOTO FINISH
END
IF (@activityName is NULL)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'activity name required'
	GOTO FINISH
END
IF (@deleteActivity = 1)
BEGIN
	IF (@activityId = 0)
	BEGIN
		select @activityId = ActivityId from WF_Activity where Name = @activityName AND SchemaId = @schemaId
	END
	IF (@activityId = 0)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'could not find activity [' +  @activityName + ']'
		GOTO FINISH
	END
	DELETE FROM WF_Activity
	WHERE ActivityId = @activityId AND SchemaId = @schemaId
	GOTO FINISH
END
IF (@activityId = 0)
BEGIN
	IF exists (select * from WF_Activity where Name = @activityName AND SchemaId = @schemaId) AND @overwriteActivity = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'activity [' +  @activityName + '] already exists'
		GOTO FINISH
	END
	SELECT @activityId = ISNULL(ActivityId, 0)
	FROM WF_Activity
	WHERE Name = @activityName
	AND SchemaId = @schemaId
END
IF (@activityId > 0)
BEGIN
	UPDATE WF_Activity
	SET Name = @activityName,
		DisplayName = @displayName,
		Description = @description,
		Class = @className,
		Operation = @operation,
		CellClass = @cellClass,
		InputEditor = @inputEditor,
		Definition = @definition,
		Icon = @icon,
		SchemaFile = @schemaFile,
		SchemaId = @schemaId,
		ActivitySchema = @activitySchema,
		Modified = GETUTCDATE()
	WHERE ActivityId = @activityId
	DELETE FROM WF_ActivityGroup
	WHERE ActivityId = @activityId
END
ELSE
BEGIN
	INSERT INTO WF_Activity(Name,
							DisplayName,
							Description,
							Class,
							Operation,
							CellClass,
							InputEditor,
							Definition,
							Icon,
							SchemaFile,
							SchemaId,
							ActivitySchema,
							Created,
							Modified)
	VALUES (@activityName,
			@displayName,
			@description,
			@className,
			@operation,
			@cellClass,
			@inputEditor,
			@definition,
			@icon,
			@schemaFile,
			@schemaId,
			@activitySchema,
			GETUTCDATE(),
			GETUTCDATE())
	SELECT @activityId = @@IDENTITY
END
IF (LEN(@activitySetName) > 0)
BEGIN
	IF (@activitySetId = 0)
	BEGIN
		SELECT @activitySetId = ISNULL(ActivitySetId, 0)
		FROM WF_ActivitySet
		WHERE Name = @activitySetName
	END
	IF (@activitySetId = 0)
	BEGIN
		INSERT INTO WF_ActivitySet(Name)
		VALUES (@activitySetName)
		SET @activitySetId = @@IDENTITY
	END
	INSERT INTO WF_ActivityGroup(ActivitySetId, ActivityId)
	VALUES (@activitySetId, @activityId)
END
--SET @o_xmlText = (
--	SELECT	ActivityId '@activityId',
--			Name '@activityName'
--	FROM WF_Activity
--	WHERE ActivityId = @activityId
--	FOR XML PATH('activity'), ROOT('Workflow_SetActivityResponse'))
--IF (@o_xmlText IS NULL)
--BEGIN
--	SET @o_xmlText = '<Workflow_SetActivityResponse />'
--END
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFSetActivity')
	delete from GxQscripts where name = 'WFSetActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFSetActivity')
	delete from GXDBVersions where aliasname = 'WFSetActivity'
GO

insert into GXDBVersions values(2, 'WFSetActivity',  '00010016007400030000', 'WFSetActivity', '00010016007400030000')
GO

