

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFProcessAuthorizations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFProcessAuthorizations.sp,v $ $Id: WFProcessAuthorizations.sp,v 1.1.2.1 2020/05/05 17:57:00 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets the list of workflow engines
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFProcessAuthorizations')
BEGIN
	print '>>> Drop Stored Procedure: WFProcessAuthorizations <<<'
	drop procedure WFProcessAuthorizations
END
IF EXISTS (select * from GxQscripts where name='WFProcessAuthorizations')
	delete from GxQscripts where name = 'WFProcessAuthorizations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFProcessAuthorizations')
	delete from GXDBVersions where aliasname = 'WFProcessAuthorizations'
GO
print '... Creating Procedure: WFProcessAuthorizations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFProcessAuthorizations
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_WorkflowId integer,
  @i_Action varchar(50),
  @i_userId integer,
  @o_errorCode integer OUTPUT,
  @o_errorMsg nvarchar(255) OUTPUT
AS
SET NOCOUNT ON
BEGIN
DECLARE @currentAction nvarchar(50)
DECLARE @initiatedBy int
DECLARE @restricted int
SELECT @restricted=Restricted
FROM WF_Definition
WHERE WorkflowId = @i_WorkflowId
IF @restricted = 0
BEGIN
	SET @o_errorCode = 0
	SET @o_errorMsg = ''
	GOTO FINISH
END
IF EXISTS(SELECT * FROM WF_Authorizations WHERE WorkflowId = @i_WorkflowId AND Action = @i_Action AND Status = 0 AND InitiatedBy = @i_userId)
BEGIN
	SET @o_errorCode = 1
	SET @o_errorMsg = 'Authorization Required'
	GOTO FINISH
END
IF @i_Action <> 'Enable'
BEGIN
	IF EXISTS(SELECT 1 FROM WF_Definition Where WorkflowId = @i_WorkflowId AND flags & 1 > 0)
	BEGIN
		SET @o_errorCode = 0
		SET @o_errorMsg = ''
		GOTO FINISH
	END
END
DECLARE @authId int
SELECT @authId = ISNULL(AuthId, 0) FROM WF_Authorizations WHERE WorkflowId = @i_WorkflowId AND Action = @i_Action AND Status = 0
IF @authId > 0
BEGIN
	UPDATE WF_Authorizations SET ApprovedBy = @i_userId, CompletedTime = dbo.GetUnixTime(GETUTCDATE()), Status = 1 Where AuthId = @authId
	SET @o_errorCode = 0
	SET @o_errorMsg = ''
END
ELSE
BEGIN
	INSERT INTO WF_Authorizations(WorkflowId, CreatedTime, Action, InitiatedBy, Status)
	VALUES(@i_WorkflowId, dbo.GetUnixTime(GETUTCDATE()), @i_Action, @i_userId, 0)
	SET @o_errorCode = 1
	SET @o_errorMsg = 'Authorization Required'
END
FINISH:
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFProcessAuthorizations')
	delete from GxQscripts where name = 'WFProcessAuthorizations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFProcessAuthorizations')
	delete from GXDBVersions where aliasname = 'WFProcessAuthorizations'
GO

insert into GXDBVersions values(2, 'WFProcessAuthorizations',  '00010001000200010000', 'WFProcessAuthorizations', '00010001000200010000')
GO

