

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflows.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflows.sp,v $ $Id: WFGetWorkflows.sp,v 1.53.2.17 2020/12/15 21:59:11 cnaik Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets all the workflows
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='WFGetWorkflows')
BEGIN
	print '>>> Drop Stored Procedure: WFGetWorkflows <<<'
	drop procedure WFGetWorkflows
END
IF EXISTS (select * from GxQscripts where name='WFGetWorkflows')
	delete from GxQscripts where name = 'WFGetWorkflows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflows')
	delete from GXDBVersions where aliasname = 'WFGetWorkflows'
GO
print '... Creating Procedure: WFGetWorkflows'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure WFGetWorkflows
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
  DECLARE @xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @capabilityFlag INT
SET @capabilityFlag = ISNULL((SELECT ref.value('@capabilityFlags', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowsRequest/filterOptions') R ( ref ) ), 0)
DECLARE @smartFolderId INT = 0
SET @smartFolderId = ISNULL( (SELECT ref.value('@smartFolderId', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowsRequest/folder') R ( ref ) ), 0)
DECLARE @showHidden BIT = 0
SET @showHidden = ISNULL( (SELECT ref.value('@showHidden', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowsRequest') R ( ref ) ), 0)
DECLARE @workflowId INT = 0
SET @workflowId = ISNULL( (SELECT ref.value('@workflowId', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowsRequest/container') R ( ref ) ), 0)
IF ( @userId = 0 OR @userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User not provided'
	GOTO FINISH
END
DECLARE @workflowTable TABLE (workflowId int PRIMARY KEY)
IF object_id('tempdb.dbo.#WFGetWorkFlows_CommcellPermissions') is not null DROP TABLE #WFGetWorkFlows_CommcellPermissions
CREATE TABLE #WFGetWorkFlows_CommcellPermissions (permissionId INT)
EXEC sec_getPermissionsOnEntity '#WFGetWorkFlows_CommcellPermissions', @userId, 1, 2
IF (
		(@capabilityFlag <> 2 AND
EXISTS (SELECT * FROM #WFGetWorkFlows_CommcellPermissions WHERE permissionId IN (16, 1))
		)
	OR (@capabilityFlag = 2 AND
EXISTS (SELECT * FROM #WFGetWorkFlows_CommcellPermissions WHERE permissionId IN (18))
		)
	)
BEGIN
	IF @workflowId <> 0
	BEGIN
		INSERT @workflowTable(workflowId)
		SELECT WorkflowId
		FROM WF_Definition d
		WHERE (@showHidden = 1 OR d.flags & 16 = 0)
AND (@smartFolderId = 0 OR d.workFlowId IN (SELECT componentId FROM dbo.GetFolderAssocs(@smartFolderId, 83)))
		AND d.WorkflowId = @workflowId
	END
	ELSE
	BEGIN
		INSERT @workflowTable(workflowId)
		SELECT WorkflowId
		FROM WF_Definition d
		WHERE (@showHidden = 1 OR d.flags & 16 = 0)
AND (@smartFolderId = 0 OR d.workFlowId IN (SELECT componentId FROM dbo.GetFolderAssocs(@smartFolderId, 83)))
	END
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#WFGetWorkflows_ViewExecute') is not null DROP TABLE #WFGetWorkflows_ViewExecute
	CREATE TABLE #WFGetWorkflows_ViewExecute (workflowId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 83, 31, '#WFGetWorkflows_ViewExecute'
EXEC sec_getNonIdaObjectsForThisUser @userId, 83, 113, '#WFGetWorkflows_ViewExecute'
	IF object_id('tempdb.dbo.#WFGetWorkflows_EditDelete') is not null DROP TABLE #WFGetWorkflows_EditDelete
	CREATE TABLE #WFGetWorkflows_EditDelete (workflowId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 83, 112, '#WFGetWorkflows_EditDelete'
EXEC sec_getNonIdaObjectsForThisUser @userId, 83, 114, '#WFGetWorkflows_EditDelete'
	MERGE #WFGetWorkflows_ViewExecute viewExe
	USING	(SELECT WorkflowId
		FROM WF_Definition WITH(NOLOCK)
		WHERE (flags & 32) = 32) skipSec
		ON viewExe.workflowId = skipSec.WorkflowId
	WHEN NOT MATCHED THEN INSERT(workflowId) VALUES(skipSec.WorkflowId);
	IF @workflowId <> 0
	BEGIN
		INSERT @workflowTable(workflowId)
		SELECT d.WorkflowId
		FROM WF_Definition d
		WHERE (d.WorkflowId IN (Select workflowId FROM #WFGetWorkflows_ViewExecute) OR d.WorkflowId IN (Select workflowId FROM #WFGetWorkflows_EditDelete))
AND (@smartFolderId = 0 OR d.workFlowId IN (SELECT componentId FROM dbo.GetFolderAssocs(@smartFolderId, 83)))
		AND d.flags & 16 = 0
		AND d.WorkflowId = @workflowId
	END
	ELSE
	BEGIN
		INSERT @workflowTable(workflowId)
		SELECT d.WorkflowId
		FROM WF_Definition d
		WHERE (d.WorkflowId IN (Select workflowId FROM #WFGetWorkflows_ViewExecute) OR d.WorkflowId IN (Select workflowId FROM #WFGetWorkflows_EditDelete))
AND (@smartFolderId = 0 OR d.workFlowId IN (SELECT componentId FROM dbo.GetFolderAssocs(@smartFolderId, 83)))
		AND d.flags & 16 = 0
	END
	IF @showHidden = 1
	BEGIN
		IF @workflowId <> 0
		BEGIN
			INSERT @workflowTable(workflowId)
			SELECT d.WorkflowId
			FROM WF_Definition d
			WHERE d.WorkflowId IN (Select workflowId FROM #WFGetWorkflows_EditDelete)
AND (@smartFolderId = 0 OR d.workFlowId IN (SELECT componentId FROM dbo.GetFolderAssocs(@smartFolderId, 83)))
			AND d.workflowId NOT IN (Select workflowId FROM @workflowTable)
			AND d.flags & 16 > 0
			AND d.WorkflowId = @workflowId
		END
		ELSE
		BEGIN
			INSERT @workflowTable(workflowId)
			SELECT d.WorkflowId
			FROM WF_Definition d
			WHERE d.WorkflowId IN (Select workflowId FROM #WFGetWorkflows_EditDelete)
AND (@smartFolderId = 0 OR d.workFlowId IN (SELECT componentId FROM dbo.GetFolderAssocs(@smartFolderId, 83)))
			AND d.workflowId NOT IN (Select workflowId FROM @workflowTable)
			AND d.flags & 16 > 0
		END
	END
	DROP TABLE #WFGetWorkflows_ViewExecute
	DROP TABLE #WFGetWorkflows_EditDelete
END
DROP TABLE #WFGetWorkFlows_CommcellPermissions
IF (@capabilityFlag = 2)
BEGIN
	SET @xmlText = (
			SELECT
				d.WorkflowId 'entity/@workflowId',
				d.Name 'entity/@workflowName'
		FROM WF_Definition d
		INNER JOIN @workflowTable t ON d.WorkflowId = t.workflowId
		FOR XML PATH('container'), ROOT('Workflow_GetWorkflowsResponse')
	)
END
ELSE
BEGIN
	SET @xmlText = (
			SELECT
				d.Version '@version',
				d.flags '@flags',
				d.Description '@description',
				d.uniqueGuid '@uniqueGuid',
				d.revision '@revision',
				d.Tags '@tags',
				dbo.GetUnixTime(d.Created) '@createdTime',
				dbo.GetUnixTime(d.Modified) '@modifiedTime',
				ISNULL(DCCache.remoteRevision, '') AS '@remoteRevision',
				ISNULL(DCCache.whatsNew, '') AS '@whatsNew',
				DCCache.packageId AS '@packageId',
				DCCache.platformId AS '@platformId',
				p.stringVal '@configSettings',
				d.WorkflowId 'entity/@workflowId',
				d.Name 'entity/@workflowName',
				u.id 'creator/@userId',
				u.userGuid 'creator/@userGUID',
				u.login 'creator/@userName',
				(SELECT	dep.DeployId '@deployId',
						dep.Deployed '@deployed',
						dep.InputSchema '@inputSchema',
						dep.InputsXml '@inputsXml',
						dep.Version '@version',
						dep.flags '@flags',
						d.Description '@description',
						(SELECT cast(x.InputForm as XML)
						FROM WF_Deploy x
						WHERE x.DeployId = dep.DeployId),
						(SELECT cast(x.ConfigForm as XML)
						FROM WF_Deploy x
						WHERE x.DeployId = dep.DeployId),
						dep.clientId 'client/@clientId',
						c.name 'client/@clientName',
						c.displayName 'client/@displayName'
				FROM WF_Deploy dep
				INNER JOIN APP_Client c ON dep.clientId = c.id
				INNER JOIN
				(
					SELECT WorkflowId, clientId, MAX(DeployId) AS DeployId
					FROM WF_Deploy
					WHERE Status = 1
					GROUP BY WorkflowId, clientId
				) dh ON dep.DeployId = dh.DeployId
				WHERE d.WorkflowId = dep.WorkflowId
				FOR XML PATH('deployments'), TYPE),
				(SELECT auth.AuthId,
						auth.CreatedTime,
						auth.Action,
						users.id 'user/@userId',
						users.userGuid 'user/@userGUID',
						users.login 'user/@userName'
				FROM WF_Authorizations auth
				INNER JOIN UMUsers users ON auth.InitiatedBy = users.id
				WHERE auth.Status = 0
				FOR XML PATH('authorizations'), TYPE)
		FROM WF_Definition d
		INNER JOIN UMUsers u ON d.userId = u.id
		INNER JOIN @workflowTable t ON d.WorkflowId = t.workflowId
		LEFT OUTER JOIN (
			Select componentId, stringVal from APP_ComponentProp Where componentType = 13 And propertyTypeId = 18
		) p ON d.WorkflowId = p.componentId
		LEFT OUTER JOIN DCStoreItemCache DCCache ON d.uniqueGuid = DCCache.guid
		ORDER BY d.Name
		FOR XML PATH('container'), ROOT('Workflow_GetWorkflowsResponse')
	)
END
IF (@xmlText IS NULL)
BEGIN
	SET @xmlText = '<Workflow_GetWorkflowsResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @xmlText AS o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflows')
	delete from GxQscripts where name = 'WFGetWorkflows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflows')
	delete from GXDBVersions where aliasname = 'WFGetWorkflows'
GO

insert into GXDBVersions values(2, 'WFGetWorkflows',  '00010053000200170000', 'WFGetWorkflows', '00010053000200170000')
GO

