

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflowSchema.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflowSchema.sp,v $ $Id: WFGetWorkflowSchema.sp,v 1.17.200.1 2018/03/27 08:09:33 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets schema definitions based on a namespace
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetWorkflowSchema <<<'

IF EXISTS (select * from sysobjects where name='WFGetWorkflowSchema')
	drop procedure WFGetWorkflowSchema
IF EXISTS (select * from GxQscripts where name='WFGetWorkflowSchema')
	delete from GxQscripts where name = 'WFGetWorkflowSchema'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowSchema')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowSchema'
GO
print '... Creating Procedure: WFGetWorkflowSchema'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflowSchema
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
SET @o_xmlText = (
	SELECT	s.XsdSchema '@schema',
			s.SchemaId 'workflowSchema/@schemaId',
			s.Namespace 'workflowSchema/@schemaNamespace',
			(SELECT 	a.LocationId '@schemaLocationId',
						a.LocationUrl '@schemaLocationUrl'
				 FROM WF_SchemaLocation a
				 WHERE a.LocationId = s.LocationId
				 FOR XML PATH('location'), TYPE)
	FROM WF_Schema s
	FOR XML PATH('schemas'), ROOT('Workflow_GetWorkflowSchemaResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWorkflowSchemaResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflowSchema')
	delete from GxQscripts where name = 'WFGetWorkflowSchema'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowSchema')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowSchema'
GO

insert into GXDBVersions values(2, 'WFGetWorkflowSchema',  '00010017020000010000', 'WFGetWorkflowSchema', '00010017020000010000')
GO

