

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflowMessage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflowMessage.sp,v $ $Id: WFGetWorkflowMessage.sp,v 1.10.200.1 2018/03/27 07:58:04 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets the workflow message queue response
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetWorkflowMessage <<<'

IF EXISTS (select * from sysobjects where name='WFGetWorkflowMessage')
	drop procedure WFGetWorkflowMessage
IF EXISTS (select * from GxQscripts where name='WFGetWorkflowMessage')
	delete from GxQscripts where name = 'WFGetWorkflowMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowMessage')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowMessage'
GO
print '... Creating Procedure: WFGetWorkflowMessage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflowMessage
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @messageId INT
SET @messageId = ISNULL((SELECT ref.value('@messageId', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowMessageRequest') R ( ref ) ), 0)
SET @o_xmlText = (SELECT MessageResponse FROM WF_MessageQueue WHERE MessageId = @messageId)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWorkflowMessageResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflowMessage')
	delete from GxQscripts where name = 'WFGetWorkflowMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowMessage')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowMessage'
GO

insert into GXDBVersions values(2, 'WFGetWorkflowMessage',  '00010010020000010000', 'WFGetWorkflowMessage', '00010010020000010000')
GO

