

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflowHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflowHistory.sp,v $ $Id: WFGetWorkflowHistory.sp,v 1.10.88.3 2020/01/15 03:58:23 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/31/2011
-- Description:	gets a workflow history
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetWorkflowHistory')
BEGIN
	print '>>> Drop Stored Procedure: WFGetWorkflowHistory <<<'
	drop procedure WFGetWorkflowHistory
END
IF EXISTS (select * from GxQscripts where name='WFGetWorkflowHistory')
	delete from GxQscripts where name = 'WFGetWorkflowHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowHistory')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowHistory'
GO
print '... Creating Procedure: WFGetWorkflowHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflowHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId INT
DECLARE @workflowName nvarchar(255)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','INT'), 0),
		@workflowName = ref.value('@workflowName','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_GetWorkflowHistory/workflow') R(ref)
DECLARE @hasRights INT = 0
IF object_id('tempdb.dbo.#WFGetWorkFlow_PermissionsTbl') IS NOT NULL DROP TABLE #WFGetWorkFlow_PermissionsTbl
CREATE TABLE #WFGetWorkFlow_PermissionsTbl (permissionId INT)
EXEC sec_getPermissionsOnEntity '#WFGetWorkFlow_PermissionsTbl', @i_userId, 83, @workflowId
IF NOT EXISTS (SELECT permissionId FROM #WFGetWorkFlow_PermissionsTbl WHERE permissionId IN (31, 112))
BEGIN
	SET @hasRights = 0
END
ELSE
	SET @hasRights = 1
IF @hasRights = 0
BEGIN
	EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
END
IF @hasRights = 0
BEGIN
	SET @o_errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @o_errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
	SET @o_errorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
	IF dbo.isNewSecurity() = 0
SET @o_errorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 31), 0,2))
	ELSE
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 31), 0,2))
	SET @o_errorString = REPLACE(@o_ErrorString, '^3%s', @workflowName)
	GOTO FINISH
END
SET @o_xmlText = (
    SELECT	h.HistoryId '@historyId',
			h.Version '@version',
			h.Created '@created',
			h.Description '@workflowComment',
			h.WorkflowId 'workflow/@workflowId',
			h.Name 'workflow/@workflowName',
			u.id 'user/@userId',
			u.userGuid 'user/@userGUID',
			u.login 'user/@userName',
			(SELECT	d.DeployId '@deployId',
					d.Deployed '@deployed',
					d.InputSchema '@inputSchema',
					d.InputsXml '@inputsXml',
					d.Version '@version',
					d.flags '@flags',
					r.Description '@workflowComment',
					(SELECT cast(x.InputForm as XML)
					FROM WF_Deploy x
					WHERE x.DeployId = d.DeployId),
					d.clientId 'client/@clientId',
					c.name 'client/@clientName',
					c.displayName 'client/@displayName'
			FROM WF_Deploy d
			INNER JOIN APP_Client c ON d.clientId = c.id
			INNER JOIN WF_Definition r ON d.WorkflowId = r.WorkflowId
			INNER JOIN
			(
				SELECT WorkflowId, clientId, Version, MAX(DeployId) AS DeployId
				FROM WF_Deploy
				WHERE Status = 1
				GROUP BY WorkflowId, clientId, Version
			) dh ON d.DeployId = dh.DeployId
			WHERE d.WorkflowId = h.WorkflowId
			AND d.Version = h.Version
			FOR XML PATH('deployments'), TYPE)
	FROM	WF_DefinitionHistory h
	INNER JOIN UMUsers u ON h.userId = u.id
	WHERE	h.WorkflowId = @workflowId
	ORDER BY h.HistoryId DESC
	FOR XML PATH('history'), ROOT('Workflow_GetWorkflowHistoryResp')
)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWorkflowHistoryResp />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflowHistory')
	delete from GxQscripts where name = 'WFGetWorkflowHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowHistory')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowHistory'
GO

insert into GXDBVersions values(2, 'WFGetWorkflowHistory',  '00010010008800030000', 'WFGetWorkflowHistory', '00010010008800030000')
GO

