

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflowDeployments.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflowDeployments.sp,v $ $Id: WFGetWorkflowDeployments.sp,v 1.20.88.5 2020/09/01 20:29:21 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/15/2010
-- Description:	returns the list of deployments for a workflow definition
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetWorkflowDeployments')
BEGIN
	print '>>> Drop Stored Procedure: WFGetWorkflowDeployments <<<'
	drop procedure WFGetWorkflowDeployments
END
IF EXISTS (select * from GxQscripts where name='WFGetWorkflowDeployments')
	delete from GxQscripts where name = 'WFGetWorkflowDeployments'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowDeployments')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowDeployments'
GO
print '... Creating Procedure: WFGetWorkflowDeployments'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflowDeployments
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId INT
SET @workflowId = ISNULL((SELECT ref.value('@workflowId', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowDeploymentsRequest/workflow') R ( ref ) ), 0)
DECLARE @workflowName nvarchar(255)
SET @workflowName = ISNULL((SELECT ref.value('@workflowName', 'nvarchar(255)') FROM @i_xmlText.nodes('Workflow_GetWorkflowDeploymentsRequest/workflow') R ( ref ) ), '')
IF (@workflowId = 0)
BEGIN
	SELECT @workflowId=ISNULL(WorkflowId, 0)
	FROM WF_Definition
	WHERE Name = @workflowName
END
SET @o_xmlText = (
		SELECT
			r.Version '@latestVersion',
			r.flags '@flags',
			r.WorkflowId 'workflow/@workflowId',
			r.Name 'workflow/@workflowName',
			(SELECT	d.DeployId '@deployId',
					d.Deployed '@deployed',
					d.InputSchema '@inputSchema',
					d.InputsXml '@inputsXml',
					d.Version '@version',
					d.flags '@flags',
					r.Description '@description',
					(SELECT cast(x.InputForm as XML)
					FROM WF_Deploy x
					WHERE x.DeployId = d.DeployId),
					(SELECT cast(x.ConfigForm as XML)
					FROM WF_Deploy x
					WHERE x.DeployId = d.DeployId),
					d.clientId 'client/@clientId',
					c.name 'client/@clientName',
					c.displayName 'client/@displayName'
			FROM WF_Deploy d
			INNER JOIN APP_Client c ON d.clientId = c.id
			INNER JOIN
			(
				SELECT WorkflowId, clientId, MAX(DeployId) AS DeployId
				FROM WF_Deploy
				WHERE Status = 1
				GROUP BY WorkflowId, clientId
			) dh ON d.DeployId = dh.DeployId
			WHERE d.WorkflowId = r.WorkflowId
			FOR XML PATH('deployments'), TYPE)
	FROM	WF_Definition r
	WHERE	r.WorkflowId = @workflowId
	FOR XML PATH('deployments'), ROOT('Workflow_GetWorkflowDeploymentsResponse')
)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWorkflowDeploymentsResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflowDeployments')
	delete from GxQscripts where name = 'WFGetWorkflowDeployments'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowDeployments')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowDeployments'
GO

insert into GXDBVersions values(2, 'WFGetWorkflowDeployments',  '00010020008800050000', 'WFGetWorkflowDeployments', '00010020008800050000')
GO

