

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflowClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflowClients.sp,v $ $Id: WFGetWorkflowClients.sp,v 1.1.2.5 2020/04/29 17:45:52 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 05/18/2017
-- Description:	retrieves the clients for the workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetWorkflowClients')
BEGIN
	print '>>> Drop Stored Procedure: WFGetWorkflowClients <<<'
	drop procedure WFGetWorkflowClients
END
IF EXISTS (select * from GxQscripts where name='WFGetWorkflowClients')
	delete from GxQscripts where name = 'WFGetWorkflowClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowClients')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowClients'
GO
print '... Creating Procedure: WFGetWorkflowClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflowClients
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @clientId int
DECLARE @workflowName nvarchar(255)
DECLARE @workflowId int
DECLARE @alwaysReturnEngine BIT
SELECT	@workflowName = ref.value('@workflowName','nvarchar(255)'),
		@workflowId = ISNULL(ref.value('@workflowId','int'), 0)
FROM @i_xmlText.nodes('Workflow_GetClientForWorkflowReq/workflow') R(ref)
SELECT	@alwaysReturnEngine = ref.value('@alwaysReturnEngine','BIT')
FROM @i_xmlText.nodes('Workflow_GetClientForWorkflowReq') R(ref)
IF (@workflowId = 0)
BEGIN
	SELECT @workflowId=ISNULL(WorkflowId, 0)
	FROM WF_Definition
	WHERE Name = @workflowName OR uniqueGuid = @workflowName
END
IF (@workflowId = 0)
	RAISERROR('workflow does not exist', 15 /* Severity > 10 to force DOS error code 1 */, 1);
DECLARE @engineTable TABLE (clientId int, flag int, jobs int)
DECLARE @lastestVersion int
SELECT @lastestVersion = Max(Version) FROM WF_Deploy Where WorkflowId = @workflowId
INSERT INTO @engineTable
SELECT d.clientId, 1, ISNULL(j.jobs, 0)
FROM WF_Deploy d
LEFT OUTER JOIN (
	SELECT cloudId As clientId, Count(*) AS jobs
	FROM JMAdminJobInfoTable with(nolock)
	WHERE opType = 90
	GROUP BY cloudId
) j ON d.ClientId = j.clientId
WHERE [Version] = @lastestVersion AND WorkflowId = @workflowId
AND d.ClientId IN (
	SELECT ClientId
	FROM dbo.simInstalledPackages
	WHERE simPackageID in (808,854)
)
IF @alwaysReturnEngine = 1 AND NOT EXISTS(SELECT * FROM @engineTable)
BEGIN
	SELECT ClientId FROM dbo.simInstalledPackages WHERE simPackageID in (808,854)
END
ELSE
BEGIN
	SELECT clientId FROM @engineTable ORDER BY jobs
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflowClients')
	delete from GxQscripts where name = 'WFGetWorkflowClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowClients')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowClients'
GO

insert into GXDBVersions values(2, 'WFGetWorkflowClients',  '00010001000200050000', 'WFGetWorkflowClients', '00010001000200050000')
GO

