

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflowClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflowClient.sp,v $ $Id: WFGetWorkflowClient.sp,v 1.4.12.5 2020/04/29 17:45:37 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 06/07/2013
-- Description:	retrieves the default client for the workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetWorkflowClient')
BEGIN
	print '>>> Drop Stored Procedure: WFGetWorkflowClient <<<'
	drop procedure WFGetWorkflowClient
END
IF EXISTS (select * from GxQscripts where name='WFGetWorkflowClient')
	delete from GxQscripts where name = 'WFGetWorkflowClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowClient')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowClient'
GO
print '... Creating Procedure: WFGetWorkflowClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflowClient
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowName nvarchar(255)
DECLARE @workflowId int
DECLARE @clientName nvarchar(255)
DECLARE @clientId int
DECLARE @alwaysReturnEngine BIT
SELECT	@alwaysReturnEngine = ref.value('@alwaysReturnEngine','BIT')
FROM @i_xmlText.nodes('Workflow_GetClientForWorkflowReq') R(ref)
SELECT	@workflowName = ref.value('@workflowName','nvarchar(255)'),
		@workflowId = ISNULL(ref.value('@workflowId','int'), 0)
FROM @i_xmlText.nodes('Workflow_GetClientForWorkflowReq/workflow') R(ref)
SELECT	@clientName = ref.value('@clientName','nvarchar(255)'),
		@clientId = ISNULL(ref.value('@clientId','int'), 0)
FROM @i_xmlText.nodes('Workflow_GetClientForWorkflowReq/defaultClient') R(ref)
IF (@workflowId = 0)
BEGIN
	SELECT @workflowId=ISNULL(WorkflowId, 0)
	FROM WF_Definition
	WHERE Name = @workflowName OR uniqueGuid = @workflowName
END
IF (@workflowId = 0)
BEGIN
	SET @o_errorCode = 1
	SET	@o_errorString = 'workflow not provided'
	GOTO FINISH
END
DECLARE @engineTable TABLE (clientId int)
IF (@clientId = 0)
BEGIN
	SELECT @clientId=ISNULL(id, 0)
	FROM APP_Client
	WHERE name = @clientName
END
DECLARE @clientForWorkflow INT
SET @clientForWorkflow = dbo.GetClientForWorkflow(@workflowId, @clientId)
IF EXISTS (SELECT * FROM APP_Client Where id = @clientForWorkflow)
BEGIN
	INSERT INTO @engineTable(clientId)
	VALUES (@clientForWorkflow)
END
ELSE IF @alwaysReturnEngine = 1
BEGIN
	INSERT INTO @engineTable(clientId)
	SELECT TOP 1 ClientId
	FROM dbo.simInstalledPackages
	WHERE simPackageID in (808,854)
END
SET @o_xmlText = (
	SELECT TOP 1
		id '@clientId',
		name '@clientName',
		displayName '@displayName'
	FROM APP_Client c
	WHERE c.id IN (SELECT clientId FROM @engineTable)
	FOR XML PATH('client'), ROOT('Workflow_GetClientForWorkflowResp')
)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_errorCode = 2
	SET	@o_errorString = 'no engine available for workflow'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [Workflow_GetClientForWorkflowResp!1!errorCode],
				@o_ErrorString	as [Workflow_GetClientForWorkflowResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText As o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflowClient')
	delete from GxQscripts where name = 'WFGetWorkflowClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflowClient')
	delete from GXDBVersions where aliasname = 'WFGetWorkflowClient'
GO

insert into GXDBVersions values(2, 'WFGetWorkflowClient',  '00010004001200050000', 'WFGetWorkflowClient', '00010004001200050000')
GO

