

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetWorkflow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetWorkflow.sp,v $ $Id: WFGetWorkflow.sp,v 1.36.2.5 2020/09/01 20:29:12 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetWorkflow')
BEGIN
	print '>>> Drop Stored Procedure: WFGetWorkflow <<<'
	drop procedure WFGetWorkflow
END
IF EXISTS (select * from GxQscripts where name='WFGetWorkflow')
	delete from GxQscripts where name = 'WFGetWorkflow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflow')
	delete from GXDBVersions where aliasname = 'WFGetWorkflow'
GO
print '... Creating Procedure: WFGetWorkflow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetWorkflow
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @version INT
SET @version = ISNULL((SELECT ref.value('@version', 'INT') FROM @i_xmlText.nodes('Workflow_GetWorkflowRequest') R ( ref ) ), 0)
DECLARE @workflowId INT
DECLARE @workflowName nvarchar(255)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','INT'), 0),
		@workflowName = ref.value('@workflowName','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_GetWorkflowRequest/workflow') R(ref)
IF ( @i_userId = 0 OR @i_userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User not provided'
	GOTO FINISH
END
DECLARE @hasRights INT = 0
IF dbo.isNewSecurity() = 0
BEGIN
	IF object_id('tempdb.dbo.#WFGetWorkflow_UserObjects') is not null DROP TABLE #WFGetWorkflow_UserObjects
create table  #WFGetWorkflow_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 14033, 0, '#WFGetWorkflow_UserObjects'
	DECLARE @two bigint =2
IF NOT EXISTS(SELECT * FROM #WFGetWorkflow_UserObjects WHERE (workflowId = @workflowId OR commCellId = 2) AND ((capabilities & power(@two, 31-1) > 0 ) OR (capabilities & power(@two, 34-1) > 0)))
	BEGIN
		SET @hasRights = 0
	END
	ELSE
		SET @hasRights = 1
	DROP TABLE #WFGetWorkflow_UserObjects
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#WFGetWorkFlow_PermissionsTbl') IS NOT NULL DROP TABLE #WFGetWorkFlow_PermissionsTbl
	CREATE TABLE #WFGetWorkFlow_PermissionsTbl (permissionId INT)
EXEC sec_getPermissionsOnEntity '#WFGetWorkFlow_PermissionsTbl', @i_userId, 83, @workflowId
IF NOT EXISTS (SELECT permissionId FROM #WFGetWorkFlow_PermissionsTbl WHERE permissionId IN (31, 112))
	BEGIN
		SET @hasRights = 0
	END
	ELSE
		SET @hasRights = 1
END
IF @hasRights = 0
BEGIN
	EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
END
IF @hasRights = 0
BEGIN
	SET @o_errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @o_errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
	SET @o_errorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
	IF dbo.isNewSecurity() = 0
SET @o_errorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 31), 0,2))
	ELSE
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 31), 0,2))
	SET @o_errorString = REPLACE(@o_ErrorString, '^3%s', @workflowName)
	GOTO FINISH
END
DECLARE @definitionTable TABLE (WorkflowId int,
								Name nvarchar(255),
								Definition XML,
								Description nvarchar(MAX) NULL,
								Version int,
								flags int,
								uniqueGuid nvarchar(256) NULL,
								revision nvarchar(255) NULL)
IF (@version = 0)
BEGIN
	INSERT INTO @definitionTable
	SELECT WorkflowId, Name, Definition, Description, Version, flags, uniqueGuid, revision
	FROM WF_Definition
	WHERE WorkflowId = @workflowId
END
ELSE
BEGIN
	INSERT INTO @definitionTable
	SELECT h.WorkflowId, h.Name, h.Definition, h.Description, h.Version, d.flags, d.uniqueGuid, d.revision
	FROM WF_DefinitionHistory h
	INNER JOIN WF_Definition d ON h.WorkflowId = d.WorkflowId
	WHERE h.Version = @version
END
DECLARE @configXml nvarchar(max)
Select @configXml = stringVal from APP_ComponentProp Where componentType = 13 AND componentId = @workflowId And propertyTypeId = 18
SET @o_xmlText = (
		SELECT
			d.Version '@version',
			d.flags '@flags',
			d.Description '@description',
			d.uniqueGuid '@uniqueGuid',
			d.revision '@revision',
			@configXml '@configSettings',
			(SELECT w.Definition
			FROM @definitionTable w
			WHERE w.WorkflowId = d.WorkflowId),
			d.WorkflowId 'entity/@workflowId',
			d.Name 'entity/@workflowName',
			(SELECT	dep.DeployId '@deployId',
					dep.Deployed '@deployed',
					dep.InputSchema '@inputSchema',
					dep.InputsXml '@inputsXml',
					dep.Version '@version',
					dep.flags '@flags',
					d.Description '@description',
					(SELECT cast(x.InputForm as XML)
					FROM WF_Deploy x
					WHERE x.DeployId = dep.DeployId),
					(SELECT cast(x.ConfigForm as XML)
					FROM WF_Deploy x
					WHERE x.DeployId = dep.DeployId),
					dep.clientId 'client/@clientId',
					c.name 'client/@clientName',
					c.displayName 'client/@displayName'
			FROM WF_Deploy dep
			INNER JOIN APP_Client c ON dep.clientId = c.id
			INNER JOIN
			(
				SELECT WorkflowId, clientId, MAX(DeployId) AS DeployId
				FROM WF_Deploy
				WHERE Status = 1
				GROUP BY WorkflowId, clientId
			) dh ON dep.DeployId = dh.DeployId
			WHERE d.WorkflowId = dep.WorkflowId
			FOR XML PATH('deployments'), TYPE)
		FROM @definitionTable d
		WHERE d.WorkflowId = @workflowId
		FOR XML PATH('container'), ROOT('Workflow_GetWorkflowResponse')
	)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWorkflowResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetWorkflow')
	delete from GxQscripts where name = 'WFGetWorkflow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetWorkflow')
	delete from GXDBVersions where aliasname = 'WFGetWorkflow'
GO

insert into GXDBVersions values(2, 'WFGetWorkflow',  '00010036000200050000', 'WFGetWorkflow', '00010036000200050000')
GO

