

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetSchemaLock.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetSchemaLock.sp,v $ $Id: WFGetSchemaLock.sp,v 1.3.84.1 2018/03/27 08:10:52 jiechen Exp $";
-- =========================================================
-- Author:		Chris Sunderland
-- Create date: 10/11/2011
-- Description:	gains lock on the schema table for updating
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetSchemaLock <<<'

IF EXISTS (select * from sysobjects where name='WFGetSchemaLock')
	drop procedure WFGetSchemaLock
IF EXISTS (select * from GxQscripts where name='WFGetSchemaLock')
	delete from GxQscripts where name = 'WFGetSchemaLock'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetSchemaLock')
	delete from GXDBVersions where aliasname = 'WFGetSchemaLock'
GO
print '... Creating Procedure: WFGetSchemaLock'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetSchemaLock
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_server nvarchar(255)
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_lockedBy nvarchar(255)
BEGIN TRANSACTION
	DECLARE @res INT
	EXEC @res = sp_getapplock @Resource = 'WFGetSchemaLock', @LockMode = 'Exclusive', @LockTimeout = '60000'
	IF @res >= 0
	BEGIN
		IF OBJECT_ID('tempdb..##schemaLock') IS NOT NULL
		BEGIN
			SET @o_lockedBy = (SELECT TOP 1 ENGINE FROM ##schemaLock)
		END
		ELSE
		BEGIN
			SELECT @i_server AS ENGINE INTO ##schemaLock
			SET @o_lockedBy = @i_server
		END
	END
	ELSE
	BEGIN
		SET @o_lockedBy = ''
	END
COMMIT TRAN
SELECT @o_lockedBy
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetSchemaLock')
	delete from GxQscripts where name = 'WFGetSchemaLock'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetSchemaLock')
	delete from GXDBVersions where aliasname = 'WFGetSchemaLock'
GO

insert into GXDBVersions values(2, 'WFGetSchemaLock',  '00010003008400010000', 'WFGetSchemaLock', '00010003008400010000')
GO

