

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetSchemaLocations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetSchemaLocations.sp,v $ $Id: WFGetSchemaLocations.sp,v 1.12.200.1 2018/03/27 08:16:17 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/15/2010
-- Description:	retrieves all defined locations
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetSchemaLocations <<<'

IF EXISTS (select * from sysobjects where name='WFGetSchemaLocations')
	drop procedure WFGetSchemaLocations
IF EXISTS (select * from GxQscripts where name='WFGetSchemaLocations')
	delete from GxQscripts where name = 'WFGetSchemaLocations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetSchemaLocations')
	delete from GXDBVersions where aliasname = 'WFGetSchemaLocations'
GO
print '... Creating Procedure: WFGetSchemaLocations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetSchemaLocations
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @LOCATION_TYPES TABLE (
	[locationType] [int] NULL
)
INSERT INTO @LOCATION_TYPES(locationType)
SELECT ref.value('@val', 'INT')
FROM @i_xmlText.nodes('Workflow_GetSchemaLocationsRequest/locationType') R ( ref )
IF NOT EXISTS (select * from @LOCATION_TYPES)
	SET @o_xmlText = (
		SELECT	LocationType '@locationType',
				serviceUrl '@serviceUrl',
				Modified '@modified',
				LocationId 'location/@schemaLocationId',
				LocationUrl 'location/@schemaLocationUrl'
		FROM WF_SchemaLocation
		FOR XML PATH('locations'), ROOT('Workflow_GetSchemaLocationsResponse'))
ELSE
	SET @o_xmlText = (
		SELECT	LocationType '@locationType',
				serviceUrl '@serviceUrl',
				Modified '@modified',
				LocationId 'location/@schemaLocationId',
				LocationUrl 'location/@schemaLocationUrl'
		FROM WF_SchemaLocation
		WHERE LocationType IN (SELECT locationType FROM @LOCATION_TYPES)
		FOR XML PATH('locations'), ROOT('Workflow_GetSchemaLocationsResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetSchemaLocationsResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetSchemaLocations')
	delete from GxQscripts where name = 'WFGetSchemaLocations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetSchemaLocations')
	delete from GXDBVersions where aliasname = 'WFGetSchemaLocations'
GO

insert into GXDBVersions values(2, 'WFGetSchemaLocations',  '00010012020000010000', 'WFGetSchemaLocations', '00010012020000010000')
GO

