

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetSchemaLocation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetSchemaLocation.sp,v $ $Id: WFGetSchemaLocation.sp,v 1.2.200.1 2018/03/27 08:04:56 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/14/2011
-- Description:	retrieves all defined locations
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetSchemaLocation <<<'

IF EXISTS (select * from sysobjects where name='WFGetSchemaLocation')
	drop procedure WFGetSchemaLocation
IF EXISTS (select * from GxQscripts where name='WFGetSchemaLocation')
	delete from GxQscripts where name = 'WFGetSchemaLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetSchemaLocation')
	delete from GXDBVersions where aliasname = 'WFGetSchemaLocation'
GO
print '... Creating Procedure: WFGetSchemaLocation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetSchemaLocation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @locationType INT
SET @locationType = (SELECT ref.value('@locationType', 'INT') FROM @i_xmlText.nodes('Workflow_GetSchemaLocationsRequest') R ( ref ) )
IF (@locationType = NULL)
	SET @o_xmlText = (
		SELECT	LocationType '@locationType',
				serviceUrl '@serviceUrl',
				Modified '@modified',
				LocationId 'location/@schemaLocationId',
				LocationUrl 'location/@schemaLocationUrl'
		FROM WF_SchemaLocation
		FOR XML PATH('locations'), ROOT('Workflow_GetSchemaLocationsResponse'))
ELSE
	SET @o_xmlText = (
		SELECT	LocationType '@locationType',
				serviceUrl '@serviceUrl',
				Modified '@modified',
				LocationId 'location/@schemaLocationId',
				LocationUrl 'location/@schemaLocationUrl'
		FROM WF_SchemaLocation
		WHERE LocationType = @locationType
		FOR XML PATH('locations'), ROOT('Workflow_GetSchemaLocationsResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetSchemaLocationsResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetSchemaLocation')
	delete from GxQscripts where name = 'WFGetSchemaLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetSchemaLocation')
	delete from GXDBVersions where aliasname = 'WFGetSchemaLocation'
GO

insert into GXDBVersions values(2, 'WFGetSchemaLocation',  '00010002020000010000', 'WFGetSchemaLocation', '00010002020000010000')
GO

