

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetLocationForNamespace.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetLocationForNamespace.sp,v $ $Id: WFGetLocationForNamespace.sp,v 1.3.208.1 2018/03/27 08:05:31 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	retrieves the location url for a namespace
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetLocationForNamespace <<<'

IF EXISTS (select * from sysobjects where name='WFGetLocationForNamespace')
	drop procedure WFGetLocationForNamespace
IF EXISTS (select * from GxQscripts where name='WFGetLocationForNamespace')
	delete from GxQscripts where name = 'WFGetLocationForNamespace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetLocationForNamespace')
	delete from GXDBVersions where aliasname = 'WFGetLocationForNamespace'
GO
print '... Creating Procedure: WFGetLocationForNamespace'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetLocationForNamespace
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_namespace NVARCHAR(255)
AS
  DECLARE @locationUrl NVARCHAR(255)
	Select @locationUrl = LocationUrl
	From WF_SchemaLocation
	Where LocationId = (Select LocationId From WF_Schema Where Namespace = @i_namespace)
    SELECT @locationUrl
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetLocationForNamespace')
	delete from GxQscripts where name = 'WFGetLocationForNamespace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetLocationForNamespace')
	delete from GXDBVersions where aliasname = 'WFGetLocationForNamespace'
GO

insert into GXDBVersions values(2, 'WFGetLocationForNamespace',  '00010003020800010000', 'WFGetLocationForNamespace', '00010003020800010000')
GO

