

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetJobVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetJobVersion.sp,v $ $Id: WFGetJobVersion.sp,v 1.2.84.1 2018/03/27 08:00:41 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets the list of workflow engines
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetJobVersion <<<'

IF EXISTS (select * from sysobjects where name='WFGetJobVersion')
	drop procedure WFGetJobVersion
IF EXISTS (select * from GxQscripts where name='WFGetJobVersion')
	delete from GxQscripts where name = 'WFGetJobVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetJobVersion')
	delete from GXDBVersions where aliasname = 'WFGetJobVersion'
GO
print '... Creating Procedure: WFGetJobVersion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetJobVersion
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @jobId INT
SET @jobId = ISNULL((SELECT ref.value('@jobId', 'INT') FROM @i_xmlText.nodes('Workflow_ChangeVersionRequest') R ( ref ) ), 0)
Declare @jobVersion int
Declare @latestVersion int
Select	@jobVersion = m.intData,
		@latestVersion = d.Version
From JMAdminJobInfoTable j
INNER JOIN JMMisc m ON j.jobId = m.jobId AND m.itemType = 90
INNER JOIN
(
	Select WorkflowId, clientId, MAX(Version) As Version
	From WF_Deploy
	Group By WorkflowId, clientId
) d ON j.cloudId = d.clientId And j.workFlowId = d.WorkflowId
Where j.jobId = @jobId
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@jobVersion		as [Workflow_ChangeVersionResponse!1!jobVersion],
			@latestVersion	as [Workflow_ChangeVersionResponse!1!latestVersion]
FOR XML EXPLICIT)
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetJobVersion')
	delete from GxQscripts where name = 'WFGetJobVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetJobVersion')
	delete from GXDBVersions where aliasname = 'WFGetJobVersion'
GO

insert into GXDBVersions values(2, 'WFGetJobVersion',  '00010002008400010000', 'WFGetJobVersion', '00010002008400010000')
GO

