

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetInteractions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetInteractions.sp,v $ $Id: WFGetInteractions.sp,v 1.7.46.4 2018/03/27 07:59:37 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets the list of interaction requests for the user
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetInteractions <<<'

IF EXISTS (select * from sysobjects where name='WFGetInteractions')
	drop procedure WFGetInteractions
IF EXISTS (select * from GxQscripts where name='WFGetInteractions')
	delete from GxQscripts where name = 'WFGetInteractions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteractions')
	delete from GXDBVersions where aliasname = 'WFGetInteractions'
GO
print '... Creating Procedure: WFGetInteractions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetInteractions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId int
DECLARE @workflowName nvarchar(255)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','int'), 0),
		@workflowName = ISNULL(ref.value('@workflowName','nvarchar(255)'), '')
FROM @i_xmlText.nodes('Workflow_GetWebFormInteractionsRequest/workflow') R(ref)
DECLARE @jobId bigint
DECLARE @allowAll bit
SELECT	@jobId = ISNULL(ref.value('@jobId','bigint'), 0),
		@allowAll =	ISNULL(ref.value('@allowAll','bit'), 0)
FROM @i_xmlText.nodes('Workflow_GetWebFormInteractionsRequest') R(ref)
DECLARE @filter int
SELECT	@filter = ISNULL(ref.value('@filter','int'), 0)
FROM @i_xmlText.nodes('Workflow_GetWebFormInteractionsRequest') R(ref)
CREATE TABLE #interactionTable (
	InteractionId int, WorkflowId int, jobId bigint
)
CREATE CLUSTERED INDEX interactionTable_idx ON #interactionTable (InteractionId)
IF (@filter = 0)
BEGIN
	INSERT INTO #interactionTable
	SELECT i.InteractionId, i.WorkflowId, i.jobId
	FROM WF_Interaction i
		INNER JOIN dbo.GetUserInteractions(@i_userId, @allowAll) ui ON
			ui.InteractionId = i.InteractionId
			AND i.interactionType = 1
			AND i.Status = 0
END
IF (@filter = 1)
BEGIN
	INSERT INTO #interactionTable
	SELECT i.InteractionId, i.WorkflowId, i.jobId
	FROM WF_Interaction i
		INNER JOIN dbo.GetUserInteractions(@i_userId, @allowAll) ui ON
			ui.InteractionId = i.InteractionId
			AND i.interactionType = 1
			AND i.Status = 1
END
IF (@filter = 2)
BEGIN
	INSERT INTO #interactionTable
	SELECT i.InteractionId, i.WorkflowId, i.jobId
	FROM WF_Interaction i
		INNER JOIN dbo.GetUserInteractions(@i_userId, @allowAll) ui ON
			ui.InteractionId = i.InteractionId
			AND i.interactionType = 1
			AND i.Status = 1
	WHERE i.interactionType = 1
END
IF (@filter > 2)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'unknown filter value ' + cast(@filter as varchar)
	GOTO FINISH
END
IF (LEN(@workflowName) > 0)
BEGIN
	DELETE FROM #interactionTable
	WHERE WorkflowId NOT IN (SELECT WorkflowId FROM WF_Definition WHERE Name = @workflowName)
END
IF (@jobId > 0)
BEGIN
	DELETE FROM #interactionTable
	WHERE jobId NOT IN (@jobId)
END
--select count(*) rows from @interactionTable
SET @o_xmlText = (
  SELECT  i.InteractionId '@interactionId',
            i.jobId '@jobId',
            i.created '@created',
            i.activityName '@activityName',
            i.processStepId '@processStepId',
            i.description '@description',
            i.subject '@subject',
            i.status '@status',
            i.completed '@completed',
            i.inputSchema '@action',
            i.sessionId '@sessionId',
            i.flags '@flags',
            i.inputSchema '@actionExecuted',
					d.WorkflowId 'workflow/@workflowId',
                    d.Name 'workflow/@workflowName',
					crU.id 'user/@userId',
                    crU.login 'user/@userName',
					compU.id 'completedBy/@userId',
                    compU.login 'completedBy/@userName',
					c.id 'client/@clientId',
                    c.name 'client/@clientName',
					cc.id 'commCell/@commCellId',
                    cc.aliasName 'commCell/@commCellName'
    FROM WF_Interaction i
		INNER JOIN #interactionTable it ON
			it.InteractionId = i.InteractionId
		--INNER JOIN dbo.GetUserInteractions(@i_userId, @allowAll) ui ON
		--	ui.InteractionId = i.InteractionId
		INNER JOIN APP_CommCell cc ON
			cc.id = i.commCellId
		INNER JOIN  APP_Client c ON
			c.id = i.clientId
		LEFT OUTER JOIN UMUsers crU ON
			crU.id = i.createdBy
		LEFT OUTER JOIN WF_Definition d ON
			d.WorkflowId = i.workflowId
		LEFT OUTER JOIN UMUsers compU ON
			compU.id = i.completedBy
    ORDER BY i.created DESC
    FOR XML PATH('request'), ROOT('Workflow_GetWebFormInteractionsResponse')
)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWebFormInteractionsResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetInteractions')
	delete from GxQscripts where name = 'WFGetInteractions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteractions')
	delete from GXDBVersions where aliasname = 'WFGetInteractions'
GO

insert into GXDBVersions values(2, 'WFGetInteractions',  '00010007004600040000', 'WFGetInteractions', '00010007004600040000')
GO

