

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetInteractionUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetInteractionUsers.sp,v $ $Id: WFGetInteractionUsers.sp,v 1.2.86.1 2018/03/27 08:07:40 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 10/03/2013
-- Description:	retrieves all individual users assigned to an interaction
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetInteractionUsers <<<'

IF EXISTS (select * from sysobjects where name='WFGetInteractionUsers')
	drop procedure WFGetInteractionUsers
IF EXISTS (select * from GxQscripts where name='WFGetInteractionUsers')
	delete from GxQscripts where name = 'WFGetInteractionUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteractionUsers')
	delete from GXDBVersions where aliasname = 'WFGetInteractionUsers'
GO
print '... Creating Procedure: WFGetInteractionUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetInteractionUsers
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_interactionId integer
AS
SET NOCOUNT ON
BEGIN
DECLARE @userTable TABLE (userId int, userName nvarchar(255), email nvarchar(255))
INSERT INTO @userTable
SELECT id, login, email
FROM UMUsers
WHERE id IN (SELECT userId FROM WF_InteractionUsers WHERE InteractionId = @i_interactionId)
INSERT INTO @userTable
SELECT id, login, email
FROM UMUsers
WHERE id IN
(
	SELECT UMUserGroup.userId
	FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
	WHERE UMGroups.id IN (SELECT groupId FROM WF_InteractionUsers WHERE InteractionId = @i_interactionId)
)
AND id NOT IN (SELECT userId FROM @userTable)
INSERT INTO @userTable
SELECT id, login, email
FROM UMUsers
WHERE id IN
(
  		SELECT   DISTINCT  UMDSUserGroup.userId
  		FROM      UMGroups INNER JOIN
  				  UMDSGroupMaps ON UMGroups.id = UMDSGroupMaps.umgroupId INNER JOIN
  				  UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
  		WHERE UMGroups.id IN (SELECT groupId FROM WF_InteractionUsers WHERE InteractionId = @i_interactionId)
)
AND id NOT IN (SELECT userId FROM @userTable)
INSERT INTO @userTable
SELECT id, login, email
FROM UMUsers
WHERE id IN
(
  		SELECT UMDSUserGroup.userId
  		FROM UMDSgroups INNER JOIN UMDSUserGroup ON UMDSgroups.id = UMDSUserGroup.groupId
  		WHERE UMDSgroups.id IN (SELECT extGroupId FROM WF_InteractionUsers WHERE InteractionId = @i_interactionId)
)
AND id NOT IN (SELECT userId FROM @userTable)
SELECT * FROM @userTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetInteractionUsers')
	delete from GxQscripts where name = 'WFGetInteractionUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteractionUsers')
	delete from GXDBVersions where aliasname = 'WFGetInteractionUsers'
GO

insert into GXDBVersions values(2, 'WFGetInteractionUsers',  '00010002008600010000', 'WFGetInteractionUsers', '00010002008600010000')
GO

