

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetInteractionOverview.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetInteractionOverview.sp,v $ $Id: WFGetInteractionOverview.sp,v 1.2.86.1 2018/03/27 08:15:01 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/11/2013
-- Description:	returns interaction overview for user
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetInteractionOverview <<<'

IF EXISTS (select * from sysobjects where name='WFGetInteractionOverview')
	drop procedure WFGetInteractionOverview
IF EXISTS (select * from GxQscripts where name='WFGetInteractionOverview')
	delete from GxQscripts where name = 'WFGetInteractionOverview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteractionOverview')
	delete from GXDBVersions where aliasname = 'WFGetInteractionOverview'
GO
print '... Creating Procedure: WFGetInteractionOverview'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetInteractionOverview
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @pendingActions int
DECLARE @completedActions int = 0
IF ( @userId = 0 OR @userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User not provided'
	GOTO FINISH
END
Select InteractionId
INTO #interactionsOverview
FROM dbo.GetUserInteractions(@userId, 0)
Select @pendingActions = ISNULL(COUNT(*), 0)
from WF_Interaction
Where InteractionId IN (Select InteractionId FROM #interactionsOverview)
And status = 0
IF EXISTS (Select * FROM #interactionsOverview)
BEGIN
	SET @completedActions = 1
END
DROP TABLE #interactionsOverview
FINISH:
SET @o_xmlText = (
	SELECT	1					as TAG,
			0					as Parent,
			@pendingActions		as [Workflow_GetInteractionOverviewResp!1!pendingActions],
			@completedActions	as [Workflow_GetInteractionOverviewResp!1!completedActions],
			@o_ErrorCode		as [Workflow_GetInteractionOverviewResp!1!errorCode],
			@o_ErrorString		as [Workflow_GetInteractionOverviewResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetInteractionOverview')
	delete from GxQscripts where name = 'WFGetInteractionOverview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteractionOverview')
	delete from GXDBVersions where aliasname = 'WFGetInteractionOverview'
GO

insert into GXDBVersions values(2, 'WFGetInteractionOverview',  '00010002008600010000', 'WFGetInteractionOverview', '00010002008600010000')
GO

