

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetInteraction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetInteraction.sp,v $ $Id: WFGetInteraction.sp,v 1.9.2.3 2020/01/15 03:58:32 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets a single interaction request
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetInteraction')
BEGIN
	print '>>> Drop Stored Procedure: WFGetInteraction <<<'
	drop procedure WFGetInteraction
END
IF EXISTS (select * from GxQscripts where name='WFGetInteraction')
	delete from GxQscripts where name = 'WFGetInteraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteraction')
	delete from GXDBVersions where aliasname = 'WFGetInteraction'
GO
print '... Creating Procedure: WFGetInteraction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetInteraction
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @interactionId int
SELECT	@interactionId = ISNULL(ref.value('@interactionId','int'), 0)
FROM @i_xmlText.nodes('Workflow_GetWebFormInteractionRequest') R(ref)
IF NOT EXISTS(SELECT InteractionId FROM WF_Interaction WHERE InteractionId = @interactionId)
BEGIN
	SET @o_ErrorCode = -1
	SET @o_ErrorString = 'Action does not exist'
	GOTO FINISH
END
IF NOT EXISTS(SELECT * FROM dbo.GetUserInteractions(@i_userId, 1) WHERE InteractionId = @interactionId)
BEGIN
	SET @o_ErrorCode = -2
	--SET @o_ErrorString = 'You are not permitted to perform this Action'
	SET @o_ErrorString = (SELECT TOP 1 value FROM GXGlobalParam Where name = 'WorkflowActionPermissionError')
	IF (@o_ErrorString IS NULL OR LEN(@o_ErrorString) = 0)
		SET @o_ErrorString = 'You are not permitted to perform this Action'
	GOTO FINISH
END
SET @o_xmlText = (
	SELECT	i.InteractionId '@interactionId',
			i.jobId '@jobId',
			i.created '@created',
			i.activityName '@activityName',
			i.processStepId '@processStepId',
			i.description '@description',
			i.subject '@subject',
			i.status '@status',
			i.completed '@completed',
			i.inputSchema '@action',
			i.sessionId '@sessionId',
			i.flags '@flags',
			i.inputSchema '@actionExecuted',
			(SELECT d.WorkflowId '@workflowId',
					d.Name '@workflowName'
			FROM WF_Definition d
			WHERE i.workflowId = d.WorkflowId
			FOR XML PATH('workflow'), TYPE),
			(SELECT u.id '@userId',
					u.login '@userName'
			FROM UMUsers u
			WHERE i.createdBy = u.id
			FOR XML PATH('user'), TYPE),
			(SELECT u.id '@userId',
					u.login '@userName'
			FROM UMUsers u
			WHERE i.completedBy = u.id
			FOR XML PATH('completedBy'), TYPE),
			(SELECT c.id '@clientId',
					c.name '@clientName',
					c.displayName '@displayName'
			FROM APP_Client c
			WHERE i.clientId = c.id
			FOR XML PATH('client'), TYPE),
			(SELECT c.id '@commCellId',
					c.aliasName '@commCellName'
			FROM APP_CommCell c
			WHERE i.commCellId = c.id
			FOR XML PATH('commCell'), TYPE),
			(SELECT Cast(z.InputForm AS XML)
			FROM WF_Interaction z
			WHERE i.InteractionId = z.InteractionId),
			(SELECT Cast(z.completedForm AS XML)
			FROM WF_Interaction z
			WHERE i.InteractionId = z.InteractionId)
	FROM WF_Interaction i
	WHERE i.InteractionId = @interactionId
	FOR XML PATH('request'), ROOT('Workflow_GetWebFormInteractionResponse')
)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetWebFormInteractionResponse />'
END
FINISH:
IF (@o_ErrorCode <> 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetInteraction')
	delete from GxQscripts where name = 'WFGetInteraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetInteraction')
	delete from GXDBVersions where aliasname = 'WFGetInteraction'
GO

insert into GXDBVersions values(2, 'WFGetInteraction',  '00010009000200030000', 'WFGetInteraction', '00010009000200030000')
GO

