

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetExecutableWorkflows.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetExecutableWorkflows.sp,v $ $Id: WFGetExecutableWorkflows.sp,v 1.7.12.17 2020/01/15 03:58:17 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	returns the list of workflows that can be executed
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetExecutableWorkflows')
BEGIN
	print '>>> Drop Stored Procedure: WFGetExecutableWorkflows <<<'
	drop procedure WFGetExecutableWorkflows
END
IF EXISTS (select * from GxQscripts where name='WFGetExecutableWorkflows')
	delete from GxQscripts where name = 'WFGetExecutableWorkflows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetExecutableWorkflows')
	delete from GXDBVersions where aliasname = 'WFGetExecutableWorkflows'
GO
print '... Creating Procedure: WFGetExecutableWorkflows'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetExecutableWorkflows
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @preferredClient int
SET @preferredClient = ISNULL((SELECT ref.value('@clientId', 'int') FROM @i_xmlText.nodes('Workflow_GetExecutableWorkflowsRequest/preferredClient') R ( ref ) ), 0)
DECLARE @workflowId int
DECLARE @workflowName nvarchar(255)
SET @workflowId = ISNULL((SELECT ref.value('@workflowId', 'int') FROM @i_xmlText.nodes('Workflow_GetExecutableWorkflowsRequest/workflow') R ( ref ) ), 0)
SET @workflowName = ISNULL((SELECT ref.value('@workflowName', 'nvarchar(255)') FROM @i_xmlText.nodes('Workflow_GetExecutableWorkflowsRequest/workflow') R ( ref ) ), '')
IF ( @userId = 0 OR @userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User not provided'
	GOTO FINISH
END
IF (@workflowId = 0 AND LEN(@workflowName) > 0)
BEGIN
	SELECT @workflowId = WorkflowId
	FROM WF_Definition
	WHERE Name = @workflowName
	IF (@workflowId = 0)
	BEGIN
		SET @o_errorCode = -1
		SET	@o_errorString = 'workflow does not exist'
		GOTO FINISH
	END
END
IF object_id('tempdb.dbo.#WFGetWorkflowsExecute_WFObjects') is not null DROP TABLE #WFGetWorkflowsExecute_WFObjects
CREATE TABLE #WFGetWorkflowsExecute_WFObjects (workflowId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 83, 113, '#WFGetWorkflowsExecute_WFObjects'
	MERGE #WFGetWorkflowsExecute_WFObjects viewExe
	USING	(SELECT WorkflowId
		FROM WF_Definition WITH(NOLOCK)
		WHERE (flags & 32) = 32) skipSec
		ON viewExe.workflowId = skipSec.WorkflowId
	WHEN NOT MATCHED THEN INSERT(workflowId) VALUES(skipSec.WorkflowId);
DECLARE @workflowTable TABLE (t_workflowId int, t_clientId int, t_deployId int)
INSERT @workflowTable
SELECT d.WorkflowId, d.clientId, dep.DeployId
FROM (
	SELECT d.WorkflowId, dbo.GetClientForWorkflow(d.WorkflowId, @preferredClient) As clientId
	FROM WF_Definition d
	WHERE d.Name not in (Select workflowname from App_MessageHandler) --hide business logic workflows
	AND (@workflowId = 0 OR d.WorkflowId = @workflowId)
	AND (@workflowId > 0 OR d.flags & 16 = 0)
) d
INNER JOIN #WFGetWorkflowsExecute_WFObjects c ON d.WorkflowId = c.WorkflowId
INNER JOIN
(
	SELECT WorkflowId, ClientId, Max(DeployId) As DeployId
	FROM WF_Deploy
	WHERE Status = 1
	Group BY WorkflowId, ClientId
) dep ON d.WorkflowId = dep.WorkflowId AND d.clientId = dep.clientId
IF (@workflowId > 0)
BEGIN
	IF NOT EXISTS (SELECT * FROM @workflowTable)
	BEGIN
		SET @o_errorCode = -1
		SET	@o_errorString = 'workflow does not exist'
		GOTO FINISH
	END
END
SET @xmlText = (
		SELECT
			d.Version '@version',
			d.flags '@flags',
			d.Description '@description',
			d.uniqueGuid '@uniqueGuid',
			d.revision '@revision',
			d.Tags '@tags',
			d.WorkflowId 'entity/@workflowId',
			d.Name 'entity/@workflowName',
			u.id 'creator/@userId',
			u.login 'creator/@userName',
			ISNULL(c.id, 0) 'client/@clientId',
			ISNULL(c.name, '') 'client/@clientName',
			ISNULL(c.displayName, '') 'client/@displayName',
			(SELECT Cast(dep.InputForm As XML)
			 FROM WF_Deploy dep
			 WHERE dep.DeployId = t.t_deployId)
	FROM WF_Definition d
	INNER JOIN UMUsers u ON d.userId = u.id
	INNER JOIN @workflowTable t ON d.WorkflowId = t.t_workflowId
	LEFT OUTER JOIN APP_Client c ON t.t_clientId = c.id
	INNER JOIN WF_Deploy p ON p.DeployId = t.t_deployId
	WHERE (@workflowId > 0 OR p.flags & 8 = 0) -- allow web hidden workflows to be returned if a workflowId is passed into procedure
	ORDER BY d.Name
	FOR XML PATH('container'), ROOT('Workflow_GetExecutableWorkflowsResponse')
)
IF (@xmlText IS NULL)
BEGIN
	SET @xmlText = '<Workflow_GetExecutableWorkflowsResponse />'
END
Select InteractionId
INTO #interactions
FROM dbo.GetUserInteractions(@userId, 0)
DECLARE @pendingActions int
DECLARE @completedActions int = 0
Select @pendingActions = ISNULL(COUNT(*), 0)
from WF_Interaction
Where InteractionId IN (Select InteractionId FROM #interactions)
And status = 0
IF EXISTS (Select * FROM #interactions)
BEGIN
	SET @completedActions = 1
END
SET @xmlText.modify('insert (attribute pendingActions {sql:variable("@pendingActions")})into ((/Workflow_GetExecutableWorkflowsResponse))[1]')
SET @xmlText.modify('insert (attribute completedActions {sql:variable("@completedActions")})into ((/Workflow_GetExecutableWorkflowsResponse))[1]')
DROP TABLE #interactions
FINISH:
IF (@o_ErrorCode <> 0)
BEGIN
	SET @xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @xmlText AS o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetExecutableWorkflows')
	delete from GxQscripts where name = 'WFGetExecutableWorkflows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetExecutableWorkflows')
	delete from GXDBVersions where aliasname = 'WFGetExecutableWorkflows'
GO

insert into GXDBVersions values(2, 'WFGetExecutableWorkflows',  '00010007001200170000', 'WFGetExecutableWorkflows', '00010007001200170000')
GO

