

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetEngines.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetEngines.sp,v $ $Id: WFGetEngines.sp,v 1.10.88.3 2020/04/29 17:46:22 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets the list of workflow engines
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFGetEngines')
BEGIN
	print '>>> Drop Stored Procedure: WFGetEngines <<<'
	drop procedure WFGetEngines
END
IF EXISTS (select * from GxQscripts where name='WFGetEngines')
	delete from GxQscripts where name = 'WFGetEngines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetEngines')
	delete from GXDBVersions where aliasname = 'WFGetEngines'
GO
print '... Creating Procedure: WFGetEngines'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetEngines
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
SET @o_xmlText = (
SELECT	id '@clientId',
		name '@clientName',displayName '@displayName'
FROM APP_Client
WHERE id IN (
	SELECT ClientId
	FROM dbo.simInstalledPackages
	WHERE simPackageID in (808,854)
)
FOR XML PATH('clients'), ROOT('Workflow_GetEnginesResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetEnginesResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetEngines')
	delete from GxQscripts where name = 'WFGetEngines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetEngines')
	delete from GXDBVersions where aliasname = 'WFGetEngines'
GO

insert into GXDBVersions values(2, 'WFGetEngines',  '00010010008800030000', 'WFGetEngines', '00010010008800030000')
GO

